// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: envoy/api/v2/core/config_source.proto

package core

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/types"
import _ "github.com/lyft/protoc-gen-validate/validate"
import _ "github.com/gogo/protobuf/gogoproto"

import time "time"

import types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// APIs may be fetched via either REST or gRPC.
type ApiConfigSource_ApiType int32

const (
	// REST-JSON legacy corresponds to the v1 API.
	ApiConfigSource_REST_LEGACY ApiConfigSource_ApiType = 0
	// REST-JSON v2 API. The `canonical JSON encoding
	// <https://developers.google.com/protocol-buffers/docs/proto3#json>`_ for
	// the v2 protos is used.
	ApiConfigSource_REST ApiConfigSource_ApiType = 1
	// gRPC v2 API.
	ApiConfigSource_GRPC ApiConfigSource_ApiType = 2
)

var ApiConfigSource_ApiType_name = map[int32]string{
	0: "REST_LEGACY",
	1: "REST",
	2: "GRPC",
}
var ApiConfigSource_ApiType_value = map[string]int32{
	"REST_LEGACY": 0,
	"REST":        1,
	"GRPC":        2,
}

func (x ApiConfigSource_ApiType) String() string {
	return proto.EnumName(ApiConfigSource_ApiType_name, int32(x))
}
func (ApiConfigSource_ApiType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorConfigSource, []int{0, 0}
}

// API configuration source. This identifies the API type and cluster that Envoy
// will use to fetch an xDS API.
type ApiConfigSource struct {
	ApiType ApiConfigSource_ApiType `protobuf:"varint,1,opt,name=api_type,json=apiType,proto3,enum=envoy.api.v2.core.ApiConfigSource_ApiType" json:"api_type,omitempty"`
	// Cluster names should be used only with REST_LEGACY/REST. If > 1
	// cluster is defined, clusters will be cycled through if any kind of failure
	// occurs.
	//
	// .. note::
	//
	//  The cluster with name ``cluster_name`` must be statically defined and its
	//  type must not be ``EDS``.
	ClusterNames []string `protobuf:"bytes,2,rep,name=cluster_names,json=clusterNames" json:"cluster_names,omitempty"`
	// Multiple gRPC services be provided for GRPC. If > 1 cluster is defined,
	// services will be cycled through if any kind of failure occurs.
	GrpcServices []*GrpcService `protobuf:"bytes,4,rep,name=grpc_services,json=grpcServices" json:"grpc_services,omitempty"`
	// For REST APIs, the delay between successive polls.
	RefreshDelay *time.Duration `protobuf:"bytes,3,opt,name=refresh_delay,json=refreshDelay,stdduration" json:"refresh_delay,omitempty"`
}

func (m *ApiConfigSource) Reset()                    { *m = ApiConfigSource{} }
func (m *ApiConfigSource) String() string            { return proto.CompactTextString(m) }
func (*ApiConfigSource) ProtoMessage()               {}
func (*ApiConfigSource) Descriptor() ([]byte, []int) { return fileDescriptorConfigSource, []int{0} }

func (m *ApiConfigSource) GetApiType() ApiConfigSource_ApiType {
	if m != nil {
		return m.ApiType
	}
	return ApiConfigSource_REST_LEGACY
}

func (m *ApiConfigSource) GetClusterNames() []string {
	if m != nil {
		return m.ClusterNames
	}
	return nil
}

func (m *ApiConfigSource) GetGrpcServices() []*GrpcService {
	if m != nil {
		return m.GrpcServices
	}
	return nil
}

func (m *ApiConfigSource) GetRefreshDelay() *time.Duration {
	if m != nil {
		return m.RefreshDelay
	}
	return nil
}

// Aggregated Discovery Service (ADS) options. This is currently empty, but when
// set in :ref:`ConfigSource <envoy_api_msg_core.ConfigSource>` can be used to
// specify that ADS is to be used.
type AggregatedConfigSource struct {
}

func (m *AggregatedConfigSource) Reset()         { *m = AggregatedConfigSource{} }
func (m *AggregatedConfigSource) String() string { return proto.CompactTextString(m) }
func (*AggregatedConfigSource) ProtoMessage()    {}
func (*AggregatedConfigSource) Descriptor() ([]byte, []int) {
	return fileDescriptorConfigSource, []int{1}
}

// Configuration for :ref:`listeners <config_listeners>`, :ref:`clusters
// <config_cluster_manager_cluster>`, :ref:`routes
// <config_http_conn_man_route_table>`, :ref:`endpoints
// <arch_overview_service_discovery>` etc. may either be sourced from the
// filesystem or from an xDS API source. Filesystem configs are watched with
// inotify for updates.
type ConfigSource struct {
	// Types that are valid to be assigned to ConfigSourceSpecifier:
	//	*ConfigSource_Path
	//	*ConfigSource_ApiConfigSource
	//	*ConfigSource_Ads
	ConfigSourceSpecifier isConfigSource_ConfigSourceSpecifier `protobuf_oneof:"config_source_specifier"`
}

func (m *ConfigSource) Reset()                    { *m = ConfigSource{} }
func (m *ConfigSource) String() string            { return proto.CompactTextString(m) }
func (*ConfigSource) ProtoMessage()               {}
func (*ConfigSource) Descriptor() ([]byte, []int) { return fileDescriptorConfigSource, []int{2} }

type isConfigSource_ConfigSourceSpecifier interface {
	isConfigSource_ConfigSourceSpecifier()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type ConfigSource_Path struct {
	Path string `protobuf:"bytes,1,opt,name=path,proto3,oneof"`
}
type ConfigSource_ApiConfigSource struct {
	ApiConfigSource *ApiConfigSource `protobuf:"bytes,2,opt,name=api_config_source,json=apiConfigSource,oneof"`
}
type ConfigSource_Ads struct {
	Ads *AggregatedConfigSource `protobuf:"bytes,3,opt,name=ads,oneof"`
}

func (*ConfigSource_Path) isConfigSource_ConfigSourceSpecifier()            {}
func (*ConfigSource_ApiConfigSource) isConfigSource_ConfigSourceSpecifier() {}
func (*ConfigSource_Ads) isConfigSource_ConfigSourceSpecifier()             {}

func (m *ConfigSource) GetConfigSourceSpecifier() isConfigSource_ConfigSourceSpecifier {
	if m != nil {
		return m.ConfigSourceSpecifier
	}
	return nil
}

func (m *ConfigSource) GetPath() string {
	if x, ok := m.GetConfigSourceSpecifier().(*ConfigSource_Path); ok {
		return x.Path
	}
	return ""
}

func (m *ConfigSource) GetApiConfigSource() *ApiConfigSource {
	if x, ok := m.GetConfigSourceSpecifier().(*ConfigSource_ApiConfigSource); ok {
		return x.ApiConfigSource
	}
	return nil
}

func (m *ConfigSource) GetAds() *AggregatedConfigSource {
	if x, ok := m.GetConfigSourceSpecifier().(*ConfigSource_Ads); ok {
		return x.Ads
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ConfigSource) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ConfigSource_OneofMarshaler, _ConfigSource_OneofUnmarshaler, _ConfigSource_OneofSizer, []interface{}{
		(*ConfigSource_Path)(nil),
		(*ConfigSource_ApiConfigSource)(nil),
		(*ConfigSource_Ads)(nil),
	}
}

func _ConfigSource_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ConfigSource)
	// config_source_specifier
	switch x := m.ConfigSourceSpecifier.(type) {
	case *ConfigSource_Path:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		_ = b.EncodeStringBytes(x.Path)
	case *ConfigSource_ApiConfigSource:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ApiConfigSource); err != nil {
			return err
		}
	case *ConfigSource_Ads:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Ads); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ConfigSource.ConfigSourceSpecifier has unexpected type %T", x)
	}
	return nil
}

func _ConfigSource_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ConfigSource)
	switch tag {
	case 1: // config_source_specifier.path
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ConfigSourceSpecifier = &ConfigSource_Path{x}
		return true, err
	case 2: // config_source_specifier.api_config_source
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ApiConfigSource)
		err := b.DecodeMessage(msg)
		m.ConfigSourceSpecifier = &ConfigSource_ApiConfigSource{msg}
		return true, err
	case 3: // config_source_specifier.ads
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AggregatedConfigSource)
		err := b.DecodeMessage(msg)
		m.ConfigSourceSpecifier = &ConfigSource_Ads{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ConfigSource_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ConfigSource)
	// config_source_specifier
	switch x := m.ConfigSourceSpecifier.(type) {
	case *ConfigSource_Path:
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.Path)))
		n += len(x.Path)
	case *ConfigSource_ApiConfigSource:
		s := proto.Size(x.ApiConfigSource)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ConfigSource_Ads:
		s := proto.Size(x.Ads)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*ApiConfigSource)(nil), "envoy.api.v2.core.ApiConfigSource")
	proto.RegisterType((*AggregatedConfigSource)(nil), "envoy.api.v2.core.AggregatedConfigSource")
	proto.RegisterType((*ConfigSource)(nil), "envoy.api.v2.core.ConfigSource")
	proto.RegisterEnum("envoy.api.v2.core.ApiConfigSource_ApiType", ApiConfigSource_ApiType_name, ApiConfigSource_ApiType_value)
}
func (this *ApiConfigSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ApiConfigSource)
	if !ok {
		that2, ok := that.(ApiConfigSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.ApiType != that1.ApiType {
		return false
	}
	if len(this.ClusterNames) != len(that1.ClusterNames) {
		return false
	}
	for i := range this.ClusterNames {
		if this.ClusterNames[i] != that1.ClusterNames[i] {
			return false
		}
	}
	if len(this.GrpcServices) != len(that1.GrpcServices) {
		return false
	}
	for i := range this.GrpcServices {
		if !this.GrpcServices[i].Equal(that1.GrpcServices[i]) {
			return false
		}
	}
	if this.RefreshDelay != nil && that1.RefreshDelay != nil {
		if *this.RefreshDelay != *that1.RefreshDelay {
			return false
		}
	} else if this.RefreshDelay != nil {
		return false
	} else if that1.RefreshDelay != nil {
		return false
	}
	return true
}
func (this *AggregatedConfigSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*AggregatedConfigSource)
	if !ok {
		that2, ok := that.(AggregatedConfigSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *ConfigSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConfigSource)
	if !ok {
		that2, ok := that.(ConfigSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.ConfigSourceSpecifier == nil {
		if this.ConfigSourceSpecifier != nil {
			return false
		}
	} else if this.ConfigSourceSpecifier == nil {
		return false
	} else if !this.ConfigSourceSpecifier.Equal(that1.ConfigSourceSpecifier) {
		return false
	}
	return true
}
func (this *ConfigSource_Path) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConfigSource_Path)
	if !ok {
		that2, ok := that.(ConfigSource_Path)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *ConfigSource_ApiConfigSource) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConfigSource_ApiConfigSource)
	if !ok {
		that2, ok := that.(ConfigSource_ApiConfigSource)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.ApiConfigSource.Equal(that1.ApiConfigSource) {
		return false
	}
	return true
}
func (this *ConfigSource_Ads) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ConfigSource_Ads)
	if !ok {
		that2, ok := that.(ConfigSource_Ads)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Ads.Equal(that1.Ads) {
		return false
	}
	return true
}
func (m *ApiConfigSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ApiConfigSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ApiType != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintConfigSource(dAtA, i, uint64(m.ApiType))
	}
	if len(m.ClusterNames) > 0 {
		for _, s := range m.ClusterNames {
			dAtA[i] = 0x12
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if m.RefreshDelay != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfigSource(dAtA, i, uint64(types.SizeOfStdDuration(*m.RefreshDelay)))
		n1, err := types.StdDurationMarshalTo(*m.RefreshDelay, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.GrpcServices) > 0 {
		for _, msg := range m.GrpcServices {
			dAtA[i] = 0x22
			i++
			i = encodeVarintConfigSource(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AggregatedConfigSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AggregatedConfigSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ConfigSource) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConfigSource) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ConfigSourceSpecifier != nil {
		nn2, err := m.ConfigSourceSpecifier.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn2
	}
	return i, nil
}

func (m *ConfigSource_Path) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	dAtA[i] = 0xa
	i++
	i = encodeVarintConfigSource(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	return i, nil
}
func (m *ConfigSource_ApiConfigSource) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.ApiConfigSource != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintConfigSource(dAtA, i, uint64(m.ApiConfigSource.Size()))
		n3, err := m.ApiConfigSource.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}
func (m *ConfigSource_Ads) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Ads != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintConfigSource(dAtA, i, uint64(m.Ads.Size()))
		n4, err := m.Ads.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}
func encodeVarintConfigSource(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ApiConfigSource) Size() (n int) {
	var l int
	_ = l
	if m.ApiType != 0 {
		n += 1 + sovConfigSource(uint64(m.ApiType))
	}
	if len(m.ClusterNames) > 0 {
		for _, s := range m.ClusterNames {
			l = len(s)
			n += 1 + l + sovConfigSource(uint64(l))
		}
	}
	if m.RefreshDelay != nil {
		l = types.SizeOfStdDuration(*m.RefreshDelay)
		n += 1 + l + sovConfigSource(uint64(l))
	}
	if len(m.GrpcServices) > 0 {
		for _, e := range m.GrpcServices {
			l = e.Size()
			n += 1 + l + sovConfigSource(uint64(l))
		}
	}
	return n
}

func (m *AggregatedConfigSource) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ConfigSource) Size() (n int) {
	var l int
	_ = l
	if m.ConfigSourceSpecifier != nil {
		n += m.ConfigSourceSpecifier.Size()
	}
	return n
}

func (m *ConfigSource_Path) Size() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	n += 1 + l + sovConfigSource(uint64(l))
	return n
}
func (m *ConfigSource_ApiConfigSource) Size() (n int) {
	var l int
	_ = l
	if m.ApiConfigSource != nil {
		l = m.ApiConfigSource.Size()
		n += 1 + l + sovConfigSource(uint64(l))
	}
	return n
}
func (m *ConfigSource_Ads) Size() (n int) {
	var l int
	_ = l
	if m.Ads != nil {
		l = m.Ads.Size()
		n += 1 + l + sovConfigSource(uint64(l))
	}
	return n
}

func sovConfigSource(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfigSource(x uint64) (n int) {
	return sovConfigSource(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ApiConfigSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigSource
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ApiConfigSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ApiConfigSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiType", wireType)
			}
			m.ApiType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigSource
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ApiType |= (ApiConfigSource_ApiType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigSource
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfigSource
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClusterNames = append(m.ClusterNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RefreshDelay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigSource
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigSource
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RefreshDelay == nil {
				m.RefreshDelay = new(time.Duration)
			}
			if err := types.StdDurationUnmarshal(m.RefreshDelay, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GrpcServices", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigSource
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigSource
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.GrpcServices = append(m.GrpcServices, &GrpcService{})
			if err := m.GrpcServices[len(m.GrpcServices)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigSource(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigSource
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AggregatedConfigSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigSource
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AggregatedConfigSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AggregatedConfigSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipConfigSource(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigSource
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConfigSource) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfigSource
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConfigSource: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConfigSource: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigSource
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfigSource
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConfigSourceSpecifier = &ConfigSource_Path{string(dAtA[iNdEx:postIndex])}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApiConfigSource", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigSource
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigSource
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ApiConfigSource{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigSourceSpecifier = &ConfigSource_ApiConfigSource{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ads", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfigSource
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfigSource
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &AggregatedConfigSource{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.ConfigSourceSpecifier = &ConfigSource_Ads{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfigSource(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfigSource
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfigSource(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfigSource
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfigSource
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfigSource
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthConfigSource
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfigSource
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfigSource(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfigSource = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfigSource   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("envoy/api/v2/core/config_source.proto", fileDescriptorConfigSource) }

var fileDescriptorConfigSource = []byte{
	// 469 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x84, 0x52, 0x3f, 0x6f, 0xd3, 0x40,
	0x1c, 0xcd, 0xc5, 0x29, 0x6d, 0x2f, 0x09, 0x71, 0xad, 0x8a, 0x9a, 0x0e, 0xc6, 0x32, 0x20, 0x05,
	0x86, 0xb3, 0x64, 0x66, 0x86, 0xfc, 0xa9, 0x92, 0x01, 0xa1, 0x72, 0xe9, 0xc2, 0x64, 0x5d, 0xed,
	0xcb, 0xf5, 0xa4, 0x90, 0x3b, 0xdd, 0x39, 0x96, 0xb2, 0xf2, 0x29, 0xf8, 0x08, 0x7c, 0x04, 0xc4,
	0xd4, 0x81, 0x81, 0x91, 0x8d, 0x11, 0x94, 0xad, 0xdf, 0x02, 0xdd, 0xc5, 0x11, 0x4d, 0x1b, 0xa9,
	0xdb, 0xef, 0xbd, 0xfb, 0x3d, 0xeb, 0xbd, 0xf7, 0x33, 0x7c, 0x49, 0xe7, 0xa5, 0x58, 0xc6, 0x44,
	0xf2, 0xb8, 0x4c, 0xe2, 0x4c, 0x28, 0x1a, 0x67, 0x62, 0x3e, 0xe5, 0x2c, 0xd5, 0x62, 0xa1, 0x32,
	0x8a, 0xa4, 0x12, 0x85, 0xf0, 0x8e, 0xec, 0x1a, 0x22, 0x92, 0xa3, 0x32, 0x41, 0x66, 0xed, 0xf4,
	0xc5, 0x7d, 0x25, 0x53, 0x32, 0x4b, 0x35, 0x55, 0x25, 0xdf, 0x08, 0x4f, 0x03, 0x26, 0x04, 0x9b,
	0xd1, 0xd8, 0xa2, 0xcb, 0xc5, 0x34, 0xce, 0x17, 0x8a, 0x14, 0x5c, 0xcc, 0xab, 0xf7, 0x93, 0x92,
	0xcc, 0x78, 0x4e, 0x0a, 0x1a, 0x6f, 0x86, 0xea, 0xe1, 0x98, 0x09, 0x26, 0xec, 0x18, 0x9b, 0x69,
	0xcd, 0x46, 0x3f, 0xea, 0xb0, 0xd3, 0x93, 0x7c, 0x60, 0x2d, 0x4e, 0xac, 0x43, 0xef, 0x03, 0x3c,
	0x20, 0x92, 0xa7, 0xc5, 0x52, 0x52, 0x1f, 0x84, 0xa0, 0xfb, 0x38, 0x79, 0x8d, 0xee, 0xd9, 0x45,
	0x77, 0x54, 0x06, 0x5f, 0x2c, 0x25, 0xed, 0xc3, 0xef, 0x37, 0xd7, 0xce, 0xde, 0x67, 0x50, 0x77,
	0x01, 0xde, 0x27, 0x6b, 0xd2, 0x7b, 0x0e, 0xdb, 0xd9, 0x6c, 0xa1, 0x0b, 0xaa, 0xd2, 0x39, 0xf9,
	0x44, 0xb5, 0x5f, 0x0f, 0x9d, 0xee, 0x21, 0x6e, 0x55, 0xe4, 0x7b, 0xc3, 0x79, 0x43, 0xd8, 0x56,
	0x74, 0xaa, 0xa8, 0xbe, 0x4a, 0x73, 0x3a, 0x23, 0x4b, 0xdf, 0x09, 0x41, 0xb7, 0x99, 0x3c, 0x45,
	0xeb, 0xc8, 0x68, 0x13, 0x19, 0x0d, 0xab, 0xc8, 0xfd, 0xc6, 0x97, 0x3f, 0xcf, 0x00, 0x6e, 0x55,
	0xaa, 0xa1, 0x11, 0x79, 0x03, 0xd8, 0xbe, 0x5d, 0x9b, 0xf6, 0x1b, 0xa1, 0xd3, 0x6d, 0x26, 0xc1,
	0x8e, 0x08, 0x23, 0x25, 0xb3, 0xc9, 0x7a, 0x0d, 0xb7, 0xd8, 0x7f, 0xa0, 0x23, 0x04, 0xf7, 0xab,
	0x3c, 0x5e, 0x07, 0x36, 0xf1, 0xd9, 0xe4, 0x22, 0x7d, 0x77, 0x36, 0xea, 0x0d, 0x3e, 0xba, 0x35,
	0xef, 0x00, 0x36, 0x0c, 0xe1, 0x02, 0x33, 0x8d, 0xf0, 0xf9, 0xc0, 0xad, 0x47, 0x3e, 0x7c, 0xd2,
	0x63, 0x4c, 0x51, 0x46, 0x0a, 0x9a, 0xdf, 0xae, 0x25, 0xfa, 0x0d, 0x60, 0x6b, 0xab, 0xdd, 0x63,
	0xd8, 0x90, 0xa4, 0xb8, 0xb2, 0xcd, 0x1e, 0x8e, 0x6b, 0xd8, 0x22, 0xef, 0x1c, 0x1e, 0x99, 0xce,
	0xb7, 0x7e, 0x15, 0xbf, 0x6e, 0xf3, 0x47, 0x0f, 0x97, 0x3f, 0xae, 0xe1, 0x0e, 0xb9, 0x73, 0xc5,
	0xb7, 0xd0, 0x21, 0xb9, 0xae, 0x3a, 0x7c, 0xb5, 0xeb, 0x1b, 0x3b, 0x0d, 0x8f, 0x6b, 0xd8, 0xe8,
	0xfa, 0x21, 0x3c, 0xd9, 0x32, 0x93, 0x6a, 0x49, 0x33, 0x3e, 0xe5, 0x54, 0x79, 0x7b, 0xdf, 0x6e,
	0xae, 0x1d, 0xd0, 0x77, 0xbf, 0xae, 0x02, 0xf0, 0x73, 0x15, 0x80, 0x5f, 0xab, 0x00, 0xfc, 0x5d,
	0x05, 0xe0, 0xf2, 0x91, 0xbd, 0xd0, 0x9b, 0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x72, 0xee, 0x5d,
	0x69, 0x04, 0x03, 0x00, 0x00,
}
