// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/template/logentry/template_handler_service.proto

/*
	Package logentry is a generated protocol buffer package.

	The `logentry` template represents an individual entry within a log.

	Example config:

	```yaml
	apiVersion: "config.istio.io/v1alpha2"
	kind: logentry
	metadata:
	  name: accesslog
	  namespace: istio-system
	spec:
	  severity: '"Default"'
	  timestamp: request.time
	  variables:
	    sourceIp: source.ip | ip("0.0.0.0")
	    destinationIp: destination.ip | ip("0.0.0.0")
	    sourceUser: source.user | ""
	    method: request.method | ""
	    url: request.path | ""
	    protocol: request.scheme | "http"
	    responseCode: response.code | 0
	    responseSize: response.size | 0
	    requestSize: request.size | 0
	    latency: response.duration | "0ms"
	  monitored_resource_type: '"UNSPECIFIED"'
	```

	The `logentry` template represents an individual entry within a log.

	When writing the configuration, the value for the fields associated with this template can either be a
	literal or an [expression](https://istio.io/docs/reference//config/policy-and-telemetry/expression-language/). Please note that if the datatype of a field is not istio.policy.v1beta1.Value,
	then the expression's [inferred type](https://istio.io/docs/reference//config/policy-and-telemetry/expression-language/#type-checking) must match the datatype of the field.

	It is generated from these files:
		mixer/template/logentry/template_handler_service.proto

	It has these top-level messages:
		HandleLogEntryRequest
		InstanceMsg
		Type
		InstanceParam
*/
package logentry

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "istio.io/api/mixer/adapter/model/v1beta1"
import google_protobuf1 "github.com/gogo/protobuf/types"
import istio_mixer_adapter_model_v1beta11 "istio.io/api/mixer/adapter/model/v1beta1"
import istio_policy_v1beta1 "istio.io/api/policy/v1beta1"
import istio_policy_v1beta11 "istio.io/api/policy/v1beta1"

import context "golang.org/x/net/context"
import grpc "google.golang.org/grpc"

import strings "strings"
import reflect "reflect"
import sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Request message for HandleLogEntry method.
type HandleLogEntryRequest struct {
	// 'logentry' instances.
	Instances []*InstanceMsg `protobuf:"bytes,1,rep,name=instances" json:"instances,omitempty"`
	// Adapter specific handler configuration.
	//
	// Note: Backends can also implement [InfrastructureBackend][https://istio.io/docs/reference/config/mixer/istio.mixer.adapter.model.v1beta1.html#InfrastructureBackend]
	// service and therefore opt to receive handler configuration during session creation through [InfrastructureBackend.CreateSession][TODO: Link to this fragment]
	// call. In that case, adapter_config will have type_url as 'google.protobuf.Any.type_url' and would contain string
	// value of session_id (returned from InfrastructureBackend.CreateSession).
	AdapterConfig *google_protobuf1.Any `protobuf:"bytes,2,opt,name=adapter_config,json=adapterConfig" json:"adapter_config,omitempty"`
	// Id to dedupe identical requests from Mixer.
	DedupId string `protobuf:"bytes,3,opt,name=dedup_id,json=dedupId,proto3" json:"dedup_id,omitempty"`
}

func (m *HandleLogEntryRequest) Reset()      { *m = HandleLogEntryRequest{} }
func (*HandleLogEntryRequest) ProtoMessage() {}
func (*HandleLogEntryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{0}
}

// Contains instance payload for 'logentry' template. This is passed to infrastructure backends during request-time
// through HandleLogEntryService.HandleLogEntry.
type InstanceMsg struct {
	// Name of the instance as specified in configuration.
	Name string `protobuf:"bytes,72295727,opt,name=name,proto3" json:"name,omitempty"`
	// Variables that are delivered for each log entry.
	Variables map[string]*istio_policy_v1beta11.Value `protobuf:"bytes,1,rep,name=variables" json:"variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// Timestamp is the time value for the log entry
	Timestamp *istio_policy_v1beta11.TimeStamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp,omitempty"`
	// Severity indicates the importance of the log entry.
	Severity string `protobuf:"bytes,3,opt,name=severity,proto3" json:"severity,omitempty"`
	// Optional. An expression to compute the type of the monitored resource this log entry is being recorded on.
	// If the logging backend supports monitored resources, these fields are used to populate that resource.
	// Otherwise these fields will be ignored by the adapter.
	MonitoredResourceType string `protobuf:"bytes,4,opt,name=monitored_resource_type,json=monitoredResourceType,proto3" json:"monitored_resource_type,omitempty"`
	// Optional. A set of expressions that will form the dimensions of the monitored resource this log entry is being
	// recorded on. If the logging backend supports monitored resources, these fields are used to populate that resource.
	// Otherwise these fields will be ignored by the adapter.
	MonitoredResourceDimensions map[string]*istio_policy_v1beta11.Value `protobuf:"bytes,5,rep,name=monitored_resource_dimensions,json=monitoredResourceDimensions" json:"monitored_resource_dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *InstanceMsg) Reset()      { *m = InstanceMsg{} }
func (*InstanceMsg) ProtoMessage() {}
func (*InstanceMsg) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{1}
}

// Contains inferred type information about specific instance of 'logentry' template. This is passed to
// infrastructure backends during configuration-time through [InfrastructureBackend.CreateSession][TODO: Link to this fragment].
type Type struct {
	// Variables that are delivered for each log entry.
	Variables map[string]istio_policy_v1beta1.ValueType `protobuf:"bytes,1,rep,name=variables" json:"variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType"`
	// Optional. A set of expressions that will form the dimensions of the monitored resource this log entry is being
	// recorded on. If the logging backend supports monitored resources, these fields are used to populate that resource.
	// Otherwise these fields will be ignored by the adapter.
	MonitoredResourceDimensions map[string]istio_policy_v1beta1.ValueType `protobuf:"bytes,5,rep,name=monitored_resource_dimensions,json=monitoredResourceDimensions" json:"monitored_resource_dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=istio.policy.v1beta1.ValueType"`
}

func (m *Type) Reset()                    { *m = Type{} }
func (*Type) ProtoMessage()               {}
func (*Type) Descriptor() ([]byte, []int) { return fileDescriptorTemplateHandlerService, []int{2} }

// Represents instance configuration schema for 'logentry' template.
type InstanceParam struct {
	// Variables that are delivered for each log entry.
	Variables map[string]string `protobuf:"bytes,1,rep,name=variables" json:"variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Timestamp is the time value for the log entry
	Timestamp string `protobuf:"bytes,2,opt,name=timestamp,proto3" json:"timestamp,omitempty"`
	// Severity indicates the importance of the log entry.
	Severity string `protobuf:"bytes,3,opt,name=severity,proto3" json:"severity,omitempty"`
	// Optional. An expression to compute the type of the monitored resource this log entry is being recorded on.
	// If the logging backend supports monitored resources, these fields are used to populate that resource.
	// Otherwise these fields will be ignored by the adapter.
	MonitoredResourceType string `protobuf:"bytes,4,opt,name=monitored_resource_type,json=monitoredResourceType,proto3" json:"monitored_resource_type,omitempty"`
	// Optional. A set of expressions that will form the dimensions of the monitored resource this log entry is being
	// recorded on. If the logging backend supports monitored resources, these fields are used to populate that resource.
	// Otherwise these fields will be ignored by the adapter.
	MonitoredResourceDimensions map[string]string `protobuf:"bytes,5,rep,name=monitored_resource_dimensions,json=monitoredResourceDimensions" json:"monitored_resource_dimensions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *InstanceParam) Reset()      { *m = InstanceParam{} }
func (*InstanceParam) ProtoMessage() {}
func (*InstanceParam) Descriptor() ([]byte, []int) {
	return fileDescriptorTemplateHandlerService, []int{3}
}

func init() {
	proto.RegisterType((*HandleLogEntryRequest)(nil), "logentry.HandleLogEntryRequest")
	proto.RegisterType((*InstanceMsg)(nil), "logentry.InstanceMsg")
	proto.RegisterType((*Type)(nil), "logentry.Type")
	proto.RegisterType((*InstanceParam)(nil), "logentry.InstanceParam")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for HandleLogEntryService service

type HandleLogEntryServiceClient interface {
	// HandleLogEntry is called by Mixer at request-time to deliver 'logentry' instances to the backend.
	HandleLogEntry(ctx context.Context, in *HandleLogEntryRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

type handleLogEntryServiceClient struct {
	cc *grpc.ClientConn
}

func NewHandleLogEntryServiceClient(cc *grpc.ClientConn) HandleLogEntryServiceClient {
	return &handleLogEntryServiceClient{cc}
}

func (c *handleLogEntryServiceClient) HandleLogEntry(ctx context.Context, in *HandleLogEntryRequest, opts ...grpc.CallOption) (*istio_mixer_adapter_model_v1beta11.ReportResult, error) {
	out := new(istio_mixer_adapter_model_v1beta11.ReportResult)
	err := grpc.Invoke(ctx, "/logentry.HandleLogEntryService/HandleLogEntry", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for HandleLogEntryService service

type HandleLogEntryServiceServer interface {
	// HandleLogEntry is called by Mixer at request-time to deliver 'logentry' instances to the backend.
	HandleLogEntry(context.Context, *HandleLogEntryRequest) (*istio_mixer_adapter_model_v1beta11.ReportResult, error)
}

func RegisterHandleLogEntryServiceServer(s *grpc.Server, srv HandleLogEntryServiceServer) {
	s.RegisterService(&_HandleLogEntryService_serviceDesc, srv)
}

func _HandleLogEntryService_HandleLogEntry_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HandleLogEntryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HandleLogEntryServiceServer).HandleLogEntry(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/logentry.HandleLogEntryService/HandleLogEntry",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HandleLogEntryServiceServer).HandleLogEntry(ctx, req.(*HandleLogEntryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _HandleLogEntryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "logentry.HandleLogEntryService",
	HandlerType: (*HandleLogEntryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "HandleLogEntry",
			Handler:    _HandleLogEntryService_HandleLogEntry_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "mixer/template/logentry/template_handler_service.proto",
}

func (m *HandleLogEntryRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandleLogEntryRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, msg := range m.Instances {
			dAtA[i] = 0xa
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.AdapterConfig != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.AdapterConfig.Size()))
		n1, err := m.AdapterConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if len(m.DedupId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.DedupId)))
		i += copy(dAtA[i:], m.DedupId)
	}
	return i, nil
}

func (m *InstanceMsg) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceMsg) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for k, _ := range m.Variables {
			dAtA[i] = 0xa
			i++
			v := m.Variables[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovTemplateHandlerService(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + msgSize
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintTemplateHandlerService(dAtA, i, uint64(v.Size()))
				n2, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n2
			}
		}
	}
	if m.Timestamp != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(m.Timestamp.Size()))
		n3, err := m.Timestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.Severity) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Severity)))
		i += copy(dAtA[i:], m.Severity)
	}
	if len(m.MonitoredResourceType) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.MonitoredResourceType)))
		i += copy(dAtA[i:], m.MonitoredResourceType)
	}
	if len(m.MonitoredResourceDimensions) > 0 {
		for k, _ := range m.MonitoredResourceDimensions {
			dAtA[i] = 0x2a
			i++
			v := m.MonitoredResourceDimensions[k]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovTemplateHandlerService(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + msgSize
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintTemplateHandlerService(dAtA, i, uint64(v.Size()))
				n4, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n4
			}
		}
	}
	if len(m.Name) > 0 {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0xe4
		i++
		dAtA[i] = 0x93
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Name)))
		i += copy(dAtA[i:], m.Name)
	}
	return i, nil
}

func (m *Type) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Type) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for k, _ := range m.Variables {
			dAtA[i] = 0xa
			i++
			v := m.Variables[k]
			mapSize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + sovTemplateHandlerService(uint64(v))
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(v))
		}
	}
	if len(m.MonitoredResourceDimensions) > 0 {
		for k, _ := range m.MonitoredResourceDimensions {
			dAtA[i] = 0x2a
			i++
			v := m.MonitoredResourceDimensions[k]
			mapSize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + sovTemplateHandlerService(uint64(v))
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x10
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(v))
		}
	}
	return i, nil
}

func (m *InstanceParam) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InstanceParam) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for k, _ := range m.Variables {
			dAtA[i] = 0xa
			i++
			v := m.Variables[k]
			mapSize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovTemplateHandlerService(uint64(len(v)))
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	if len(m.Timestamp) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Timestamp)))
		i += copy(dAtA[i:], m.Timestamp)
	}
	if len(m.Severity) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.Severity)))
		i += copy(dAtA[i:], m.Severity)
	}
	if len(m.MonitoredResourceType) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(m.MonitoredResourceType)))
		i += copy(dAtA[i:], m.MonitoredResourceType)
	}
	if len(m.MonitoredResourceDimensions) > 0 {
		for k, _ := range m.MonitoredResourceDimensions {
			dAtA[i] = 0x2a
			i++
			v := m.MonitoredResourceDimensions[k]
			mapSize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovTemplateHandlerService(uint64(len(v)))
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintTemplateHandlerService(dAtA, i, uint64(len(v)))
			i += copy(dAtA[i:], v)
		}
	}
	return i, nil
}

func encodeVarintTemplateHandlerService(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *HandleLogEntryRequest) Size() (n int) {
	var l int
	_ = l
	if len(m.Instances) > 0 {
		for _, e := range m.Instances {
			l = e.Size()
			n += 1 + l + sovTemplateHandlerService(uint64(l))
		}
	}
	if m.AdapterConfig != nil {
		l = m.AdapterConfig.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.DedupId)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *InstanceMsg) Size() (n int) {
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for k, v := range m.Variables {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovTemplateHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	if m.Timestamp != nil {
		l = m.Timestamp.Size()
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.Severity)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.MonitoredResourceType)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if len(m.MonitoredResourceDimensions) > 0 {
		for k, v := range m.MonitoredResourceDimensions {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovTemplateHandlerService(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.Name)
	if l > 0 {
		n += 5 + l + sovTemplateHandlerService(uint64(l))
	}
	return n
}

func (m *Type) Size() (n int) {
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for k, v := range m.Variables {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + sovTemplateHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	if len(m.MonitoredResourceDimensions) > 0 {
		for k, v := range m.MonitoredResourceDimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + sovTemplateHandlerService(uint64(v))
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *InstanceParam) Size() (n int) {
	var l int
	_ = l
	if len(m.Variables) > 0 {
		for k, v := range m.Variables {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	l = len(m.Timestamp)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.Severity)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	l = len(m.MonitoredResourceType)
	if l > 0 {
		n += 1 + l + sovTemplateHandlerService(uint64(l))
	}
	if len(m.MonitoredResourceDimensions) > 0 {
		for k, v := range m.MonitoredResourceDimensions {
			_ = k
			_ = v
			mapEntrySize := 1 + len(k) + sovTemplateHandlerService(uint64(len(k))) + 1 + len(v) + sovTemplateHandlerService(uint64(len(v)))
			n += mapEntrySize + 1 + sovTemplateHandlerService(uint64(mapEntrySize))
		}
	}
	return n
}

func sovTemplateHandlerService(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozTemplateHandlerService(x uint64) (n int) {
	return sovTemplateHandlerService(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *HandleLogEntryRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HandleLogEntryRequest{`,
		`Instances:` + strings.Replace(fmt.Sprintf("%v", this.Instances), "InstanceMsg", "InstanceMsg", 1) + `,`,
		`AdapterConfig:` + strings.Replace(fmt.Sprintf("%v", this.AdapterConfig), "Any", "google_protobuf1.Any", 1) + `,`,
		`DedupId:` + fmt.Sprintf("%v", this.DedupId) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceMsg) String() string {
	if this == nil {
		return "nil"
	}
	keysForVariables := make([]string, 0, len(this.Variables))
	for k, _ := range this.Variables {
		keysForVariables = append(keysForVariables, k)
	}
	sortkeys.Strings(keysForVariables)
	mapStringForVariables := "map[string]*istio_policy_v1beta11.Value{"
	for _, k := range keysForVariables {
		mapStringForVariables += fmt.Sprintf("%v: %v,", k, this.Variables[k])
	}
	mapStringForVariables += "}"
	keysForMonitoredResourceDimensions := make([]string, 0, len(this.MonitoredResourceDimensions))
	for k, _ := range this.MonitoredResourceDimensions {
		keysForMonitoredResourceDimensions = append(keysForMonitoredResourceDimensions, k)
	}
	sortkeys.Strings(keysForMonitoredResourceDimensions)
	mapStringForMonitoredResourceDimensions := "map[string]*istio_policy_v1beta11.Value{"
	for _, k := range keysForMonitoredResourceDimensions {
		mapStringForMonitoredResourceDimensions += fmt.Sprintf("%v: %v,", k, this.MonitoredResourceDimensions[k])
	}
	mapStringForMonitoredResourceDimensions += "}"
	s := strings.Join([]string{`&InstanceMsg{`,
		`Variables:` + mapStringForVariables + `,`,
		`Timestamp:` + strings.Replace(fmt.Sprintf("%v", this.Timestamp), "TimeStamp", "istio_policy_v1beta11.TimeStamp", 1) + `,`,
		`Severity:` + fmt.Sprintf("%v", this.Severity) + `,`,
		`MonitoredResourceType:` + fmt.Sprintf("%v", this.MonitoredResourceType) + `,`,
		`MonitoredResourceDimensions:` + mapStringForMonitoredResourceDimensions + `,`,
		`Name:` + fmt.Sprintf("%v", this.Name) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Type) String() string {
	if this == nil {
		return "nil"
	}
	keysForVariables := make([]string, 0, len(this.Variables))
	for k, _ := range this.Variables {
		keysForVariables = append(keysForVariables, k)
	}
	sortkeys.Strings(keysForVariables)
	mapStringForVariables := "map[string]istio_policy_v1beta1.ValueType{"
	for _, k := range keysForVariables {
		mapStringForVariables += fmt.Sprintf("%v: %v,", k, this.Variables[k])
	}
	mapStringForVariables += "}"
	keysForMonitoredResourceDimensions := make([]string, 0, len(this.MonitoredResourceDimensions))
	for k, _ := range this.MonitoredResourceDimensions {
		keysForMonitoredResourceDimensions = append(keysForMonitoredResourceDimensions, k)
	}
	sortkeys.Strings(keysForMonitoredResourceDimensions)
	mapStringForMonitoredResourceDimensions := "map[string]istio_policy_v1beta1.ValueType{"
	for _, k := range keysForMonitoredResourceDimensions {
		mapStringForMonitoredResourceDimensions += fmt.Sprintf("%v: %v,", k, this.MonitoredResourceDimensions[k])
	}
	mapStringForMonitoredResourceDimensions += "}"
	s := strings.Join([]string{`&Type{`,
		`Variables:` + mapStringForVariables + `,`,
		`MonitoredResourceDimensions:` + mapStringForMonitoredResourceDimensions + `,`,
		`}`,
	}, "")
	return s
}
func (this *InstanceParam) String() string {
	if this == nil {
		return "nil"
	}
	keysForVariables := make([]string, 0, len(this.Variables))
	for k, _ := range this.Variables {
		keysForVariables = append(keysForVariables, k)
	}
	sortkeys.Strings(keysForVariables)
	mapStringForVariables := "map[string]string{"
	for _, k := range keysForVariables {
		mapStringForVariables += fmt.Sprintf("%v: %v,", k, this.Variables[k])
	}
	mapStringForVariables += "}"
	keysForMonitoredResourceDimensions := make([]string, 0, len(this.MonitoredResourceDimensions))
	for k, _ := range this.MonitoredResourceDimensions {
		keysForMonitoredResourceDimensions = append(keysForMonitoredResourceDimensions, k)
	}
	sortkeys.Strings(keysForMonitoredResourceDimensions)
	mapStringForMonitoredResourceDimensions := "map[string]string{"
	for _, k := range keysForMonitoredResourceDimensions {
		mapStringForMonitoredResourceDimensions += fmt.Sprintf("%v: %v,", k, this.MonitoredResourceDimensions[k])
	}
	mapStringForMonitoredResourceDimensions += "}"
	s := strings.Join([]string{`&InstanceParam{`,
		`Variables:` + mapStringForVariables + `,`,
		`Timestamp:` + fmt.Sprintf("%v", this.Timestamp) + `,`,
		`Severity:` + fmt.Sprintf("%v", this.Severity) + `,`,
		`MonitoredResourceType:` + fmt.Sprintf("%v", this.MonitoredResourceType) + `,`,
		`MonitoredResourceDimensions:` + mapStringForMonitoredResourceDimensions + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringTemplateHandlerService(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *HandleLogEntryRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandleLogEntryRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandleLogEntryRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Instances", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Instances = append(m.Instances, &InstanceMsg{})
			if err := m.Instances[len(m.Instances)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdapterConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdapterConfig == nil {
				m.AdapterConfig = &google_protobuf1.Any{}
			}
			if err := m.AdapterConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DedupId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DedupId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceMsg) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceMsg: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceMsg: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Variables == nil {
				m.Variables = make(map[string]*istio_policy_v1beta11.Value)
			}
			var mapkey string
			var mapvalue *istio_policy_v1beta11.Value
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &istio_policy_v1beta11.Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Variables[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Timestamp == nil {
				m.Timestamp = &istio_policy_v1beta11.TimeStamp{}
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Severity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonitoredResourceType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MonitoredResourceType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonitoredResourceDimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MonitoredResourceDimensions == nil {
				m.MonitoredResourceDimensions = make(map[string]*istio_policy_v1beta11.Value)
			}
			var mapkey string
			var mapvalue *istio_policy_v1beta11.Value
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &istio_policy_v1beta11.Value{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.MonitoredResourceDimensions[mapkey] = mapvalue
			iNdEx = postIndex
		case 72295727:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Type) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Type: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Type: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Variables == nil {
				m.Variables = make(map[string]istio_policy_v1beta1.ValueType)
			}
			var mapkey string
			var mapvalue istio_policy_v1beta1.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (istio_policy_v1beta1.ValueType(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Variables[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonitoredResourceDimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MonitoredResourceDimensions == nil {
				m.MonitoredResourceDimensions = make(map[string]istio_policy_v1beta1.ValueType)
			}
			var mapkey string
			var mapvalue istio_policy_v1beta1.ValueType
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (istio_policy_v1beta1.ValueType(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.MonitoredResourceDimensions[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InstanceParam) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InstanceParam: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InstanceParam: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Variables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Variables == nil {
				m.Variables = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Variables[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Timestamp = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Severity", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Severity = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonitoredResourceType", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MonitoredResourceType = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MonitoredResourceDimensions", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MonitoredResourceDimensions == nil {
				m.MonitoredResourceDimensions = make(map[string]string)
			}
			var mapkey string
			var mapvalue string
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var stringLenmapvalue uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowTemplateHandlerService
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapvalue |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapvalue := int(stringLenmapvalue)
					if intStringLenmapvalue < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					postStringIndexmapvalue := iNdEx + intStringLenmapvalue
					if postStringIndexmapvalue > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = string(dAtA[iNdEx:postStringIndexmapvalue])
					iNdEx = postStringIndexmapvalue
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthTemplateHandlerService
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.MonitoredResourceDimensions[mapkey] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipTemplateHandlerService(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthTemplateHandlerService
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipTemplateHandlerService(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowTemplateHandlerService
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowTemplateHandlerService
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthTemplateHandlerService
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowTemplateHandlerService
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipTemplateHandlerService(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthTemplateHandlerService = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowTemplateHandlerService   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("mixer/template/logentry/template_handler_service.proto", fileDescriptorTemplateHandlerService)
}

var fileDescriptorTemplateHandlerService = []byte{
	// 731 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x55, 0x4f, 0x6b, 0x13, 0x4d,
	0x18, 0xcf, 0x26, 0xe9, 0xfb, 0x36, 0x53, 0x1a, 0x5e, 0x86, 0x86, 0x37, 0x4d, 0xed, 0x36, 0x04,
	0x91, 0x1c, 0x64, 0x97, 0xb6, 0x58, 0x8a, 0xd5, 0x83, 0xb5, 0x82, 0x05, 0x2b, 0xb2, 0x2d, 0x05,
	0x0f, 0x12, 0x36, 0xd9, 0xa7, 0xeb, 0xd0, 0xdd, 0x9d, 0x75, 0x76, 0x12, 0xba, 0xea, 0x41, 0x3c,
	0x79, 0x14, 0xfa, 0x15, 0x3c, 0x78, 0xf3, 0x0b, 0x08, 0x5e, 0x8b, 0xa7, 0xa2, 0x17, 0x2f, 0x82,
	0x89, 0x3d, 0x78, 0xec, 0xd1, 0xa3, 0x64, 0x76, 0xb2, 0x49, 0xd3, 0xa4, 0x86, 0x56, 0x6f, 0x3b,
	0xfb, 0xfc, 0x66, 0xe6, 0xf9, 0xfd, 0x19, 0x1e, 0xb4, 0xe4, 0x92, 0x3d, 0x60, 0x3a, 0x07, 0xd7,
	0x77, 0x4c, 0x0e, 0xba, 0x43, 0x6d, 0xf0, 0x38, 0x0b, 0xe3, 0x3f, 0x95, 0xc7, 0xa6, 0x67, 0x39,
	0xc0, 0x2a, 0x01, 0xb0, 0x06, 0xa9, 0x81, 0xe6, 0x33, 0xca, 0x29, 0x1e, 0xef, 0x00, 0x0b, 0x53,
	0x36, 0xb5, 0xa9, 0xf8, 0xa9, 0xb7, 0xbf, 0xa2, 0x7a, 0xe1, 0x6a, 0x74, 0xae, 0x69, 0x99, 0x3e,
	0x07, 0xa6, 0xbb, 0xd4, 0x02, 0x47, 0x6f, 0xcc, 0x57, 0x81, 0x9b, 0xf3, 0x3a, 0xec, 0x71, 0xf0,
	0x02, 0x42, 0xbd, 0x40, 0xa2, 0xa7, 0x6d, 0x4a, 0x6d, 0x07, 0x74, 0xb1, 0xaa, 0xd6, 0x77, 0x74,
	0xd3, 0x0b, 0x65, 0xa9, 0x7c, 0xd6, 0x41, 0x0c, 0x7c, 0xca, 0xb8, 0x44, 0xce, 0xf9, 0xd4, 0x21,
	0xb5, 0x30, 0x2e, 0x36, 0x4c, 0xa7, 0x0e, 0x15, 0x1e, 0xfa, 0xd0, 0xb9, 0xa5, 0x0f, 0xd0, 0x2d,
	0x95, 0xde, 0x28, 0x28, 0x77, 0x57, 0x10, 0xbd, 0x47, 0xed, 0x3b, 0x6d, 0x5e, 0x06, 0x3c, 0xa9,
	0x43, 0xc0, 0xf1, 0x22, 0xca, 0x10, 0x2f, 0xe0, 0xa6, 0x57, 0x83, 0x20, 0xaf, 0x14, 0x53, 0xe5,
	0x89, 0x85, 0x9c, 0xd6, 0x21, 0xaf, 0xad, 0xcb, 0xd2, 0x46, 0x60, 0x1b, 0x5d, 0x1c, 0x5e, 0x41,
	0x59, 0xd9, 0x70, 0xa5, 0x46, 0xbd, 0x1d, 0x62, 0xe7, 0x93, 0x45, 0xa5, 0x3c, 0xb1, 0x30, 0xa5,
	0x45, 0x44, 0xb5, 0x0e, 0x51, 0xed, 0x96, 0x17, 0x1a, 0x93, 0x12, 0x7b, 0x5b, 0x40, 0xf1, 0x34,
	0x1a, 0xb7, 0xc0, 0xaa, 0xfb, 0x15, 0x62, 0xe5, 0x53, 0x45, 0xa5, 0x9c, 0x31, 0xfe, 0x15, 0xeb,
	0x75, 0xab, 0xf4, 0x21, 0x8d, 0x26, 0x7a, 0xae, 0xc4, 0xab, 0x28, 0xd3, 0x30, 0x19, 0x31, 0xab,
	0x4e, 0xdc, 0xdc, 0xe5, 0x81, 0xcd, 0x69, 0xdb, 0x1d, 0x58, 0x44, 0xae, 0xbb, 0x0d, 0xdf, 0x44,
	0x19, 0x4e, 0x5c, 0x08, 0xb8, 0xe9, 0xfa, 0xb2, 0xcd, 0x39, 0x8d, 0x04, 0x9c, 0x50, 0x2d, 0xd2,
	0x4b, 0x93, 0x7a, 0x69, 0x5b, 0xc4, 0x85, 0xcd, 0x36, 0xcc, 0xe8, 0xee, 0xc0, 0x05, 0x34, 0x1e,
	0x40, 0x03, 0x18, 0xe1, 0xa1, 0xec, 0x36, 0x5e, 0xe3, 0x25, 0xf4, 0xbf, 0x4b, 0x3d, 0xc2, 0x29,
	0x03, 0xab, 0xc2, 0x20, 0xa0, 0x75, 0x56, 0x8b, 0x1c, 0xc9, 0xa7, 0x05, 0x34, 0x17, 0x97, 0x0d,
	0x59, 0xdd, 0x0a, 0x7d, 0xc0, 0x4f, 0xd1, 0xec, 0x80, 0x7d, 0x16, 0x71, 0x65, 0x6a, 0xf2, 0x63,
	0x82, 0xea, 0xd2, 0x60, 0xaa, 0x1b, 0xfd, 0x67, 0xae, 0xc5, 0x1b, 0x23, 0xf2, 0x33, 0xee, 0x70,
	0x04, 0xce, 0xa1, 0xb4, 0x67, 0xba, 0x90, 0x7f, 0xf7, 0xf1, 0x7d, 0x49, 0xf4, 0x28, 0x96, 0x85,
	0x87, 0x28, 0x7b, 0x52, 0x42, 0xfc, 0x1f, 0x4a, 0xed, 0x42, 0x98, 0x57, 0x04, 0xa8, 0xfd, 0x89,
	0xe7, 0xd1, 0x98, 0xc8, 0x9c, 0x54, 0x71, 0x66, 0xb0, 0x8a, 0xdb, 0x6d, 0x88, 0x11, 0x21, 0xaf,
	0x27, 0x97, 0x95, 0xc2, 0x2e, 0x2a, 0xfe, 0xae, 0xe5, 0x3f, 0x76, 0x59, 0xe9, 0x55, 0x0a, 0xa5,
	0x85, 0xc6, 0x2b, 0xa7, 0xa3, 0x33, 0xdb, 0xd5, 0xb3, 0x0d, 0x39, 0x23, 0x33, 0xc1, 0x68, 0x06,
	0xe9, 0x7d, 0x07, 0x5e, 0xc8, 0x99, 0xc2, 0xa3, 0x11, 0x2c, 0xb8, 0xd6, 0xab, 0x4a, 0x76, 0x58,
	0x90, 0x85, 0x2a, 0xed, 0x8e, 0x7a, 0x6d, 0xa0, 0xe7, 0xb2, 0xe1, 0xfc, 0x17, 0x96, 0x3e, 0xa7,
	0xd0, 0x64, 0x27, 0xb7, 0x0f, 0x4c, 0x66, 0xba, 0x78, 0xed, 0xb4, 0x27, 0x57, 0x4e, 0x67, 0x5c,
	0x60, 0xcf, 0x30, 0xe7, 0x52, 0xff, 0x83, 0xce, 0xfc, 0xed, 0xf7, 0xfa, 0x7c, 0xb4, 0x38, 0x2c,
	0x0f, 0xe3, 0x72, 0xb1, 0x5c, 0xdc, 0x18, 0x21, 0x17, 0x53, 0xbd, 0x36, 0x65, 0x7a, 0x6d, 0xbf,
	0x7f, 0x2e, 0xdb, 0x87, 0x9e, 0xb7, 0xf0, 0xac, 0x7f, 0x90, 0x6c, 0x46, 0x73, 0x13, 0x57, 0x51,
	0xf6, 0x64, 0x01, 0xcf, 0x75, 0xf5, 0x18, 0x38, 0x7b, 0x0a, 0xba, 0x4c, 0x93, 0x18, 0x81, 0x9a,
	0x9c, 0x12, 0x9a, 0x18, 0x81, 0x71, 0xb4, 0x0c, 0x31, 0x02, 0x0d, 0x08, 0xea, 0x0e, 0x5f, 0x5d,
	0x3b, 0x68, 0xaa, 0x89, 0xc3, 0xa6, 0x9a, 0xf8, 0xd2, 0x54, 0x13, 0xc7, 0x4d, 0x35, 0xf1, 0xa2,
	0xa5, 0x2a, 0x6f, 0x5b, 0x6a, 0xe2, 0xa0, 0xa5, 0x2a, 0x87, 0x2d, 0x55, 0xf9, 0xd6, 0x52, 0x95,
	0x1f, 0x2d, 0x35, 0x71, 0xdc, 0x52, 0x95, 0xd7, 0xdf, 0xd5, 0xc4, 0xcf, 0x4f, 0x47, 0xfb, 0x49,
	0xe5, 0xe5, 0xd7, 0xa3, 0xfd, 0x64, 0x3c, 0xd1, 0xab, 0xff, 0x88, 0xe9, 0xb4, 0xf8, 0x2b, 0x00,
	0x00, 0xff, 0xff, 0xb7, 0x15, 0xe2, 0x41, 0x1c, 0x08, 0x00, 0x00,
}
