// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: mixer/adapter/kubernetesenv/config/config.proto

/*
	Package config is a generated protocol buffer package.

	The `kubernetesenv` adapter extracts information from a Kubernetes environment
	and produces attribtes that can be used in downstream adapters.

	This adapter supports the [kubernetesenv template](https://istio.io/docs/reference/config/policy-and-telemetry/templates/kubernetes/).

	It is generated from these files:
		mixer/adapter/kubernetesenv/config/config.proto

	It has these top-level messages:
		Params
*/
package config

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "github.com/gogo/protobuf/types"

import time "time"

import types "github.com/gogo/protobuf/types"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// Configuration parameters for the kubernetes adapter. These params
// control the manner in which the kubernetes adapter discovers and
// generates values related to pod information.
//
// The adapter works by looking up pod information by UIDs (of the
// form: "kubernetes://pod.namespace"). It expects that the UIDs will be
// supplied in an input map for three distinct traffic classes (source,
// destination, and origin).
//
// For all valid UIDs supplied, this adapter generates output
// values containing information about the related pods.
type Params struct {
	// File path to discover kubeconfig. For in-cluster configuration,
	// this should be left unset. For local configuration, this should
	// be set to the path of a kubeconfig file that can be used to
	// reach a kubernetes API server.
	//
	// NOTE: The kubernetes adapter will use the value of the env var
	// KUBECONFIG in the case where it is set (overriding any value configured
	// through this proto).
	//
	// Default: "" (unset)
	KubeconfigPath string `protobuf:"bytes,1,opt,name=kubeconfig_path,json=kubeconfigPath,proto3" json:"kubeconfig_path,omitempty"`
	// Controls the resync period of the kubernetes cluster info cache.
	// The cache will watch for events and every so often completely resync.
	// This controls how frequently the complete resync occurs.
	//
	// Default: 5 minutes
	CacheRefreshDuration time.Duration `protobuf:"bytes,2,opt,name=cache_refresh_duration,json=cacheRefreshDuration,stdduration" json:"cache_refresh_duration"`
}

func (m *Params) Reset()                    { *m = Params{} }
func (*Params) ProtoMessage()               {}
func (*Params) Descriptor() ([]byte, []int) { return fileDescriptorConfig, []int{0} }

func init() {
	proto.RegisterType((*Params)(nil), "adapter.kubernetesenv.config.Params")
}
func (m *Params) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Params) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.KubeconfigPath) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintConfig(dAtA, i, uint64(len(m.KubeconfigPath)))
		i += copy(dAtA[i:], m.KubeconfigPath)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintConfig(dAtA, i, uint64(types.SizeOfStdDuration(m.CacheRefreshDuration)))
	n1, err := types.StdDurationMarshalTo(m.CacheRefreshDuration, dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func encodeVarintConfig(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *Params) Size() (n int) {
	var l int
	_ = l
	l = len(m.KubeconfigPath)
	if l > 0 {
		n += 1 + l + sovConfig(uint64(l))
	}
	l = types.SizeOfStdDuration(m.CacheRefreshDuration)
	n += 1 + l + sovConfig(uint64(l))
	return n
}

func sovConfig(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozConfig(x uint64) (n int) {
	return sovConfig(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Params) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Params{`,
		`KubeconfigPath:` + fmt.Sprintf("%v", this.KubeconfigPath) + `,`,
		`CacheRefreshDuration:` + strings.Replace(strings.Replace(this.CacheRefreshDuration.String(), "Duration", "google_protobuf1.Duration", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringConfig(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Params) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Params: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Params: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KubeconfigPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KubeconfigPath = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CacheRefreshDuration", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthConfig
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := types.StdDurationUnmarshal(&m.CacheRefreshDuration, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipConfig(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthConfig
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipConfig(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowConfig
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowConfig
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthConfig
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowConfig
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipConfig(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthConfig = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowConfig   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("mixer/adapter/kubernetesenv/config/config.proto", fileDescriptorConfig)
}

var fileDescriptorConfig = []byte{
	// 297 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x54, 0x8e, 0xbd, 0x4e, 0xc3, 0x30,
	0x14, 0x85, 0x6d, 0x70, 0x43, 0x08, 0x12, 0x44, 0x55, 0x85, 0x4a, 0x85, 0x6e, 0x2b, 0x16, 0x3a,
	0xd9, 0x12, 0x2c, 0xcc, 0x15, 0x53, 0xa6, 0xaa, 0x1b, 0x2c, 0x95, 0xdb, 0xba, 0x49, 0x04, 0x8d,
	0x23, 0xc7, 0x41, 0x8c, 0x3c, 0x02, 0x23, 0x0f, 0xc0, 0xc0, 0xa3, 0x64, 0xec, 0xc8, 0x04, 0xc4,
	0x2c, 0x8c, 0x7d, 0x04, 0xd4, 0x38, 0x11, 0x62, 0xf2, 0xcf, 0xfd, 0xee, 0x77, 0x8e, 0xc7, 0x56,
	0xf1, 0xa3, 0x50, 0x8c, 0x2f, 0x78, 0xaa, 0x85, 0x62, 0x77, 0xf9, 0x4c, 0xa8, 0x44, 0x68, 0x91,
	0x89, 0xe4, 0x81, 0xcd, 0x65, 0xb2, 0x8c, 0xc3, 0xfa, 0xa0, 0xa9, 0x92, 0x5a, 0xb6, 0x4f, 0x6b,
	0x94, 0xfe, 0x43, 0xa9, 0x65, 0x7a, 0x9d, 0x50, 0x86, 0xb2, 0x02, 0xd9, 0xf6, 0x66, 0x77, 0x7a,
	0x10, 0x4a, 0x19, 0xde, 0x0b, 0x56, 0xbd, 0x66, 0xf9, 0x92, 0x2d, 0x72, 0xc5, 0x75, 0x2c, 0x13,
	0x3b, 0x3f, 0x7b, 0xc5, 0x9e, 0x33, 0xe6, 0x8a, 0xaf, 0xb2, 0xf6, 0xb9, 0x77, 0xb4, 0x15, 0x5b,
	0xdd, 0x34, 0xe5, 0x3a, 0xea, 0xe2, 0x01, 0x1e, 0xee, 0x4f, 0x0e, 0xff, 0xbe, 0xc7, 0x5c, 0x47,
	0xed, 0x1b, 0xef, 0x78, 0xce, 0xe7, 0x91, 0x98, 0x2a, 0xb1, 0x54, 0x22, 0x8b, 0xa6, 0x8d, 0xb3,
	0xbb, 0x33, 0xc0, 0xc3, 0x83, 0x8b, 0x13, 0x6a, 0x43, 0x69, 0x13, 0x4a, 0xaf, 0x6b, 0x60, 0xe4,
	0x16, 0x1f, 0x7d, 0xf4, 0xf2, 0xd9, 0xc7, 0x93, 0x4e, 0xa5, 0x98, 0x58, 0x43, 0x33, 0x0f, 0x88,
	0xbb, 0xeb, 0x93, 0x80, 0xb8, 0xc4, 0x6f, 0x05, 0xc4, 0x6d, 0xf9, 0x4e, 0x40, 0x5c, 0xc7, 0xdf,
	0x1b, 0x5d, 0x15, 0x25, 0xa0, 0x75, 0x09, 0xe8, 0xbd, 0x04, 0xb4, 0x29, 0x01, 0x3d, 0x19, 0xc0,
	0x6f, 0x06, 0x50, 0x61, 0x00, 0xaf, 0x0d, 0xe0, 0x2f, 0x03, 0xf8, 0xc7, 0x00, 0xda, 0x18, 0xc0,
	0xcf, 0xdf, 0x80, 0x6e, 0x1d, 0x5b, 0x78, 0xe6, 0x54, 0x25, 0x2e, 0x7f, 0x03, 0x00, 0x00, 0xff,
	0xff, 0x36, 0xd7, 0x73, 0x71, 0x6e, 0x01, 0x00, 0x00,
}
