package notification

const (
	SyncWillStart   = "com.apple.itunes-mobdev.syncWillStart"
	SyncDidStart    = "com.apple.itunes-mobdev.syncDidStart"
	SyncDidFinish   = "com.apple.itunes-mobdev.syncDidFinish"
	SyncLockRequest = "com.apple.itunes-mobdev.syncLockRequest"
)

const (
	SyncCancelRequest            = "com.apple.itunes-client.syncCancelRequest"
	SyncSuspendRequest           = "com.apple.itunes-client.syncSuspendRequest"
	SyncResumeRequest            = "com.apple.itunes-client.syncResumeRequest"
	PhoneNumberChanged           = "com.apple.mobile.lockdown.phone_number_changed"
	DeviceNameChanged            = "com.apple.mobile.lockdown.device_name_changed"
	TimezoneChanged              = "com.apple.mobile.lockdown.timezone_changed"
	TrustedHostAttached          = "com.apple.mobile.lockdown.trusted_host_attached"
	HostDetached                 = "com.apple.mobile.lockdown.host_detached"
	HostAttached                 = "com.apple.mobile.lockdown.host_attached"
	RegistrationFailed           = "com.apple.mobile.lockdown.registration_failed"
	ActivationState              = "com.apple.mobile.lockdown.activation_state"
	BrickState                   = "com.apple.mobile.lockdown.brick_state"
	DiskUageChanged              = "com.apple.mobile.lockdown.disk_usage_changed"
	DataSyncDomainChanged        = "com.apple.mobile.data_sync.domain_changed"
	BackupDomainChanged          = "com.apple.mobile.backup.domain_changed"
	ApplicationInstalled         = "com.apple.mobile.application_installed"
	ApplicationUninstalled       = "com.apple.mobile.application_uninstalled"
	DeveloperImageMounter        = "com.apple.mobile.developer_image_mounted"
	AttemptActivation            = "com.apple.springboard.attemptactivation"
	ITDBPrepNoficationDidEnd     = "com.apple.itdbprep.notification.didEnd"
	LanguageChanged              = "com.apple.language.changed"
	AddressBookPreferenceChanged = "com.apple.AddressBook.PreferenceChanged"
)

// CREDIT: https://github.com/doronz88/pymobiledevice3/blob/master/pymobiledevice3/resources/notifications.txt
var notifications = []string{
	"com.apple.networkextension.app-paths-changed",
	"com.apple.ap.adprivacyd.iTunesActiveStorefrontDidChangeNotification",
	"com.apple.ManagedConfiguration.profileListChanged",
	"com.apple.mobileslideshow.ICPLStateChanged",
	"EKNotificationCountChangedExternallyNotification",
	"com.apple.tv.updateAppVisibility",
	"com.apple.bluetooth.connection",
	"com.apple.duetexpertd.ATXAnchorModel.invalidate.ChargerConnectedAnchor",
	"com.apple.LaunchServices.ApplicationsChanged",
	"kCalEventOccurrenceCacheChangedNotification",
	"com.apple.MobileAsset.ProactiveEventTrackerAssets.ma.new-asset-installed",
	"com.apple.family.family_updated",
	"com.apple.mobilecal.invitationalertschanged",
	"com.apple.LoginKit.isLoggedIn",
	"com.apple.ams.privateListeningChanged",
	"com.apple.coreaudio.RoutingConfiguration",
	"com.apple.siri.ShortcutsCloudKitAccountAddedNotification",
	"com.apple.security.publickeyavailable",
	"com.apple.springboard.finishedstartup",
	"com.apple.AirTunes.DACP.play",
	"com.apple.softwareupdate.autoinstall.startInstall",
	"com.apple.ProtectedCloudStorage.updatedKeys",
	"com.apple.nanomusic.sync.defaults",
	"kAFPreferencesDidChangeDarwinNotification",
	"com.apple.siri.koa.donate",
	"com.apple.softwareupdateservicesd.activity.splatAutoScan",
	"com.apple.AirTunes.DACP.volumedown",
	"com.apple.appstored.ActivitySubEntitlementsCacheUpdated",
	"com.apple.tv.appRemoved",
	"com.apple.mobilecal.preference.notification.weekStart",
	"com.apple.mobileipod.keeplocalstatechanged",
	"com.apple.accessibility.cache.invert.colors",
	"com.apple.duetexpertd.ATXAnchorModel.invalidate.BluetoothConnectedAnchor",
	"CNContactStoreMeContactDidChangeNotification",
	"com.apple.duetexpertd.ms.carplaydisconnect",
	"com.apple.duetexpertd.ATXScreenUnlockUpdateSource",
	"com.apple.mobile.lockdown.activation_state",
	"com.apple.kvs.store-did-change.com.apple.iBooks",
	"com.apple.eventkit.preference.notification.UnselectedCalendarIdentifiersForFocusMode",
	"com.apple.security.cloudkeychain.forceupdate",
	"com.apple.datamigrator.migrationDidFinish",
	"com.apple.assistant.app_vocabulary",
	"com.apple.voicetrigger.enablePolicyChanged",
	"com.apple.duetexpertd.ATXAnchorModel.ChargerConnectedAnchor",
	"com.apple.security.view-ready.SE-PTC",
	"com.apple.MobileAsset.VoiceTriggerAssetsIPad.ma.cached-metadata-updated",
	"com.apple.duetexpertd.ms.nowplayingplay",
	"com.apple.security.octagon.peer-changed",
	"com.apple.softwareupdateservicesd.SUCoreConfigScheduledScan",
	"com.apple.ManagedConfiguration.webContentFilterChanged",
	"AppleKeyboardsPreferencesChangedNotification",
	"com.apple.mobile.keybagd.first_unlock",
	"com.apple.carkit.capabilities-changed",
	"com.apple.NanoPhotos.Library.changed",
	"SUPreferencesChangedNotification",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.keyboard",
	"com.apple.security.octagon.joined-with-bottle",
	"com.apple.EscrowSecurityAlert.server",
	"com.apple.telephonyutilities.callservicesd.fakeoutgoingmessage",
	"com.apple.duetexpertd.donationmonitor.intent",
	"com.apple.MediaRemote.nowPlayingActivePlayersIsPlayingDidChange",
	"com.apple.kvs.store-did-change.com.apple.sleepd",
	"com.apple.duetexpertd.mm.bluetoothconnected",
	"com.apple.security.view-change.PCS",
	"com.apple.trial.NamespaceUpdate.SIRI_VALUE_INFERENCE_CONTACT_RESOLUTION",
	"com.apple.cloud.quota.simulate.vfs.almostfull",
	"com.apple.dmd.iCloudAccount.didChange",
	"com.apple.system.batterysavermode.first_time",
	"com.apple.idscredentials.idslaunchnotification",
	"com.apple.triald.wake",
	"com.apple.system.lowpowermode.auto_disabled",
	"com.apple.UsageTrackingAgent.registration.application",
	"com.apple.system.batterysavermode",
	"com.apple.MobileAsset.VoiceServices.VoiceResources.new-asset-installed",
	"com.apple.MobileAsset.VoiceTriggerHSAssetsIPad.ma.new-asset-installed",
	"AppleDatePreferencesChangedNotification",
	"com.apple.duetexpertd.updateDefaultsDueToRelevantHomeScreenConfigUpdate",
	"com.apple.homed.AppleTVAccessoryAdded",
	"com.apple.photostream.idslaunchnotification",
	"SLSharedWithYouSettingHasChanged",
	"com.apple.MobileAsset.VoiceTriggerAssetsMarsh.ma.new-asset-installed",
	"com.apple.duetexpertd.ATXMMAppPredictor.WiredAudioDeviceDisconnectedAnchor",
	"com.apple.pasteboard.notify.changed",
	"com.apple.system.config.network_change",
	"com.apple.ProtectedCloudStorage.mobileBackupStateChange",
	"com.apple.corerecents.iCloudAccountChanged",
	"com.apple.duetexpertd.donationmonitor.activity",
	"com.apple.idsremoteurlconnection.idslaunchnotification",
	"com.apple.security.octagon.trust-status-change",
	"com.apple.icloud.searchparty.accessoryDidPair",
	"MISProvisioningProfileInstalled",
	"com.apple.ap.adprivacyd.iTunesActiveAccountDidChangeNotification",
	"com.apple.cloud.quota.simulate.vfs.notfull",
	"com.apple.softwareupdateservicesd.activity.installAlert",
	"com.apple.MobileAsset.VoiceTriggerAssets.ma.new-asset-installed",
	"com.apple.assistant.sync_needed",
	"com.apple.spotlightui.prefschanged",
	"com.apple.assistant.sync_homekit_now",
	"com.apple.AirTunes.DACP.pause",
	"com.apple.StoreServices.StorefrontChanged",
	"com.apple.smartcharging.defaultschanged",
	"com.apple.AirTunes.DACP.volumeup",
	"com.apple.MobileAsset.VoiceTriggerHSAssetsWatch.ma.cached-metadata-updated",
	"com.apple.mobileipod.displayvalueschanged",
	"com.apple.coreduetd.remoteDeviceChange",
	"com.apple.powerui.smartcharge",
	"com.apple.MobileAsset.VoiceServices.VoiceResources.ma.new-asset-installed",
	"com.apple.MobileAsset.VoiceTriggerHSAssetsIPad.ma.cached-metadata-updated",
	"com.apple.MusicLibrary.importFinished-/var/mobile/Media/iTunes_Control/iTunes/MediaLibrary.sqlitedb",
	"com.apple.mobiletimerd.chargetest",
	"com.apple.powermanagement.idlesleeppreventers",
	"com.apple.duetexpertd.clientModelRefreshBlendingLayer",
	"com.apple.nanoregistry.paireddevicedidchangeversion",
	"com.apple.duetexpertd.feedbackavailable",
	"com.apple.contacts.clientDidDisplayFavorites",
	"com.apple.appstored.NewsSubEntitlementsCacheUpdated",
	"com.apple.coreduetd.nearbydeviceschanged",
	"com.apple.networkextension.apps-changed",
	"AppleLanguagePreferencesChangedNotification",
	"CalSyncClientBeginningMultiSave",
	"com.apple.nanoregistry.devicedidpair",
	"com.apple.sleepd.ids.test",
	"com.apple.voiceservices.notification.voice-update",
	"com.apple.ProximityControl.LockScreenDiscovery",
	"com.apple.accessibility.cache.enhance.background.contrast",
	"com.apple.tv.TVWidgetExtension.Register",
	"com.apple.siri.cloud.synch.changed",
	"com.apple.system.lowpowermode",
	"com.apple.rapport.prefsChanged",
	"kKeepAppsUpToDateEnabledChangedNotification",
	"com.apple.powermanagement.restartpreventers",
	"com.apple.shortcuts.daemon-wakeup-request",
	"com.apple.jett.switch.environmentChange.idms.complete",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.international",
	"com.apple.telephonyutilities.callservicesdaemon.voicemailcallended",
	"com.apple.nanophotos.prefs.LibraryCollectionTargetMapData-changed",
	"com.apple.AirTunes.DACP.device-prevent-playback",
	"com.apple.appletv.backgroundstate",
	"com.apple.duetexpertd.ATXMMAppPredictor.CarPlayDisconnectedAnchor",
	"com.apple.nearfield.handoff.terminal",
	"com.apple.icloud.fmip.lostmode.enable",
	"com.apple.AOSNotification.FMIPStateDidChange",
	"com.apple.navd.backgroundCommute.startPredicting",
	"com.apple.system.clock_set",
	"com.apple.ProtectedCloudStorage.rollBackupDisabled",
	"com.apple.accessibility.cache.reduce.motion",
	"com.apple.mobile.storage_unmounted",
	"com.apple.ap.aes",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.controlcenter",
	"com.apple.itunesstored.accountschanged",
	"com.apple.siri.inference.coreduet-context",
	"com.apple.mobileipod.noncontentspropertieschanged",
	"com.apple.bookmarks.BookmarksFileChanged",
	"com.apple.locationd.vehicle.exit",
	"com.apple.mobilemail.afc.poll",
	"com.apple.locationd.vehicle.disconnected",
	"com.apple.cmfsyncagent.kvstorechange",
	"com.apple.SafariShared.Assistant.reload_plugin",
	"RTLocationsOfInterestDidChangeNotification",
	"com.apple.ttsasset.NewAssetNotification",
	"com.apple.ap.adprivacyd.deviceKnowledge",
	"com.apple.purplebuddy.setupdone",
	"HKHealthDaemonActiveWorkoutServersDidUpdateNotification",
	"com.apple.MobileAsset.VoiceTriggerAssets.ma.cached-metadata-updated",
	"com.apple.ap.adprivacyd.reconcile",
	"com.apple.icloud.findmydeviced.findkit.magSafe.removed",
	"com.apple.siri.ShortcutsCloudKitAccountModifiedNotification",
	"com.apple.pairedsync.syncDidComplete",
	"kFZVCAppBundleIdentifierLaunchNotification",
	"com.apple.parsecd.bag",
	"com.apple.appstored.TVSubEntitlementsCacheUpdated",
	"com.apple.symptoms.materialLinkQualityChange",
	"com.apple.MobileAsset.VoiceTriggerAssets.new-asset-installed",
	"com.apple.MobileAsset.VoiceServicesVocalizerVoice.ma.cached-metadata-updated",
	"com.apple.duetexpertd.ATXAnchorModel.invalidate.CarPlayConnectedAnchor",
	"com.apple.navd.wakeUpForHypothesisUpdate",
	"com.apple.duetexpertd.mm.bluetoothdisconnect",
	"com.apple.duetexpertd.ATXMMAppPredictor.IdleTimeEndAnchor",
	"com.apple.mobilecal.timezonechanged",
	"com.apple.proactive.information.source.weather",
	"com.apple.MobileAsset.VoiceTriggerAssets.cached-metadata-updated",
	"com.apple.duetexpertd.ATXMMAppPredictor.BluetoothConnectedAnchor",
	"com.apple.voicetrigger.RemoteDarwin.ConnectionChanged",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.displays",
	"com.apple.mobileipod-prefsChanged",
	"com.apple.CallHistoryPluginHelper.launchnotification",
	"com.apple.exchangesyncd.ping",
	"com.apple.homehubd.endpointDeactivated",
	"com.apple.wcd.wake-up",
	"com.apple.media.entities.siri_data_changed",
	"kFZACAppBundleIdentifierLaunchNotification",
	"com.apple.voicemail.changed",
	"PCPreferencesDidChangeNotification",
	"CSLDisableWristDetectionChangedNotification",
	"com.apple.MobileAsset.TimeZoneUpdate.ma.new-asset-installed",
	"com.apple.springboard.lockstate",
	"com.apple.homed.televisionAccessoryAdded",
	"com.apple.locationd.vehicular.changed.toVehicular",
	"com.apple.duetexpertd.ms.nowplayingpause",
	"com.apple.mobileslideshow.PLNotificationKeepOriginalsChanged",
	"com.apple.voicetrigger.XPCRestarted",
	"com.apple.duetexpertd.ATXAnchorModel.invalidate.WiredAudioDeviceConnectedAnchor",
	"com.apple.assistant.sync_data_changed",
	"EKFeatureSetDidChangeNotification",
	"com.apple.MobileAsset.VoiceTriggerAssetsIPad.ma.new-asset-installed",
	"com.apple.system.powersources.criticallevel",
	"com.apple.tcc.access.changed",
	"com.apple.locationd.appreset",
	"com.apple.coreaudio.borealisTrigger",
	"logging tasks have changed",
	"com.apple.proactive.PersonalizationPortrait.namedEntitiesDidChangeMeaningfully",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.appearance",
	"com.apple.mobiletimerd.resttest",
	"com.apple.suggestions.settingsChanged",
	"com.apple.VideosUI.PlayHistoryUpdatedNotification",
	"com.apple.thermalmonitor.ageAwareMitigationsEnabled",
	"com.apple.media.podcasts.siri_data_changed",
	"com.apple.voicemail.ReloadService",
	"com.apple.duetexpertd.ATXMMAppPredictor.WiredAudioDeviceConnectedAnchor",
	"com.apple.mobiletimerd.waketest",
	"com.apple.AirTunes.DACP.shuffletoggle",
	"com.apple.MediaRemote.lockScreenControlsDidChange",
	"CNContactStoreDidChangeNotification",
	"com.apple.accessibility.cache.darken.system.colors.enabled",
	"com.apple.AirTunes.DACP.devicevolume",
	"com.apple.softwareupdateservicesd.activity.autoDownload",
	"com.apple.da.tasking_changed",
	"com.apple.fairplayd.resync-fpkeybag",
	"com.apple.SensorKit.deviceUsageReport",
	"com.apple.isp.backcamerapower",
	"com.apple.homed.user-cloud-share.wake.com.apple.siri.zonesharing",
	"com.apple.ProtectedCloudStorage.test.mobileBackupStateChange",
	"com.apple.triald.new-experiment",
	"com.apple.private.SensorKit.pedometer.stridecalibration",
	"com.apple.duetexpertd.homeScreenPageConfigCacheUpdate",
	"com.apple.homed.user-cloud-share.wake.com.apple.siri.data",
	"com.apple.UsageTrackingAgent.registration.now-playing",
	"com.apple.system.powermanagement.poweradapter",
	"com.apple.MobileAsset.VoiceServices.CustomVoice.ma.new-asset-installed",
	"com.apple.homed.user-cloud-share.wake.com.apple.applemediaservices.multiuser",
	"SBApplicationNotificationStateChanged",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.pencil",
	"com.apple.managedconfiguration.managedorginfochanged",
	"com.apple.callhistory.RecentsClearedNotification",
	"com.apple.wirelessproximity.launch",
	"MFNanoMailImportantBridgeSettingHasChangedDarwinNotification",
	"com.apple.mobiletimerd.wakeuptest",
	"NewOperatorNotification",
	"com.apple.MobileAsset.VoiceTriggerHSAssets.ma.cached-metadata-updated",
	"com.apple.siri.cloud.storage.deleted",
	"com.apple.commcenter.InternationalRoamingEDGE.changed",
	"com.apple.alarm.label.siri_data_changed",
	"com.apple.idstransfers.idslaunchnotification",
	"com.apple.MobileAsset.AppleKeyServicesCRL.new-asset-installed",
	"com.apple.aggregated.addaily.logging",
	"com.apple.springboard.pluggedin",
	"com.apple.managedconfiguration.restrictionchanged",
	"com.apple.SensorKit.als",
	"com.apple.powerlog.batteryServiceNotification",
	"com.apple.system.logging.power_button_notification",
	"com.apple.ManagedConfiguration.managedAppsChanged",
	"com.apple.bluetooth.WirelessSplitterOn",
	"com.apple.accessibility.component-change",
	"com.apple.MobileAsset.Font7.ma.cached-metadata-updated",
	"com.apple.appstored.AppStoreSubEntitlementsCacheUpdated",
	"com.apple.itunesstored.autodownloaddefaultschange",
	"com.apple.managedconfiguration.effectivesettingschanged",
	"com.apple.mobileipod.librarychanged",
	"com.apple.mobiletimerd.bedtimetest",
	"com.apple.MobileAsset.CoreTextAssets.ma.new-asset-installed",
	"com.apple.atc.xpc.runkeeplocaltask",
	"com.apple.coremedia.carplayisconnected",
	"com.apple.dataaccess.checkHolidayCalendarAccount",
	"com.apple.MediaRemote.nowPlayingApplicationIsPlayingDidChange",
	"com.apple.imautomatichistorydeletionagent.prefchange",
	"com.apple.proactive.queries.databaseChange",
	"__ABDataBaseChangedByOtherProcessNotification",
	"com.apple.pushproxy.idslaunchnotification",
	"com.apple.isp.frontcamerapower",
	"com.apple.security.view-change.SE-PTC",
	"FMFDataUpdateCompleteNotification",
	"AppleTimePreferencesChangedNotification",
	"com.apple.spotlight.SyndicatedContentRefreshed",
	"com.apple.duetexpertd.dockAppListCacheUpdate",
	"com.apple.geoservices.siri_data_changed",
	"com.apple.cmfsyncagent.storedidchangeexternally",
	"com.apple.system.powersources.timeremaining",
	"com.apple.MobileAsset.SpeechEndpointAssets.ma.cached-metadata-updated",
	"com.apple.icloud.searchparty.selfbeaconchanged",
	"com.apple.homed.user-cloud-share.wake.com.apple.applemediaservices.multiuser.qa",
	"com.apple.AirTunes.DACP.previtem",
	"com.apple.trial.NamespaceUpdate.SIRI_UNDERSTANDING_ASR_ASSISTANT",
	"com.apple.accessories.connection.MFi4AccessoryDisconnected",
	"com.apple.ManagedConfiguration.webContentFilterTypeChanged",
	"com.apple.voicemail.VVVerifierCheckpointDictionaryChanged",
	"com.apple.UsageTrackingAgent.registration.video",
	"com.apple.carkit.carplay-attached",
	"com.apple.itunescloudd.artworkDownloadsDidCompleteNotification",
	"com.apple.sleepd.cloudkit.reset",
	"com.apple.SoftwareUpdate.SUPreferencesChanged",
	"com.apple.managedconfiguration.passcodechanged",
	"com.apple.springboard.hasBlankedScreen",
	"com.apple.softwareupdateservicesd.activity.autoInstallEnd",
	"com.apple.cloudrecents.kvstorechange",
	"com.apple.softwareupdateservicesd.activity.presentBanner",
	"com.apple.awd.launch.nfcd",
	"com.apple.cddcommunicator.nwchanged",
	"com.apple.proactive.PersonalizationPortrait.namedEntitiesInvalidated",
	"com.apple.assistant.sync_homekit_urgent",
	"com.apple.duetexpertd.appclipprediction",
	"com.apple.sockpuppet.applications.updated",
	"com.apple.mobile.lockdown.device_name_changed",
	"CKIdentityUpdateNotification",
	"com.apple.videos.migrationCompleted",
	"com.apple.homed.multi-user-status-changed",
	"com.apple.MobileAsset.ProactiveEventTrackerAssets.ma.cached-metadata-updated",
	"com.apple.ap.adprivacyd.launch",
	"com.apple.AirTunes.DACP.mutetoggle",
	"com.apple.ap.adprivacyd.canceltasks",
	"com.apple.TVRemoteCore.connectionRequested",
	"com.apple.system.lowpowermode.first_time",
	"com.apple.MobileAsset.CoreTextAssets.ma.cached-metadata-updated",
	"com.apple.duetexpertd.mm.audiodisconnect",
	"com.apple.hangtracerd.htse_state_changed",
	"com.apple.sleep.sync.SleepScheduleDidChange",
	"com.apple.powerui.requiredFullCharge",
	"com.apple.DuetHeuristic-BM.shutdowsoon",
	"com.apple.datamigrator.datamigrationcompletecontinuerestore",
	"NanoLifestylePreferencesChangedNotification",
	"com.apple.icloud.findmydeviced.findkit.magSafe.added",
	"com.apple.homekit.sync-data-cache-updated",
	"com.apple.assistant.siri_settings_did_change",
	"com.apple.proactive.queries.clearData",
	"com.apple.corespotlight.developer.ReindexAllItemsWithIdentifiers",
	"com.apple.corespotlight.developer.ReindexAllItems",
	"com.apple.cddcommunicator.pluginChanged",
	"com.apple.language.changed",
	"com.apple.rapport.CompanionLinkDeviceAdded",
	"com.apple.voicetrigger.EarlyDetect",
	"com.apple.voiceservices.trigger.asset-force-update",
	"MPStoreClientTokenDidChangeNotification",
	"com.apple.VideoSubscriberAccount.DidRegisterSubscription",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.mouse",
	"com.apple.MobileAsset.VoiceTriggerAssetsWatch.new-asset-installed",
	"ConnectedGymPreferencesChangedNotification",
	"_CalDatabaseChangedNotification",
	"com.apple.powermanagement.systemsleeppreventers",
	"com.apple.MobileAsset.EmbeddedSpeech.ma.new-asset-installed",
	"com.apple.OTACrashCopier.SubmissionPreferenceChanged",
	"com.apple.duetexpertd.ms.carplayconnect",
	"com.apple.SensorKit.messagesUsageReport",
	"com.apple.sleep.sync.SleepRecordDidChange",
	"com.apple.healthlite.SleepSessionEndRequest",
	"com.apple.welcomemat.finalizeMigratableApps",
	"com.apple.Carousel.wristStateChanged",
	"com.apple.networkserviceproxy.reset",
	"ACDAccountStoreDidChangeNotification",
	"com.apple.EscrowSecurityAlert.reset",
	"CalSyncClientFinishedMultiSave",
	"com.apple.mobiletimerd.reset",
	"com.apple.mobileipod.libraryimportdidfinish",
	"com.apple.security.publickeynotavailable",
	"com.apple.Music-AllowsCellularDataDownloads",
	"com.apple.siri.preheat.quiet",
	"com.apple.AirTunes.DACP.nextitem",
	"com.apple.duetbm.internalSettingsChanged",
	"com.apple.parsecd.queries.clearData",
	"com.apple.duetexpertd.ATXMMAppPredictor.CarPlayConnectedAnchor",
	"MISProvisioningProfileRemoved",
	"com.apple.siri.power.PowerContextPolicy.updated",
	"com.apple.bluetooth.accessory-authentication.success",
	"com.apple.dmd.budget.didChange",
	"com.apple.icloud.fmip.siri_data_changed",
	"com.apple.SensorKit.visits",
	"NoteContextDarwinNotificationWithLoggedChanges",
	"com.apple.mobile.keybagd.lock_status",
	"com.apple.healthlite.SleepDetectedActivity",
	"com.apple.locationd.vehicle.connected",
	"com.apple.mobiletimerd.goodmorningtest",
	"com.apple.UsageTrackingAgent.registration.web-domain",
	"com.apple.assistant.speech-capture.finished",
	"com.apple.awd.launch.wifi",
	"com.apple.duetexpertd.ATXAnchorModel.WiredAudioDeviceConnectedAnchor",
	"com.apple.devicemanagementclient.longLivedTokenChanged",
	"com.apple.VideosUI.UpNextRequestDidFinishNotification",
	"com.apple.MobileAsset.TTSAXResourceModelAssets.ma.new-asset-installed",
	"com.apple.system.batterysavermode.auto_disabled",
	"com.apple.MCX._managementStatusChangedForDomains",
	"com.apple.softwareupdateservicesd.activity.autoDownloadEnd",
	"com.apple.coreduet.client-needs-help.coreduetd",
	"com.apple.fitness.FitnessAppInstalled",
	"NewCarrierNotification",
	"com.apple.duetexpertd.ATXAnchorModel.IdleTimeEndAnchor",
	"com.apple.softwareupdateservicesd.activity.autoInstallUnlock",
	"com.apple.icloud.findmydeviced.localActivationLockInfoChanged",
	"com.apple.calendar.database.preference.notification.kCalPreferredDaysToSyncKey",
	"com.apple.accessibility.cache.enhance.text.legibility",
	"com.apple.security.cloudkeychainproxy.kvstorechange3",
	"com.apple.MobileAsset.TimeZoneUpdate.ma.cached-metadata-updated",
	"com.apple.softwareupdateservicesd.activity.delayEndScan",
	"com.apple.trial.NamespaceUpdate.FREEZER_POLICIES",
	"com.apple.ams.provision-biometrics",
	"com.apple.cddcommunicator.batteryChanged",
	"com.apple.icloud.findmydeviced.findkit.magSafe.detach",
	"com.apple.powermanagement.systempowerstate",
	"com.apple.icloud.FindMy.addMagSafeAccessory",
	"com.apple.GeoServices.navigation.stopped",
	"kVMVoicemailTranscriptionTaskTranscribeAllVoicemails",
	"com.apple.BiometricKit.passcodeGracePeriodChanged",
	"INVoocabularyChangedNotification",
	"com.apple.SynthesisProvider.updatedVoices",
	"com.apple.security.tick",
	"com.apple.security.secureobjectsync.circlechanged",
	"com.apple.security.itembackup",
	"com.apple.Preferences.ChangedRestrictionsEnabledStateNotification",
	"com.apple.parsec-fbf.FLUploadImmediately",
	"com.apple.cddcommunicator.thermalChanged",
	"com.apple.system.thermalpressurelevel.cold",
	"AppleNumberPreferencesChangedNotification",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.sound",
	"com.apple.stockholm.se.mfd",
	"com.apple.security.secureobjectsync.viewschanged",
	"SignificantTimeChangeNotification",
	"com.apple.softwareupdateservicesd.activity.emergencyAutoScan",
	"com.apple.dataaccess.ping",
	"com.apple.MobileSoftwareUpdate.OSVersionChanged",
	"kCalBirthdayDefaultAlarmChangedNote",
	"com.apple.system.timezone",
	"com.apple.calendar.database.preference.notification.suggestEventLocations",
	"com.apple.duetexpertd.ATXAnchorModel.invalidate.IdleTimeEndAnchor",
	"com.apple.homehubd.endpointActivated",
	"com.apple.system.powersources.percent",
	"com.apple.duetexpertd.appchangeprediction",
	"com.apple.system.thermalpressurelevel",
	"com.apple.timezonesync.idslaunchnotification",
	"com.apple.MobileAsset.VoiceTriggerHSAssetsWatch.ma.new-asset-installed",
	"com.apple.mobilecal.preference.notification.calendarsExcludedFromNotifications",
	"com.apple.system.powersources.source",
	"com.apple.duetexpertd.ATXMMAppPredictor.BluetoothDisconnectedAnchor",
	"com.apple.reminder.list.name.siri_data_changed",
	"com.apple.managedconfiguration.allowpasscodemodificationchanged",
	"com.apple.nanoregistry.devicedidunpair",
	"com.apple.homed.user-cloud-share.wake.com.apple.mediaservicesbroker.container",
	"com.apple.MobileAsset.VoiceServices.GryphonVoice.ma.new-asset-installed",
	"com.apple.awdd.anonymity",
	"com.apple.appstored.iCloudSubEntitlementsCacheUpdated",
	"SLSharedWithYouAppSettingHasChanged",
	"com.apple.nanoregistry.paireddevicedidchangecapabilities",
	"com.apple.SensorKit.phoneUsageReport",
	"com.apple.LaunchServices.applicationRegistered",
	"com.apple.AirTunes.DACP.repeatadv",
	"com.apple.audio.AOP.enable",
	"com.apple.locationd/Prefs",
	"security.mac.amfi.developer_mode_status.changed",
	"com.apple.MobileAsset.SpeechEndpointAssets.cached-metadata-updated",
	"com.apple.siri.inference.biome-context",
	"com.apple.sbd.kvstorechange",
	"com.apple.system.powermanagement.useractivity2",
	"com.apple.coreaudio.speechDetectionVAD.created",
	"com.apple.ProtectedCloudStorage.rollIfAged",
	"com.apple.MediaRemote.nowPlayingInfoDidChange",
	"com.apple.locationd.authorization",
	"com.apple.GeoServices.navigation.started",
	"com.apple.MobileAsset.SecureElementServiceAssets.ma.new-asset-installed",
	"com.apple.softwareupdateservicesd.activity.autoScan",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.trackpad",
	"com.apple.purplebuddy.setupexited",
	"com.apple.remindd.nano_preferences_sync",
	"com.apple.voicetrigger.RemoteDarwin.EarlyDetect",
	"com.apple.itunesstored.invalidatebags",
	"com.apple.EscrowSecurityAlert.record",
	"com.apple.ContinuityKeyBoard.enabled",
	"com.apple.iokit.hid.displayStatus",
	"com.apple.system.powermanagement.uservisiblepowerevent",
	"com.apple.nanoregistry.watchdidbecomeactive",
	"com.apple.softwareupdateservicesd.activity.rollbackReboot",
	"FMFFollowersChangedNotification",
	"FMFMeDeviceChangedNotification",
	"com.apple.MobileAsset.SecureElementServiceAssets.ma.cached-metadata-updated",
	"com.apple.duetexpertd.ATXAnchorModel.BluetoothConnectedAnchor",
	"com.apple.security.secureobjectsync.holdlock",
	"com.apple.pex.connections.focalappchanged",
	"com.apple.Sharing.prefsChanged",
	"com.apple.system.hostname",
	"com.apple.appstored.PodcastSubEntitlementsCacheUpdated",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.gamecontroller",
	"com.apple.MobileAsset.VoiceTriggerAssetsWatch.ma.new-asset-installed",
	"com.apple.callhistorysync.idslaunchnotification",
	"com.apple.icloud.findmydeviced.findkit.magSafe.attach",
	"SPSpotlightRecentsCacheDidChange",
	"com.apple.screensharing.idslaunchnotification",
	"com.apple.mobileme.fmf1.allowFindMyFriendsModification",
	"com.apple.chatkit.groups.siri_data_changed",
	"com.apple.GeoServices.countryCodeChanged",
	"com.apple.MobileAsset.VoiceTriggerAssetsWatch.ma.cached-metadata-updated",
	"com.apple.remotemanagement.accountsChanged",
	"com.apple.duetexpertd.defaultsChanged",
	"com.apple.AirTunes.DACP.devicevolumechanged",
	"com.apple.accessibility.cache.differentiate.without.color",
	"com.apple.mobiletimerd.diagnostics",
	"com.apple.ProtectedCloudStorage.rollNow",
	"com.apple.sleepd.diagnostics",
	"com.apple.touchsetupd.launch",
	"com.apple.trial.NamespaceUpdate.SIRI_DICTATION_ASSETS",
	"com.apple.cloudd.pcsIdentityUpdate-com.apple.ProactivePredictionsBackup",
	"com.apple.trial.NamespaceUpdate.NETWORK_SERVICE_PROXY_CONFIG_UPDATE",
	"BYSetupAssistantFinishedDarwinNotification",
	"com.apple.siri.client.state.DynamiteClientState.siri_data_changed",
	"com.apple.Preferences.ResetPrivacyWarningsNotification",
	"kFaceTimeChangedNotification",
	"FMFDevicesChangedNotification",
	"VVMessageWaitingFallbackNotification",
	"CKAccountChangedNotification",
	"com.apple.MobileAsset.VoiceTriggerAssetsMarsh.ma.cached-metadata-updated",
	"com.apple.coreduetd.knowledgebase.launch.duetexpertd",
	"com.apple.MobileBackup.backgroundCellularAccessChanged",
	"com.apple.homed.user-cloud-share.repair.wake.com.apple.applemediaservices.multiuser",
	"com.apple.suggestions.prepareForQuery",
	"AFLanguageCodeDidChangeDarwinNotification",
	"com.apple.networkextension.nehelper-init",
	"com.apple.GeoServices.PreferencesSync.SettingsChanged",
	"com.apple.homed.speakersConfiguredChanged",
	"ApplePreferredContentSizeCategoryChangedNotification",
	"dmf.policy.monitor.app",
	"com.apple.voicetrigger.PHSProfileModified",
	"com.apple.duet.expertcenter.appRefresh",
	"com.apple.duetexpertd.ATXAnchorModel.CarPlayConnectedAnchor",
	"com.apple.icloudpairing.idslaunchnotification",
	"com.apple.accessories.connection.passedMFi4Auth",
	"com.apple.bluetooth.daemonStarted",
	"CNFavoritesChangedExternallyNotification",
	"VMStoreSetTokenNotification",
	"com.apple.spotlight.SyndicatedContentDeleted",
	"com.apple.coreduet.idslaunchnotification",
	"com.apple.appstored.MusicSubEntitlementsCacheUpdated",
	"com.apple.trial.NamespaceUpdate.SIRI_TEXT_TO_SPEECH",
	"com.apple.MobileAsset.VoiceTriggerHSAssets.ma.new-asset-installed",
	"com.apple.CloudSubscriptionFeature.Changed",
	"com.apple.bluetooth.pairing",
	"com.apple.telephonyutilities.callservicesd.fakeincomingmessage",
	"com.apple.mobile.disk_image_mounted",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.desktop",
	"com.apple.sleep.sync.SleepSettingsDidChange",
	"com.apple.nfcacd.multitag.state.change",
	"com.apple.VideosUI.StoreAcquisitionCrossProcessNotification",
	"com.apple.duetexpertd.prefschanged",
	"com.apple.kvs.store-did-change.com.apple.cloudsettings.general",
	"com.apple.LaunchServices.applicationUnregistered",
	"com.apple.AppleMediaServices.deviceOffersChanged",
}
