# Artifactory

Publish your artifacts to an Artifactory instance.

## How it works

You can declare multiple Artifactory instances.
All binaries generated by your `builds` section will be pushed to
each configured Artifactory.

If you have only one Artifactory instance,
the configuration is as easy as adding the
upload target, and a username to your `.goreleaser.yaml` file:

```yaml
artifactories:
  - name: production
    target: http://<Your-Instance>:8081/artifactory/example-repo-local/{{ .ProjectName }}/{{ .Version }}/
    username: goreleaser
```

Prerequisites:

- A running Artifactory instances
- A user + password / client x509 certificate / API key with grants to upload an artifact

### Target

The `target` is the URL to upload the artifacts to (_without_ the name of the artifact).

An example configuration for `goreleaser` in upload mode `binary` with the target can look like

```yaml
- mode: binary
  target: 'http://artifacts.company.com:8081/artifactory/example-repo-local/{{ .ProjectName }}/{{ .Version }}/{{ .Os }}/{{ .Arch }}{{ if .Arm }}{{ .Arm }}{{ end }}'
```

and will result in a final deployment like `http://artifacts.company.com:8081/artifactory/example-repo-local/goreleaser/1.0.0/Darwin/x86_64/goreleaser`.

Supported variables:

- Version
- Tag
- ProjectName
- Os
- Arch
- Arm

!!! info
    Variables _Os_, _Arch_ and _Arm_ are only supported in upload mode `binary`.

### Username

Your configured username needs to be authenticated against your Artifactory.

You can have the username set in the configuration file as shown above, or you
can have it read from an environment variable. The configured name of your
Artifactory instance will be used to build the environment variable name. This
way we support authentication for multiple instances. This also means that the
`name` per configured instance needs to be unique per GoReleaser configuration.

The name of the environment variable will be `ARTIFACTORY_NAME_USERNAME`.
If your instance is named `production`, you can store the username in the
environment variable `ARTIFACTORY_PRODUCTION_USERNAME`.
The name will be transformed to uppercase.

If a configured username is found in the configuration file, then the
environment variable is not used at all.

### Password / API Key

The password or API key will be stored in a environment variable.
The configured name of your Artifactory instance will be used.
With this way we support auth for multiple instances.
This also means that the `name` per configured instance needs to be unique
per goreleaser configuration.

The name of the environment variable will be `ARTIFACTORY_NAME_SECRET`.
If your instance is named `production`, you need to store the secret in the
environment variable `ARTIFACTORY_PRODUCTION_SECRET`.
The name will be transformed to uppercase.

### Client authorization with x509 certificate (mTLS / mutual TLS)

If your artifactory server supports authorization with mTLS (client certificates), you can provide them by specifying
the location of an x509 certificate/key pair of pem-encode files.

```yaml
artifactories:
  - name: production
    target: http://<Your-Instance>:8081/artifactory/example-repo-local/{{ .ProjectName }}/{{ .Version }}/
    client_x509_cert: path/to/client.cert.pem
    client_x509_key: path/to/client.key.pem
```

This will offer the client certificate during the TLS handshake, which your artifactory server may use to authenticate
and authorize you to upload.

### Server authentication

You can authenticate your Artifactory TLS server adding a trusted X.509
certificate chain in your configuration.

The trusted certificate chain will be used to validate the server certificates.

You can set the trusted certificate chain using the `trusted_certificates`
setting the artifactory section with PEM encoded certificates on a YAML literal
block like this:

```yaml
puts:
  - name: "some artifactory server with a private TLS certificate"
    #...(other settings)...
    trusted_certificates: |
      -----BEGIN CERTIFICATE-----
      MIIDrjCCApagAwIBAgIIShr2zchZo+8wDQYJKoZIhvcNAQENBQAwNTEXMBUGA1UE
      ...(edited content)...
      TyzMJasj5BPZrmKjJb6O/tOtEIJ66xPSBTxPShkEYHnB7A==
      -----END CERTIFICATE-----
      -----BEGIN CERTIFICATE-----
      MIIDrjCCApagAwIBAgIIShr2zchZo+8wDQYJKoZIhvcNAQENBQAwNTEXMBUGA1UE
      ...(edited content)...
      TyzMJasj5BPZrmKjJb6O/tOtEIJ66xPSBTxPShkEYHnB7A==
      -----END CERTIFICATE-----
```

## Customization

Of course, you can customize a lot of things:

```yaml
# .goreleaser.yaml
artifactories:
  # You can have multiple Artifactory instances.
  -
    # Unique name of your artifactory instance. Used to identify the instance
    name: production

    # IDs of the artifacts you want to upload.
    ids:
    - foo
    - bar

    # File extensions to filter for.
    # This might be useful if you have multiple packages with different
    # extensions with the same ID, and need to upload each extension to
    # a different place (e.g. nFPM packages).
    #
    # Since: v1.7
    exts:
    - deb
    - rpm

    # Upload mode. Valid options are `binary` and `archive`.
    # If mode is `archive`, variables _Os_, _Arch_ and _Arm_ for target name are not supported.
    # In that case these variables are empty.
    #
    # Default: 'archive'
    mode: archive

    # URL of your Artifactory instance + path to deploy to
    target: http://artifacts.company.com:8081/artifactory/example-repo-local/{{ .ProjectName }}/{{ .Version }}/

    # Tells goreleaer not to append the artifact name to the target URL. You must do this manually
    custom_artifact_name: true

    # User that will be used for the deployment
    username: deployuser

    # Client certificate and key (when provided, added as client cert to TLS connections)
    #
    # Since: v1.11
    client_x509_cert: /path/to/client.cert.pem
    client_x509_key: /path/to/client.key.pem

    # Upload checksums.
    checksum: true

    # Upload signatures.
    signature: true

    # Certificate chain used to validate server certificates
    trusted_certificates: |
      -----BEGIN CERTIFICATE-----
      MIIDrjCCApagAwIBAgIIShr2zchZo+8wDQYJKoZIhvcNAQENBQAwNTEXMBUGA1UE
      ...(edited content)...
      TyzMJasj5BPZrmKjJb6O/tOtEIJ66xPSBTxPShkEYHnB7A==
      -----END CERTIFICATE-----
```

These settings should allow you to push your artifacts into multiple Artifactories.

!!! tip
    Learn more about the [name template engine](/customization/templates/).
