// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package appengine

import (
	"context"
	"fmt"
	"math"
	"net/url"

	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	appenginepb "google.golang.org/genproto/googleapis/appengine/v1"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/proto"
)

var newAuthorizedCertificatesClientHook clientHook

// AuthorizedCertificatesCallOptions contains the retry settings for each method of AuthorizedCertificatesClient.
type AuthorizedCertificatesCallOptions struct {
	ListAuthorizedCertificates  []gax.CallOption
	GetAuthorizedCertificate    []gax.CallOption
	CreateAuthorizedCertificate []gax.CallOption
	UpdateAuthorizedCertificate []gax.CallOption
	DeleteAuthorizedCertificate []gax.CallOption
}

func defaultAuthorizedCertificatesGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("appengine.googleapis.com:443"),
		internaloption.WithDefaultMTLSEndpoint("appengine.mtls.googleapis.com:443"),
		internaloption.WithDefaultAudience("https://appengine.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultAuthorizedCertificatesCallOptions() *AuthorizedCertificatesCallOptions {
	return &AuthorizedCertificatesCallOptions{
		ListAuthorizedCertificates:  []gax.CallOption{},
		GetAuthorizedCertificate:    []gax.CallOption{},
		CreateAuthorizedCertificate: []gax.CallOption{},
		UpdateAuthorizedCertificate: []gax.CallOption{},
		DeleteAuthorizedCertificate: []gax.CallOption{},
	}
}

// internalAuthorizedCertificatesClient is an interface that defines the methods availaible from App Engine Admin API.
type internalAuthorizedCertificatesClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListAuthorizedCertificates(context.Context, *appenginepb.ListAuthorizedCertificatesRequest, ...gax.CallOption) *AuthorizedCertificateIterator
	GetAuthorizedCertificate(context.Context, *appenginepb.GetAuthorizedCertificateRequest, ...gax.CallOption) (*appenginepb.AuthorizedCertificate, error)
	CreateAuthorizedCertificate(context.Context, *appenginepb.CreateAuthorizedCertificateRequest, ...gax.CallOption) (*appenginepb.AuthorizedCertificate, error)
	UpdateAuthorizedCertificate(context.Context, *appenginepb.UpdateAuthorizedCertificateRequest, ...gax.CallOption) (*appenginepb.AuthorizedCertificate, error)
	DeleteAuthorizedCertificate(context.Context, *appenginepb.DeleteAuthorizedCertificateRequest, ...gax.CallOption) error
}

// AuthorizedCertificatesClient is a client for interacting with App Engine Admin API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Manages SSL certificates a user is authorized to administer. A user can
// administer any SSL certificates applicable to their authorized domains.
type AuthorizedCertificatesClient struct {
	// The internal transport-dependent client.
	internalClient internalAuthorizedCertificatesClient

	// The call options for this service.
	CallOptions *AuthorizedCertificatesCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *AuthorizedCertificatesClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *AuthorizedCertificatesClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *AuthorizedCertificatesClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListAuthorizedCertificates lists all SSL certificates the user is authorized to administer.
func (c *AuthorizedCertificatesClient) ListAuthorizedCertificates(ctx context.Context, req *appenginepb.ListAuthorizedCertificatesRequest, opts ...gax.CallOption) *AuthorizedCertificateIterator {
	return c.internalClient.ListAuthorizedCertificates(ctx, req, opts...)
}

// GetAuthorizedCertificate gets the specified SSL certificate.
func (c *AuthorizedCertificatesClient) GetAuthorizedCertificate(ctx context.Context, req *appenginepb.GetAuthorizedCertificateRequest, opts ...gax.CallOption) (*appenginepb.AuthorizedCertificate, error) {
	return c.internalClient.GetAuthorizedCertificate(ctx, req, opts...)
}

// CreateAuthorizedCertificate uploads the specified SSL certificate.
func (c *AuthorizedCertificatesClient) CreateAuthorizedCertificate(ctx context.Context, req *appenginepb.CreateAuthorizedCertificateRequest, opts ...gax.CallOption) (*appenginepb.AuthorizedCertificate, error) {
	return c.internalClient.CreateAuthorizedCertificate(ctx, req, opts...)
}

// UpdateAuthorizedCertificate updates the specified SSL certificate. To renew a certificate and maintain
// its existing domain mappings, update certificate_data with a new
// certificate. The new certificate must be applicable to the same domains as
// the original certificate. The certificate display_name may also be
// updated.
func (c *AuthorizedCertificatesClient) UpdateAuthorizedCertificate(ctx context.Context, req *appenginepb.UpdateAuthorizedCertificateRequest, opts ...gax.CallOption) (*appenginepb.AuthorizedCertificate, error) {
	return c.internalClient.UpdateAuthorizedCertificate(ctx, req, opts...)
}

// DeleteAuthorizedCertificate deletes the specified SSL certificate.
func (c *AuthorizedCertificatesClient) DeleteAuthorizedCertificate(ctx context.Context, req *appenginepb.DeleteAuthorizedCertificateRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteAuthorizedCertificate(ctx, req, opts...)
}

// authorizedCertificatesGRPCClient is a client for interacting with App Engine Admin API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type authorizedCertificatesGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing AuthorizedCertificatesClient
	CallOptions **AuthorizedCertificatesCallOptions

	// The gRPC API client.
	authorizedCertificatesClient appenginepb.AuthorizedCertificatesClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewAuthorizedCertificatesClient creates a new authorized certificates client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Manages SSL certificates a user is authorized to administer. A user can
// administer any SSL certificates applicable to their authorized domains.
func NewAuthorizedCertificatesClient(ctx context.Context, opts ...option.ClientOption) (*AuthorizedCertificatesClient, error) {
	clientOpts := defaultAuthorizedCertificatesGRPCClientOptions()
	if newAuthorizedCertificatesClientHook != nil {
		hookOpts, err := newAuthorizedCertificatesClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := AuthorizedCertificatesClient{CallOptions: defaultAuthorizedCertificatesCallOptions()}

	c := &authorizedCertificatesGRPCClient{
		connPool:                     connPool,
		disableDeadlines:             disableDeadlines,
		authorizedCertificatesClient: appenginepb.NewAuthorizedCertificatesClient(connPool),
		CallOptions:                  &client.CallOptions,
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated.
func (c *authorizedCertificatesGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *authorizedCertificatesGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *authorizedCertificatesGRPCClient) Close() error {
	return c.connPool.Close()
}

func (c *authorizedCertificatesGRPCClient) ListAuthorizedCertificates(ctx context.Context, req *appenginepb.ListAuthorizedCertificatesRequest, opts ...gax.CallOption) *AuthorizedCertificateIterator {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ListAuthorizedCertificates[0:len((*c.CallOptions).ListAuthorizedCertificates):len((*c.CallOptions).ListAuthorizedCertificates)], opts...)
	it := &AuthorizedCertificateIterator{}
	req = proto.Clone(req).(*appenginepb.ListAuthorizedCertificatesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*appenginepb.AuthorizedCertificate, string, error) {
		resp := &appenginepb.ListAuthorizedCertificatesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = c.authorizedCertificatesClient.ListAuthorizedCertificates(ctx, req, settings.GRPC...)
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetCertificates(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *authorizedCertificatesGRPCClient) GetAuthorizedCertificate(ctx context.Context, req *appenginepb.GetAuthorizedCertificateRequest, opts ...gax.CallOption) (*appenginepb.AuthorizedCertificate, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).GetAuthorizedCertificate[0:len((*c.CallOptions).GetAuthorizedCertificate):len((*c.CallOptions).GetAuthorizedCertificate)], opts...)
	var resp *appenginepb.AuthorizedCertificate
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.authorizedCertificatesClient.GetAuthorizedCertificate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *authorizedCertificatesGRPCClient) CreateAuthorizedCertificate(ctx context.Context, req *appenginepb.CreateAuthorizedCertificateRequest, opts ...gax.CallOption) (*appenginepb.AuthorizedCertificate, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).CreateAuthorizedCertificate[0:len((*c.CallOptions).CreateAuthorizedCertificate):len((*c.CallOptions).CreateAuthorizedCertificate)], opts...)
	var resp *appenginepb.AuthorizedCertificate
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.authorizedCertificatesClient.CreateAuthorizedCertificate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *authorizedCertificatesGRPCClient) UpdateAuthorizedCertificate(ctx context.Context, req *appenginepb.UpdateAuthorizedCertificateRequest, opts ...gax.CallOption) (*appenginepb.AuthorizedCertificate, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).UpdateAuthorizedCertificate[0:len((*c.CallOptions).UpdateAuthorizedCertificate):len((*c.CallOptions).UpdateAuthorizedCertificate)], opts...)
	var resp *appenginepb.AuthorizedCertificate
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.authorizedCertificatesClient.UpdateAuthorizedCertificate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *authorizedCertificatesGRPCClient) DeleteAuthorizedCertificate(ctx context.Context, req *appenginepb.DeleteAuthorizedCertificateRequest, opts ...gax.CallOption) error {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).DeleteAuthorizedCertificate[0:len((*c.CallOptions).DeleteAuthorizedCertificate):len((*c.CallOptions).DeleteAuthorizedCertificate)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = c.authorizedCertificatesClient.DeleteAuthorizedCertificate(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	return err
}

// AuthorizedCertificateIterator manages a stream of *appenginepb.AuthorizedCertificate.
type AuthorizedCertificateIterator struct {
	items    []*appenginepb.AuthorizedCertificate
	pageInfo *iterator.PageInfo
	nextFunc func() error

	// Response is the raw response for the current page.
	// It must be cast to the RPC response type.
	// Calling Next() or InternalFetch() updates this value.
	Response interface{}

	// InternalFetch is for use by the Google Cloud Libraries only.
	// It is not part of the stable interface of this package.
	//
	// InternalFetch returns results from a single call to the underlying RPC.
	// The number of results is no greater than pageSize.
	// If there are no more results, nextPageToken is empty and err is nil.
	InternalFetch func(pageSize int, pageToken string) (results []*appenginepb.AuthorizedCertificate, nextPageToken string, err error)
}

// PageInfo supports pagination. See the google.golang.org/api/iterator package for details.
func (it *AuthorizedCertificateIterator) PageInfo() *iterator.PageInfo {
	return it.pageInfo
}

// Next returns the next result. Its second return value is iterator.Done if there are no more
// results. Once Next returns Done, all subsequent calls will return Done.
func (it *AuthorizedCertificateIterator) Next() (*appenginepb.AuthorizedCertificate, error) {
	var item *appenginepb.AuthorizedCertificate
	if err := it.nextFunc(); err != nil {
		return item, err
	}
	item = it.items[0]
	it.items = it.items[1:]
	return item, nil
}

func (it *AuthorizedCertificateIterator) bufLen() int {
	return len(it.items)
}

func (it *AuthorizedCertificateIterator) takeBuf() interface{} {
	b := it.items
	it.items = nil
	return b
}
