---
title: Staticcheck 2022.1 release notes
linkTitle: "2022.1 (v0.3.0)"
weight: -7
---

## Improvements {#improvements}

This release adds support for Go 1.18 and type parameters (generics).

Furthermore, it adds two new flags for handling build tags, `-matrix` and `-merge`. Their use is extensively documented
on the new [Build tags]({{< relref "/docs/running-staticcheck/cli/build-tags" >}}) page. Their intended use is for
avoiding false positives when dealing with different build tags.

Not tied directly to this release, but worth mentioning regardless: Staticcheck has an [official GitHub
Action](https://github.com/dominikh/staticcheck-action) now, which may simplify your CI pipeline.

Minor changes include slightly nicer output from `staticcheck -explain`, better error messages, and allowing whitespace in flags like `-checks`.

## Checks {#checks}

### New checks {#checks-new}

The following new checks have been added:

- {{< check "SA4028" >}} flags `x % 1`, which always yields zero, and is sometimes accidentally used instead of `x % 2`
- {{< check "SA4029" >}} flags misuses of `sort.IntSlice` and related types
- {{< check "SA4030" >}} flags misuses of `math/rand` that always generate zeros
- {{< check "SA4031" >}} flags comparisons of never-nil values against nil
- {{< check "SA9007" >}} flags attempts at deleting system directories
- {{< check "SA9008" >}} flags accidental shadowing in the else branches of type assertions

### Changed checks {#checks-changed}

The following checks have been improved:

- {{< check "S1001"  >}} now simplifies more loops
- {{< check "S1038"  >}} now simplifies formatted printing in `log` and `testing`, in addition to `fmt`
- {{< check "SA1019" >}} no longer flags deprecated API in the Go standard library if it doesn't know when the API was
  deprecated. This is to avoid false positives when using older versions of Staticcheck on newer versions of Go, in
  particular Go's `master` branch.
- {{< check "SA1020" >}} no longer flags `net/http.ListenAndServe` with a completely empty address
- {{< check "ST1001" >}} various packages of `github.com/mmcloughlin/avo` have been whitelisted by default
- {{< check "ST1008" >}} no longer flags functions that return `(..., error, bool)`
- {{< check "ST1018" >}} no longer flags emoji sequences
- {{< check "ST1023" >}} no longer makes erroneous suggestions
- Numerous checks have a better understanding of integer literals and can detect mistakes involving unconventional
  literals such as `---1` instead of `-1`
- Some runtime crashes have been fixed

## Staticcheck 2022.1.1 release notes {#2022.1.1}

This release addresses the following false positives, crashes, and infinite loops:

- {{< check "SA1026" >}} and {{< check "SA5008" >}} no longer get stuck in infinite loops when code attempts to marshal cyclic pointer types ({{< issue "1202" >}})
- U1000 no longer crashes when code contains mutually recursive type instantiations ({{< issue "1247" >}})
- U1000 no longer crashes when generic functions use composite literals of type parameter types ({{< commit "0ccdb5c9dad7e96a8e3a3136738192491b37dbdb" >}})
- {{< check "ST1021" >}} now understands type names that are also English articles ({{< issue "1187" >}})
- {{< check "SA4023" >}} no longer gets confused by the nilness of type parameters ({{< issue "1242" >}})
- Some checks no longer crash when trying to generate automated code fixes that involve function literals ({{< issue "1134" >}})
- {{< check "SA1026" >}} no longer claims that `encoding/json` cannot marshal generic maps ([golang/go#52467](https://golang.org/issue/52467))
- The `binary` format has been improved to handle OS-specific file paths correctly, in turn making the `-merge` flag work more reliably ({{< commit "1846305a946b13d350894512c7ac1e5ed71dc331" >}})
- When using the `-merge` or `-matrix` flags, diagnostics reported by {{< check "SA4008" >}} now have to occur in all runs to be reported, reducing the number of false positives ({{< commit "0e678cbe1c8b3f09ac481673453886b1afc9906a" >}})
- U1000 now understands struct type conversions involving type parameters, reducing the number of false positives ({{< commit "90804df0287d9265e565bcabbe19568efbe374fa" >}})
