Feature: shipped parent of a stacked change with independent changes

  Background:
    Given a Git repo with origin
    And the branches
      | NAME      | TYPE    | PARENT    | LOCATIONS     |
      | feature-1 | feature | main      | local, origin |
      | feature-2 | feature | feature-1 | local, origin |
      | feature-3 | feature | feature-2 | local, origin |
    And the commits
      | BRANCH    | LOCATION      | MESSAGE          | FILE NAME      | FILE CONTENT      |
      | feature-1 | local, origin | feature-1 commit | feature-1-file | feature 1 content |
      | feature-2 | local, origin | feature-2 commit | feature-2-file | feature 2 content |
      | feature-3 | local, origin | feature-3 commit | feature-3-file | feature 3 content |
    And origin ships the "feature-1" branch using the "squash-merge" ship-strategy
    And origin ships the "feature-2" branch using the "squash-merge" ship-strategy
    And the current branch is "feature-3"
    When I run "git-town sync"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH    | COMMAND                                           |
      | feature-3 | git fetch --prune --tags                          |
      |           | git checkout main                                 |
      | main      | git -c rebase.updateRefs=false rebase origin/main |
      |           | git branch -D feature-1                           |
      |           | git branch -D feature-2                           |
      |           | git checkout feature-3                            |
      | feature-3 | git merge --no-edit --ff main                     |
      |           | git push                                          |
    And Git Town prints:
      """
      deleted branch "feature-1"
      """
    And Git Town prints:
      """
      deleted branch "feature-2"
      """
    And this lineage exists now
      """
      main
        feature-3
      """
    And the branches are now
      | REPOSITORY    | BRANCHES        |
      | local, origin | main, feature-3 |

  Scenario: undo
    When I run "git-town undo"
    Then Git Town runs the commands
      | BRANCH    | COMMAND                                                   |
      | feature-3 | git reset --hard {{ sha 'feature-3 commit' }}             |
      |           | git push --force-with-lease --force-if-includes           |
      |           | git checkout main                                         |
      | main      | git reset --hard {{ sha 'initial commit' }}               |
      |           | git branch feature-1 {{ sha-initial 'feature-1 commit' }} |
      |           | git branch feature-2 {{ sha-initial 'feature-2 commit' }} |
      |           | git checkout feature-3                                    |
    And the initial branches and lineage exist now
