// Code generated by ifacemaker; DO NOT EDIT.

package awsapi

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/service/cloudtrail"
	. "github.com/aws/aws-sdk-go-v2/service/cloudtrail"
)

// CloudTrail provides an interface to the AWS CloudTrail service.
type CloudTrail interface {
	// Options returns a copy of the client configuration.
	//
	// Callers SHOULD NOT perform mutations on any inner structures within client
	// config. Config overrides should instead be made on a per-operation basis through
	// functional options.
	Options() cloudtrail.Options
	// Adds one or more tags to a trail, event data store, dashboard, or channel, up
	// to a limit of 50. Overwrites an existing tag's value when a new value is
	// specified for an existing tag key. Tag key names must be unique; you cannot have
	// two keys with the same name but different values. If you specify a key without a
	// value, the tag will be created with the specified key and a value of null. You
	// can tag a trail or event data store that applies to all Amazon Web Services
	// Regions only from the Region in which the trail or event data store was created
	// (also known as its home Region).
	AddTags(ctx context.Context, params *cloudtrail.AddTagsInput, optFns ...func(*Options)) (*cloudtrail.AddTagsOutput, error)
	// Cancels a query if the query is not in a terminated state, such as CANCELLED ,
	// FAILED , TIMED_OUT , or FINISHED . You must specify an ARN value for
	// EventDataStore . The ID of the query that you want to cancel is also required.
	// When you run CancelQuery , the query status might show as CANCELLED even if the
	// operation is not yet finished.
	CancelQuery(ctx context.Context, params *cloudtrail.CancelQueryInput, optFns ...func(*Options)) (*cloudtrail.CancelQueryOutput, error)
	// Creates a channel for CloudTrail to ingest events from a partner or external
	// source. After you create a channel, a CloudTrail Lake event data store can log
	// events from the partner or source that you specify.
	CreateChannel(ctx context.Context, params *cloudtrail.CreateChannelInput, optFns ...func(*Options)) (*cloudtrail.CreateChannelOutput, error)
	//	Creates a custom dashboard or the Highlights dashboard.
	//
	//	 - Custom dashboards - Custom dashboards allow you to query events in any
	//	 event data store type. You can add up to 10 widgets to a custom dashboard. You
	//	 can manually refresh a custom dashboard, or you can set a refresh schedule.
	//
	//	 - Highlights dashboard - You can create the Highlights dashboard to see a
	//	 summary of key user activities and API usage across all your event data stores.
	//	 CloudTrail Lake manages the Highlights dashboard and refreshes the dashboard
	//	 every 6 hours. To create the Highlights dashboard, you must set and enable a
	//	 refresh schedule.
	//
	// CloudTrail runs queries to populate the dashboard's widgets during a manual or
	// scheduled refresh. CloudTrail must be granted permissions to run the StartQuery
	// operation on your behalf. To provide permissions, run the PutResourcePolicy
	// operation to attach a resource-based policy to each event data store. For more
	// information, see [Example: Allow CloudTrail to run queries to populate a dashboard]in the CloudTrail User Guide.
	//
	// To set a refresh schedule, CloudTrail must be granted permissions to run the
	// StartDashboardRefresh operation to refresh the dashboard on your behalf. To
	// provide permissions, run the PutResourcePolicy operation to attach a
	// resource-based policy to the dashboard. For more information, see [Resource-based policy example for a dashboard]in the
	// CloudTrail User Guide.
	//
	// For more information about dashboards, see [CloudTrail Lake dashboards] in the CloudTrail User Guide.
	//
	// [CloudTrail Lake dashboards]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-dashboard.html
	// [Example: Allow CloudTrail to run queries to populate a dashboard]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard
	// [Resource-based policy example for a dashboard]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards
	CreateDashboard(ctx context.Context, params *cloudtrail.CreateDashboardInput, optFns ...func(*Options)) (*cloudtrail.CreateDashboardOutput, error)
	// Creates a new event data store.
	CreateEventDataStore(ctx context.Context, params *cloudtrail.CreateEventDataStoreInput, optFns ...func(*Options)) (*cloudtrail.CreateEventDataStoreOutput, error)
	// Creates a trail that specifies the settings for delivery of log data to an
	// Amazon S3 bucket.
	CreateTrail(ctx context.Context, params *cloudtrail.CreateTrailInput, optFns ...func(*Options)) (*cloudtrail.CreateTrailOutput, error)
	// Deletes a channel.
	DeleteChannel(ctx context.Context, params *cloudtrail.DeleteChannelInput, optFns ...func(*Options)) (*cloudtrail.DeleteChannelOutput, error)
	//	Deletes the specified dashboard. You cannot delete a dashboard that has
	//
	// termination protection enabled.
	DeleteDashboard(ctx context.Context, params *cloudtrail.DeleteDashboardInput, optFns ...func(*Options)) (*cloudtrail.DeleteDashboardOutput, error)
	// Disables the event data store specified by EventDataStore , which accepts an
	// event data store ARN. After you run DeleteEventDataStore , the event data store
	// enters a PENDING_DELETION state, and is automatically deleted after a wait
	// period of seven days. TerminationProtectionEnabled must be set to False on the
	// event data store and the FederationStatus must be DISABLED . You cannot delete
	// an event data store if TerminationProtectionEnabled is True or the
	// FederationStatus is ENABLED .
	//
	// After you run DeleteEventDataStore on an event data store, you cannot run
	// ListQueries , DescribeQuery , or GetQueryResults on queries that are using an
	// event data store in a PENDING_DELETION state. An event data store in the
	// PENDING_DELETION state does not incur costs.
	DeleteEventDataStore(ctx context.Context, params *cloudtrail.DeleteEventDataStoreInput, optFns ...func(*Options)) (*cloudtrail.DeleteEventDataStoreOutput, error)
	//	Deletes the resource-based policy attached to the CloudTrail event data store,
	//
	// dashboard, or channel.
	DeleteResourcePolicy(ctx context.Context, params *cloudtrail.DeleteResourcePolicyInput, optFns ...func(*Options)) (*cloudtrail.DeleteResourcePolicyOutput, error)
	// Deletes a trail. This operation must be called from the Region in which the
	// trail was created. DeleteTrail cannot be called on the shadow trails
	// (replicated trails in other Regions) of a trail that is enabled in all Regions.
	DeleteTrail(ctx context.Context, params *cloudtrail.DeleteTrailInput, optFns ...func(*Options)) (*cloudtrail.DeleteTrailOutput, error)
	// Removes CloudTrail delegated administrator permissions from a member account in
	// an organization.
	DeregisterOrganizationDelegatedAdmin(ctx context.Context, params *cloudtrail.DeregisterOrganizationDelegatedAdminInput, optFns ...func(*Options)) (*cloudtrail.DeregisterOrganizationDelegatedAdminOutput, error)
	// Returns metadata about a query, including query run time in milliseconds,
	// number of events scanned and matched, and query status. If the query results
	// were delivered to an S3 bucket, the response also provides the S3 URI and the
	// delivery status.
	//
	// You must specify either QueryId or QueryAlias . Specifying the QueryAlias
	// parameter returns information about the last query run for the alias. You can
	// provide RefreshId along with QueryAlias to view the query results of a
	// dashboard query for the specified RefreshId .
	DescribeQuery(ctx context.Context, params *cloudtrail.DescribeQueryInput, optFns ...func(*Options)) (*cloudtrail.DescribeQueryOutput, error)
	// Retrieves settings for one or more trails associated with the current Region
	// for your account.
	DescribeTrails(ctx context.Context, params *cloudtrail.DescribeTrailsInput, optFns ...func(*Options)) (*cloudtrail.DescribeTrailsOutput, error)
	//	Disables Lake query federation on the specified event data store. When you
	//
	// disable federation, CloudTrail disables the integration with Glue, Lake
	// Formation, and Amazon Athena. After disabling Lake query federation, you can no
	// longer query your event data in Amazon Athena.
	//
	// No CloudTrail Lake data is deleted when you disable federation and you can
	// continue to run queries in CloudTrail Lake.
	DisableFederation(ctx context.Context, params *cloudtrail.DisableFederationInput, optFns ...func(*Options)) (*cloudtrail.DisableFederationOutput, error)
	//	Enables Lake query federation on the specified event data store. Federating an
	//
	// event data store lets you view the metadata associated with the event data store
	// in the Glue [Data Catalog]and run SQL queries against your event data using Amazon Athena.
	// The table metadata stored in the Glue Data Catalog lets the Athena query engine
	// know how to find, read, and process the data that you want to query.
	//
	// When you enable Lake query federation, CloudTrail creates a managed database
	// named aws:cloudtrail (if the database doesn't already exist) and a managed
	// federated table in the Glue Data Catalog. The event data store ID is used for
	// the table name. CloudTrail registers the role ARN and event data store in [Lake Formation], the
	// service responsible for allowing fine-grained access control of the federated
	// resources in the Glue Data Catalog.
	//
	// For more information about Lake query federation, see [Federate an event data store].
	//
	// [Federate an event data store]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation.html
	// [Lake Formation]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/query-federation-lake-formation.html
	// [Data Catalog]: https://docs.aws.amazon.com/glue/latest/dg/components-overview.html#data-catalog-intro
	EnableFederation(ctx context.Context, params *cloudtrail.EnableFederationInput, optFns ...func(*Options)) (*cloudtrail.EnableFederationOutput, error)
	//	Generates a query from a natural language prompt. This operation uses
	//
	// generative artificial intelligence (generative AI) to produce a ready-to-use SQL
	// query from the prompt.
	//
	// The prompt can be a question or a statement about the event data in your event
	// data store. For example, you can enter prompts like "What are my top errors in
	// the past month?" and “Give me a list of users that used SNS.”
	//
	// The prompt must be in English. For information about limitations, permissions,
	// and supported Regions, see [Create CloudTrail Lake queries from natural language prompts]in the CloudTrail user guide.
	//
	// Do not include any personally identifying, confidential, or sensitive
	// information in your prompts.
	//
	// This feature uses generative AI large language models (LLMs); we recommend
	// double-checking the LLM response.
	//
	// [Create CloudTrail Lake queries from natural language prompts]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-query-generator.html
	GenerateQuery(ctx context.Context, params *cloudtrail.GenerateQueryInput, optFns ...func(*Options)) (*cloudtrail.GenerateQueryOutput, error)
	// Returns information about a specific channel.
	GetChannel(ctx context.Context, params *cloudtrail.GetChannelInput, optFns ...func(*Options)) (*cloudtrail.GetChannelOutput, error)
	// Returns the specified dashboard.
	GetDashboard(ctx context.Context, params *cloudtrail.GetDashboardInput, optFns ...func(*Options)) (*cloudtrail.GetDashboardOutput, error)
	// Returns information about an event data store specified as either an ARN or the
	// ID portion of the ARN.
	GetEventDataStore(ctx context.Context, params *cloudtrail.GetEventDataStoreInput, optFns ...func(*Options)) (*cloudtrail.GetEventDataStoreOutput, error)
	// Describes the settings for the event selectors that you configured for your
	// trail. The information returned for your event selectors includes the following:
	//
	//   - If your event selector includes read-only events, write-only events, or all
	//     events. This applies to management events, data events, and network activity
	//     events.
	//
	//   - If your event selector includes management events.
	//
	//   - If your event selector includes network activity events, the event sources
	//     for which you are logging network activity events.
	//
	//   - If your event selector includes data events, the resources on which you are
	//     logging data events.
	//
	// For more information about logging management, data, and network activity
	// events, see the following topics in the CloudTrail User Guide:
	//
	// [Logging management events]
	//
	// [Logging data events]
	//
	// [Logging network activity events]
	//
	// [Logging network activity events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html
	// [Logging management events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html
	// [Logging data events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html
	GetEventSelectors(ctx context.Context, params *cloudtrail.GetEventSelectorsInput, optFns ...func(*Options)) (*cloudtrail.GetEventSelectorsOutput, error)
	// Returns information about a specific import.
	GetImport(ctx context.Context, params *cloudtrail.GetImportInput, optFns ...func(*Options)) (*cloudtrail.GetImportOutput, error)
	// Describes the settings for the Insights event selectors that you configured for
	// your trail or event data store. GetInsightSelectors shows if CloudTrail
	// Insights event logging is enabled on the trail or event data store, and if it
	// is, which Insights types are enabled. If you run GetInsightSelectors on a trail
	// or event data store that does not have Insights events enabled, the operation
	// throws the exception InsightNotEnabledException
	//
	// Specify either the EventDataStore parameter to get Insights event selectors for
	// an event data store, or the TrailName parameter to the get Insights event
	// selectors for a trail. You cannot specify these parameters together.
	//
	// For more information, see [Working with CloudTrail Insights] in the CloudTrail User Guide.
	//
	// [Working with CloudTrail Insights]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html
	GetInsightSelectors(ctx context.Context, params *cloudtrail.GetInsightSelectorsInput, optFns ...func(*Options)) (*cloudtrail.GetInsightSelectorsOutput, error)
	// Gets event data results of a query. You must specify the QueryID value returned
	// by the StartQuery operation.
	GetQueryResults(ctx context.Context, params *cloudtrail.GetQueryResultsInput, optFns ...func(*Options)) (*cloudtrail.GetQueryResultsOutput, error)
	//	Retrieves the JSON text of the resource-based policy document attached to the
	//
	// CloudTrail event data store, dashboard, or channel.
	GetResourcePolicy(ctx context.Context, params *cloudtrail.GetResourcePolicyInput, optFns ...func(*Options)) (*cloudtrail.GetResourcePolicyOutput, error)
	// Returns settings information for a specified trail.
	GetTrail(ctx context.Context, params *cloudtrail.GetTrailInput, optFns ...func(*Options)) (*cloudtrail.GetTrailOutput, error)
	// Returns a JSON-formatted list of information about the specified trail. Fields
	// include information on delivery errors, Amazon SNS and Amazon S3 errors, and
	// start and stop logging times for each trail. This operation returns trail status
	// from a single Region. To return trail status from all Regions, you must call the
	// operation on each Region.
	GetTrailStatus(ctx context.Context, params *cloudtrail.GetTrailStatusInput, optFns ...func(*Options)) (*cloudtrail.GetTrailStatusOutput, error)
	// Lists the channels in the current account, and their source names.
	ListChannels(ctx context.Context, params *cloudtrail.ListChannelsInput, optFns ...func(*Options)) (*cloudtrail.ListChannelsOutput, error)
	//	Returns information about all dashboards in the account, in the current
	//
	// Region.
	ListDashboards(ctx context.Context, params *cloudtrail.ListDashboardsInput, optFns ...func(*Options)) (*cloudtrail.ListDashboardsOutput, error)
	// Returns information about all event data stores in the account, in the current
	// Region.
	ListEventDataStores(ctx context.Context, params *cloudtrail.ListEventDataStoresInput, optFns ...func(*Options)) (*cloudtrail.ListEventDataStoresOutput, error)
	// Returns a list of failures for the specified import.
	ListImportFailures(ctx context.Context, params *cloudtrail.ListImportFailuresInput, optFns ...func(*Options)) (*cloudtrail.ListImportFailuresOutput, error)
	//	Returns information on all imports, or a select set of imports by ImportStatus
	//
	// or Destination .
	ListImports(ctx context.Context, params *cloudtrail.ListImportsInput, optFns ...func(*Options)) (*cloudtrail.ListImportsOutput, error)
	// Returns Insights metrics data for trails that have enabled Insights. The
	// request must include the EventSource , EventName , and InsightType parameters.
	//
	// If the InsightType is set to ApiErrorRateInsight , the request must also include
	// the ErrorCode parameter.
	//
	// The following are the available time periods for ListInsightsMetricData . Each
	// cutoff is inclusive.
	//
	//   - Data points with a period of 60 seconds (1-minute) are available for 15
	//     days.
	//
	//   - Data points with a period of 300 seconds (5-minute) are available for 63
	//     days.
	//
	//   - Data points with a period of 3600 seconds (1 hour) are available for 90
	//     days.
	//
	// Access to the ListInsightsMetricData API operation is linked to the
	// cloudtrail:LookupEvents action. To use this operation, you must have permissions
	// to perform the cloudtrail:LookupEvents action.
	ListInsightsMetricData(ctx context.Context, params *cloudtrail.ListInsightsMetricDataInput, optFns ...func(*Options)) (*cloudtrail.ListInsightsMetricDataOutput, error)
	// Returns all public keys whose private keys were used to sign the digest files
	// within the specified time range. The public key is needed to validate digest
	// files that were signed with its corresponding private key.
	//
	// CloudTrail uses different private and public key pairs per Region. Each digest
	// file is signed with a private key unique to its Region. When you validate a
	// digest file from a specific Region, you must look in the same Region for its
	// corresponding public key.
	ListPublicKeys(ctx context.Context, params *cloudtrail.ListPublicKeysInput, optFns ...func(*Options)) (*cloudtrail.ListPublicKeysOutput, error)
	// Returns a list of queries and query statuses for the past seven days. You must
	// specify an ARN value for EventDataStore . Optionally, to shorten the list of
	// results, you can specify a time range, formatted as timestamps, by adding
	// StartTime and EndTime parameters, and a QueryStatus value. Valid values for
	// QueryStatus include QUEUED , RUNNING , FINISHED , FAILED , TIMED_OUT , or
	// CANCELLED .
	ListQueries(ctx context.Context, params *cloudtrail.ListQueriesInput, optFns ...func(*Options)) (*cloudtrail.ListQueriesOutput, error)
	// Lists the tags for the specified trails, event data stores, dashboards, or
	// channels in the current Region.
	ListTags(ctx context.Context, params *cloudtrail.ListTagsInput, optFns ...func(*Options)) (*cloudtrail.ListTagsOutput, error)
	// Lists trails that are in the current account.
	ListTrails(ctx context.Context, params *cloudtrail.ListTrailsInput, optFns ...func(*Options)) (*cloudtrail.ListTrailsOutput, error)
	// Looks up [management events] or [CloudTrail Insights events] that are captured by CloudTrail. You can look up events that
	// occurred in a Region within the last 90 days.
	//
	// LookupEvents returns recent Insights events for trails that enable Insights. To
	// view Insights events for an event data store, you can run queries on your
	// Insights event data store, and you can also view the Lake dashboard for
	// Insights.
	//
	// Lookup supports the following attributes for management events:
	//
	//   - Amazon Web Services access key
	//
	//   - Event ID
	//
	//   - Event name
	//
	//   - Event source
	//
	//   - Read only
	//
	//   - Resource name
	//
	//   - Resource type
	//
	//   - User name
	//
	// Lookup supports the following attributes for Insights events:
	//
	//   - Event ID
	//
	//   - Event name
	//
	//   - Event source
	//
	// All attributes are optional. The default number of results returned is 50, with
	// a maximum of 50 possible. The response includes a token that you can use to get
	// the next page of results.
	//
	// The rate of lookup requests is limited to two per second, per account, per
	// Region. If this limit is exceeded, a throttling error occurs.
	//
	// [CloudTrail Insights events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events
	// [management events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events
	LookupEvents(ctx context.Context, params *cloudtrail.LookupEventsInput, optFns ...func(*Options)) (*cloudtrail.LookupEventsOutput, error)
	// Configures event selectors (also referred to as basic event selectors) or
	// advanced event selectors for your trail. You can use either
	// AdvancedEventSelectors or EventSelectors , but not both. If you apply
	// AdvancedEventSelectors to a trail, any existing EventSelectors are overwritten.
	//
	// You can use AdvancedEventSelectors to log management events, data events for
	// all resource types, and network activity events.
	//
	// You can use EventSelectors to log management events and data events for the
	// following resource types:
	//
	//   - AWS::DynamoDB::Table
	//
	//   - AWS::Lambda::Function
	//
	//   - AWS::S3::Object
	//
	// You can't use EventSelectors to log network activity events.
	//
	// If you want your trail to log Insights events, be sure the event selector or
	// advanced event selector enables logging of the Insights event types you want
	// configured for your trail. For more information about logging Insights events,
	// see [Working with CloudTrail Insights]in the CloudTrail User Guide. By default, trails created without specific
	// event selectors are configured to log all read and write management events, and
	// no data events or network activity events.
	//
	// When an event occurs in your account, CloudTrail evaluates the event selectors
	// or advanced event selectors in all trails. For each trail, if the event matches
	// any event selector, the trail processes and logs the event. If the event doesn't
	// match any event selector, the trail doesn't log the event.
	//
	// Example
	//
	//   - You create an event selector for a trail and specify that you want to log
	//     write-only events.
	//
	//   - The EC2 GetConsoleOutput and RunInstances API operations occur in your
	//     account.
	//
	//   - CloudTrail evaluates whether the events match your event selectors.
	//
	//   - The RunInstances is a write-only event and it matches your event selector.
	//     The trail logs the event.
	//
	//   - The GetConsoleOutput is a read-only event that doesn't match your event
	//     selector. The trail doesn't log the event.
	//
	// The PutEventSelectors operation must be called from the Region in which the
	// trail was created; otherwise, an InvalidHomeRegionException exception is thrown.
	//
	// You can configure up to five event selectors for each trail.
	//
	// You can add advanced event selectors, and conditions for your advanced event
	// selectors, up to a maximum of 500 values for all conditions and selectors on a
	// trail. For more information, see [Logging management events], [Logging data events], [Logging network activity events], and [Quotas in CloudTrail] in the CloudTrail User Guide.
	//
	// [Logging network activity events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html
	// [Logging management events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html
	// [Working with CloudTrail Insights]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html
	// [Quotas in CloudTrail]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html
	// [Logging data events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html
	PutEventSelectors(ctx context.Context, params *cloudtrail.PutEventSelectorsInput, optFns ...func(*Options)) (*cloudtrail.PutEventSelectorsOutput, error)
	// Lets you enable Insights event logging by specifying the Insights selectors
	// that you want to enable on an existing trail or event data store. You also use
	// PutInsightSelectors to turn off Insights event logging, by passing an empty list
	// of Insights types. The valid Insights event types are ApiErrorRateInsight and
	// ApiCallRateInsight .
	//
	// To enable Insights on an event data store, you must specify the ARNs (or ID
	// suffix of the ARNs) for the source event data store ( EventDataStore ) and the
	// destination event data store ( InsightsDestination ). The source event data
	// store logs management events and enables Insights. The destination event data
	// store logs Insights events based upon the management event activity of the
	// source event data store. The source and destination event data stores must
	// belong to the same Amazon Web Services account.
	//
	// To log Insights events for a trail, you must specify the name ( TrailName ) of
	// the CloudTrail trail for which you want to change or add Insights selectors.
	//
	// To log CloudTrail Insights events on API call volume, the trail or event data
	// store must log write management events. To log CloudTrail Insights events on
	// API error rate, the trail or event data store must log read or write management
	// events. You can call GetEventSelectors on a trail to check whether the trail
	// logs management events. You can call GetEventDataStore on an event data store
	// to check whether the event data store logs management events.
	//
	// For more information, see [Working with CloudTrail Insights] in the CloudTrail User Guide.
	//
	// [Working with CloudTrail Insights]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-insights-events-with-cloudtrail.html
	PutInsightSelectors(ctx context.Context, params *cloudtrail.PutInsightSelectorsInput, optFns ...func(*Options)) (*cloudtrail.PutInsightSelectorsOutput, error)
	//	Attaches a resource-based permission policy to a CloudTrail event data store,
	//
	// dashboard, or channel. For more information about resource-based policies, see [CloudTrail resource-based policy examples]
	// in the CloudTrail User Guide.
	//
	// [CloudTrail resource-based policy examples]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html
	PutResourcePolicy(ctx context.Context, params *cloudtrail.PutResourcePolicyInput, optFns ...func(*Options)) (*cloudtrail.PutResourcePolicyOutput, error)
	// Registers an organization’s member account as the CloudTrail [delegated administrator].
	//
	// [delegated administrator]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-delegated-administrator.html
	RegisterOrganizationDelegatedAdmin(ctx context.Context, params *cloudtrail.RegisterOrganizationDelegatedAdminInput, optFns ...func(*Options)) (*cloudtrail.RegisterOrganizationDelegatedAdminOutput, error)
	// Removes the specified tags from a trail, event data store, dashboard, or
	// channel.
	RemoveTags(ctx context.Context, params *cloudtrail.RemoveTagsInput, optFns ...func(*Options)) (*cloudtrail.RemoveTagsOutput, error)
	// Restores a deleted event data store specified by EventDataStore , which accepts
	// an event data store ARN. You can only restore a deleted event data store within
	// the seven-day wait period after deletion. Restoring an event data store can take
	// several minutes, depending on the size of the event data store.
	RestoreEventDataStore(ctx context.Context, params *cloudtrail.RestoreEventDataStoreInput, optFns ...func(*Options)) (*cloudtrail.RestoreEventDataStoreOutput, error)
	//	Searches sample queries and returns a list of sample queries that are sorted
	//
	// by relevance. To search for sample queries, provide a natural language
	// SearchPhrase in English.
	SearchSampleQueries(ctx context.Context, params *cloudtrail.SearchSampleQueriesInput, optFns ...func(*Options)) (*cloudtrail.SearchSampleQueriesOutput, error)
	//	Starts a refresh of the specified dashboard.
	//
	// Each time a dashboard is refreshed, CloudTrail runs queries to populate the
	// dashboard's widgets. CloudTrail must be granted permissions to run the
	// StartQuery operation on your behalf. To provide permissions, run the
	// PutResourcePolicy operation to attach a resource-based policy to each event data
	// store. For more information, see [Example: Allow CloudTrail to run queries to populate a dashboard]in the CloudTrail User Guide.
	//
	// [Example: Allow CloudTrail to run queries to populate a dashboard]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard
	StartDashboardRefresh(ctx context.Context, params *cloudtrail.StartDashboardRefreshInput, optFns ...func(*Options)) (*cloudtrail.StartDashboardRefreshOutput, error)
	// Starts the ingestion of live events on an event data store specified as either
	// an ARN or the ID portion of the ARN. To start ingestion, the event data store
	// Status must be STOPPED_INGESTION and the eventCategory must be Management , Data
	// , NetworkActivity , or ConfigurationItem .
	StartEventDataStoreIngestion(ctx context.Context, params *cloudtrail.StartEventDataStoreIngestionInput, optFns ...func(*Options)) (*cloudtrail.StartEventDataStoreIngestionOutput, error)
	//	Starts an import of logged trail events from a source S3 bucket to a
	//
	// destination event data store. By default, CloudTrail only imports events
	// contained in the S3 bucket's CloudTrail prefix and the prefixes inside the
	// CloudTrail prefix, and does not check prefixes for other Amazon Web Services
	// services. If you want to import CloudTrail events contained in another prefix,
	// you must include the prefix in the S3LocationUri . For more considerations about
	// importing trail events, see [Considerations for copying trail events]in the CloudTrail User Guide.
	//
	// When you start a new import, the Destinations and ImportSource parameters are
	// required. Before starting a new import, disable any access control lists (ACLs)
	// attached to the source S3 bucket. For more information about disabling ACLs, see
	// [Controlling ownership of objects and disabling ACLs for your bucket].
	//
	// When you retry an import, the ImportID parameter is required.
	//
	// If the destination event data store is for an organization, you must use the
	// management account to import trail events. You cannot use the delegated
	// administrator account for the organization.
	//
	// [Considerations for copying trail events]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-copy-trail-to-lake.html#cloudtrail-trail-copy-considerations
	// [Controlling ownership of objects and disabling ACLs for your bucket]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/about-object-ownership.html
	StartImport(ctx context.Context, params *cloudtrail.StartImportInput, optFns ...func(*Options)) (*cloudtrail.StartImportOutput, error)
	// Starts the recording of Amazon Web Services API calls and log file delivery for
	// a trail. For a trail that is enabled in all Regions, this operation must be
	// called from the Region in which the trail was created. This operation cannot be
	// called on the shadow trails (replicated trails in other Regions) of a trail that
	// is enabled in all Regions.
	StartLogging(ctx context.Context, params *cloudtrail.StartLoggingInput, optFns ...func(*Options)) (*cloudtrail.StartLoggingOutput, error)
	// Starts a CloudTrail Lake query. Use the QueryStatement parameter to provide
	// your SQL query, enclosed in single quotation marks. Use the optional
	// DeliveryS3Uri parameter to deliver the query results to an S3 bucket.
	//
	// StartQuery requires you specify either the QueryStatement parameter, or a
	// QueryAlias and any QueryParameters . In the current release, the QueryAlias and
	// QueryParameters parameters are used only for the queries that populate the
	// CloudTrail Lake dashboards.
	StartQuery(ctx context.Context, params *cloudtrail.StartQueryInput, optFns ...func(*Options)) (*cloudtrail.StartQueryOutput, error)
	// Stops the ingestion of live events on an event data store specified as either
	// an ARN or the ID portion of the ARN. To stop ingestion, the event data store
	// Status must be ENABLED and the eventCategory must be Management , Data ,
	// NetworkActivity , or ConfigurationItem .
	StopEventDataStoreIngestion(ctx context.Context, params *cloudtrail.StopEventDataStoreIngestionInput, optFns ...func(*Options)) (*cloudtrail.StopEventDataStoreIngestionOutput, error)
	// Stops a specified import.
	StopImport(ctx context.Context, params *cloudtrail.StopImportInput, optFns ...func(*Options)) (*cloudtrail.StopImportOutput, error)
	// Suspends the recording of Amazon Web Services API calls and log file delivery
	// for the specified trail. Under most circumstances, there is no need to use this
	// action. You can update a trail without stopping it first. This action is the
	// only way to stop recording. For a trail enabled in all Regions, this operation
	// must be called from the Region in which the trail was created, or an
	// InvalidHomeRegionException will occur. This operation cannot be called on the
	// shadow trails (replicated trails in other Regions) of a trail enabled in all
	// Regions.
	StopLogging(ctx context.Context, params *cloudtrail.StopLoggingInput, optFns ...func(*Options)) (*cloudtrail.StopLoggingOutput, error)
	// Updates a channel specified by a required channel ARN or UUID.
	UpdateChannel(ctx context.Context, params *cloudtrail.UpdateChannelInput, optFns ...func(*Options)) (*cloudtrail.UpdateChannelOutput, error)
	//	Updates the specified dashboard.
	//
	// To set a refresh schedule, CloudTrail must be granted permissions to run the
	// StartDashboardRefresh operation to refresh the dashboard on your behalf. To
	// provide permissions, run the PutResourcePolicy operation to attach a
	// resource-based policy to the dashboard. For more information, see [Resource-based policy example for a dashboard]in the
	// CloudTrail User Guide.
	//
	// CloudTrail runs queries to populate the dashboard's widgets during a manual or
	// scheduled refresh. CloudTrail must be granted permissions to run the StartQuery
	// operation on your behalf. To provide permissions, run the PutResourcePolicy
	// operation to attach a resource-based policy to each event data store. For more
	// information, see [Example: Allow CloudTrail to run queries to populate a dashboard]in the CloudTrail User Guide.
	//
	// [Example: Allow CloudTrail to run queries to populate a dashboard]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard
	// [Resource-based policy example for a dashboard]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards
	UpdateDashboard(ctx context.Context, params *cloudtrail.UpdateDashboardInput, optFns ...func(*Options)) (*cloudtrail.UpdateDashboardOutput, error)
	// Updates an event data store. The required EventDataStore value is an ARN or the
	// ID portion of the ARN. Other parameters are optional, but at least one optional
	// parameter must be specified, or CloudTrail throws an error. RetentionPeriod is
	// in days, and valid values are integers between 7 and 3653 if the BillingMode is
	// set to EXTENDABLE_RETENTION_PRICING , or between 7 and 2557 if BillingMode is
	// set to FIXED_RETENTION_PRICING . By default, TerminationProtection is enabled.
	//
	// For event data stores for CloudTrail events, AdvancedEventSelectors includes or
	// excludes management, data, or network activity events in your event data store.
	// For more information about AdvancedEventSelectors , see [AdvancedEventSelectors].
	//
	// For event data stores for CloudTrail Insights events, Config configuration
	// items, Audit Manager evidence, or non-Amazon Web Services events,
	// AdvancedEventSelectors includes events of that type in your event data store.
	//
	// [AdvancedEventSelectors]: https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html
	UpdateEventDataStore(ctx context.Context, params *cloudtrail.UpdateEventDataStoreInput, optFns ...func(*Options)) (*cloudtrail.UpdateEventDataStoreOutput, error)
	// Updates trail settings that control what events you are logging, and how to
	// handle log files. Changes to a trail do not require stopping the CloudTrail
	// service. Use this action to designate an existing bucket for log delivery. If
	// the existing bucket has previously been a target for CloudTrail log files, an
	// IAM policy exists for the bucket. UpdateTrail must be called from the Region in
	// which the trail was created; otherwise, an InvalidHomeRegionException is thrown.
	UpdateTrail(ctx context.Context, params *cloudtrail.UpdateTrailInput, optFns ...func(*Options)) (*cloudtrail.UpdateTrailOutput, error)
}

