// Copyright 2021 Dolthub, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package altertests

import (
	"testing"
)

func TestModifyTypeDouble(t *testing.T) {
	tests := []ModifyTypeTest{
		{
			"DOUBLE",
			"TINYINT",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"0.0")`,
			[]interface{}{float64(0)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"0.0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"0.0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"0.0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"0.0")`,
			[]interface{}{"0.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"0.0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"0.0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"0.0")`,
			[]interface{}{"0.000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"0.0")`,
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"0.0")`,
			[]interface{}{"0.000000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"0.0")`,
			[]interface{}{uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"0.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"0.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"0.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"0.0")`,
			[]interface{}{"0"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"0.0")`,
			[]interface{}{int64(0)},
			false,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"0.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"0.0")`,
			[]interface{}{"00:00:00"},
			false,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"0.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"0.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"0.0")`,
			[]interface{}{""},
			false,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{float64(0), float64(0.5)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{"00:00:00", "00:00:00.500000"},
			false,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{float64(-0.5), float64(0), float64(0.5)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0.0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0.0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0.0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0.0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.500000000000000", "0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.500000000000000", "0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.500000000000000", "0.000000000000000", "0.500000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-0.5", "0", "0.5"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{"-00:00:00.500000", "00:00:00", "00:00:00.500000"},
			false,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"-0.5"), (1,"0.0"), (2,"0.5")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{float64(0), float64(0.5), float64(0.125)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "1", "0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "1", "0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "1", "0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "1", "0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.0", "0.5", "0.1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.0", "0.5", "0.1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.0", "0.5", "0.1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.0", "0.5", "0.1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{"00:00:00", "00:00:00.500000", "00:00:00.125000"},
			false,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{float64(-0.125), float64(-0.5), float64(0), float64(0.5), float64(0.125)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"0", "-1", "0", "1", "0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"0", "-1", "0", "1", "0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"0", "-1", "0", "1", "0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"0", "-1", "0", "1", "0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.1", "-0.5", "0.0", "0.5", "0.1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.1", "-0.5", "0.0", "0.5", "0.1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.1", "-0.5", "0.0", "0.5", "0.1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.1", "-0.5", "0.0", "0.5", "0.1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(0), uint64(0)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-0.125", "-0.5", "0", "0.5", "0.125"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(0), int64(0)},
			false,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{"-00:00:00.125000", "-00:00:00.500000", "00:00:00", "00:00:00.500000", "00:00:00.125000"},
			false,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"-0.125"), (1,"-0.5"), (2,"0.0"), (3,"0.5"), (4,"0.125")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{float64(0), float64(0.5), float64(0.125), float64(1)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(2001)},
			false,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{"00:00:00", "00:00:00.500000", "00:00:00.125000", "00:00:01"},
			false,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{float64(-1), float64(-0.125), float64(-0.5), float64(0), float64(0.5), float64(0.125), float64(1)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "0", "-1", "0", "1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "0", "-1", "0", "1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "0", "-1", "0", "1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "0", "-1", "0", "1", "0", "1"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1.000000000000000000000000000000", "-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{uint64(18446744073709551615), uint64(0), uint64(0), uint64(0), uint64(0), uint64(0), uint64(1)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{"-00:00:01", "-00:00:00.125000", "-00:00:00.500000", "00:00:00", "00:00:00.500000", "00:00:00.125000", "00:00:01"},
			false,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"-1.0"), (1,"-0.125"), (2,"-0.5"), (3,"0.0"), (4,"0.5"), (5,"0.125"), (6,"1.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "1", "0", "1", "257"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "1", "0", "1", "257"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "1", "0", "1", "257"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{"00:00:00", "00:00:00.500000", "00:00:00.125000", "00:00:01", "00:02:56.750000"},
			false,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{float64(-256.75), float64(-1), float64(-0.125), float64(-0.5), float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-257", "-1", "0", "-1", "0", "1", "0", "1", "257"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-257", "-1", "0", "-1", "0", "1", "0", "1", "257"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-257", "-1", "0", "-1", "0", "1", "0", "1", "257"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.750000000000000000000000000000", "-1.000000000000000000000000000000", "-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{uint64(18446744073709551359), uint64(18446744073709551615), uint64(0), uint64(0), uint64(0), uint64(0), uint64(0), uint64(1), uint64(257)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{"-00:02:56.750000", "-00:00:01", "-00:00:00.125000", "-00:00:00.500000", "00:00:00", "00:00:00.500000", "00:00:00.125000", "00:00:01", "00:02:56.750000"},
			false,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"-256.75"), (1,"-1.0"), (2,"-0.125"), (3,"-0.5"), (4,"0.0"), (5,"0.5"), (6,"0.125"), (7,"1.0"), (8,"256.75")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75), float64(1.048575e+06)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000", "1048575.000000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00", "1048575\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{float64(-1.048575e+06), float64(-256.75), float64(-1), float64(-0.125), float64(-0.5), float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75), float64(1.048575e+06)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.000000000000000", "-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.000000000000000", "-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575.000000000000000000000000000000", "-256.750000000000000000000000000000", "-1.000000000000000000000000000000", "-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000", "1048575.000000000000000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{uint64(18446744073708503041), uint64(18446744073709551359), uint64(18446744073709551615), uint64(0), uint64(0), uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575\x00\x00", "-256.75\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00", "1048575\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{"-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"-1048575.0"), (1,"-256.75"), (2,"-1.0"), (3,"-0.125"), (4,"-0.5"), (5,"0.0"), (6,"0.5"), (7,"0.125"), (8,"1.0"), (9,"256.75"), (10,"1048575.0")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75), float64(1.048575e+06), float64(1.048575e+06)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000", "1048575.000015258800000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000", "1048575.000015258800000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000", "1048575.000000000000000000000000000000", "1048575.000015258800000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575.0000152588\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575.0000152588\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{"0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"0.0"), (1,"0.5"), (2,"0.125"), (3,"1.0"), (4,"256.75"), (5,"1048575.0"), (6,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TINYINT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"MEDIUMINT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{int64(-1048575), int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"INT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{int64(-1048575), int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"BIGINT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{int64(-1048575), int64(-1048575), int64(-257), int64(-1), int64(0), int64(0), int64(0), int64(0), int64(0), int64(1), int64(257), int64(1048575), int64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"TINYINT UNSIGNED",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SMALLINT UNSIGNED",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"MEDIUMINT UNSIGNED",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"INT UNSIGNED",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIGINT UNSIGNED",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"FLOAT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{float64(-1.048575e+06), float64(-1.048575e+06), float64(-256.75), float64(-1), float64(-0.125), float64(-0.5), float64(0), float64(0.5), float64(0.125), float64(1), float64(256.75), float64(1.048575e+06), float64(1.048575e+06)},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,0)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,0)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,0)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,0)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575", "-1048575", "-257", "-1", "0", "-1", "0", "1", "0", "1", "257", "1048575", "1048575"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(1,1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(15,1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0", "-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0", "-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0", "-1048575.0", "-256.8", "-1.0", "-0.1", "-0.5", "0.0", "0.5", "0.1", "1.0", "256.8", "1048575.0", "1048575.0"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(15,15)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(30,15)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.000015258800000", "-1048575.000000000000000", "-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000", "1048575.000015258800000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(65,15)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.000015258800000", "-1048575.000000000000000", "-256.750000000000000", "-1.000000000000000", "-0.125000000000000", "-0.500000000000000", "0.000000000000000", "0.500000000000000", "0.125000000000000", "1.000000000000000", "256.750000000000000", "1048575.000000000000000", "1048575.000015258800000"},
			false,
		},
		{
			"DOUBLE",
			"DECIMAL(30,30)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DECIMAL(65,30)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.000015258800000000000000000000", "-1048575.000000000000000000000000000000", "-256.750000000000000000000000000000", "-1.000000000000000000000000000000", "-0.125000000000000000000000000000", "-0.500000000000000000000000000000", "0.000000000000000000000000000000", "0.500000000000000000000000000000", "0.125000000000000000000000000000", "1.000000000000000000000000000000", "256.750000000000000000000000000000", "1048575.000000000000000000000000000000", "1048575.000015258800000000000000000000"},
			false,
		},
		{
			"DOUBLE",
			"BIT(1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(8)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(16)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(24)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(32)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(48)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BIT(64)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{uint64(18446744073708503041), uint64(18446744073708503041), uint64(18446744073709551359), uint64(18446744073709551615), uint64(0), uint64(0), uint64(0), uint64(0), uint64(0), uint64(1), uint64(257), uint64(1048575), uint64(1048575)},
			false,
		},
		{
			"DOUBLE",
			"TINYBLOB",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"BLOB",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMBLOB",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"LONGBLOB",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"TINYTEXT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"TEXT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"MEDIUMTEXT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"LONGTEXT",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(10)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"CHAR(100)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"CHAR(255)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(10)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"BINARY(100)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575.0000152588\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"BINARY(255)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "-0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.5\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "0.125\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "256.75\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", "1048575.0000152588\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(10)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARCHAR(100)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(255)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(1023)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARCHAR(4095)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(10)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"VARBINARY(100)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(255)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(1023)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(4095)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"VARBINARY(16383)",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{"-1048575.0000152588", "-1048575", "-256.75", "-1", "-0.125", "-0.5", "0", "0.5", "0.125", "1", "256.75", "1048575", "1048575.0000152588"},
			false,
		},
		{
			"DOUBLE",
			"YEAR",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATE",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIME",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"TIMESTAMP",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"DATETIME",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('B','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('A','B','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"ENUM('C','A','B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('B','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('A','B','C')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
		{
			"DOUBLE",
			"SET('C','A','B')",
			`(0,"-1048575.0000152587890625"), (1,"-1048575.0"), (2,"-256.75"), (3,"-1.0"), (4,"-0.125"), (5,"-0.5"), (6,"0.0"), (7,"0.5"), (8,"0.125"), (9,"1.0"), (10,"256.75"), (11,"1048575.0"), (12,"1048575.0000152587890625")`,
			[]interface{}{},
			true,
		},
	}

	RunModifyTypeTests(t, tests)
}
