// Code generated by smithy-go-codegen DO NOT EDIT.

package workspaces

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/workspaces/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the available directories that are registered with Amazon WorkSpaces.
func (c *Client) DescribeWorkspaceDirectories(ctx context.Context, params *DescribeWorkspaceDirectoriesInput, optFns ...func(*Options)) (*DescribeWorkspaceDirectoriesOutput, error) {
	if params == nil {
		params = &DescribeWorkspaceDirectoriesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeWorkspaceDirectories", params, optFns, c.addOperationDescribeWorkspaceDirectoriesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeWorkspaceDirectoriesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeWorkspaceDirectoriesInput struct {

	// The identifiers of the directories. If the value is null, all directories are
	// retrieved.
	DirectoryIds []string

	// The filter condition for the WorkSpaces.
	Filters []types.DescribeWorkspaceDirectoriesFilter

	// The maximum number of directories to return.
	Limit *int32

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string

	// The names of the WorkSpace directories.
	WorkspaceDirectoryNames []string

	noSmithyDocumentSerde
}

type DescribeWorkspaceDirectoriesOutput struct {

	// Information about the directories.
	Directories []types.WorkspaceDirectory

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeWorkspaceDirectoriesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeWorkspaceDirectories{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeWorkspaceDirectories{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeWorkspaceDirectories"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeWorkspaceDirectoriesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeWorkspaceDirectories(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeWorkspaceDirectoriesPaginatorOptions is the paginator options for
// DescribeWorkspaceDirectories
type DescribeWorkspaceDirectoriesPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeWorkspaceDirectoriesPaginator is a paginator for
// DescribeWorkspaceDirectories
type DescribeWorkspaceDirectoriesPaginator struct {
	options   DescribeWorkspaceDirectoriesPaginatorOptions
	client    DescribeWorkspaceDirectoriesAPIClient
	params    *DescribeWorkspaceDirectoriesInput
	nextToken *string
	firstPage bool
}

// NewDescribeWorkspaceDirectoriesPaginator returns a new
// DescribeWorkspaceDirectoriesPaginator
func NewDescribeWorkspaceDirectoriesPaginator(client DescribeWorkspaceDirectoriesAPIClient, params *DescribeWorkspaceDirectoriesInput, optFns ...func(*DescribeWorkspaceDirectoriesPaginatorOptions)) *DescribeWorkspaceDirectoriesPaginator {
	if params == nil {
		params = &DescribeWorkspaceDirectoriesInput{}
	}

	options := DescribeWorkspaceDirectoriesPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeWorkspaceDirectoriesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeWorkspaceDirectoriesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeWorkspaceDirectories page.
func (p *DescribeWorkspaceDirectoriesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeWorkspaceDirectoriesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeWorkspaceDirectories(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeWorkspaceDirectoriesAPIClient is a client that implements the
// DescribeWorkspaceDirectories operation.
type DescribeWorkspaceDirectoriesAPIClient interface {
	DescribeWorkspaceDirectories(context.Context, *DescribeWorkspaceDirectoriesInput, ...func(*Options)) (*DescribeWorkspaceDirectoriesOutput, error)
}

var _ DescribeWorkspaceDirectoriesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeWorkspaceDirectories(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeWorkspaceDirectories",
	}
}
