// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// The aggregation Region is now called the home Region.
//
// Updates cross-Region aggregation settings. You can use this operation to update
// the Region linking mode and the list of included or excluded Amazon Web Services
// Regions. However, you can't use this operation to change the home Region.
//
// You can invoke this operation from the current home Region only.
func (c *Client) UpdateFindingAggregator(ctx context.Context, params *UpdateFindingAggregatorInput, optFns ...func(*Options)) (*UpdateFindingAggregatorOutput, error) {
	if params == nil {
		params = &UpdateFindingAggregatorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateFindingAggregator", params, optFns, c.addOperationUpdateFindingAggregatorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateFindingAggregatorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateFindingAggregatorInput struct {

	// The ARN of the finding aggregator. To obtain the ARN, use ListFindingAggregators
	// .
	//
	// This member is required.
	FindingAggregatorArn *string

	// Indicates whether to aggregate findings from all of the available Regions in
	// the current partition. Also determines whether to automatically aggregate
	// findings from new Regions as Security Hub supports them and you opt into them.
	//
	// The selected option also determines how to use the Regions provided in the
	// Regions list.
	//
	// The options are as follows:
	//
	//   - ALL_REGIONS - Aggregates findings from all of the Regions where Security Hub
	//   is enabled. When you choose this option, Security Hub also automatically
	//   aggregates findings from new Regions as Security Hub supports them and you opt
	//   into them.
	//
	//   - ALL_REGIONS_EXCEPT_SPECIFIED - Aggregates findings from all of the Regions
	//   where Security Hub is enabled, except for the Regions listed in the Regions
	//   parameter. When you choose this option, Security Hub also automatically
	//   aggregates findings from new Regions as Security Hub supports them and you opt
	//   into them.
	//
	//   - SPECIFIED_REGIONS - Aggregates findings only from the Regions listed in the
	//   Regions parameter. Security Hub does not automatically aggregate findings from
	//   new Regions.
	//
	//   - NO_REGIONS - Aggregates no data because no Regions are selected as linked
	//   Regions.
	//
	// This member is required.
	RegionLinkingMode *string

	// If RegionLinkingMode is ALL_REGIONS_EXCEPT_SPECIFIED , then this is a
	// space-separated list of Regions that don't replicate and send findings to the
	// home Region.
	//
	// If RegionLinkingMode is SPECIFIED_REGIONS , then this is a space-separated list
	// of Regions that do replicate and send findings to the home Region.
	//
	// An InvalidInputException error results if you populate this field while
	// RegionLinkingMode is NO_REGIONS .
	Regions []string

	noSmithyDocumentSerde
}

type UpdateFindingAggregatorOutput struct {

	// The home Region. Findings generated in linked Regions are replicated and sent
	// to the home Region.
	FindingAggregationRegion *string

	// The ARN of the finding aggregator.
	FindingAggregatorArn *string

	// Indicates whether to link all Regions, all Regions except for a list of
	// excluded Regions, or a list of included Regions.
	RegionLinkingMode *string

	// The list of excluded Regions or included Regions.
	Regions []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateFindingAggregatorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateFindingAggregator{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateFindingAggregator{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateFindingAggregator"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateFindingAggregatorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateFindingAggregator(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateFindingAggregator(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateFindingAggregator",
	}
}
