// Code generated by smithy-go-codegen DO NOT EDIT.

package geoplaces

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/geoplaces/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// SearchNearby queries for points of interest within a radius from a central
// coordinates, returning place results with optional filters such as categories,
// business chains, food types and more. The API returns details such as a place
// name, address, phone, category, food type, contact, opening hours. Also, the API
// can return phonemes, time zones and more based on requested parameters.
func (c *Client) SearchNearby(ctx context.Context, params *SearchNearbyInput, optFns ...func(*Options)) (*SearchNearbyOutput, error) {
	if params == nil {
		params = &SearchNearbyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchNearby", params, optFns, c.addOperationSearchNearbyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchNearbyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchNearbyInput struct {

	// The position, in [lng, lat] for which you are querying nearby results for.
	// Results closer to the position will be ranked higher then results further away
	// from the position
	//
	// This member is required.
	QueryPosition []float64

	// A list of optional additional parameters, such as time zone, that can be
	// requested for each result.
	AdditionalFeatures []types.SearchNearbyAdditionalFeature

	// A structure which contains a set of inclusion/exclusion properties that results
	// must possess in order to be returned as a result.
	Filter *types.SearchNearbyFilter

	// Indicates if the results will be stored. Defaults to SingleUse , if left empty.
	//
	// Storing the response of an SearchNearby query is required to comply with
	// service terms, but charged at a higher cost per request. Please review the [user agreement]and [service pricing structure]
	// to determine the correct setting for your use case.
	//
	// [service pricing structure]: https://aws.amazon.com/location/pricing/
	// [user agreement]: https://aws.amazon.com/location/sla/
	IntendedUse types.SearchNearbyIntendedUse

	// Optional: The API key to be used for authorization. Either an API key or valid
	// SigV4 signature must be provided when making a request.
	Key *string

	// A list of [BCP 47] compliant language codes for the results to be rendered in. If there
	// is no data for the result in the requested language, data will be returned in
	// the default language for the entry.
	//
	// [BCP 47]: https://en.wikipedia.org/wiki/IETF_language_tag
	Language *string

	// An optional limit for the number of results returned in a single call.
	MaxResults *int32

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page.
	NextToken *string

	// The alpha-2 or alpha-3 character code for the political view of a country. The
	// political view applies to the results of the request to represent unresolved
	// territorial claims through the point of view of the specified country.
	PoliticalView *string

	// The maximum distance in meters from the QueryPosition from which a result will
	// be returned.
	//
	// The fields QueryText , and QueryID are mutually exclusive.
	QueryRadius *int64

	noSmithyDocumentSerde
}

type SearchNearbyOutput struct {

	// The pricing bucket for which the query is charged at.
	//
	// For more information on pricing, please visit [Amazon Location Service Pricing].
	//
	// [Amazon Location Service Pricing]: https://aws.amazon.com/location/pricing/
	//
	// This member is required.
	PricingBucket *string

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page.
	NextToken *string

	// List of places or results returned for a query.
	ResultItems []types.SearchNearbyResultItem

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchNearbyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchNearby{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchNearby{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchNearby"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchNearbyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchNearby(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSearchNearby(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchNearby",
	}
}
