// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A data type pair that consists of a KeyName and Values list that is used in
// conjunction with the [KeyName]and [Values] parameters to search for profiles using the [SearchProfiles] API.
//
// [KeyName]: https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html#customerprofiles-SearchProfiles-request-KeyName
// [SearchProfiles]: https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html
// [Values]: https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html#customerprofiles-SearchProfiles-request-Values
type AdditionalSearchKey struct {

	// A searchable identifier of a customer profile.
	//
	// This member is required.
	KeyName *string

	// A list of key values.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// A generic address associated with the customer that is not mailing, shipping,
// or billing.
type Address struct {

	// The first line of a customer address.
	Address1 *string

	// The second line of a customer address.
	Address2 *string

	// The third line of a customer address.
	Address3 *string

	// The fourth line of a customer address.
	Address4 *string

	// The city in which a customer lives.
	City *string

	// The country in which a customer lives.
	Country *string

	// The county in which a customer lives.
	County *string

	// The postal code of a customer address.
	PostalCode *string

	// The province in which a customer lives.
	Province *string

	// The state in which a customer lives.
	State *string

	noSmithyDocumentSerde
}

// Object that segments on Customer Profile's address object.
type AddressDimension struct {

	// The city belonging to the address.
	City *ProfileDimension

	// The country belonging to the address.
	Country *ProfileDimension

	// The county belonging to the address.
	County *ProfileDimension

	// The postal code belonging to the address.
	PostalCode *ProfileDimension

	// The province belonging to the address.
	Province *ProfileDimension

	// The state belonging to the address.
	State *ProfileDimension

	noSmithyDocumentSerde
}

// Details for workflow of type APPFLOW_INTEGRATION .
type AppflowIntegration struct {

	// The configurations that control how Customer Profiles retrieves data from the
	// source, Amazon AppFlow. Customer Profiles uses this information to create an
	// AppFlow flow on behalf of customers.
	//
	// This member is required.
	FlowDefinition *FlowDefinition

	// Batches in workflow of type APPFLOW_INTEGRATION .
	Batches []Batch

	noSmithyDocumentSerde
}

// Structure holding all APPFLOW_INTEGRATION specific workflow attributes.
type AppflowIntegrationWorkflowAttributes struct {

	// The name of the AppFlow connector profile used for ingestion.
	//
	// This member is required.
	ConnectorProfileName *string

	// Specifies the source connector type, such as Salesforce, ServiceNow, and
	// Marketo. Indicates source of ingestion.
	//
	// This member is required.
	SourceConnectorType SourceConnectorType

	// The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this
	// role to create resources on your behalf as part of workflow execution.
	RoleArn *string

	noSmithyDocumentSerde
}

// Workflow specific execution metrics for APPFLOW_INTEGRATION workflow.
type AppflowIntegrationWorkflowMetrics struct {

	// Number of records processed in APPFLOW_INTEGRATION workflow.
	//
	// This member is required.
	RecordsProcessed int64

	// Total steps completed in APPFLOW_INTEGRATION workflow.
	//
	// This member is required.
	StepsCompleted int64

	// Total steps in APPFLOW_INTEGRATION workflow.
	//
	// This member is required.
	TotalSteps int64

	noSmithyDocumentSerde
}

// Workflow step details for APPFLOW_INTEGRATION workflow.
type AppflowIntegrationWorkflowStep struct {

	// End datetime of records pulled in batch during execution of workflow step for
	// APPFLOW_INTEGRATION workflow.
	//
	// This member is required.
	BatchRecordsEndTime *string

	// Start datetime of records pulled in batch during execution of workflow step for
	// APPFLOW_INTEGRATION workflow.
	//
	// This member is required.
	BatchRecordsStartTime *string

	// Creation timestamp of workflow step for APPFLOW_INTEGRATION workflow.
	//
	// This member is required.
	CreatedAt *time.Time

	// Message indicating execution of workflow step for APPFLOW_INTEGRATION workflow.
	//
	// This member is required.
	ExecutionMessage *string

	// Name of the flow created during execution of workflow step. APPFLOW_INTEGRATION
	// workflow type creates an appflow flow during workflow step execution on the
	// customers behalf.
	//
	// This member is required.
	FlowName *string

	// Last updated timestamp for workflow step for APPFLOW_INTEGRATION workflow.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// Total number of records processed during execution of workflow step for
	// APPFLOW_INTEGRATION workflow.
	//
	// This member is required.
	RecordsProcessed int64

	// Workflow step status for APPFLOW_INTEGRATION workflow.
	//
	// This member is required.
	Status Status

	noSmithyDocumentSerde
}

// Mathematical expression and a list of attribute items specified in that
// expression.
type AttributeDetails struct {

	// A list of attribute items specified in the mathematical expression.
	//
	// This member is required.
	Attributes []AttributeItem

	// Mathematical expression that is performed on attribute items provided in the
	// attribute list. Each element in the expression should follow the structure of
	// \"{ObjectTypeName.AttributeName}\".
	//
	// This member is required.
	Expression *string

	noSmithyDocumentSerde
}

// Object that segments on various Customer Profile's fields.
type AttributeDimension struct {

	// The action to segment with.
	//
	// This member is required.
	DimensionType AttributeDimensionType

	// The values to apply the DimensionType on.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The details of a single attribute item specified in the mathematical expression.
type AttributeItem struct {

	// The name of an attribute defined in a profile object type.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Configuration information about the AttributeTypesSelector where the rule-based
// identity resolution uses to match profiles. You can choose how profiles are
// compared across attribute types and which attribute to use for matching from
// each type. There are three attribute types you can configure:
//
//   - Email type
//
//   - You can choose from Email , BusinessEmail , and PersonalEmail
//
//   - Phone number type
//
//   - You can choose from Phone , HomePhone , and MobilePhone
//
//   - Address type
//
//   - You can choose from Address , BusinessAddress , MaillingAddress , and
//     ShippingAddress
//
// You can either choose ONE_TO_ONE or MANY_TO_MANY as the AttributeMatchingModel .
// When choosing MANY_TO_MANY , the system can match attribute across the sub-types
// of an attribute type. For example, if the value of the Email field of Profile A
// and the value of BusinessEmail field of Profile B matches, the two profiles are
// matched on the Email type. When choosing ONE_TO_ONE the system can only match
// if the sub-types are exact matches. For example, only when the value of the
// Email field of Profile A and the value of the Email field of Profile B matches,
// the two profiles are matched on the Email type.
type AttributeTypesSelector struct {

	// Configures the AttributeMatchingModel , you can either choose ONE_TO_ONE or
	// MANY_TO_MANY .
	//
	// This member is required.
	AttributeMatchingModel AttributeMatchingModel

	// The Address type. You can choose from Address , BusinessAddress ,
	// MaillingAddress , and ShippingAddress .
	//
	// You only can use the Address type in the MatchingRule . For example, if you want
	// to match profile based on BusinessAddress.City or MaillingAddress.City , you
	// need to choose the BusinessAddress and the MaillingAddress to represent the
	// Address type and specify the Address.City on the matching rule.
	Address []string

	// The Email type. You can choose from EmailAddress , BusinessEmailAddress and
	// PersonalEmailAddress .
	//
	// You only can use the EmailAddress type in the MatchingRule . For example, if you
	// want to match profile based on PersonalEmailAddress or BusinessEmailAddress ,
	// you need to choose the PersonalEmailAddress and the BusinessEmailAddress to
	// represent the EmailAddress type and only specify the EmailAddress on the
	// matching rule.
	EmailAddress []string

	// The PhoneNumber type. You can choose from PhoneNumber , HomePhoneNumber , and
	// MobilePhoneNumber .
	//
	// You only can use the PhoneNumber type in the MatchingRule . For example, if you
	// want to match a profile based on Phone or HomePhone , you need to choose the
	// Phone and the HomePhone to represent the PhoneNumber type and only specify the
	// PhoneNumber on the matching rule.
	PhoneNumber []string

	noSmithyDocumentSerde
}

// List containing the values for the given attribute.
type AttributeValueItem struct {

	// An individual value belonging to the given attribute.
	Value *string

	noSmithyDocumentSerde
}

// Configuration settings for how to perform the auto-merging of profiles.
type AutoMerging struct {

	// The flag that enables the auto-merging of duplicate profiles.
	//
	// This member is required.
	Enabled *bool

	// How the auto-merging process should resolve conflicts between different
	// profiles. For example, if Profile A and Profile B have the same FirstName and
	// LastName (and that is the matching criteria), which EmailAddress should be
	// used?
	ConflictResolution *ConflictResolution

	// A list of matching attributes that represent matching criteria. If two profiles
	// meet at least one of the requirements in the matching attributes list, they will
	// be merged.
	Consolidation *Consolidation

	// A number between 0 and 1 that represents the minimum confidence score required
	// for profiles within a matching group to be merged during the auto-merge process.
	// A higher score means higher similarity required to merge profiles.
	MinAllowedConfidenceScoreForMerging *float64

	noSmithyDocumentSerde
}

// Batch defines the boundaries for ingestion for each step in APPFLOW_INTEGRATION
// workflow. APPFLOW_INTEGRATION workflow splits ingestion based on these
// boundaries.
type Batch struct {

	// End time of batch to split ingestion.
	//
	// This member is required.
	EndTime *time.Time

	// Start time of batch to split ingestion.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Error object describing why a specific profile and calculated attribute failed.
type BatchGetCalculatedAttributeForProfileError struct {

	// Status code for why a specific profile and calculated attribute failed.
	//
	// This member is required.
	Code *string

	// Message describing why a specific profile and calculated attribute failed.
	//
	// This member is required.
	Message *string

	// The profile id that failed.
	//
	// This member is required.
	ProfileId *string

	noSmithyDocumentSerde
}

// Error object describing why a specific profile failed.
type BatchGetProfileError struct {

	// Status code for why a specific profile failed.
	//
	// This member is required.
	Code *string

	// Message describing why a specific profile failed.
	//
	// This member is required.
	Message *string

	// The profile id that failed.
	//
	// This member is required.
	ProfileId *string

	noSmithyDocumentSerde
}

// Object that segments on Customer Profile's Calculated Attributes.
type CalculatedAttributeDimension struct {

	// The action to segment with.
	//
	// This member is required.
	DimensionType AttributeDimensionType

	// The values to apply the DimensionType with.
	//
	// This member is required.
	Values []string

	// Applies the given condition over the initial Calculated Attribute's definition.
	ConditionOverrides *ConditionOverrides

	noSmithyDocumentSerde
}

// The object containing the values of a single calculated attribute value.
type CalculatedAttributeValue struct {

	// The unique name of the calculated attribute.
	CalculatedAttributeName *string

	// The display name of the calculated attribute.
	DisplayName *string

	// Indicates whether the calculated attribute's value is based on partial data. If
	// the data is partial, it is set to true.
	IsDataPartial *string

	// The timestamp of the newest object included in the calculated attribute
	// calculation.
	LastObjectTimestamp *time.Time

	// The profile id belonging to this calculated attribute value.
	ProfileId *string

	// The value of the calculated attribute.
	Value *string

	noSmithyDocumentSerde
}

// An object to override the original condition block of a calculated attribute.
type ConditionOverrides struct {

	// The relative time period over which data is included in the aggregation for
	// this override.
	Range *RangeOverride

	noSmithyDocumentSerde
}

// The conditions including range, object count, and threshold for the calculated
// attribute.
type Conditions struct {

	// The number of profile objects used for the calculated attribute.
	ObjectCount *int32

	// The relative time period over which data is included in the aggregation.
	Range *Range

	// The threshold for the calculated attribute.
	Threshold *Threshold

	noSmithyDocumentSerde
}

// How the auto-merging process should resolve conflicts between different
// profiles.
type ConflictResolution struct {

	// How the auto-merging process should resolve conflicts between different
	// profiles.
	//
	//   - RECENCY : Uses the data that was most recently updated.
	//
	//   - SOURCE : Uses the data from a specific source. For example, if a company has
	//   been aquired or two departments have merged, data from the specified source is
	//   used. If two duplicate profiles are from the same source, then RECENCY is used
	//   again.
	//
	// This member is required.
	ConflictResolvingModel ConflictResolvingModel

	// The ObjectType name that is used to resolve profile merging conflicts when
	// choosing SOURCE as the ConflictResolvingModel .
	SourceName *string

	noSmithyDocumentSerde
}

// The operation to be performed on the provided source fields.
type ConnectorOperator struct {

	// The operation to be performed on the provided Marketo source fields.
	Marketo MarketoConnectorOperator

	// The operation to be performed on the provided Amazon S3 source fields.
	S3 S3ConnectorOperator

	// The operation to be performed on the provided Salesforce source fields.
	Salesforce SalesforceConnectorOperator

	// The operation to be performed on the provided ServiceNow source fields.
	ServiceNow ServiceNowConnectorOperator

	// The operation to be performed on the provided Zendesk source fields.
	Zendesk ZendeskConnectorOperator

	noSmithyDocumentSerde
}

// The matching criteria to be used during the auto-merging process.
type Consolidation struct {

	// A list of matching criteria.
	//
	// This member is required.
	MatchingAttributesList [][]string

	noSmithyDocumentSerde
}

// Object that defines users contact preference.
type ContactPreference struct {

	// The contact type used for engagement. For example: HomePhoneNumber,
	// PersonalEmailAddress.
	ContactType ContactType

	// A searchable, unique identifier of a customer profile.
	KeyName *string

	// The key value used to look up profile based off the keyName.
	KeyValue *string

	// The unique identifier of a customer profile.
	ProfileId *string

	noSmithyDocumentSerde
}

// Object that segments on various Customer Profile's date fields.
type DateDimension struct {

	// The action to segment with.
	//
	// This member is required.
	DimensionType DateDimensionType

	// The values to apply the DimensionType on.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Summary information about the Kinesis data stream
type DestinationSummary struct {

	// The status of enabling the Kinesis stream as a destination for export.
	//
	// This member is required.
	Status EventStreamDestinationStatus

	// The StreamARN of the destination to deliver profile events to. For example,
	// arn:aws:kinesis:region:account-id:stream/stream-name.
	//
	// This member is required.
	Uri *string

	// The timestamp when the status last changed to UNHEALHY .
	UnhealthySince *time.Time

	noSmithyDocumentSerde
}

// Contains ProfileObjectType mapping information from the model.
type DetectedProfileObjectType struct {

	// A map of the name and the ObjectType field.
	Fields map[string]ObjectTypeField

	// A list of unique keys that can be used to map data to a profile.
	Keys map[string][]ObjectTypeKey

	// The format of sourceLastUpdatedTimestamp that was detected in fields.
	SourceLastUpdatedTimestampFormat *string

	noSmithyDocumentSerde
}

// Object that holds what profile and calculated attributes to segment on.
//
// The following types satisfy this interface:
//
//	DimensionMemberCalculatedAttributes
//	DimensionMemberProfileAttributes
type Dimension interface {
	isDimension()
}

// Object that holds the calculated attributes to segment on.
type DimensionMemberCalculatedAttributes struct {
	Value map[string]CalculatedAttributeDimension

	noSmithyDocumentSerde
}

func (*DimensionMemberCalculatedAttributes) isDimension() {}

// Object that holds the profile attributes to segment on.
type DimensionMemberProfileAttributes struct {
	Value ProfileAttributes

	noSmithyDocumentSerde
}

func (*DimensionMemberProfileAttributes) isDimension() {}

// Usage-specific statistics about the domain.
type DomainStats struct {

	// The number of profiles that you are currently paying for in the domain. If you
	// have more than 100 objects associated with a single profile, that profile counts
	// as two profiles. If you have more than 200 objects, that profile counts as
	// three, and so on.
	MeteringProfileCount int64

	// The total number of objects in domain.
	ObjectCount int64

	// The total number of profiles currently in the domain.
	ProfileCount int64

	// The total size, in bytes, of all objects in the domain.
	TotalSize int64

	noSmithyDocumentSerde
}

// Object that defines users preferred methods of engagement.
type EngagementPreferences struct {

	// A list of email-related contact preferences
	Email []ContactPreference

	// A list of phone-related contact preferences
	Phone []ContactPreference

	noSmithyDocumentSerde
}

// Details of the destination being used for the EventStream.
type EventStreamDestinationDetails struct {

	// The status of enabling the Kinesis stream as a destination for export.
	//
	// This member is required.
	Status EventStreamDestinationStatus

	// The StreamARN of the destination to deliver profile events to. For example,
	// arn:aws:kinesis:region:account-id:stream/stream-name.
	//
	// This member is required.
	Uri *string

	// The human-readable string that corresponds to the error or success while
	// enabling the streaming destination.
	Message *string

	// The timestamp when the status last changed to UNHEALHY .
	UnhealthySince *time.Time

	noSmithyDocumentSerde
}

// An instance of EventStream in a list of EventStreams.
type EventStreamSummary struct {

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// A unique identifier for the event stream.
	//
	// This member is required.
	EventStreamArn *string

	// The name of the event stream.
	//
	// This member is required.
	EventStreamName *string

	// The operational state of destination stream for export.
	//
	// This member is required.
	State EventStreamState

	// Summary information about the Kinesis data stream.
	DestinationSummary *DestinationSummary

	// The timestamp when the State changed to STOPPED .
	StoppedSince *time.Time

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Specifies the circumstances under which the event should trigger the
// destination.
type EventTriggerCondition struct {

	// A list of dimensions to be evaluated for the event.
	//
	// This member is required.
	EventTriggerDimensions []EventTriggerDimension

	// The operator used to combine multiple dimensions.
	//
	// This member is required.
	LogicalOperator EventTriggerLogicalOperator

	noSmithyDocumentSerde
}

// A specific event dimension to be assessed.
type EventTriggerDimension struct {

	// A list of object attributes to be evaluated.
	//
	// This member is required.
	ObjectAttributes []ObjectAttribute

	noSmithyDocumentSerde
}

// Defines limits controlling whether an event triggers the destination, based on
// ingestion latency and the number of invocations per profile over specific time
// periods.
type EventTriggerLimits struct {

	// In milliseconds. Specifies that an event will only trigger the destination if
	// it is processed within a certain latency period.
	EventExpiration *int64

	// A list of time periods during which the limits apply.
	Periods []Period

	noSmithyDocumentSerde
}

// The summary of the event trigger.
type EventTriggerSummaryItem struct {

	// The timestamp of when the event trigger was created.
	CreatedAt *time.Time

	// The description of the event trigger.
	Description *string

	// The unique name of the event trigger.
	EventTriggerName *string

	// The timestamp of when the event trigger was most recently updated.
	LastUpdatedAt *time.Time

	// The unique name of the object type.
	ObjectTypeName *string

	// An array of key-value pairs to apply to this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Configuration information about the S3 bucket where Identity Resolution Jobs
// writes result files.
//
// You need to give Customer Profiles service principal write permission to your
// S3 bucket. Otherwise, you'll get an exception in the API response. For an
// example policy, see [Amazon Connect Customer Profiles cross-service confused deputy prevention].
//
// [Amazon Connect Customer Profiles cross-service confused deputy prevention]: https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html#customer-profiles-cross-service
type ExportingConfig struct {

	// The S3 location where Identity Resolution Jobs write result files.
	S3Exporting *S3ExportingConfig

	noSmithyDocumentSerde
}

// The S3 location where Identity Resolution Jobs write result files.
type ExportingLocation struct {

	// Information about the S3 location where Identity Resolution Jobs write result
	// files.
	S3Exporting *S3ExportingLocation

	noSmithyDocumentSerde
}

// Object that segments on various Customer profile's fields that are larger than
// normal.
type ExtraLengthValueProfileDimension struct {

	// The action to segment with.
	//
	// This member is required.
	DimensionType StringDimensionType

	// The values to apply the DimensionType on.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// A duplicate customer profile that is to be merged into a main profile.
type FieldSourceProfileIds struct {

	// A unique identifier for the account number field to be merged.
	AccountNumber *string

	// A unique identifier for the additional information field to be merged.
	AdditionalInformation *string

	// A unique identifier for the party type field to be merged.
	Address *string

	// A unique identifier for the attributes field to be merged.
	Attributes map[string]string

	// A unique identifier for the billing type field to be merged.
	BillingAddress *string

	// A unique identifier for the birthdate field to be merged.
	BirthDate *string

	// A unique identifier for the party type field to be merged.
	BusinessEmailAddress *string

	// A unique identifier for the business name field to be merged.
	BusinessName *string

	// A unique identifier for the business phone number field to be merged.
	BusinessPhoneNumber *string

	// A unique identifier for the email address field to be merged.
	EmailAddress *string

	// A unique identifier for the engagement preferences field to be merged.
	EngagementPreferences *string

	// A unique identifier for the first name field to be merged.
	FirstName *string

	// A unique identifier for the gender field to be merged.
	Gender *string

	// A unique identifier for the home phone number field to be merged.
	HomePhoneNumber *string

	// A unique identifier for the last name field to be merged.
	LastName *string

	// A unique identifier for the mailing address field to be merged.
	MailingAddress *string

	// A unique identifier for the middle name field to be merged.
	MiddleName *string

	// A unique identifier for the mobile phone number field to be merged.
	MobilePhoneNumber *string

	// A unique identifier for the party type field to be merged.
	PartyType *string

	// A unique identifier for the personal email address field to be merged.
	PersonalEmailAddress *string

	// A unique identifier for the phone number field to be merged.
	PhoneNumber *string

	// A unique identifier for the profile type field to be merged.
	ProfileType *string

	// A unique identifier for the shipping address field to be merged.
	ShippingAddress *string

	noSmithyDocumentSerde
}

// Defines how to filter the objects coming in for calculated attributes.
type Filter struct {

	// Holds the list of Filter groups within the Filter definition.
	//
	// This member is required.
	Groups []FilterGroup

	// Define whether to include or exclude objects for Calculated Attributed
	// calculation that fit the filter groups criteria.
	//
	// This member is required.
	Include Include

	noSmithyDocumentSerde
}

// Object that defines how to filter the incoming objects for the calculated
// attribute.
type FilterAttributeDimension struct {

	// The action to filter with.
	//
	// This member is required.
	DimensionType FilterDimensionType

	// The values to apply the DimensionType on.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Contains the map of attribute names to attribute dimensions.
type FilterDimension struct {

	// Is the attribute within the FilterDimension map
	//
	// This member is required.
	Attributes map[string]FilterAttributeDimension

	noSmithyDocumentSerde
}

// Object that holds the dimensions to filter on.
type FilterGroup struct {

	// Object that holds the attributes to filter on.
	//
	// This member is required.
	Dimensions []FilterDimension

	// The type of logical relationship between the dimensions of the Filter group.
	//
	// This member is required.
	Type Type

	noSmithyDocumentSerde
}

// The configurations that control how Customer Profiles retrieves data from the
// source, Amazon AppFlow. Customer Profiles uses this information to create an
// AppFlow flow on behalf of customers.
type FlowDefinition struct {

	// The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces
	// are not allowed.
	//
	// This member is required.
	FlowName *string

	// The Amazon Resource Name of the AWS Key Management Service (KMS) key you
	// provide for encryption.
	//
	// This member is required.
	KmsArn *string

	// The configuration that controls how Customer Profiles retrieves data from the
	// source.
	//
	// This member is required.
	SourceFlowConfig *SourceFlowConfig

	// A list of tasks that Customer Profiles performs while transferring the data in
	// the flow run.
	//
	// This member is required.
	Tasks []Task

	// The trigger settings that determine how and when the flow runs.
	//
	// This member is required.
	TriggerConfig *TriggerConfig

	// A description of the flow you want to create.
	Description *string

	noSmithyDocumentSerde
}

// A data type pair that consists of a KeyName and Values list that were used to
// find a profile returned in response to a [SearchProfiles]request.
//
// [SearchProfiles]: https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html
type FoundByKeyValue struct {

	// A searchable identifier of a customer profile.
	KeyName *string

	// A list of key values.
	Values []string

	noSmithyDocumentSerde
}

// Contains dimensions that determine what to segment on.
type Group struct {

	// Defines the attributes to segment on.
	Dimensions []Dimension

	// Defines the starting source of data.
	SourceSegments []SourceSegment

	// Defines how to interact with the source data.
	SourceType IncludeOptions

	// Defines how to interact with the profiles found in the current filtering.
	Type IncludeOptions

	noSmithyDocumentSerde
}

// Information about the Identity Resolution Job.
type IdentityResolutionJob struct {

	// The unique name of the domain.
	DomainName *string

	// The S3 location where the Identity Resolution Job writes result files.
	ExportingLocation *ExportingLocation

	// The timestamp of when the job was completed.
	JobEndTime *time.Time

	// The unique identifier of the Identity Resolution Job.
	JobId *string

	// The timestamp of when the job was started or will be started.
	JobStartTime *time.Time

	// Statistics about an Identity Resolution Job.
	JobStats *JobStats

	// The error messages that are generated when the Identity Resolution Job runs.
	Message *string

	// The status of the Identity Resolution Job.
	//
	//   - PENDING : The Identity Resolution Job is scheduled but has not started yet.
	//   If you turn off the Identity Resolution feature in your domain, jobs in the
	//   PENDING state are deleted.
	//
	//   - PREPROCESSING : The Identity Resolution Job is loading your data.
	//
	//   - FIND_MATCHING : The Identity Resolution Job is using the machine learning
	//   model to identify profiles that belong to the same matching group.
	//
	//   - MERGING : The Identity Resolution Job is merging duplicate profiles.
	//
	//   - COMPLETED : The Identity Resolution Job completed successfully.
	//
	//   - PARTIAL_SUCCESS : There's a system error and not all of the data is merged.
	//   The Identity Resolution Job writes a message indicating the source of the
	//   problem.
	//
	//   - FAILED : The Identity Resolution Job did not merge any data. It writes a
	//   message indicating the source of the problem.
	Status IdentityResolutionJobStatus

	noSmithyDocumentSerde
}

// Specifies the configuration used when importing incremental records from the
// source.
type IncrementalPullConfig struct {

	// A field that specifies the date time or timestamp field as the criteria to use
	// when importing incremental records from the source.
	DatetimeTypeFieldName *string

	noSmithyDocumentSerde
}

// Configuration data for integration workflow.
type IntegrationConfig struct {

	// Configuration data for APPFLOW_INTEGRATION workflow type.
	AppflowIntegration *AppflowIntegration

	noSmithyDocumentSerde
}

// The day and time when do you want to start the Identity Resolution Job every
// week.
type JobSchedule struct {

	// The day when the Identity Resolution Job should run every week.
	//
	// This member is required.
	DayOfTheWeek JobScheduleDayOfTheWeek

	// The time when the Identity Resolution Job should run every week.
	//
	// This member is required.
	Time *string

	noSmithyDocumentSerde
}

// Statistics about the Identity Resolution Job.
type JobStats struct {

	// The number of matches found.
	NumberOfMatchesFound int64

	// The number of merges completed.
	NumberOfMergesDone int64

	// The number of profiles reviewed.
	NumberOfProfilesReviewed int64

	noSmithyDocumentSerde
}

// The layout object that contains LayoutDefinitionName, Description, DisplayName,
// IsDefault, LayoutType, Tags, CreatedAt, LastUpdatedAt
type LayoutItem struct {

	// The timestamp of when the layout was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The description of the layout
	//
	// This member is required.
	Description *string

	// The display name of the layout
	//
	// This member is required.
	DisplayName *string

	// The timestamp of when the layout was most recently updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The unique name of the layout.
	//
	// This member is required.
	LayoutDefinitionName *string

	// The type of layout that can be used to view data under customer profiles domain.
	//
	// This member is required.
	LayoutType LayoutType

	// If set to true for a layout, this layout will be used by default to view data.
	// If set to false, then layout will not be used by default but it can be used to
	// view data by explicit selection on UI.
	IsDefault bool

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The details of a single calculated attribute definition.
type ListCalculatedAttributeDefinitionItem struct {

	// The unique name of the calculated attribute.
	CalculatedAttributeName *string

	// The threshold for the calculated attribute.
	CreatedAt *time.Time

	// The threshold for the calculated attribute.
	Description *string

	// The display name of the calculated attribute.
	DisplayName *string

	// The timestamp of when the calculated attribute definition was most recently
	// edited.
	LastUpdatedAt *time.Time

	// Status of the Calculated Attribute creation (whether all historical data has
	// been indexed.)
	Status ReadinessStatus

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	// Whether historical data ingested before the Calculated Attribute was created
	// should be included in calculations.
	UseHistoricalData *bool

	noSmithyDocumentSerde
}

// The details of a single calculated attribute for a profile.
type ListCalculatedAttributeForProfileItem struct {

	// The unique name of the calculated attribute.
	CalculatedAttributeName *string

	// The display name of the calculated attribute.
	DisplayName *string

	// Indicates whether the calculated attribute’s value is based on partial data. If
	// data is partial, it is set to true.
	IsDataPartial *string

	// The timestamp of the newest object included in the calculated attribute
	// calculation.
	LastObjectTimestamp *time.Time

	// The value of the calculated attribute.
	Value *string

	noSmithyDocumentSerde
}

// An object in a list that represents a domain.
type ListDomainItem struct {

	// The timestamp of when the domain was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The timestamp of when the domain was most recently edited.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// An integration in list of integrations.
type ListIntegrationItem struct {

	// The timestamp of when the domain was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// The timestamp of when the domain was most recently edited.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The URI of the S3 bucket or any other type of data source.
	//
	// This member is required.
	Uri *string

	// A list of unique names for active event triggers associated with the
	// integration.
	EventTriggerNames []string

	// Boolean that shows if the Flow that's associated with the Integration is
	// created in Amazon Appflow, or with ObjectTypeName equals _unstructured via
	// API/CLI in flowDefinition.
	IsUnstructured *bool

	// The name of the profile object type.
	ObjectTypeName *string

	// A map in which each key is an event type from an external application such as
	// Segment or Shopify, and each value is an ObjectTypeName (template) used to
	// ingest the event. It supports the following event types: SegmentIdentify ,
	// ShopifyCreateCustomers , ShopifyUpdateCustomers , ShopifyCreateDraftOrders ,
	// ShopifyUpdateDraftOrders , ShopifyCreateOrders , and ShopifyUpdatedOrders .
	ObjectTypeNames map[string]string

	// The Amazon Resource Name (ARN) of the IAM role. The Integration uses this role
	// to make Customer Profiles requests on your behalf.
	RoleArn *string

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	// Unique identifier for the workflow.
	WorkflowId *string

	noSmithyDocumentSerde
}

// Item that contains the attribute and when it was last updated.
type ListObjectTypeAttributeItem struct {

	// Name of the attribute.
	//
	// This member is required.
	AttributeName *string

	// When the attribute was last updated.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	noSmithyDocumentSerde
}

// A ProfileObject in a list of ProfileObjects.
type ListProfileObjectsItem struct {

	// A JSON representation of a ProfileObject that belongs to a profile.
	Object *string

	// Specifies the kind of object being added to a profile, such as
	// "Salesforce-Account."
	ObjectTypeName *string

	// The unique identifier of the ProfileObject generated by the service.
	ProfileObjectUniqueKey *string

	noSmithyDocumentSerde
}

// A ProfileObjectType instance.
type ListProfileObjectTypeItem struct {

	// Description of the profile object type.
	//
	// This member is required.
	Description *string

	// The name of the profile object type.
	//
	// This member is required.
	ObjectTypeName *string

	// The timestamp of when the domain was created.
	CreatedAt *time.Time

	// The timestamp of when the domain was most recently edited.
	LastUpdatedAt *time.Time

	// The amount of provisioned profile object max count available.
	MaxAvailableProfileObjectCount *int32

	// The amount of profile object max count assigned to the object type.
	MaxProfileObjectCount *int32

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// A ProfileObjectTypeTemplate in a list of ProfileObjectTypeTemplates.
type ListProfileObjectTypeTemplateItem struct {

	// The name of the source of the object template.
	SourceName *string

	// The source of the object template.
	SourceObject *string

	// A unique identifier for the object template.
	TemplateId *string

	noSmithyDocumentSerde
}

// A workflow in list of workflows.
type ListWorkflowsItem struct {

	// Creation timestamp for workflow.
	//
	// This member is required.
	CreatedAt *time.Time

	// Last updated timestamp for workflow.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// Status of workflow execution.
	//
	// This member is required.
	Status Status

	// Description for workflow execution status.
	//
	// This member is required.
	StatusDescription *string

	// Unique identifier for the workflow.
	//
	// This member is required.
	WorkflowId *string

	// The type of workflow. The only supported value is APPFLOW_INTEGRATION.
	//
	// This member is required.
	WorkflowType WorkflowType

	noSmithyDocumentSerde
}

// The properties that are applied when Marketo is being used as a source.
type MarketoSourceProperties struct {

	// The object specified in the Marketo flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// The flag that enables the matching process of duplicate profiles.
type MatchingRequest struct {

	// The flag that enables the matching process of duplicate profiles.
	//
	// This member is required.
	Enabled *bool

	// Configuration information about the auto-merging process.
	AutoMerging *AutoMerging

	// Configuration information for exporting Identity Resolution results, for
	// example, to an S3 bucket.
	ExportingConfig *ExportingConfig

	// The day and time when do you want to start the Identity Resolution Job every
	// week.
	JobSchedule *JobSchedule

	noSmithyDocumentSerde
}

// The flag that enables the matching process of duplicate profiles.
type MatchingResponse struct {

	// Configuration information about the auto-merging process.
	AutoMerging *AutoMerging

	// The flag that enables the matching process of duplicate profiles.
	Enabled *bool

	// Configuration information for exporting Identity Resolution results, for
	// example, to an S3 bucket.
	ExportingConfig *ExportingConfig

	// The day and time when do you want to start the Identity Resolution Job every
	// week.
	JobSchedule *JobSchedule

	noSmithyDocumentSerde
}

// Specifies how does the rule-based matching process should match profiles. You
// can choose from the following attributes to build the matching Rule:
//
//   - AccountNumber
//
//   - Address.Address
//
//   - Address.City
//
//   - Address.Country
//
//   - Address.County
//
//   - Address.PostalCode
//
//   - Address.State
//
//   - Address.Province
//
//   - BirthDate
//
//   - BusinessName
//
//   - EmailAddress
//
//   - FirstName
//
//   - Gender
//
//   - LastName
//
//   - MiddleName
//
//   - PhoneNumber
//
//   - Any customized profile attributes that start with the Attributes
type MatchingRule struct {

	// A single rule level of the MatchRules . Configures how the rule-based matching
	// process should match profiles.
	//
	// This member is required.
	Rule []string

	noSmithyDocumentSerde
}

// The Match group object.
type MatchItem struct {

	// A number between 0 and 1, where a higher score means higher similarity.
	// Examining match confidence scores lets you distinguish between groups of similar
	// records in which the system is highly confident (which you may decide to merge),
	// groups of similar records about which the system is uncertain (which you may
	// decide to have reviewed by a human), and groups of similar records that the
	// system deems to be unlikely (which you may decide to reject). Given confidence
	// scores vary as per the data input, it should not be used an absolute measure of
	// matching quality.
	ConfidenceScore *float64

	// The unique identifiers for this group of profiles that match.
	MatchId *string

	// A list of identifiers for profiles that match.
	ProfileIds []string

	noSmithyDocumentSerde
}

// The criteria that a specific object attribute must meet to trigger the
// destination.
type ObjectAttribute struct {

	// The operator used to compare an attribute against a list of values.
	//
	// This member is required.
	ComparisonOperator ComparisonOperator

	// A list of attribute values used for comparison.
	//
	// This member is required.
	Values []string

	// A field defined within an object type.
	FieldName *string

	// An attribute contained within a source object.
	Source *string

	noSmithyDocumentSerde
}

// The filter applied to ListProfileObjects response to include profile objects
// with the specified index values.
type ObjectFilter struct {

	// A searchable identifier of a profile object. The predefined keys you can use to
	// search for _asset include: _assetId , _assetName , and _serialNumber . The
	// predefined keys you can use to search for _case include: _caseId . The
	// predefined keys you can use to search for _order include: _orderId .
	//
	// This member is required.
	KeyName *string

	// A list of key values.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Represents a field in a ProfileObjectType.
type ObjectTypeField struct {

	// The content type of the field. Used for determining equality when searching.
	ContentType FieldContentType

	// A field of a ProfileObject. For example: _source.FirstName, where “_source” is
	// a ProfileObjectType of a Zendesk user and “FirstName” is a field in that
	// ObjectType.
	Source *string

	// The location of the data in the standard ProfileObject model. For example:
	// _profile.Address.PostalCode.
	Target *string

	noSmithyDocumentSerde
}

// An object that defines the Key element of a ProfileObject. A Key is a special
// element that can be used to search for a customer profile.
type ObjectTypeKey struct {

	// The reference for the key name of the fields map.
	FieldNames []string

	// The types of keys that a ProfileObject can have. Each ProfileObject can have
	// only 1 UNIQUE key but multiple PROFILE keys. PROFILE, ASSET, CASE, or ORDER
	// means that this key can be used to tie an object to a PROFILE, ASSET, CASE, or
	// ORDER respectively. UNIQUE means that it can be used to uniquely identify an
	// object. If a key a is marked as SECONDARY, it will be used to search for
	// profiles after all other PROFILE keys have been searched. A LOOKUP_ONLY key is
	// only used to match a profile but is not persisted to be used for searching of
	// the profile. A NEW_ONLY key is only used if the profile does not already exist
	// before the object is ingested, otherwise it is only used for matching objects to
	// profiles.
	StandardIdentifiers []StandardIdentifier

	noSmithyDocumentSerde
}

// Defines a limit and the time period during which it is enforced.
type Period struct {

	// The unit of time.
	//
	// This member is required.
	Unit PeriodUnit

	// The amount of time of the specified unit.
	//
	// This member is required.
	Value *int32

	// The maximum allowed number of destination invocations per profile.
	MaxInvocationsPerProfile *int32

	// If set to true, there is no limit on the number of destination invocations per
	// profile. The default is false.
	Unlimited bool

	noSmithyDocumentSerde
}

// The standard profile of a customer.
type Profile struct {

	// An account number that you have assigned to the customer.
	AccountNumber *string

	// Any additional information relevant to the customer’s profile.
	AdditionalInformation *string

	// A generic address associated with the customer that is not mailing, shipping,
	// or billing.
	Address *Address

	// A key value pair of attributes of a customer profile.
	Attributes map[string]string

	// The customer’s billing address.
	BillingAddress *Address

	// The customer’s birth date.
	BirthDate *string

	// The customer’s business email address.
	BusinessEmailAddress *string

	// The name of the customer’s business.
	BusinessName *string

	// The customer’s home phone number.
	BusinessPhoneNumber *string

	// The customer’s email address, which has not been specified as a personal or
	// business address.
	EmailAddress *string

	// The customer or account’s engagement preferences.
	EngagementPreferences *EngagementPreferences

	// The customer’s first name.
	FirstName *string

	// A list of items used to find a profile returned in a [SearchProfiles] response. An item is a
	// key-value(s) pair that matches an attribute in the profile.
	//
	// If the optional AdditionalSearchKeys parameter was included in the [SearchProfiles] request,
	// the FoundByItems list should be interpreted based on the LogicalOperator used
	// in the request:
	//
	//   - AND - The profile included in the response matched all of the search keys
	//   specified in the request. The FoundByItems will include all of the
	//   key-value(s) pairs that were specified in the request (as this is a requirement
	//   of AND search logic).
	//
	//   - OR - The profile included in the response matched at least one of the search
	//   keys specified in the request. The FoundByItems will include each of the
	//   key-value(s) pairs that the profile was found by.
	//
	// The OR relationship is the default behavior if the LogicalOperator parameter is
	// not included in the [SearchProfiles]request.
	//
	// [SearchProfiles]: https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_SearchProfiles.html
	FoundByItems []FoundByKeyValue

	// The gender with which the customer identifies.
	//
	// Deprecated: This member has been deprecated.
	Gender Gender

	// An alternative to Gender which accepts any string as input.
	GenderString *string

	// The customer’s home phone number.
	HomePhoneNumber *string

	// The customer’s last name.
	LastName *string

	// The customer’s mailing address.
	MailingAddress *Address

	// The customer’s middle name.
	MiddleName *string

	// The customer’s mobile phone number.
	MobilePhoneNumber *string

	// The type of profile used to describe the customer.
	//
	// Deprecated: This member has been deprecated.
	PartyType PartyType

	// An alternative to PartyType which accepts any string as input.
	PartyTypeString *string

	// The customer’s personal email address.
	PersonalEmailAddress *string

	// The customer's phone number, which has not been specified as a mobile, home, or
	// business number.
	PhoneNumber *string

	// The unique identifier of a customer profile.
	ProfileId *string

	// The type of the profile.
	ProfileType ProfileType

	// The customer’s shipping address.
	ShippingAddress *Address

	noSmithyDocumentSerde
}

// The object used to segment on attributes within the customer profile.
type ProfileAttributes struct {

	// A field to describe values to segment on within account number.
	AccountNumber *ProfileDimension

	// A field to describe values to segment on within additional information.
	AdditionalInformation *ExtraLengthValueProfileDimension

	// A field to describe values to segment on within address.
	Address *AddressDimension

	// A field to describe values to segment on within attributes.
	Attributes map[string]AttributeDimension

	// A field to describe values to segment on within billing address.
	BillingAddress *AddressDimension

	// A field to describe values to segment on within birthDate.
	BirthDate *DateDimension

	// A field to describe values to segment on within business email address.
	BusinessEmailAddress *ProfileDimension

	// A field to describe values to segment on within business name.
	BusinessName *ProfileDimension

	// A field to describe values to segment on within business phone number.
	BusinessPhoneNumber *ProfileDimension

	// A field to describe values to segment on within email address.
	EmailAddress *ProfileDimension

	// A field to describe values to segment on within first name.
	FirstName *ProfileDimension

	// A field to describe values to segment on within genderString.
	GenderString *ProfileDimension

	// A field to describe values to segment on within home phone number.
	HomePhoneNumber *ProfileDimension

	// A field to describe values to segment on within last name.
	LastName *ProfileDimension

	// A field to describe values to segment on within mailing address.
	MailingAddress *AddressDimension

	// A field to describe values to segment on within middle name.
	MiddleName *ProfileDimension

	// A field to describe values to segment on within mobile phone number.
	MobilePhoneNumber *ProfileDimension

	// A field to describe values to segment on within partyTypeString.
	PartyTypeString *ProfileDimension

	// A field to describe values to segment on within personal email address.
	PersonalEmailAddress *ProfileDimension

	// A field to describe values to segment on within phone number.
	PhoneNumber *ProfileDimension

	// A field to describe values to segment on within profile type.
	ProfileType *ProfileTypeDimension

	// A field to describe values to segment on within shipping address.
	ShippingAddress *AddressDimension

	noSmithyDocumentSerde
}

// Object to hold the dimensions of a profile's fields to segment on.
type ProfileDimension struct {

	// The action to segment on.
	//
	// This member is required.
	DimensionType StringDimensionType

	// The values to apply the DimensionType on.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Object that holds failures for membership.
type ProfileQueryFailures struct {

	// A message describing the failure.
	//
	// This member is required.
	Message *string

	// The profile id the failure belongs to.
	//
	// This member is required.
	ProfileId *string

	// The status describing the failure.
	Status *int32

	noSmithyDocumentSerde
}

// Object that holds the results for membership.
type ProfileQueryResult struct {

	// The profile id the result belongs to.
	//
	// This member is required.
	ProfileId *string

	// Describes whether the profile was absent or present in the segment.
	//
	// This member is required.
	QueryResult QueryResult

	// The standard profile of a customer.
	Profile *Profile

	noSmithyDocumentSerde
}

// Object to hold the dimension of a profile type field to segment on.
type ProfileTypeDimension struct {

	// The action to segment on.
	//
	// This member is required.
	DimensionType ProfileTypeDimensionType

	// The values to apply the DimensionType on.
	//
	// This member is required.
	Values []ProfileType

	noSmithyDocumentSerde
}

// The relative time period over which data is included in the aggregation.
type Range struct {

	// The format the timestamp field in your JSON object is specified. This value
	// should be one of EPOCHMILLI (for Unix epoch timestamps with second/millisecond
	// level precision) or ISO_8601 (following ISO_8601 format with second/millisecond
	// level precision, with an optional offset of Z or in the format HH:MM or HHMM.).
	// E.g. if your object type is MyType and source JSON is {"generatedAt":
	// {"timestamp": "2001-07-04T12:08:56.235-0700"}}, then TimestampFormat should be
	// "ISO_8601".
	TimestampFormat *string

	// An expression specifying the field in your JSON object from which the date
	// should be parsed. The expression should follow the structure of
	// \"{ObjectTypeName.}\". E.g. if your object type is MyType and source JSON is
	// {"generatedAt": {"timestamp": "1737587945945"}}, then TimestampSource should be
	// "{MyType.generatedAt.timestamp}".
	TimestampSource *string

	// The unit of time.
	Unit Unit

	// The amount of time of the specified unit.
	Value *int32

	// A structure letting customers specify a relative time window over which over
	// which data is included in the Calculated Attribute. Use positive numbers to
	// indicate that the endpoint is in the past, and negative numbers to indicate it
	// is in the future. ValueRange overrides Value.
	ValueRange *ValueRange

	noSmithyDocumentSerde
}

// Overrides the original range on a calculated attribute definition.
type RangeOverride struct {

	// The start time of when to include objects.
	//
	// This member is required.
	Start *int32

	// The unit for start and end.
	//
	// This member is required.
	Unit RangeUnit

	// The end time of when to include objects.
	End int32

	noSmithyDocumentSerde
}

// Information indicating if the Calculated Attribute is ready for use by
// confirming all historical data has been processed and reflected.
type Readiness struct {

	// Any customer messaging.
	Message *string

	// Approximately how far the Calculated Attribute creation is from completion.
	ProgressPercentage *int32

	noSmithyDocumentSerde
}

// The summary of results for an upload job, including the number of updated,
// created, and failed records.
type ResultsSummary struct {

	// The number of records that were newly created during the upload job.
	CreatedRecords *int64

	// The number of records that failed to be processed during the upload job.
	FailedRecords *int64

	// The number of records that were updated during the upload job.
	UpdatedRecords *int64

	noSmithyDocumentSerde
}

// The request to enable the rule-based matching.
type RuleBasedMatchingRequest struct {

	// The flag that enables the rule-based matching process of duplicate profiles.
	//
	// This member is required.
	Enabled *bool

	// Configures information about the AttributeTypesSelector where the rule-based
	// identity resolution uses to match profiles.
	AttributeTypesSelector *AttributeTypesSelector

	// How the auto-merging process should resolve conflicts between different
	// profiles.
	ConflictResolution *ConflictResolution

	// Configuration information about the S3 bucket where Identity Resolution Jobs
	// writes result files.
	//
	// You need to give Customer Profiles service principal write permission to your
	// S3 bucket. Otherwise, you'll get an exception in the API response. For an
	// example policy, see [Amazon Connect Customer Profiles cross-service confused deputy prevention].
	//
	// [Amazon Connect Customer Profiles cross-service confused deputy prevention]: https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html#customer-profiles-cross-service
	ExportingConfig *ExportingConfig

	// Configures how the rule-based matching process should match profiles. You can
	// have up to 15 MatchingRule in the MatchingRules .
	MatchingRules []MatchingRule

	// Indicates the maximum allowed rule level.
	MaxAllowedRuleLevelForMatching *int32

	// [MatchingRule]
	//
	// [MatchingRule]: https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_MatchingRule.html
	MaxAllowedRuleLevelForMerging *int32

	noSmithyDocumentSerde
}

// The response of the Rule-based matching request.
type RuleBasedMatchingResponse struct {

	// Configures information about the AttributeTypesSelector where the rule-based
	// identity resolution uses to match profiles.
	AttributeTypesSelector *AttributeTypesSelector

	// How the auto-merging process should resolve conflicts between different
	// profiles.
	ConflictResolution *ConflictResolution

	// The flag that enables the rule-based matching process of duplicate profiles.
	Enabled *bool

	// Configuration information about the S3 bucket where Identity Resolution Jobs
	// writes result files.
	//
	// You need to give Customer Profiles service principal write permission to your
	// S3 bucket. Otherwise, you'll get an exception in the API response. For an
	// example policy, see [Amazon Connect Customer Profiles cross-service confused deputy prevention].
	//
	// [Amazon Connect Customer Profiles cross-service confused deputy prevention]: https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html#customer-profiles-cross-service
	ExportingConfig *ExportingConfig

	// Configures how the rule-based matching process should match profiles. You can
	// have up to 15 MatchingRule in the MatchingRules .
	MatchingRules []MatchingRule

	// Indicates the maximum allowed rule level.
	MaxAllowedRuleLevelForMatching *int32

	// [MatchingRule]
	//
	// [MatchingRule]: https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_MatchingRule.html
	MaxAllowedRuleLevelForMerging *int32

	// PENDING
	//
	//   - The first status after configuration a rule-based matching rule. If it is
	//   an existing domain, the rule-based Identity Resolution waits one hour before
	//   creating the matching rule. If it is a new domain, the system will skip the
	//   PENDING stage.
	//
	// IN_PROGRESS
	//
	//   - The system is creating the rule-based matching rule. Under this status, the
	//   system is evaluating the existing data and you can no longer change the
	//   Rule-based matching configuration.
	//
	// ACTIVE
	//
	//   - The rule is ready to use. You can change the rule a day after the status is
	//   in ACTIVE .
	Status RuleBasedMatchingStatus

	noSmithyDocumentSerde
}

// Configuration information about the S3 bucket where Identity Resolution Jobs
// write result files.
type S3ExportingConfig struct {

	// The name of the S3 bucket where Identity Resolution Jobs write result files.
	//
	// This member is required.
	S3BucketName *string

	// The S3 key name of the location where Identity Resolution Jobs write result
	// files.
	S3KeyName *string

	noSmithyDocumentSerde
}

// The S3 location where Identity Resolution Jobs write result files.
type S3ExportingLocation struct {

	// The name of the S3 bucket name where Identity Resolution Jobs write result
	// files.
	S3BucketName *string

	// The S3 key name of the location where Identity Resolution Jobs write result
	// files.
	S3KeyName *string

	noSmithyDocumentSerde
}

// The properties that are applied when Amazon S3 is being used as the flow source.
type S3SourceProperties struct {

	// The Amazon S3 bucket name where the source files are stored.
	//
	// This member is required.
	BucketName *string

	// The object key for the Amazon S3 bucket in which the source files are stored.
	BucketPrefix *string

	noSmithyDocumentSerde
}

// The properties that are applied when Salesforce is being used as a source.
type SalesforceSourceProperties struct {

	// The object specified in the Salesforce flow source.
	//
	// This member is required.
	Object *string

	// The flag that enables dynamic fetching of new (recently added) fields in the
	// Salesforce objects while running a flow.
	EnableDynamicFieldUpdate bool

	// Indicates whether Amazon AppFlow includes deleted files in the flow run.
	IncludeDeletedRecords bool

	noSmithyDocumentSerde
}

// Specifies the configuration details of a scheduled-trigger flow that you
// define. Currently, these settings only apply to the scheduled-trigger type.
type ScheduledTriggerProperties struct {

	// The scheduling expression that determines the rate at which the schedule will
	// run, for example rate (5 minutes).
	//
	// This member is required.
	ScheduleExpression *string

	// Specifies whether a scheduled flow has an incremental data transfer or a
	// complete data transfer for each flow run.
	DataPullMode DataPullMode

	// Specifies the date range for the records to import from the connector in the
	// first flow run.
	FirstExecutionFrom *time.Time

	// Specifies the scheduled end time for a scheduled-trigger flow.
	ScheduleEndTime *time.Time

	// Specifies the optional offset that is added to the time interval for a
	// schedule-triggered flow.
	ScheduleOffset *int64

	// Specifies the scheduled start time for a scheduled-trigger flow.
	ScheduleStartTime *time.Time

	// Specifies the time zone used when referring to the date and time of a
	// scheduled-triggered flow, such as America/New_York.
	Timezone *string

	noSmithyDocumentSerde
}

// Object holding the segment definition fields.
type SegmentDefinitionItem struct {

	// When the segment definition was created.
	CreatedAt *time.Time

	// The description of the segment definition.
	Description *string

	// Display name of the segment definition.
	DisplayName *string

	// The arn of the segment definition.
	SegmentDefinitionArn *string

	// Name of the segment definition.
	SegmentDefinitionName *string

	// The tags belonging to the segment definition.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Contains all groups of the segment definition.
type SegmentGroup struct {

	// Holds the list of groups within the segment definition.
	Groups []Group

	// Defines whether to include or exclude the profiles that fit the segment
	// criteria.
	Include IncludeOptions

	noSmithyDocumentSerde
}

// Contains all groups of the segment definition.
type SegmentGroupStructure struct {

	// Holds the list of groups within the segment definition.
	Groups []Group

	// Define whether to include or exclude the profiles that fit the segment criteria.
	Include IncludeOptions

	noSmithyDocumentSerde
}

// The properties that are applied when ServiceNow is being used as a source.
type ServiceNowSourceProperties struct {

	// The object specified in the ServiceNow flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

// Specifies the information that is required to query a particular Amazon AppFlow
// connector. Customer Profiles supports Salesforce, Zendesk, Marketo, ServiceNow
// and Amazon S3.
type SourceConnectorProperties struct {

	// The properties that are applied when Marketo is being used as a source.
	Marketo *MarketoSourceProperties

	// The properties that are applied when Amazon S3 is being used as the flow source.
	S3 *S3SourceProperties

	// The properties that are applied when Salesforce is being used as a source.
	Salesforce *SalesforceSourceProperties

	// The properties that are applied when ServiceNow is being used as a source.
	ServiceNow *ServiceNowSourceProperties

	// The properties that are applied when using Zendesk as a flow source.
	Zendesk *ZendeskSourceProperties

	noSmithyDocumentSerde
}

// Contains information about the configuration of the source connector used in
// the flow.
type SourceFlowConfig struct {

	// The type of connector, such as Salesforce, Marketo, and so on.
	//
	// This member is required.
	ConnectorType SourceConnectorType

	// Specifies the information that is required to query a particular source
	// connector.
	//
	// This member is required.
	SourceConnectorProperties *SourceConnectorProperties

	// The name of the AppFlow connector profile. This name must be unique for each
	// connector profile in the AWS account.
	ConnectorProfileName *string

	// Defines the configuration for a scheduled incremental data pull. If a valid
	// configuration is provided, the fields specified in the configuration are used
	// when querying for the incremental data pull.
	IncrementalPullConfig *IncrementalPullConfig

	noSmithyDocumentSerde
}

// The source segments to build off of.
type SourceSegment struct {

	// The unique name of the segment definition.
	SegmentDefinitionName *string

	noSmithyDocumentSerde
}

// A class for modeling different type of tasks. Task implementation varies based
// on the TaskType.
type Task struct {

	// The source fields to which a particular task is applied.
	//
	// This member is required.
	SourceFields []string

	// Specifies the particular task implementation that Amazon AppFlow performs.
	//
	// This member is required.
	TaskType TaskType

	// The operation to be performed on the provided source fields.
	ConnectorOperator *ConnectorOperator

	// A field in a destination connector, or a field value against which Amazon
	// AppFlow validates a source field.
	DestinationField *string

	// A map used to store task-related information. The service looks for particular
	// information based on the TaskType.
	TaskProperties map[string]string

	noSmithyDocumentSerde
}

// The threshold for the calculated attribute.
type Threshold struct {

	// The operator of the threshold.
	//
	// This member is required.
	Operator Operator

	// The value of the threshold.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The trigger settings that determine how and when Amazon AppFlow runs the
// specified flow.
type TriggerConfig struct {

	// Specifies the type of flow trigger. It can be OnDemand, Scheduled, or Event.
	//
	// This member is required.
	TriggerType TriggerType

	// Specifies the configuration details of a schedule-triggered flow that you
	// define. Currently, these settings only apply to the Scheduled trigger type.
	TriggerProperties *TriggerProperties

	noSmithyDocumentSerde
}

// Specifies the configuration details that control the trigger for a flow.
// Currently, these settings only apply to the Scheduled trigger type.
type TriggerProperties struct {

	// Specifies the configuration details of a schedule-triggered flow that you
	// define.
	Scheduled *ScheduledTriggerProperties

	noSmithyDocumentSerde
}

// Updates associated with the address properties of a customer profile.
type UpdateAddress struct {

	// The first line of a customer address.
	Address1 *string

	// The second line of a customer address.
	Address2 *string

	// The third line of a customer address.
	Address3 *string

	// The fourth line of a customer address.
	Address4 *string

	// The city in which a customer lives.
	City *string

	// The country in which a customer lives.
	Country *string

	// The county in which a customer lives.
	County *string

	// The postal code of a customer address.
	PostalCode *string

	// The province in which a customer lives.
	Province *string

	// The state in which a customer lives.
	State *string

	noSmithyDocumentSerde
}

// The summary information for an individual upload job.
type UploadJobItem struct {

	// The timestamp when the upload job was completed.
	CompletedAt *time.Time

	// The timestamp when the upload job was created.
	CreatedAt *time.Time

	// The expiry duration for the profiles ingested with the upload job.
	DataExpiry *int32

	// The name of the upload job.
	DisplayName *string

	// The unique identifier of the upload job.
	JobId *string

	// The current status of the upload job.
	Status UploadJobStatus

	// The reason for the current status of the upload job.
	StatusReason StatusReason

	noSmithyDocumentSerde
}

// A structure letting customers specify a relative time window over which over
// which data is included in the Calculated Attribute. Use positive numbers to
// indicate that the endpoint is in the past, and negative numbers to indicate it
// is in the future. ValueRange overrides Value.
type ValueRange struct {

	// The end time of when to include objects. Use positive numbers to indicate that
	// the starting point is in the past, and negative numbers to indicate it is in the
	// future.
	//
	// This member is required.
	End *int32

	// The start time of when to include objects. Use positive numbers to indicate
	// that the starting point is in the past, and negative numbers to indicate it is
	// in the future.
	//
	// This member is required.
	Start *int32

	noSmithyDocumentSerde
}

// Structure to hold workflow attributes.
type WorkflowAttributes struct {

	// Workflow attributes specific to APPFLOW_INTEGRATION workflow.
	AppflowIntegration *AppflowIntegrationWorkflowAttributes

	noSmithyDocumentSerde
}

// Generic object containing workflow execution metrics.
type WorkflowMetrics struct {

	// Workflow execution metrics for APPFLOW_INTEGRATION workflow.
	AppflowIntegration *AppflowIntegrationWorkflowMetrics

	noSmithyDocumentSerde
}

// List containing steps in workflow.
type WorkflowStepItem struct {

	// Workflow step information specific to APPFLOW_INTEGRATION workflow.
	AppflowIntegration *AppflowIntegrationWorkflowStep

	noSmithyDocumentSerde
}

// The properties that are applied when using Zendesk as a flow source.
type ZendeskSourceProperties struct {

	// The object specified in the Zendesk flow source.
	//
	// This member is required.
	Object *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isDimension() {}
