// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Searches the hours of operation overrides.
func (c *Client) SearchHoursOfOperationOverrides(ctx context.Context, params *SearchHoursOfOperationOverridesInput, optFns ...func(*Options)) (*SearchHoursOfOperationOverridesOutput, error) {
	if params == nil {
		params = &SearchHoursOfOperationOverridesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchHoursOfOperationOverrides", params, optFns, c.addOperationSearchHoursOfOperationOverridesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchHoursOfOperationOverridesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchHoursOfOperationOverridesInput struct {

	// The identifier of the Amazon Connect instance.
	//
	// This member is required.
	InstanceId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// The search criteria to be used to return hours of operations overrides.
	SearchCriteria *types.HoursOfOperationOverrideSearchCriteria

	// Filters to be applied to search results.
	SearchFilter *types.HoursOfOperationSearchFilter

	noSmithyDocumentSerde
}

type SearchHoursOfOperationOverridesOutput struct {

	// The total number of hours of operations which matched your search query.
	ApproximateTotalCount *int64

	// Information about the hours of operations overrides.
	HoursOfOperationOverrides []types.HoursOfOperationOverride

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchHoursOfOperationOverridesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchHoursOfOperationOverrides{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchHoursOfOperationOverrides{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchHoursOfOperationOverrides"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchHoursOfOperationOverridesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchHoursOfOperationOverrides(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// SearchHoursOfOperationOverridesPaginatorOptions is the paginator options for
// SearchHoursOfOperationOverrides
type SearchHoursOfOperationOverridesPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchHoursOfOperationOverridesPaginator is a paginator for
// SearchHoursOfOperationOverrides
type SearchHoursOfOperationOverridesPaginator struct {
	options   SearchHoursOfOperationOverridesPaginatorOptions
	client    SearchHoursOfOperationOverridesAPIClient
	params    *SearchHoursOfOperationOverridesInput
	nextToken *string
	firstPage bool
}

// NewSearchHoursOfOperationOverridesPaginator returns a new
// SearchHoursOfOperationOverridesPaginator
func NewSearchHoursOfOperationOverridesPaginator(client SearchHoursOfOperationOverridesAPIClient, params *SearchHoursOfOperationOverridesInput, optFns ...func(*SearchHoursOfOperationOverridesPaginatorOptions)) *SearchHoursOfOperationOverridesPaginator {
	if params == nil {
		params = &SearchHoursOfOperationOverridesInput{}
	}

	options := SearchHoursOfOperationOverridesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchHoursOfOperationOverridesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchHoursOfOperationOverridesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchHoursOfOperationOverrides page.
func (p *SearchHoursOfOperationOverridesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchHoursOfOperationOverridesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchHoursOfOperationOverrides(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchHoursOfOperationOverridesAPIClient is a client that implements the
// SearchHoursOfOperationOverrides operation.
type SearchHoursOfOperationOverridesAPIClient interface {
	SearchHoursOfOperationOverrides(context.Context, *SearchHoursOfOperationOverridesInput, ...func(*Options)) (*SearchHoursOfOperationOverridesOutput, error)
}

var _ SearchHoursOfOperationOverridesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchHoursOfOperationOverrides(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchHoursOfOperationOverrides",
	}
}
