// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudtrail

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudtrail/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Creates a custom dashboard or the Highlights dashboard.
//
//	 - Custom dashboards - Custom dashboards allow you to query events in any
//	 event data store type. You can add up to 10 widgets to a custom dashboard. You
//	 can manually refresh a custom dashboard, or you can set a refresh schedule.
//
//	 - Highlights dashboard - You can create the Highlights dashboard to see a
//	 summary of key user activities and API usage across all your event data stores.
//	 CloudTrail Lake manages the Highlights dashboard and refreshes the dashboard
//	 every 6 hours. To create the Highlights dashboard, you must set and enable a
//	 refresh schedule.
//
// CloudTrail runs queries to populate the dashboard's widgets during a manual or
// scheduled refresh. CloudTrail must be granted permissions to run the StartQuery
// operation on your behalf. To provide permissions, run the PutResourcePolicy
// operation to attach a resource-based policy to each event data store. For more
// information, see [Example: Allow CloudTrail to run queries to populate a dashboard]in the CloudTrail User Guide.
//
// To set a refresh schedule, CloudTrail must be granted permissions to run the
// StartDashboardRefresh operation to refresh the dashboard on your behalf. To
// provide permissions, run the PutResourcePolicy operation to attach a
// resource-based policy to the dashboard. For more information, see [Resource-based policy example for a dashboard]in the
// CloudTrail User Guide.
//
// For more information about dashboards, see [CloudTrail Lake dashboards] in the CloudTrail User Guide.
//
// [CloudTrail Lake dashboards]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/lake-dashboard.html
// [Example: Allow CloudTrail to run queries to populate a dashboard]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-eds-dashboard
// [Resource-based policy example for a dashboard]: https://docs.aws.amazon.com/awscloudtrail/latest/userguide/security_iam_resource-based-policy-examples.html#security_iam_resource-based-policy-examples-dashboards
func (c *Client) CreateDashboard(ctx context.Context, params *CreateDashboardInput, optFns ...func(*Options)) (*CreateDashboardOutput, error) {
	if params == nil {
		params = &CreateDashboardInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDashboard", params, optFns, c.addOperationCreateDashboardMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDashboardOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDashboardInput struct {

	//  The name of the dashboard. The name must be unique to your account.
	//
	// To create the Highlights dashboard, the name must be AWSCloudTrail-Highlights .
	//
	// This member is required.
	Name *string

	//  The refresh schedule configuration for the dashboard.
	//
	// To create the Highlights dashboard, you must set a refresh schedule and set the
	// Status to ENABLED . The Unit for the refresh schedule must be HOURS and the
	// Value must be 6 .
	RefreshSchedule *types.RefreshSchedule

	// A list of tags.
	TagsList []types.Tag

	//  Specifies whether termination protection is enabled for the dashboard. If
	// termination protection is enabled, you cannot delete the dashboard until
	// termination protection is disabled.
	TerminationProtectionEnabled *bool

	//  An array of widgets for a custom dashboard. A custom dashboard can have a
	// maximum of ten widgets.
	//
	// You do not need to specify widgets for the Highlights dashboard.
	Widgets []types.RequestWidget

	noSmithyDocumentSerde
}

type CreateDashboardOutput struct {

	//  The ARN for the dashboard.
	DashboardArn *string

	//  The name of the dashboard.
	Name *string

	//  The refresh schedule for the dashboard, if configured.
	RefreshSchedule *types.RefreshSchedule

	// A list of tags.
	TagsList []types.Tag

	//  Indicates whether termination protection is enabled for the dashboard.
	TerminationProtectionEnabled *bool

	//  The dashboard type.
	Type types.DashboardType

	//  An array of widgets for the dashboard.
	Widgets []types.Widget

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDashboardMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateDashboard{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateDashboard{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateDashboard"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateDashboardValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDashboard(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDashboard(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateDashboard",
	}
}
