// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a custom model deployment, including its status,
// configuration, and metadata. Use this operation to monitor the deployment status
// and retrieve details needed for inference requests.
//
// The following actions are related to the GetCustomModelDeployment operation:
//
// [CreateCustomModelDeployment]
//
// [ListCustomModelDeployments]
//
// [DeleteCustomModelDeployment]
//
// [ListCustomModelDeployments]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_ListCustomModelDeployments.html
// [CreateCustomModelDeployment]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_CreateCustomModelDeployment.html
// [DeleteCustomModelDeployment]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_DeleteCustomModelDeployment.html
func (c *Client) GetCustomModelDeployment(ctx context.Context, params *GetCustomModelDeploymentInput, optFns ...func(*Options)) (*GetCustomModelDeploymentOutput, error) {
	if params == nil {
		params = &GetCustomModelDeploymentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCustomModelDeployment", params, optFns, c.addOperationGetCustomModelDeploymentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCustomModelDeploymentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCustomModelDeploymentInput struct {

	// The Amazon Resource Name (ARN) or name of the custom model deployment to
	// retrieve information about.
	//
	// This member is required.
	CustomModelDeploymentIdentifier *string

	noSmithyDocumentSerde
}

type GetCustomModelDeploymentOutput struct {

	// The date and time when the custom model deployment was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the custom model deployment.
	//
	// This member is required.
	CustomModelDeploymentArn *string

	// The Amazon Resource Name (ARN) of the custom model associated with this
	// deployment.
	//
	// This member is required.
	ModelArn *string

	// The name of the custom model deployment.
	//
	// This member is required.
	ModelDeploymentName *string

	// The status of the custom model deployment. Possible values are:
	//
	//   - CREATING - The deployment is being set up and prepared for inference.
	//
	//   - ACTIVE - The deployment is ready and available for inference requests.
	//
	//   - FAILED - The deployment failed to be created or became unavailable.
	//
	// This member is required.
	Status types.CustomModelDeploymentStatus

	// The description of the custom model deployment.
	Description *string

	// If the deployment status is FAILED , this field contains a message describing
	// the failure reason.
	FailureMessage *string

	// The date and time when the custom model deployment was last updated.
	LastUpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCustomModelDeploymentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCustomModelDeployment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCustomModelDeployment{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetCustomModelDeployment"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetCustomModelDeploymentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCustomModelDeployment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetCustomModelDeployment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetCustomModelDeployment",
	}
}
