// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package synthetics

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateCanary = "CreateCanary"

// CreateCanaryRequest generates a "aws/request.Request" representing the
// client's request for the CreateCanary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCanary for more information on using the CreateCanary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateCanaryRequest method.
//    req, resp := client.CreateCanaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/CreateCanary
func (c *Synthetics) CreateCanaryRequest(input *CreateCanaryInput) (req *request.Request, output *CreateCanaryOutput) {
	op := &request.Operation{
		Name:       opCreateCanary,
		HTTPMethod: "POST",
		HTTPPath:   "/canary",
	}

	if input == nil {
		input = &CreateCanaryInput{}
	}

	output = &CreateCanaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCanary API operation for Synthetics.
//
// Creates a canary. Canaries are scripts that monitor your endpoints and APIs
// from the outside-in. Canaries help you check the availability and latency
// of your web services and troubleshoot anomalies by investigating load time
// data, screenshots of the UI, logs, and metrics. You can set up a canary to
// run continuously or just once.
//
// Do not use CreateCanary to modify an existing canary. Use UpdateCanary (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_UpdateCanary.html)
// instead.
//
// To create canaries, you must have the CloudWatchSyntheticsFullAccess policy.
// If you are creating a new IAM role for the canary, you also need the the
// iam:CreateRole, iam:CreatePolicy and iam:AttachRolePolicy permissions. For
// more information, see Necessary Roles and Permissions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Roles).
//
// Do not include secrets or proprietary information in your canary names. The
// canary name makes up part of the Amazon Resource Name (ARN) for the canary,
// and the ARN is included in outbound calls over the internet. For more information,
// see Security Considerations for Synthetics Canaries (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation CreateCanary for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ValidationException
//   A parameter could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/CreateCanary
func (c *Synthetics) CreateCanary(input *CreateCanaryInput) (*CreateCanaryOutput, error) {
	req, out := c.CreateCanaryRequest(input)
	return out, req.Send()
}

// CreateCanaryWithContext is the same as CreateCanary with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCanary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) CreateCanaryWithContext(ctx aws.Context, input *CreateCanaryInput, opts ...request.Option) (*CreateCanaryOutput, error) {
	req, out := c.CreateCanaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCanary = "DeleteCanary"

// DeleteCanaryRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCanary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCanary for more information on using the DeleteCanary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCanaryRequest method.
//    req, resp := client.DeleteCanaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DeleteCanary
func (c *Synthetics) DeleteCanaryRequest(input *DeleteCanaryInput) (req *request.Request, output *DeleteCanaryOutput) {
	op := &request.Operation{
		Name:       opDeleteCanary,
		HTTPMethod: "DELETE",
		HTTPPath:   "/canary/{name}",
	}

	if input == nil {
		input = &DeleteCanaryInput{}
	}

	output = &DeleteCanaryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCanary API operation for Synthetics.
//
// Permanently deletes the specified canary.
//
// When you delete a canary, resources used and created by the canary are not
// automatically deleted. After you delete a canary that you do not intend to
// use again, you should also delete the following:
//
//    * The Lambda functions and layers used by this canary. These have the
//    prefix cwsyn-MyCanaryName .
//
//    * The CloudWatch alarms created for this canary. These alarms have a name
//    of Synthetics-SharpDrop-Alarm-MyCanaryName .
//
//    * Amazon S3 objects and buckets, such as the canary's artifact location.
//
//    * IAM roles created for the canary. If they were created in the console,
//    these roles have the name role/service-role/CloudWatchSyntheticsRole-MyCanaryName .
//
//    * CloudWatch Logs log groups created for the canary. These logs groups
//    have the name /aws/lambda/cwsyn-MyCanaryName .
//
// Before you delete a canary, you might want to use GetCanary to display the
// information about this canary. Make note of the information returned by this
// operation so that you can delete these resources after you delete the canary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation DeleteCanary for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ValidationException
//   A parameter could not be validated.
//
//   * ResourceNotFoundException
//   One of the specified resources was not found.
//
//   * ConflictException
//   A conflicting operation is already in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DeleteCanary
func (c *Synthetics) DeleteCanary(input *DeleteCanaryInput) (*DeleteCanaryOutput, error) {
	req, out := c.DeleteCanaryRequest(input)
	return out, req.Send()
}

// DeleteCanaryWithContext is the same as DeleteCanary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCanary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) DeleteCanaryWithContext(ctx aws.Context, input *DeleteCanaryInput, opts ...request.Option) (*DeleteCanaryOutput, error) {
	req, out := c.DeleteCanaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCanaries = "DescribeCanaries"

// DescribeCanariesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCanaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCanaries for more information on using the DescribeCanaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCanariesRequest method.
//    req, resp := client.DescribeCanariesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DescribeCanaries
func (c *Synthetics) DescribeCanariesRequest(input *DescribeCanariesInput) (req *request.Request, output *DescribeCanariesOutput) {
	op := &request.Operation{
		Name:       opDescribeCanaries,
		HTTPMethod: "POST",
		HTTPPath:   "/canaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCanariesInput{}
	}

	output = &DescribeCanariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCanaries API operation for Synthetics.
//
// This operation returns a list of the canaries in your account, along with
// full details about each canary.
//
// This operation does not have resource-level authorization, so if a user is
// able to use DescribeCanaries, the user can see all of the canaries in the
// account. A deny policy can only be used to restrict access to all canaries.
// It cannot be used on specific resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation DescribeCanaries for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ValidationException
//   A parameter could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DescribeCanaries
func (c *Synthetics) DescribeCanaries(input *DescribeCanariesInput) (*DescribeCanariesOutput, error) {
	req, out := c.DescribeCanariesRequest(input)
	return out, req.Send()
}

// DescribeCanariesWithContext is the same as DescribeCanaries with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCanaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) DescribeCanariesWithContext(ctx aws.Context, input *DescribeCanariesInput, opts ...request.Option) (*DescribeCanariesOutput, error) {
	req, out := c.DescribeCanariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCanariesPages iterates over the pages of a DescribeCanaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCanaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCanaries operation.
//    pageNum := 0
//    err := client.DescribeCanariesPages(params,
//        func(page *synthetics.DescribeCanariesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Synthetics) DescribeCanariesPages(input *DescribeCanariesInput, fn func(*DescribeCanariesOutput, bool) bool) error {
	return c.DescribeCanariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCanariesPagesWithContext same as DescribeCanariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) DescribeCanariesPagesWithContext(ctx aws.Context, input *DescribeCanariesInput, fn func(*DescribeCanariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCanariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCanariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCanariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCanariesLastRun = "DescribeCanariesLastRun"

// DescribeCanariesLastRunRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCanariesLastRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCanariesLastRun for more information on using the DescribeCanariesLastRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCanariesLastRunRequest method.
//    req, resp := client.DescribeCanariesLastRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DescribeCanariesLastRun
func (c *Synthetics) DescribeCanariesLastRunRequest(input *DescribeCanariesLastRunInput) (req *request.Request, output *DescribeCanariesLastRunOutput) {
	op := &request.Operation{
		Name:       opDescribeCanariesLastRun,
		HTTPMethod: "POST",
		HTTPPath:   "/canaries/last-run",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCanariesLastRunInput{}
	}

	output = &DescribeCanariesLastRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCanariesLastRun API operation for Synthetics.
//
// Use this operation to see information from the most recent run of each canary
// that you have created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation DescribeCanariesLastRun for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ValidationException
//   A parameter could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DescribeCanariesLastRun
func (c *Synthetics) DescribeCanariesLastRun(input *DescribeCanariesLastRunInput) (*DescribeCanariesLastRunOutput, error) {
	req, out := c.DescribeCanariesLastRunRequest(input)
	return out, req.Send()
}

// DescribeCanariesLastRunWithContext is the same as DescribeCanariesLastRun with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCanariesLastRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) DescribeCanariesLastRunWithContext(ctx aws.Context, input *DescribeCanariesLastRunInput, opts ...request.Option) (*DescribeCanariesLastRunOutput, error) {
	req, out := c.DescribeCanariesLastRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCanariesLastRunPages iterates over the pages of a DescribeCanariesLastRun operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCanariesLastRun method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCanariesLastRun operation.
//    pageNum := 0
//    err := client.DescribeCanariesLastRunPages(params,
//        func(page *synthetics.DescribeCanariesLastRunOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Synthetics) DescribeCanariesLastRunPages(input *DescribeCanariesLastRunInput, fn func(*DescribeCanariesLastRunOutput, bool) bool) error {
	return c.DescribeCanariesLastRunPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCanariesLastRunPagesWithContext same as DescribeCanariesLastRunPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) DescribeCanariesLastRunPagesWithContext(ctx aws.Context, input *DescribeCanariesLastRunInput, fn func(*DescribeCanariesLastRunOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCanariesLastRunInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCanariesLastRunRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCanariesLastRunOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRuntimeVersions = "DescribeRuntimeVersions"

// DescribeRuntimeVersionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRuntimeVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRuntimeVersions for more information on using the DescribeRuntimeVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRuntimeVersionsRequest method.
//    req, resp := client.DescribeRuntimeVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DescribeRuntimeVersions
func (c *Synthetics) DescribeRuntimeVersionsRequest(input *DescribeRuntimeVersionsInput) (req *request.Request, output *DescribeRuntimeVersionsOutput) {
	op := &request.Operation{
		Name:       opDescribeRuntimeVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/runtime-versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeRuntimeVersionsInput{}
	}

	output = &DescribeRuntimeVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRuntimeVersions API operation for Synthetics.
//
// Returns a list of Synthetics canary runtime versions. For more information,
// see Canary Runtime Versions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation DescribeRuntimeVersions for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ValidationException
//   A parameter could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/DescribeRuntimeVersions
func (c *Synthetics) DescribeRuntimeVersions(input *DescribeRuntimeVersionsInput) (*DescribeRuntimeVersionsOutput, error) {
	req, out := c.DescribeRuntimeVersionsRequest(input)
	return out, req.Send()
}

// DescribeRuntimeVersionsWithContext is the same as DescribeRuntimeVersions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRuntimeVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) DescribeRuntimeVersionsWithContext(ctx aws.Context, input *DescribeRuntimeVersionsInput, opts ...request.Option) (*DescribeRuntimeVersionsOutput, error) {
	req, out := c.DescribeRuntimeVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeRuntimeVersionsPages iterates over the pages of a DescribeRuntimeVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeRuntimeVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeRuntimeVersions operation.
//    pageNum := 0
//    err := client.DescribeRuntimeVersionsPages(params,
//        func(page *synthetics.DescribeRuntimeVersionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Synthetics) DescribeRuntimeVersionsPages(input *DescribeRuntimeVersionsInput, fn func(*DescribeRuntimeVersionsOutput, bool) bool) error {
	return c.DescribeRuntimeVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeRuntimeVersionsPagesWithContext same as DescribeRuntimeVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) DescribeRuntimeVersionsPagesWithContext(ctx aws.Context, input *DescribeRuntimeVersionsInput, fn func(*DescribeRuntimeVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeRuntimeVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeRuntimeVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeRuntimeVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetCanary = "GetCanary"

// GetCanaryRequest generates a "aws/request.Request" representing the
// client's request for the GetCanary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCanary for more information on using the GetCanary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCanaryRequest method.
//    req, resp := client.GetCanaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/GetCanary
func (c *Synthetics) GetCanaryRequest(input *GetCanaryInput) (req *request.Request, output *GetCanaryOutput) {
	op := &request.Operation{
		Name:       opGetCanary,
		HTTPMethod: "GET",
		HTTPPath:   "/canary/{name}",
	}

	if input == nil {
		input = &GetCanaryInput{}
	}

	output = &GetCanaryOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCanary API operation for Synthetics.
//
// Retrieves complete information about one canary. You must specify the name
// of the canary that you want. To get a list of canaries and their names, use
// DescribeCanaries (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation GetCanary for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ValidationException
//   A parameter could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/GetCanary
func (c *Synthetics) GetCanary(input *GetCanaryInput) (*GetCanaryOutput, error) {
	req, out := c.GetCanaryRequest(input)
	return out, req.Send()
}

// GetCanaryWithContext is the same as GetCanary with the addition of
// the ability to pass a context and additional request options.
//
// See GetCanary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) GetCanaryWithContext(ctx aws.Context, input *GetCanaryInput, opts ...request.Option) (*GetCanaryOutput, error) {
	req, out := c.GetCanaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCanaryRuns = "GetCanaryRuns"

// GetCanaryRunsRequest generates a "aws/request.Request" representing the
// client's request for the GetCanaryRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCanaryRuns for more information on using the GetCanaryRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetCanaryRunsRequest method.
//    req, resp := client.GetCanaryRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/GetCanaryRuns
func (c *Synthetics) GetCanaryRunsRequest(input *GetCanaryRunsInput) (req *request.Request, output *GetCanaryRunsOutput) {
	op := &request.Operation{
		Name:       opGetCanaryRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/canary/{name}/runs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCanaryRunsInput{}
	}

	output = &GetCanaryRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCanaryRuns API operation for Synthetics.
//
// Retrieves a list of runs for a specified canary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation GetCanaryRuns for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ValidationException
//   A parameter could not be validated.
//
//   * ResourceNotFoundException
//   One of the specified resources was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/GetCanaryRuns
func (c *Synthetics) GetCanaryRuns(input *GetCanaryRunsInput) (*GetCanaryRunsOutput, error) {
	req, out := c.GetCanaryRunsRequest(input)
	return out, req.Send()
}

// GetCanaryRunsWithContext is the same as GetCanaryRuns with the addition of
// the ability to pass a context and additional request options.
//
// See GetCanaryRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) GetCanaryRunsWithContext(ctx aws.Context, input *GetCanaryRunsInput, opts ...request.Option) (*GetCanaryRunsOutput, error) {
	req, out := c.GetCanaryRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCanaryRunsPages iterates over the pages of a GetCanaryRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCanaryRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetCanaryRuns operation.
//    pageNum := 0
//    err := client.GetCanaryRunsPages(params,
//        func(page *synthetics.GetCanaryRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Synthetics) GetCanaryRunsPages(input *GetCanaryRunsInput, fn func(*GetCanaryRunsOutput, bool) bool) error {
	return c.GetCanaryRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCanaryRunsPagesWithContext same as GetCanaryRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) GetCanaryRunsPagesWithContext(ctx aws.Context, input *GetCanaryRunsInput, fn func(*GetCanaryRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCanaryRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCanaryRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetCanaryRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/ListTagsForResource
func (c *Synthetics) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Synthetics.
//
// Displays the tags associated with a canary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ResourceNotFoundException
//   One of the specified resources was not found.
//
//   * ValidationException
//   A parameter could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/ListTagsForResource
func (c *Synthetics) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartCanary = "StartCanary"

// StartCanaryRequest generates a "aws/request.Request" representing the
// client's request for the StartCanary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCanary for more information on using the StartCanary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartCanaryRequest method.
//    req, resp := client.StartCanaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/StartCanary
func (c *Synthetics) StartCanaryRequest(input *StartCanaryInput) (req *request.Request, output *StartCanaryOutput) {
	op := &request.Operation{
		Name:       opStartCanary,
		HTTPMethod: "POST",
		HTTPPath:   "/canary/{name}/start",
	}

	if input == nil {
		input = &StartCanaryInput{}
	}

	output = &StartCanaryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartCanary API operation for Synthetics.
//
// Use this operation to run a canary that has already been created. The frequency
// of the canary runs is determined by the value of the canary's Schedule. To
// see a canary's schedule, use GetCanary (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanary.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation StartCanary for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ValidationException
//   A parameter could not be validated.
//
//   * ResourceNotFoundException
//   One of the specified resources was not found.
//
//   * ConflictException
//   A conflicting operation is already in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/StartCanary
func (c *Synthetics) StartCanary(input *StartCanaryInput) (*StartCanaryOutput, error) {
	req, out := c.StartCanaryRequest(input)
	return out, req.Send()
}

// StartCanaryWithContext is the same as StartCanary with the addition of
// the ability to pass a context and additional request options.
//
// See StartCanary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) StartCanaryWithContext(ctx aws.Context, input *StartCanaryInput, opts ...request.Option) (*StartCanaryOutput, error) {
	req, out := c.StartCanaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopCanary = "StopCanary"

// StopCanaryRequest generates a "aws/request.Request" representing the
// client's request for the StopCanary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopCanary for more information on using the StopCanary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopCanaryRequest method.
//    req, resp := client.StopCanaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/StopCanary
func (c *Synthetics) StopCanaryRequest(input *StopCanaryInput) (req *request.Request, output *StopCanaryOutput) {
	op := &request.Operation{
		Name:       opStopCanary,
		HTTPMethod: "POST",
		HTTPPath:   "/canary/{name}/stop",
	}

	if input == nil {
		input = &StopCanaryInput{}
	}

	output = &StopCanaryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopCanary API operation for Synthetics.
//
// Stops the canary to prevent all future runs. If the canary is currently running,
// Synthetics stops waiting for the current run of the specified canary to complete.
// The run that is in progress completes on its own, publishes metrics, and
// uploads artifacts, but it is not recorded in Synthetics as a completed run.
//
// You can use StartCanary to start it running again with the canary’s current
// schedule at any point in the future.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation StopCanary for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ValidationException
//   A parameter could not be validated.
//
//   * ResourceNotFoundException
//   One of the specified resources was not found.
//
//   * ConflictException
//   A conflicting operation is already in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/StopCanary
func (c *Synthetics) StopCanary(input *StopCanaryInput) (*StopCanaryOutput, error) {
	req, out := c.StopCanaryRequest(input)
	return out, req.Send()
}

// StopCanaryWithContext is the same as StopCanary with the addition of
// the ability to pass a context and additional request options.
//
// See StopCanary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) StopCanaryWithContext(ctx aws.Context, input *StopCanaryInput, opts ...request.Option) (*StopCanaryOutput, error) {
	req, out := c.StopCanaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/TagResource
func (c *Synthetics) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Synthetics.
//
// Assigns one or more tags (key-value pairs) to the specified canary.
//
// Tags can help you organize and categorize your resources. You can also use
// them to scope user permissions, by granting a user permission to access or
// change only resources with certain tag values.
//
// Tags don't have any semantic meaning to AWS and are interpreted strictly
// as strings of characters.
//
// You can use the TagResource action with a canary that already has tags. If
// you specify a new tag key for the alarm, this tag is appended to the list
// of tags associated with the alarm. If you specify a tag key that is already
// associated with the alarm, the new tag value that you specify replaces the
// previous value for that tag.
//
// You can associate as many as 50 tags with a canary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ResourceNotFoundException
//   One of the specified resources was not found.
//
//   * ValidationException
//   A parameter could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/TagResource
func (c *Synthetics) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/UntagResource
func (c *Synthetics) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Synthetics.
//
// Removes one or more tags from the specified canary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ResourceNotFoundException
//   One of the specified resources was not found.
//
//   * ValidationException
//   A parameter could not be validated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/UntagResource
func (c *Synthetics) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCanary = "UpdateCanary"

// UpdateCanaryRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCanary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCanary for more information on using the UpdateCanary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateCanaryRequest method.
//    req, resp := client.UpdateCanaryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/UpdateCanary
func (c *Synthetics) UpdateCanaryRequest(input *UpdateCanaryInput) (req *request.Request, output *UpdateCanaryOutput) {
	op := &request.Operation{
		Name:       opUpdateCanary,
		HTTPMethod: "PATCH",
		HTTPPath:   "/canary/{name}",
	}

	if input == nil {
		input = &UpdateCanaryInput{}
	}

	output = &UpdateCanaryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateCanary API operation for Synthetics.
//
// Use this operation to change the settings of a canary that has already been
// created.
//
// You can't use this operation to update the tags of an existing canary. To
// change the tags of an existing canary, use TagResource (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_TagResource.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Synthetics's
// API operation UpdateCanary for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   An unknown internal error occurred.
//
//   * ValidationException
//   A parameter could not be validated.
//
//   * ResourceNotFoundException
//   One of the specified resources was not found.
//
//   * ConflictException
//   A conflicting operation is already in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/UpdateCanary
func (c *Synthetics) UpdateCanary(input *UpdateCanaryInput) (*UpdateCanaryOutput, error) {
	req, out := c.UpdateCanaryRequest(input)
	return out, req.Send()
}

// UpdateCanaryWithContext is the same as UpdateCanary with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCanary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Synthetics) UpdateCanaryWithContext(ctx aws.Context, input *UpdateCanaryInput, opts ...request.Option) (*UpdateCanaryOutput, error) {
	req, out := c.UpdateCanaryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// This structure contains all information about one canary in your account.
type Canary struct {
	_ struct{} `type:"structure"`

	// The location in Amazon S3 where Synthetics stores artifacts from the runs
	// of this canary. Artifacts include the log file, screenshots, and HAR files.
	ArtifactS3Location *string `min:"1" type:"string"`

	// This structure contains information about the canary's Lambda handler and
	// where its code is stored by CloudWatch Synthetics.
	Code *CanaryCodeOutput `type:"structure"`

	// The ARN of the Lambda function that is used as your canary's engine. For
	// more information about Lambda ARN format, see Resources and Conditions for
	// Lambda Actions (https://docs.aws.amazon.com/lambda/latest/dg/lambda-api-permissions-ref.html).
	EngineArn *string `type:"string"`

	// The ARN of the IAM role used to run the canary. This role must include lambda.amazonaws.com
	// as a principal in the trust policy.
	ExecutionRoleArn *string `type:"string"`

	// The number of days to retain data about failed runs of this canary.
	FailureRetentionPeriodInDays *int64 `min:"1" type:"integer"`

	// The unique ID of this canary.
	Id *string `type:"string"`

	// The name of the canary.
	Name *string `min:"1" type:"string"`

	// A structure that contains information for a canary run.
	RunConfig *CanaryRunConfigOutput `type:"structure"`

	// Specifies the runtime version to use for the canary. Currently, the only
	// valid value is syn-1.0. For more information about runtime versions, see
	// Canary Runtime Versions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
	RuntimeVersion *string `min:"1" type:"string"`

	// A structure that contains information about how often the canary is to run,
	// and when these runs are to stop.
	Schedule *CanaryScheduleOutput `type:"structure"`

	// A structure that contains information about the canary's status.
	Status *CanaryStatus `type:"structure"`

	// The number of days to retain data about successful runs of this canary.
	SuccessRetentionPeriodInDays *int64 `min:"1" type:"integer"`

	// The list of key-value pairs that are associated with the canary.
	Tags map[string]*string `min:"1" type:"map"`

	// A structure that contains information about when the canary was created,
	// modified, and most recently run.
	Timeline *CanaryTimeline `type:"structure"`

	// If this canary is to test an endpoint in a VPC, this structure contains information
	// about the subnets and security groups of the VPC endpoint. For more information,
	// see Running a Canary in a VPC (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
	VpcConfig *VpcConfigOutput `type:"structure"`
}

// String returns the string representation
func (s Canary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Canary) GoString() string {
	return s.String()
}

// SetArtifactS3Location sets the ArtifactS3Location field's value.
func (s *Canary) SetArtifactS3Location(v string) *Canary {
	s.ArtifactS3Location = &v
	return s
}

// SetCode sets the Code field's value.
func (s *Canary) SetCode(v *CanaryCodeOutput) *Canary {
	s.Code = v
	return s
}

// SetEngineArn sets the EngineArn field's value.
func (s *Canary) SetEngineArn(v string) *Canary {
	s.EngineArn = &v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *Canary) SetExecutionRoleArn(v string) *Canary {
	s.ExecutionRoleArn = &v
	return s
}

// SetFailureRetentionPeriodInDays sets the FailureRetentionPeriodInDays field's value.
func (s *Canary) SetFailureRetentionPeriodInDays(v int64) *Canary {
	s.FailureRetentionPeriodInDays = &v
	return s
}

// SetId sets the Id field's value.
func (s *Canary) SetId(v string) *Canary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Canary) SetName(v string) *Canary {
	s.Name = &v
	return s
}

// SetRunConfig sets the RunConfig field's value.
func (s *Canary) SetRunConfig(v *CanaryRunConfigOutput) *Canary {
	s.RunConfig = v
	return s
}

// SetRuntimeVersion sets the RuntimeVersion field's value.
func (s *Canary) SetRuntimeVersion(v string) *Canary {
	s.RuntimeVersion = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *Canary) SetSchedule(v *CanaryScheduleOutput) *Canary {
	s.Schedule = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Canary) SetStatus(v *CanaryStatus) *Canary {
	s.Status = v
	return s
}

// SetSuccessRetentionPeriodInDays sets the SuccessRetentionPeriodInDays field's value.
func (s *Canary) SetSuccessRetentionPeriodInDays(v int64) *Canary {
	s.SuccessRetentionPeriodInDays = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Canary) SetTags(v map[string]*string) *Canary {
	s.Tags = v
	return s
}

// SetTimeline sets the Timeline field's value.
func (s *Canary) SetTimeline(v *CanaryTimeline) *Canary {
	s.Timeline = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *Canary) SetVpcConfig(v *VpcConfigOutput) *Canary {
	s.VpcConfig = v
	return s
}

// Use this structure to input your script code for the canary. This structure
// contains the Lambda handler with the location where the canary should start
// running the script. If the script is stored in an S3 bucket, the bucket name,
// key, and version are also included. If the script was passed into the canary
// directly, the script code is contained in the value of Zipfile.
type CanaryCodeInput struct {
	_ struct{} `type:"structure"`

	// The entry point to use for the source code when running the canary. This
	// value must end with the string .handler.
	//
	// Handler is a required field
	Handler *string `min:"1" type:"string" required:"true"`

	// If your canary script is located in S3, specify the full bucket name here.
	// The bucket must already exist. Specify the full bucket name, including s3://
	// as the start of the bucket name.
	S3Bucket *string `min:"1" type:"string"`

	// The S3 key of your script. For more information, see Working with Amazon
	// S3 Objects (https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingObjects.html).
	S3Key *string `min:"1" type:"string"`

	// The S3 version ID of your script.
	S3Version *string `min:"1" type:"string"`

	// If you input your canary script directly into the canary instead of referring
	// to an S3 location, the value of this parameter is the .zip file that contains
	// the script. It can be up to 5 MB.
	//
	// ZipFile is automatically base64 encoded/decoded by the SDK.
	ZipFile []byte `min:"1" type:"blob"`
}

// String returns the string representation
func (s CanaryCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryCodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CanaryCodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CanaryCodeInput"}
	if s.Handler == nil {
		invalidParams.Add(request.NewErrParamRequired("Handler"))
	}
	if s.Handler != nil && len(*s.Handler) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Handler", 1))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 1))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}
	if s.S3Version != nil && len(*s.S3Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Version", 1))
	}
	if s.ZipFile != nil && len(s.ZipFile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ZipFile", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHandler sets the Handler field's value.
func (s *CanaryCodeInput) SetHandler(v string) *CanaryCodeInput {
	s.Handler = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *CanaryCodeInput) SetS3Bucket(v string) *CanaryCodeInput {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *CanaryCodeInput) SetS3Key(v string) *CanaryCodeInput {
	s.S3Key = &v
	return s
}

// SetS3Version sets the S3Version field's value.
func (s *CanaryCodeInput) SetS3Version(v string) *CanaryCodeInput {
	s.S3Version = &v
	return s
}

// SetZipFile sets the ZipFile field's value.
func (s *CanaryCodeInput) SetZipFile(v []byte) *CanaryCodeInput {
	s.ZipFile = v
	return s
}

// This structure contains information about the canary's Lambda handler and
// where its code is stored by CloudWatch Synthetics.
type CanaryCodeOutput struct {
	_ struct{} `type:"structure"`

	// The entry point to use for the source code when running the canary.
	Handler *string `min:"1" type:"string"`

	// The ARN of the Lambda layer where Synthetics stores the canary script code.
	SourceLocationArn *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CanaryCodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryCodeOutput) GoString() string {
	return s.String()
}

// SetHandler sets the Handler field's value.
func (s *CanaryCodeOutput) SetHandler(v string) *CanaryCodeOutput {
	s.Handler = &v
	return s
}

// SetSourceLocationArn sets the SourceLocationArn field's value.
func (s *CanaryCodeOutput) SetSourceLocationArn(v string) *CanaryCodeOutput {
	s.SourceLocationArn = &v
	return s
}

// This structure contains information about the most recent run of a single
// canary.
type CanaryLastRun struct {
	_ struct{} `type:"structure"`

	// The name of the canary.
	CanaryName *string `min:"1" type:"string"`

	// The results from this canary's most recent run.
	LastRun *CanaryRun `type:"structure"`
}

// String returns the string representation
func (s CanaryLastRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryLastRun) GoString() string {
	return s.String()
}

// SetCanaryName sets the CanaryName field's value.
func (s *CanaryLastRun) SetCanaryName(v string) *CanaryLastRun {
	s.CanaryName = &v
	return s
}

// SetLastRun sets the LastRun field's value.
func (s *CanaryLastRun) SetLastRun(v *CanaryRun) *CanaryLastRun {
	s.LastRun = v
	return s
}

// This structure contains the details about one run of one canary.
type CanaryRun struct {
	_ struct{} `type:"structure"`

	// The location where the canary stored artifacts from the run. Artifacts include
	// the log file, screenshots, and HAR files.
	ArtifactS3Location *string `min:"1" type:"string"`

	// The name of the canary.
	Name *string `min:"1" type:"string"`

	// The status of this run.
	Status *CanaryRunStatus `type:"structure"`

	// A structure that contains the start and end times of this run.
	Timeline *CanaryRunTimeline `type:"structure"`
}

// String returns the string representation
func (s CanaryRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryRun) GoString() string {
	return s.String()
}

// SetArtifactS3Location sets the ArtifactS3Location field's value.
func (s *CanaryRun) SetArtifactS3Location(v string) *CanaryRun {
	s.ArtifactS3Location = &v
	return s
}

// SetName sets the Name field's value.
func (s *CanaryRun) SetName(v string) *CanaryRun {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CanaryRun) SetStatus(v *CanaryRunStatus) *CanaryRun {
	s.Status = v
	return s
}

// SetTimeline sets the Timeline field's value.
func (s *CanaryRun) SetTimeline(v *CanaryRunTimeline) *CanaryRun {
	s.Timeline = v
	return s
}

// A structure that contains input information for a canary run.
type CanaryRunConfigInput struct {
	_ struct{} `type:"structure"`

	// The maximum amount of memory available to the canary while it is running,
	// in MB. The value you specify must be a multiple of 64.
	MemoryInMB *int64 `min:"960" type:"integer"`

	// How long the canary is allowed to run before it must stop. If you omit this
	// field, the frequency of the canary is used as this value, up to a maximum
	// of 14 minutes.
	//
	// TimeoutInSeconds is a required field
	TimeoutInSeconds *int64 `min:"60" type:"integer" required:"true"`
}

// String returns the string representation
func (s CanaryRunConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryRunConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CanaryRunConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CanaryRunConfigInput"}
	if s.MemoryInMB != nil && *s.MemoryInMB < 960 {
		invalidParams.Add(request.NewErrParamMinValue("MemoryInMB", 960))
	}
	if s.TimeoutInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeoutInSeconds"))
	}
	if s.TimeoutInSeconds != nil && *s.TimeoutInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("TimeoutInSeconds", 60))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMemoryInMB sets the MemoryInMB field's value.
func (s *CanaryRunConfigInput) SetMemoryInMB(v int64) *CanaryRunConfigInput {
	s.MemoryInMB = &v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *CanaryRunConfigInput) SetTimeoutInSeconds(v int64) *CanaryRunConfigInput {
	s.TimeoutInSeconds = &v
	return s
}

// A structure that contains information for a canary run.
type CanaryRunConfigOutput struct {
	_ struct{} `type:"structure"`

	// The maximum amount of memory available to the canary while it is running,
	// in MB. The value you must be a multiple of 64.
	MemoryInMB *int64 `min:"960" type:"integer"`

	// How long the canary is allowed to run before it must stop.
	TimeoutInSeconds *int64 `min:"60" type:"integer"`
}

// String returns the string representation
func (s CanaryRunConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryRunConfigOutput) GoString() string {
	return s.String()
}

// SetMemoryInMB sets the MemoryInMB field's value.
func (s *CanaryRunConfigOutput) SetMemoryInMB(v int64) *CanaryRunConfigOutput {
	s.MemoryInMB = &v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *CanaryRunConfigOutput) SetTimeoutInSeconds(v int64) *CanaryRunConfigOutput {
	s.TimeoutInSeconds = &v
	return s
}

// This structure contains the status information about a canary run.
type CanaryRunStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the run.
	State *string `type:"string" enum:"CanaryRunState"`

	// If run of the canary failed, this field contains the reason for the error.
	StateReason *string `min:"1" type:"string"`

	// If this value is CANARY_FAILURE, an exception occurred in the canary code.
	// If this value is EXECUTION_FAILURE, an exception occurred in CloudWatch Synthetics.
	StateReasonCode *string `type:"string" enum:"CanaryRunStateReasonCode"`
}

// String returns the string representation
func (s CanaryRunStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryRunStatus) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *CanaryRunStatus) SetState(v string) *CanaryRunStatus {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *CanaryRunStatus) SetStateReason(v string) *CanaryRunStatus {
	s.StateReason = &v
	return s
}

// SetStateReasonCode sets the StateReasonCode field's value.
func (s *CanaryRunStatus) SetStateReasonCode(v string) *CanaryRunStatus {
	s.StateReasonCode = &v
	return s
}

// This structure contains the start and end times of a single canary run.
type CanaryRunTimeline struct {
	_ struct{} `type:"structure"`

	// The end time of the run.
	Completed *time.Time `type:"timestamp"`

	// The start time of the run.
	Started *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CanaryRunTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryRunTimeline) GoString() string {
	return s.String()
}

// SetCompleted sets the Completed field's value.
func (s *CanaryRunTimeline) SetCompleted(v time.Time) *CanaryRunTimeline {
	s.Completed = &v
	return s
}

// SetStarted sets the Started field's value.
func (s *CanaryRunTimeline) SetStarted(v time.Time) *CanaryRunTimeline {
	s.Started = &v
	return s
}

// This structure specifies how often a canary is to make runs and the date
// and time when it should stop making runs.
type CanaryScheduleInput struct {
	_ struct{} `type:"structure"`

	// How long, in seconds, for the canary to continue making regular runs according
	// to the schedule in the Expression value. If you specify 0, the canary continues
	// making runs until you stop it. If you omit this field, the default of 0 is
	// used.
	DurationInSeconds *int64 `type:"long"`

	// A rate expression that defines how often the canary is to run. The syntax
	// is rate(number unit). unit can be minute, minutes, or hour.
	//
	// For example, rate(1 minute) runs the canary once a minute, rate(10 minutes)
	// runs it once every 10 minutes, and rate(1 hour) runs it once every hour.
	// You can specify a frequency between rate(1 minute) and rate(1 hour).
	//
	// Specifying rate(0 minute) or rate(0 hour) is a special value that causes
	// the canary to run only once when it is started.
	//
	// Expression is a required field
	Expression *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CanaryScheduleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryScheduleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CanaryScheduleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CanaryScheduleInput"}
	if s.Expression == nil {
		invalidParams.Add(request.NewErrParamRequired("Expression"))
	}
	if s.Expression != nil && len(*s.Expression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Expression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *CanaryScheduleInput) SetDurationInSeconds(v int64) *CanaryScheduleInput {
	s.DurationInSeconds = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *CanaryScheduleInput) SetExpression(v string) *CanaryScheduleInput {
	s.Expression = &v
	return s
}

// How long, in seconds, for the canary to continue making regular runs according
// to the schedule in the Expression value.
type CanaryScheduleOutput struct {
	_ struct{} `type:"structure"`

	// How long, in seconds, for the canary to continue making regular runs after
	// it was created. The runs are performed according to the schedule in the Expression
	// value.
	DurationInSeconds *int64 `type:"long"`

	// A rate expression that defines how often the canary is to run. The syntax
	// is rate(number unit). unit can be minute, minutes, or hour.
	//
	// For example, rate(1 minute) runs the canary once a minute, rate(10 minutes)
	// runs it once every 10 minutes, and rate(1 hour) runs it once every hour.
	//
	// Specifying rate(0 minute) or rate(0 hour) is a special value that causes
	// the canary to run only once when it is started.
	Expression *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CanaryScheduleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryScheduleOutput) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *CanaryScheduleOutput) SetDurationInSeconds(v int64) *CanaryScheduleOutput {
	s.DurationInSeconds = &v
	return s
}

// SetExpression sets the Expression field's value.
func (s *CanaryScheduleOutput) SetExpression(v string) *CanaryScheduleOutput {
	s.Expression = &v
	return s
}

// A structure that contains the current state of the canary.
type CanaryStatus struct {
	_ struct{} `type:"structure"`

	// The current state of the canary.
	State *string `type:"string" enum:"CanaryState"`

	// If the canary has insufficient permissions to run, this field provides more
	// details.
	StateReason *string `min:"1" type:"string"`

	// If the canary cannot run or has failed, this field displays the reason.
	StateReasonCode *string `type:"string" enum:"CanaryStateReasonCode"`
}

// String returns the string representation
func (s CanaryStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryStatus) GoString() string {
	return s.String()
}

// SetState sets the State field's value.
func (s *CanaryStatus) SetState(v string) *CanaryStatus {
	s.State = &v
	return s
}

// SetStateReason sets the StateReason field's value.
func (s *CanaryStatus) SetStateReason(v string) *CanaryStatus {
	s.StateReason = &v
	return s
}

// SetStateReasonCode sets the StateReasonCode field's value.
func (s *CanaryStatus) SetStateReasonCode(v string) *CanaryStatus {
	s.StateReasonCode = &v
	return s
}

// This structure contains information about when the canary was created and
// modified.
type CanaryTimeline struct {
	_ struct{} `type:"structure"`

	// The date and time the canary was created.
	Created *time.Time `type:"timestamp"`

	// The date and time the canary was most recently modified.
	LastModified *time.Time `type:"timestamp"`

	// The date and time that the canary's most recent run started.
	LastStarted *time.Time `type:"timestamp"`

	// The date and time that the canary's most recent run ended.
	LastStopped *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s CanaryTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CanaryTimeline) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *CanaryTimeline) SetCreated(v time.Time) *CanaryTimeline {
	s.Created = &v
	return s
}

// SetLastModified sets the LastModified field's value.
func (s *CanaryTimeline) SetLastModified(v time.Time) *CanaryTimeline {
	s.LastModified = &v
	return s
}

// SetLastStarted sets the LastStarted field's value.
func (s *CanaryTimeline) SetLastStarted(v time.Time) *CanaryTimeline {
	s.LastStarted = &v
	return s
}

// SetLastStopped sets the LastStopped field's value.
func (s *CanaryTimeline) SetLastStopped(v time.Time) *CanaryTimeline {
	s.LastStopped = &v
	return s
}

// A conflicting operation is already in progress.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateCanaryInput struct {
	_ struct{} `type:"structure"`

	// The location in Amazon S3 where Synthetics stores artifacts from the test
	// runs of this canary. Artifacts include the log file, screenshots, and HAR
	// files.
	//
	// ArtifactS3Location is a required field
	ArtifactS3Location *string `min:"1" type:"string" required:"true"`

	// A structure that includes the entry point from which the canary should start
	// running your script. If the script is stored in an S3 bucket, the bucket
	// name, key, and version are also included.
	//
	// Code is a required field
	Code *CanaryCodeInput `type:"structure" required:"true"`

	// The ARN of the IAM role to be used to run the canary. This role must already
	// exist, and must include lambda.amazonaws.com as a principal in the trust
	// policy. The role must also have the following permissions:
	//
	//    * s3:PutObject
	//
	//    * s3:GetBucketLocation
	//
	//    * s3:ListAllMyBuckets
	//
	//    * cloudwatch:PutMetricData
	//
	//    * logs:CreateLogGroup
	//
	//    * logs:CreateLogStream
	//
	//    * logs:CreateLogStream
	//
	// ExecutionRoleArn is a required field
	ExecutionRoleArn *string `type:"string" required:"true"`

	// The number of days to retain data about failed runs of this canary. If you
	// omit this field, the default of 31 days is used. The valid range is 1 to
	// 455 days.
	FailureRetentionPeriodInDays *int64 `min:"1" type:"integer"`

	// The name for this canary. Be sure to give it a descriptive name that distinguishes
	// it from other canaries in your account.
	//
	// Do not include secrets or proprietary information in your canary names. The
	// canary name makes up part of the canary ARN, and the ARN is included in outbound
	// calls over the internet. For more information, see Security Considerations
	// for Synthetics Canaries (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/servicelens_canaries_security.html).
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A structure that contains the configuration for individual canary runs, such
	// as timeout value.
	RunConfig *CanaryRunConfigInput `type:"structure"`

	// Specifies the runtime version to use for the canary. Currently, the only
	// valid value is syn-1.0. For more information about runtime versions, see
	// Canary Runtime Versions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
	//
	// RuntimeVersion is a required field
	RuntimeVersion *string `min:"1" type:"string" required:"true"`

	// A structure that contains information about how often the canary is to run
	// and when these test runs are to stop.
	//
	// Schedule is a required field
	Schedule *CanaryScheduleInput `type:"structure" required:"true"`

	// The number of days to retain data about successful runs of this canary. If
	// you omit this field, the default of 31 days is used. The valid range is 1
	// to 455 days.
	SuccessRetentionPeriodInDays *int64 `min:"1" type:"integer"`

	// A list of key-value pairs to associate with the canary. You can associate
	// as many as 50 tags with a canary.
	//
	// Tags can help you organize and categorize your resources. You can also use
	// them to scope user permissions, by granting a user permission to access or
	// change only the resources that have certain tag values.
	Tags map[string]*string `min:"1" type:"map"`

	// If this canary is to test an endpoint in a VPC, this structure contains information
	// about the subnet and security groups of the VPC endpoint. For more information,
	// see Running a Canary in a VPC (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
	VpcConfig *VpcConfigInput `type:"structure"`
}

// String returns the string representation
func (s CreateCanaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCanaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCanaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCanaryInput"}
	if s.ArtifactS3Location == nil {
		invalidParams.Add(request.NewErrParamRequired("ArtifactS3Location"))
	}
	if s.ArtifactS3Location != nil && len(*s.ArtifactS3Location) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ArtifactS3Location", 1))
	}
	if s.Code == nil {
		invalidParams.Add(request.NewErrParamRequired("Code"))
	}
	if s.ExecutionRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ExecutionRoleArn"))
	}
	if s.FailureRetentionPeriodInDays != nil && *s.FailureRetentionPeriodInDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FailureRetentionPeriodInDays", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RuntimeVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("RuntimeVersion"))
	}
	if s.RuntimeVersion != nil && len(*s.RuntimeVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuntimeVersion", 1))
	}
	if s.Schedule == nil {
		invalidParams.Add(request.NewErrParamRequired("Schedule"))
	}
	if s.SuccessRetentionPeriodInDays != nil && *s.SuccessRetentionPeriodInDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SuccessRetentionPeriodInDays", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Code != nil {
		if err := s.Code.Validate(); err != nil {
			invalidParams.AddNested("Code", err.(request.ErrInvalidParams))
		}
	}
	if s.RunConfig != nil {
		if err := s.RunConfig.Validate(); err != nil {
			invalidParams.AddNested("RunConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArtifactS3Location sets the ArtifactS3Location field's value.
func (s *CreateCanaryInput) SetArtifactS3Location(v string) *CreateCanaryInput {
	s.ArtifactS3Location = &v
	return s
}

// SetCode sets the Code field's value.
func (s *CreateCanaryInput) SetCode(v *CanaryCodeInput) *CreateCanaryInput {
	s.Code = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *CreateCanaryInput) SetExecutionRoleArn(v string) *CreateCanaryInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetFailureRetentionPeriodInDays sets the FailureRetentionPeriodInDays field's value.
func (s *CreateCanaryInput) SetFailureRetentionPeriodInDays(v int64) *CreateCanaryInput {
	s.FailureRetentionPeriodInDays = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateCanaryInput) SetName(v string) *CreateCanaryInput {
	s.Name = &v
	return s
}

// SetRunConfig sets the RunConfig field's value.
func (s *CreateCanaryInput) SetRunConfig(v *CanaryRunConfigInput) *CreateCanaryInput {
	s.RunConfig = v
	return s
}

// SetRuntimeVersion sets the RuntimeVersion field's value.
func (s *CreateCanaryInput) SetRuntimeVersion(v string) *CreateCanaryInput {
	s.RuntimeVersion = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateCanaryInput) SetSchedule(v *CanaryScheduleInput) *CreateCanaryInput {
	s.Schedule = v
	return s
}

// SetSuccessRetentionPeriodInDays sets the SuccessRetentionPeriodInDays field's value.
func (s *CreateCanaryInput) SetSuccessRetentionPeriodInDays(v int64) *CreateCanaryInput {
	s.SuccessRetentionPeriodInDays = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateCanaryInput) SetTags(v map[string]*string) *CreateCanaryInput {
	s.Tags = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateCanaryInput) SetVpcConfig(v *VpcConfigInput) *CreateCanaryInput {
	s.VpcConfig = v
	return s
}

type CreateCanaryOutput struct {
	_ struct{} `type:"structure"`

	// The full details about the canary you have created.
	Canary *Canary `type:"structure"`
}

// String returns the string representation
func (s CreateCanaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCanaryOutput) GoString() string {
	return s.String()
}

// SetCanary sets the Canary field's value.
func (s *CreateCanaryOutput) SetCanary(v *Canary) *CreateCanaryOutput {
	s.Canary = v
	return s
}

type DeleteCanaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the canary that you want to delete. To find the names of your
	// canaries, use DescribeCanaries (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html).
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCanaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCanaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCanaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCanaryInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteCanaryInput) SetName(v string) *DeleteCanaryInput {
	s.Name = &v
	return s
}

type DeleteCanaryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCanaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCanaryOutput) GoString() string {
	return s.String()
}

type DescribeCanariesInput struct {
	_ struct{} `type:"structure"`

	// Specify this parameter to limit how many canaries are returned each time
	// you use the DescribeCanaries operation. If you omit this parameter, the default
	// of 100 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent operation to retrieve the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeCanariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCanariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCanariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCanariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeCanariesInput) SetMaxResults(v int64) *DescribeCanariesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCanariesInput) SetNextToken(v string) *DescribeCanariesInput {
	s.NextToken = &v
	return s
}

type DescribeCanariesLastRunInput struct {
	_ struct{} `type:"structure"`

	// Specify this parameter to limit how many runs are returned each time you
	// use the DescribeLastRun operation. If you omit this parameter, the default
	// of 100 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent DescribeCanaries operation to retrieve the next set
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeCanariesLastRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCanariesLastRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCanariesLastRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCanariesLastRunInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeCanariesLastRunInput) SetMaxResults(v int64) *DescribeCanariesLastRunInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCanariesLastRunInput) SetNextToken(v string) *DescribeCanariesLastRunInput {
	s.NextToken = &v
	return s
}

type DescribeCanariesLastRunOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains the information from the most recent run of each canary.
	CanariesLastRun []*CanaryLastRun `type:"list"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent DescribeCanariesLastRun operation to retrieve the next
	// set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeCanariesLastRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCanariesLastRunOutput) GoString() string {
	return s.String()
}

// SetCanariesLastRun sets the CanariesLastRun field's value.
func (s *DescribeCanariesLastRunOutput) SetCanariesLastRun(v []*CanaryLastRun) *DescribeCanariesLastRunOutput {
	s.CanariesLastRun = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCanariesLastRunOutput) SetNextToken(v string) *DescribeCanariesLastRunOutput {
	s.NextToken = &v
	return s
}

type DescribeCanariesOutput struct {
	_ struct{} `type:"structure"`

	// Returns an array. Each item in the array contains the full information about
	// one canary.
	Canaries []*Canary `type:"list"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent DescribeCanaries operation to retrieve the next set
	// of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeCanariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCanariesOutput) GoString() string {
	return s.String()
}

// SetCanaries sets the Canaries field's value.
func (s *DescribeCanariesOutput) SetCanaries(v []*Canary) *DescribeCanariesOutput {
	s.Canaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeCanariesOutput) SetNextToken(v string) *DescribeCanariesOutput {
	s.NextToken = &v
	return s
}

type DescribeRuntimeVersionsInput struct {
	_ struct{} `type:"structure"`

	// Specify this parameter to limit how many runs are returned each time you
	// use the DescribeRuntimeVersions operation. If you omit this parameter, the
	// default of 100 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent DescribeRuntimeVersions operation to retrieve the next
	// set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeRuntimeVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuntimeVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRuntimeVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRuntimeVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeRuntimeVersionsInput) SetMaxResults(v int64) *DescribeRuntimeVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRuntimeVersionsInput) SetNextToken(v string) *DescribeRuntimeVersionsInput {
	s.NextToken = &v
	return s
}

type DescribeRuntimeVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent DescribeRuntimeVersions operation to retrieve the next
	// set of results.
	NextToken *string `type:"string"`

	// An array of objects that display the details about each Synthetics canary
	// runtime version.
	RuntimeVersions []*RuntimeVersion `type:"list"`
}

// String returns the string representation
func (s DescribeRuntimeVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRuntimeVersionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeRuntimeVersionsOutput) SetNextToken(v string) *DescribeRuntimeVersionsOutput {
	s.NextToken = &v
	return s
}

// SetRuntimeVersions sets the RuntimeVersions field's value.
func (s *DescribeRuntimeVersionsOutput) SetRuntimeVersions(v []*RuntimeVersion) *DescribeRuntimeVersionsOutput {
	s.RuntimeVersions = v
	return s
}

type GetCanaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the canary that you want details for.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetCanaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCanaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCanaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCanaryInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetCanaryInput) SetName(v string) *GetCanaryInput {
	s.Name = &v
	return s
}

type GetCanaryOutput struct {
	_ struct{} `type:"structure"`

	// A strucure that contains the full information about the canary.
	Canary *Canary `type:"structure"`
}

// String returns the string representation
func (s GetCanaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCanaryOutput) GoString() string {
	return s.String()
}

// SetCanary sets the Canary field's value.
func (s *GetCanaryOutput) SetCanary(v *Canary) *GetCanaryOutput {
	s.Canary = v
	return s
}

type GetCanaryRunsInput struct {
	_ struct{} `type:"structure"`

	// Specify this parameter to limit how many runs are returned each time you
	// use the GetCanaryRuns operation. If you omit this parameter, the default
	// of 100 is used.
	MaxResults *int64 `min:"1" type:"integer"`

	// The name of the canary that you want to see runs for.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent GetCanaryRuns operation to retrieve the next set of
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCanaryRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCanaryRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCanaryRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCanaryRunsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetCanaryRunsInput) SetMaxResults(v int64) *GetCanaryRunsInput {
	s.MaxResults = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetCanaryRunsInput) SetName(v string) *GetCanaryRunsInput {
	s.Name = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCanaryRunsInput) SetNextToken(v string) *GetCanaryRunsInput {
	s.NextToken = &v
	return s
}

type GetCanaryRunsOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures. Each structure contains the details of one of the
	// retrieved canary runs.
	CanaryRuns []*CanaryRun `type:"list"`

	// A token that indicates that there is more data available. You can use this
	// token in a subsequent GetCanaryRuns operation to retrieve the next set of
	// results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s GetCanaryRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCanaryRunsOutput) GoString() string {
	return s.String()
}

// SetCanaryRuns sets the CanaryRuns field's value.
func (s *GetCanaryRunsOutput) SetCanaryRuns(v []*CanaryRun) *GetCanaryRunsOutput {
	s.CanaryRuns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetCanaryRunsOutput) SetNextToken(v string) *GetCanaryRunsOutput {
	s.NextToken = &v
	return s
}

// An unknown internal error occurred.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the canary that you want to view tags for.
	//
	// The ARN format of a canary is arn:aws:synthetics:Region:account-id:canary:canary-name .
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tag keys and values associated with the canary that you specified.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// One of the specified resources was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This structure contains information about one canary runtime version. For
// more information about runtime versions, see Canary Runtime Versions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
type RuntimeVersion struct {
	_ struct{} `type:"structure"`

	// If this runtime version is deprecated, this value is the date of deprecation.
	DeprecationDate *time.Time `type:"timestamp"`

	// A description of the runtime version, created by Amazon.
	Description *string `min:"1" type:"string"`

	// The date that the runtime version was released.
	ReleaseDate *time.Time `type:"timestamp"`

	// The name of the runtime version. Currently, the only valid value is syn-1.0.
	//
	// Specifies the runtime version to use for the canary. Currently, the only
	// valid value is syn-1.0.
	VersionName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s RuntimeVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuntimeVersion) GoString() string {
	return s.String()
}

// SetDeprecationDate sets the DeprecationDate field's value.
func (s *RuntimeVersion) SetDeprecationDate(v time.Time) *RuntimeVersion {
	s.DeprecationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RuntimeVersion) SetDescription(v string) *RuntimeVersion {
	s.Description = &v
	return s
}

// SetReleaseDate sets the ReleaseDate field's value.
func (s *RuntimeVersion) SetReleaseDate(v time.Time) *RuntimeVersion {
	s.ReleaseDate = &v
	return s
}

// SetVersionName sets the VersionName field's value.
func (s *RuntimeVersion) SetVersionName(v string) *RuntimeVersion {
	s.VersionName = &v
	return s
}

type StartCanaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the canary that you want to run. To find canary names, use DescribeCanaries
	// (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html).
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartCanaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartCanaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCanaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCanaryInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StartCanaryInput) SetName(v string) *StartCanaryInput {
	s.Name = &v
	return s
}

type StartCanaryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartCanaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartCanaryOutput) GoString() string {
	return s.String()
}

type StopCanaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the canary that you want to stop. To find the names of your canaries,
	// use DescribeCanaries (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html).
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StopCanaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopCanaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopCanaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopCanaryInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *StopCanaryInput) SetName(v string) *StopCanaryInput {
	s.Name = &v
	return s
}

type StopCanaryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopCanaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopCanaryOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the canary that you're adding tags to.
	//
	// The ARN format of a canary is arn:aws:synthetics:Region:account-id:canary:canary-name .
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The list of key-value pairs to associate with the canary.
	//
	// Tags is a required field
	Tags map[string]*string `min:"1" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the canary that you're removing tags from.
	//
	// The ARN format of a canary is arn:aws:synthetics:Region:account-id:canary:canary-name .
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The list of tag keys to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCanaryInput struct {
	_ struct{} `type:"structure"`

	// A structure that includes the entry point from which the canary should start
	// running your script. If the script is stored in an S3 bucket, the bucket
	// name, key, and version are also included.
	Code *CanaryCodeInput `type:"structure"`

	// The ARN of the IAM role to be used to run the canary. This role must already
	// exist, and must include lambda.amazonaws.com as a principal in the trust
	// policy. The role must also have the following permissions:
	//
	//    * s3:PutObject
	//
	//    * s3:GetBucketLocation
	//
	//    * s3:ListAllMyBuckets
	//
	//    * cloudwatch:PutMetricData
	//
	//    * logs:CreateLogGroup
	//
	//    * logs:CreateLogStream
	//
	//    * logs:CreateLogStream
	ExecutionRoleArn *string `type:"string"`

	// The number of days to retain data about failed runs of this canary.
	FailureRetentionPeriodInDays *int64 `min:"1" type:"integer"`

	// The name of the canary that you want to update. To find the names of your
	// canaries, use DescribeCanaries (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html).
	//
	// You cannot change the name of a canary that has already been created.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`

	// A structure that contains the timeout value that is used for each individual
	// run of the canary.
	RunConfig *CanaryRunConfigInput `type:"structure"`

	// Specifies the runtime version to use for the canary. Currently, the only
	// valid value is syn-1.0. For more information about runtime versions, see
	// Canary Runtime Versions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_Library.html).
	RuntimeVersion *string `min:"1" type:"string"`

	// A structure that contains information about how often the canary is to run,
	// and when these runs are to stop.
	Schedule *CanaryScheduleInput `type:"structure"`

	// The number of days to retain data about successful runs of this canary.
	SuccessRetentionPeriodInDays *int64 `min:"1" type:"integer"`

	// If this canary is to test an endpoint in a VPC, this structure contains information
	// about the subnet and security groups of the VPC endpoint. For more information,
	// see Running a Canary in a VPC (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
	VpcConfig *VpcConfigInput `type:"structure"`
}

// String returns the string representation
func (s UpdateCanaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCanaryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCanaryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCanaryInput"}
	if s.FailureRetentionPeriodInDays != nil && *s.FailureRetentionPeriodInDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FailureRetentionPeriodInDays", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RuntimeVersion != nil && len(*s.RuntimeVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuntimeVersion", 1))
	}
	if s.SuccessRetentionPeriodInDays != nil && *s.SuccessRetentionPeriodInDays < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SuccessRetentionPeriodInDays", 1))
	}
	if s.Code != nil {
		if err := s.Code.Validate(); err != nil {
			invalidParams.AddNested("Code", err.(request.ErrInvalidParams))
		}
	}
	if s.RunConfig != nil {
		if err := s.RunConfig.Validate(); err != nil {
			invalidParams.AddNested("RunConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Schedule != nil {
		if err := s.Schedule.Validate(); err != nil {
			invalidParams.AddNested("Schedule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCode sets the Code field's value.
func (s *UpdateCanaryInput) SetCode(v *CanaryCodeInput) *UpdateCanaryInput {
	s.Code = v
	return s
}

// SetExecutionRoleArn sets the ExecutionRoleArn field's value.
func (s *UpdateCanaryInput) SetExecutionRoleArn(v string) *UpdateCanaryInput {
	s.ExecutionRoleArn = &v
	return s
}

// SetFailureRetentionPeriodInDays sets the FailureRetentionPeriodInDays field's value.
func (s *UpdateCanaryInput) SetFailureRetentionPeriodInDays(v int64) *UpdateCanaryInput {
	s.FailureRetentionPeriodInDays = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateCanaryInput) SetName(v string) *UpdateCanaryInput {
	s.Name = &v
	return s
}

// SetRunConfig sets the RunConfig field's value.
func (s *UpdateCanaryInput) SetRunConfig(v *CanaryRunConfigInput) *UpdateCanaryInput {
	s.RunConfig = v
	return s
}

// SetRuntimeVersion sets the RuntimeVersion field's value.
func (s *UpdateCanaryInput) SetRuntimeVersion(v string) *UpdateCanaryInput {
	s.RuntimeVersion = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *UpdateCanaryInput) SetSchedule(v *CanaryScheduleInput) *UpdateCanaryInput {
	s.Schedule = v
	return s
}

// SetSuccessRetentionPeriodInDays sets the SuccessRetentionPeriodInDays field's value.
func (s *UpdateCanaryInput) SetSuccessRetentionPeriodInDays(v int64) *UpdateCanaryInput {
	s.SuccessRetentionPeriodInDays = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *UpdateCanaryInput) SetVpcConfig(v *VpcConfigInput) *UpdateCanaryInput {
	s.VpcConfig = v
	return s
}

type UpdateCanaryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCanaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateCanaryOutput) GoString() string {
	return s.String()
}

// A parameter could not be validated.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// If this canary is to test an endpoint in a VPC, this structure contains information
// about the subnets and security groups of the VPC endpoint. For more information,
// see Running a Canary in a VPC (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
type VpcConfigInput struct {
	_ struct{} `type:"structure"`

	// The IDs of the security groups for this canary.
	SecurityGroupIds []*string `type:"list"`

	// The IDs of the subnets where this canary is to run.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s VpcConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfigInput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigInput) SetSecurityGroupIds(v []*string) *VpcConfigInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigInput) SetSubnetIds(v []*string) *VpcConfigInput {
	s.SubnetIds = v
	return s
}

// If this canary is to test an endpoint in a VPC, this structure contains information
// about the subnets and security groups of the VPC endpoint. For more information,
// see Running a Canary in a VPC (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_VPC.html).
type VpcConfigOutput struct {
	_ struct{} `type:"structure"`

	// The IDs of the security groups for this canary.
	SecurityGroupIds []*string `type:"list"`

	// The IDs of the subnets where this canary is to run.
	SubnetIds []*string `type:"list"`

	// The IDs of the VPC where this canary is to run.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s VpcConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcConfigOutput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigOutput) SetSecurityGroupIds(v []*string) *VpcConfigOutput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigOutput) SetSubnetIds(v []*string) *VpcConfigOutput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfigOutput) SetVpcId(v string) *VpcConfigOutput {
	s.VpcId = &v
	return s
}

const (
	// CanaryRunStateRunning is a CanaryRunState enum value
	CanaryRunStateRunning = "RUNNING"

	// CanaryRunStatePassed is a CanaryRunState enum value
	CanaryRunStatePassed = "PASSED"

	// CanaryRunStateFailed is a CanaryRunState enum value
	CanaryRunStateFailed = "FAILED"
)

// CanaryRunState_Values returns all elements of the CanaryRunState enum
func CanaryRunState_Values() []string {
	return []string{
		CanaryRunStateRunning,
		CanaryRunStatePassed,
		CanaryRunStateFailed,
	}
}

const (
	// CanaryRunStateReasonCodeCanaryFailure is a CanaryRunStateReasonCode enum value
	CanaryRunStateReasonCodeCanaryFailure = "CANARY_FAILURE"

	// CanaryRunStateReasonCodeExecutionFailure is a CanaryRunStateReasonCode enum value
	CanaryRunStateReasonCodeExecutionFailure = "EXECUTION_FAILURE"
)

// CanaryRunStateReasonCode_Values returns all elements of the CanaryRunStateReasonCode enum
func CanaryRunStateReasonCode_Values() []string {
	return []string{
		CanaryRunStateReasonCodeCanaryFailure,
		CanaryRunStateReasonCodeExecutionFailure,
	}
}

const (
	// CanaryStateCreating is a CanaryState enum value
	CanaryStateCreating = "CREATING"

	// CanaryStateReady is a CanaryState enum value
	CanaryStateReady = "READY"

	// CanaryStateStarting is a CanaryState enum value
	CanaryStateStarting = "STARTING"

	// CanaryStateRunning is a CanaryState enum value
	CanaryStateRunning = "RUNNING"

	// CanaryStateUpdating is a CanaryState enum value
	CanaryStateUpdating = "UPDATING"

	// CanaryStateStopping is a CanaryState enum value
	CanaryStateStopping = "STOPPING"

	// CanaryStateStopped is a CanaryState enum value
	CanaryStateStopped = "STOPPED"

	// CanaryStateError is a CanaryState enum value
	CanaryStateError = "ERROR"

	// CanaryStateDeleting is a CanaryState enum value
	CanaryStateDeleting = "DELETING"
)

// CanaryState_Values returns all elements of the CanaryState enum
func CanaryState_Values() []string {
	return []string{
		CanaryStateCreating,
		CanaryStateReady,
		CanaryStateStarting,
		CanaryStateRunning,
		CanaryStateUpdating,
		CanaryStateStopping,
		CanaryStateStopped,
		CanaryStateError,
		CanaryStateDeleting,
	}
}

const (
	// CanaryStateReasonCodeInvalidPermissions is a CanaryStateReasonCode enum value
	CanaryStateReasonCodeInvalidPermissions = "INVALID_PERMISSIONS"
)

// CanaryStateReasonCode_Values returns all elements of the CanaryStateReasonCode enum
func CanaryStateReasonCode_Values() []string {
	return []string{
		CanaryStateReasonCodeInvalidPermissions,
	}
}
