// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ssoadminiface provides an interface to enable mocking the AWS Single Sign-On Admin service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ssoadminiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/ssoadmin"
)

// SSOAdminAPI provides an interface to enable mocking the
// ssoadmin.SSOAdmin service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Single Sign-On Admin.
//    func myFunc(svc ssoadminiface.SSOAdminAPI) bool {
//        // Make svc.AttachManagedPolicyToPermissionSet request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := ssoadmin.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockSSOAdminClient struct {
//        ssoadminiface.SSOAdminAPI
//    }
//    func (m *mockSSOAdminClient) AttachManagedPolicyToPermissionSet(input *ssoadmin.AttachManagedPolicyToPermissionSetInput) (*ssoadmin.AttachManagedPolicyToPermissionSetOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockSSOAdminClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SSOAdminAPI interface {
	AttachManagedPolicyToPermissionSet(*ssoadmin.AttachManagedPolicyToPermissionSetInput) (*ssoadmin.AttachManagedPolicyToPermissionSetOutput, error)
	AttachManagedPolicyToPermissionSetWithContext(aws.Context, *ssoadmin.AttachManagedPolicyToPermissionSetInput, ...request.Option) (*ssoadmin.AttachManagedPolicyToPermissionSetOutput, error)
	AttachManagedPolicyToPermissionSetRequest(*ssoadmin.AttachManagedPolicyToPermissionSetInput) (*request.Request, *ssoadmin.AttachManagedPolicyToPermissionSetOutput)

	CreateAccountAssignment(*ssoadmin.CreateAccountAssignmentInput) (*ssoadmin.CreateAccountAssignmentOutput, error)
	CreateAccountAssignmentWithContext(aws.Context, *ssoadmin.CreateAccountAssignmentInput, ...request.Option) (*ssoadmin.CreateAccountAssignmentOutput, error)
	CreateAccountAssignmentRequest(*ssoadmin.CreateAccountAssignmentInput) (*request.Request, *ssoadmin.CreateAccountAssignmentOutput)

	CreatePermissionSet(*ssoadmin.CreatePermissionSetInput) (*ssoadmin.CreatePermissionSetOutput, error)
	CreatePermissionSetWithContext(aws.Context, *ssoadmin.CreatePermissionSetInput, ...request.Option) (*ssoadmin.CreatePermissionSetOutput, error)
	CreatePermissionSetRequest(*ssoadmin.CreatePermissionSetInput) (*request.Request, *ssoadmin.CreatePermissionSetOutput)

	DeleteAccountAssignment(*ssoadmin.DeleteAccountAssignmentInput) (*ssoadmin.DeleteAccountAssignmentOutput, error)
	DeleteAccountAssignmentWithContext(aws.Context, *ssoadmin.DeleteAccountAssignmentInput, ...request.Option) (*ssoadmin.DeleteAccountAssignmentOutput, error)
	DeleteAccountAssignmentRequest(*ssoadmin.DeleteAccountAssignmentInput) (*request.Request, *ssoadmin.DeleteAccountAssignmentOutput)

	DeleteInlinePolicyFromPermissionSet(*ssoadmin.DeleteInlinePolicyFromPermissionSetInput) (*ssoadmin.DeleteInlinePolicyFromPermissionSetOutput, error)
	DeleteInlinePolicyFromPermissionSetWithContext(aws.Context, *ssoadmin.DeleteInlinePolicyFromPermissionSetInput, ...request.Option) (*ssoadmin.DeleteInlinePolicyFromPermissionSetOutput, error)
	DeleteInlinePolicyFromPermissionSetRequest(*ssoadmin.DeleteInlinePolicyFromPermissionSetInput) (*request.Request, *ssoadmin.DeleteInlinePolicyFromPermissionSetOutput)

	DeletePermissionSet(*ssoadmin.DeletePermissionSetInput) (*ssoadmin.DeletePermissionSetOutput, error)
	DeletePermissionSetWithContext(aws.Context, *ssoadmin.DeletePermissionSetInput, ...request.Option) (*ssoadmin.DeletePermissionSetOutput, error)
	DeletePermissionSetRequest(*ssoadmin.DeletePermissionSetInput) (*request.Request, *ssoadmin.DeletePermissionSetOutput)

	DescribeAccountAssignmentCreationStatus(*ssoadmin.DescribeAccountAssignmentCreationStatusInput) (*ssoadmin.DescribeAccountAssignmentCreationStatusOutput, error)
	DescribeAccountAssignmentCreationStatusWithContext(aws.Context, *ssoadmin.DescribeAccountAssignmentCreationStatusInput, ...request.Option) (*ssoadmin.DescribeAccountAssignmentCreationStatusOutput, error)
	DescribeAccountAssignmentCreationStatusRequest(*ssoadmin.DescribeAccountAssignmentCreationStatusInput) (*request.Request, *ssoadmin.DescribeAccountAssignmentCreationStatusOutput)

	DescribeAccountAssignmentDeletionStatus(*ssoadmin.DescribeAccountAssignmentDeletionStatusInput) (*ssoadmin.DescribeAccountAssignmentDeletionStatusOutput, error)
	DescribeAccountAssignmentDeletionStatusWithContext(aws.Context, *ssoadmin.DescribeAccountAssignmentDeletionStatusInput, ...request.Option) (*ssoadmin.DescribeAccountAssignmentDeletionStatusOutput, error)
	DescribeAccountAssignmentDeletionStatusRequest(*ssoadmin.DescribeAccountAssignmentDeletionStatusInput) (*request.Request, *ssoadmin.DescribeAccountAssignmentDeletionStatusOutput)

	DescribePermissionSet(*ssoadmin.DescribePermissionSetInput) (*ssoadmin.DescribePermissionSetOutput, error)
	DescribePermissionSetWithContext(aws.Context, *ssoadmin.DescribePermissionSetInput, ...request.Option) (*ssoadmin.DescribePermissionSetOutput, error)
	DescribePermissionSetRequest(*ssoadmin.DescribePermissionSetInput) (*request.Request, *ssoadmin.DescribePermissionSetOutput)

	DescribePermissionSetProvisioningStatus(*ssoadmin.DescribePermissionSetProvisioningStatusInput) (*ssoadmin.DescribePermissionSetProvisioningStatusOutput, error)
	DescribePermissionSetProvisioningStatusWithContext(aws.Context, *ssoadmin.DescribePermissionSetProvisioningStatusInput, ...request.Option) (*ssoadmin.DescribePermissionSetProvisioningStatusOutput, error)
	DescribePermissionSetProvisioningStatusRequest(*ssoadmin.DescribePermissionSetProvisioningStatusInput) (*request.Request, *ssoadmin.DescribePermissionSetProvisioningStatusOutput)

	DetachManagedPolicyFromPermissionSet(*ssoadmin.DetachManagedPolicyFromPermissionSetInput) (*ssoadmin.DetachManagedPolicyFromPermissionSetOutput, error)
	DetachManagedPolicyFromPermissionSetWithContext(aws.Context, *ssoadmin.DetachManagedPolicyFromPermissionSetInput, ...request.Option) (*ssoadmin.DetachManagedPolicyFromPermissionSetOutput, error)
	DetachManagedPolicyFromPermissionSetRequest(*ssoadmin.DetachManagedPolicyFromPermissionSetInput) (*request.Request, *ssoadmin.DetachManagedPolicyFromPermissionSetOutput)

	GetInlinePolicyForPermissionSet(*ssoadmin.GetInlinePolicyForPermissionSetInput) (*ssoadmin.GetInlinePolicyForPermissionSetOutput, error)
	GetInlinePolicyForPermissionSetWithContext(aws.Context, *ssoadmin.GetInlinePolicyForPermissionSetInput, ...request.Option) (*ssoadmin.GetInlinePolicyForPermissionSetOutput, error)
	GetInlinePolicyForPermissionSetRequest(*ssoadmin.GetInlinePolicyForPermissionSetInput) (*request.Request, *ssoadmin.GetInlinePolicyForPermissionSetOutput)

	ListAccountAssignmentCreationStatus(*ssoadmin.ListAccountAssignmentCreationStatusInput) (*ssoadmin.ListAccountAssignmentCreationStatusOutput, error)
	ListAccountAssignmentCreationStatusWithContext(aws.Context, *ssoadmin.ListAccountAssignmentCreationStatusInput, ...request.Option) (*ssoadmin.ListAccountAssignmentCreationStatusOutput, error)
	ListAccountAssignmentCreationStatusRequest(*ssoadmin.ListAccountAssignmentCreationStatusInput) (*request.Request, *ssoadmin.ListAccountAssignmentCreationStatusOutput)

	ListAccountAssignmentCreationStatusPages(*ssoadmin.ListAccountAssignmentCreationStatusInput, func(*ssoadmin.ListAccountAssignmentCreationStatusOutput, bool) bool) error
	ListAccountAssignmentCreationStatusPagesWithContext(aws.Context, *ssoadmin.ListAccountAssignmentCreationStatusInput, func(*ssoadmin.ListAccountAssignmentCreationStatusOutput, bool) bool, ...request.Option) error

	ListAccountAssignmentDeletionStatus(*ssoadmin.ListAccountAssignmentDeletionStatusInput) (*ssoadmin.ListAccountAssignmentDeletionStatusOutput, error)
	ListAccountAssignmentDeletionStatusWithContext(aws.Context, *ssoadmin.ListAccountAssignmentDeletionStatusInput, ...request.Option) (*ssoadmin.ListAccountAssignmentDeletionStatusOutput, error)
	ListAccountAssignmentDeletionStatusRequest(*ssoadmin.ListAccountAssignmentDeletionStatusInput) (*request.Request, *ssoadmin.ListAccountAssignmentDeletionStatusOutput)

	ListAccountAssignmentDeletionStatusPages(*ssoadmin.ListAccountAssignmentDeletionStatusInput, func(*ssoadmin.ListAccountAssignmentDeletionStatusOutput, bool) bool) error
	ListAccountAssignmentDeletionStatusPagesWithContext(aws.Context, *ssoadmin.ListAccountAssignmentDeletionStatusInput, func(*ssoadmin.ListAccountAssignmentDeletionStatusOutput, bool) bool, ...request.Option) error

	ListAccountAssignments(*ssoadmin.ListAccountAssignmentsInput) (*ssoadmin.ListAccountAssignmentsOutput, error)
	ListAccountAssignmentsWithContext(aws.Context, *ssoadmin.ListAccountAssignmentsInput, ...request.Option) (*ssoadmin.ListAccountAssignmentsOutput, error)
	ListAccountAssignmentsRequest(*ssoadmin.ListAccountAssignmentsInput) (*request.Request, *ssoadmin.ListAccountAssignmentsOutput)

	ListAccountAssignmentsPages(*ssoadmin.ListAccountAssignmentsInput, func(*ssoadmin.ListAccountAssignmentsOutput, bool) bool) error
	ListAccountAssignmentsPagesWithContext(aws.Context, *ssoadmin.ListAccountAssignmentsInput, func(*ssoadmin.ListAccountAssignmentsOutput, bool) bool, ...request.Option) error

	ListAccountsForProvisionedPermissionSet(*ssoadmin.ListAccountsForProvisionedPermissionSetInput) (*ssoadmin.ListAccountsForProvisionedPermissionSetOutput, error)
	ListAccountsForProvisionedPermissionSetWithContext(aws.Context, *ssoadmin.ListAccountsForProvisionedPermissionSetInput, ...request.Option) (*ssoadmin.ListAccountsForProvisionedPermissionSetOutput, error)
	ListAccountsForProvisionedPermissionSetRequest(*ssoadmin.ListAccountsForProvisionedPermissionSetInput) (*request.Request, *ssoadmin.ListAccountsForProvisionedPermissionSetOutput)

	ListAccountsForProvisionedPermissionSetPages(*ssoadmin.ListAccountsForProvisionedPermissionSetInput, func(*ssoadmin.ListAccountsForProvisionedPermissionSetOutput, bool) bool) error
	ListAccountsForProvisionedPermissionSetPagesWithContext(aws.Context, *ssoadmin.ListAccountsForProvisionedPermissionSetInput, func(*ssoadmin.ListAccountsForProvisionedPermissionSetOutput, bool) bool, ...request.Option) error

	ListInstances(*ssoadmin.ListInstancesInput) (*ssoadmin.ListInstancesOutput, error)
	ListInstancesWithContext(aws.Context, *ssoadmin.ListInstancesInput, ...request.Option) (*ssoadmin.ListInstancesOutput, error)
	ListInstancesRequest(*ssoadmin.ListInstancesInput) (*request.Request, *ssoadmin.ListInstancesOutput)

	ListInstancesPages(*ssoadmin.ListInstancesInput, func(*ssoadmin.ListInstancesOutput, bool) bool) error
	ListInstancesPagesWithContext(aws.Context, *ssoadmin.ListInstancesInput, func(*ssoadmin.ListInstancesOutput, bool) bool, ...request.Option) error

	ListManagedPoliciesInPermissionSet(*ssoadmin.ListManagedPoliciesInPermissionSetInput) (*ssoadmin.ListManagedPoliciesInPermissionSetOutput, error)
	ListManagedPoliciesInPermissionSetWithContext(aws.Context, *ssoadmin.ListManagedPoliciesInPermissionSetInput, ...request.Option) (*ssoadmin.ListManagedPoliciesInPermissionSetOutput, error)
	ListManagedPoliciesInPermissionSetRequest(*ssoadmin.ListManagedPoliciesInPermissionSetInput) (*request.Request, *ssoadmin.ListManagedPoliciesInPermissionSetOutput)

	ListManagedPoliciesInPermissionSetPages(*ssoadmin.ListManagedPoliciesInPermissionSetInput, func(*ssoadmin.ListManagedPoliciesInPermissionSetOutput, bool) bool) error
	ListManagedPoliciesInPermissionSetPagesWithContext(aws.Context, *ssoadmin.ListManagedPoliciesInPermissionSetInput, func(*ssoadmin.ListManagedPoliciesInPermissionSetOutput, bool) bool, ...request.Option) error

	ListPermissionSetProvisioningStatus(*ssoadmin.ListPermissionSetProvisioningStatusInput) (*ssoadmin.ListPermissionSetProvisioningStatusOutput, error)
	ListPermissionSetProvisioningStatusWithContext(aws.Context, *ssoadmin.ListPermissionSetProvisioningStatusInput, ...request.Option) (*ssoadmin.ListPermissionSetProvisioningStatusOutput, error)
	ListPermissionSetProvisioningStatusRequest(*ssoadmin.ListPermissionSetProvisioningStatusInput) (*request.Request, *ssoadmin.ListPermissionSetProvisioningStatusOutput)

	ListPermissionSetProvisioningStatusPages(*ssoadmin.ListPermissionSetProvisioningStatusInput, func(*ssoadmin.ListPermissionSetProvisioningStatusOutput, bool) bool) error
	ListPermissionSetProvisioningStatusPagesWithContext(aws.Context, *ssoadmin.ListPermissionSetProvisioningStatusInput, func(*ssoadmin.ListPermissionSetProvisioningStatusOutput, bool) bool, ...request.Option) error

	ListPermissionSets(*ssoadmin.ListPermissionSetsInput) (*ssoadmin.ListPermissionSetsOutput, error)
	ListPermissionSetsWithContext(aws.Context, *ssoadmin.ListPermissionSetsInput, ...request.Option) (*ssoadmin.ListPermissionSetsOutput, error)
	ListPermissionSetsRequest(*ssoadmin.ListPermissionSetsInput) (*request.Request, *ssoadmin.ListPermissionSetsOutput)

	ListPermissionSetsPages(*ssoadmin.ListPermissionSetsInput, func(*ssoadmin.ListPermissionSetsOutput, bool) bool) error
	ListPermissionSetsPagesWithContext(aws.Context, *ssoadmin.ListPermissionSetsInput, func(*ssoadmin.ListPermissionSetsOutput, bool) bool, ...request.Option) error

	ListPermissionSetsProvisionedToAccount(*ssoadmin.ListPermissionSetsProvisionedToAccountInput) (*ssoadmin.ListPermissionSetsProvisionedToAccountOutput, error)
	ListPermissionSetsProvisionedToAccountWithContext(aws.Context, *ssoadmin.ListPermissionSetsProvisionedToAccountInput, ...request.Option) (*ssoadmin.ListPermissionSetsProvisionedToAccountOutput, error)
	ListPermissionSetsProvisionedToAccountRequest(*ssoadmin.ListPermissionSetsProvisionedToAccountInput) (*request.Request, *ssoadmin.ListPermissionSetsProvisionedToAccountOutput)

	ListPermissionSetsProvisionedToAccountPages(*ssoadmin.ListPermissionSetsProvisionedToAccountInput, func(*ssoadmin.ListPermissionSetsProvisionedToAccountOutput, bool) bool) error
	ListPermissionSetsProvisionedToAccountPagesWithContext(aws.Context, *ssoadmin.ListPermissionSetsProvisionedToAccountInput, func(*ssoadmin.ListPermissionSetsProvisionedToAccountOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*ssoadmin.ListTagsForResourceInput) (*ssoadmin.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *ssoadmin.ListTagsForResourceInput, ...request.Option) (*ssoadmin.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*ssoadmin.ListTagsForResourceInput) (*request.Request, *ssoadmin.ListTagsForResourceOutput)

	ListTagsForResourcePages(*ssoadmin.ListTagsForResourceInput, func(*ssoadmin.ListTagsForResourceOutput, bool) bool) error
	ListTagsForResourcePagesWithContext(aws.Context, *ssoadmin.ListTagsForResourceInput, func(*ssoadmin.ListTagsForResourceOutput, bool) bool, ...request.Option) error

	ProvisionPermissionSet(*ssoadmin.ProvisionPermissionSetInput) (*ssoadmin.ProvisionPermissionSetOutput, error)
	ProvisionPermissionSetWithContext(aws.Context, *ssoadmin.ProvisionPermissionSetInput, ...request.Option) (*ssoadmin.ProvisionPermissionSetOutput, error)
	ProvisionPermissionSetRequest(*ssoadmin.ProvisionPermissionSetInput) (*request.Request, *ssoadmin.ProvisionPermissionSetOutput)

	PutInlinePolicyToPermissionSet(*ssoadmin.PutInlinePolicyToPermissionSetInput) (*ssoadmin.PutInlinePolicyToPermissionSetOutput, error)
	PutInlinePolicyToPermissionSetWithContext(aws.Context, *ssoadmin.PutInlinePolicyToPermissionSetInput, ...request.Option) (*ssoadmin.PutInlinePolicyToPermissionSetOutput, error)
	PutInlinePolicyToPermissionSetRequest(*ssoadmin.PutInlinePolicyToPermissionSetInput) (*request.Request, *ssoadmin.PutInlinePolicyToPermissionSetOutput)

	TagResource(*ssoadmin.TagResourceInput) (*ssoadmin.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *ssoadmin.TagResourceInput, ...request.Option) (*ssoadmin.TagResourceOutput, error)
	TagResourceRequest(*ssoadmin.TagResourceInput) (*request.Request, *ssoadmin.TagResourceOutput)

	UntagResource(*ssoadmin.UntagResourceInput) (*ssoadmin.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *ssoadmin.UntagResourceInput, ...request.Option) (*ssoadmin.UntagResourceOutput, error)
	UntagResourceRequest(*ssoadmin.UntagResourceInput) (*request.Request, *ssoadmin.UntagResourceOutput)

	UpdatePermissionSet(*ssoadmin.UpdatePermissionSetInput) (*ssoadmin.UpdatePermissionSetOutput, error)
	UpdatePermissionSetWithContext(aws.Context, *ssoadmin.UpdatePermissionSetInput, ...request.Option) (*ssoadmin.UpdatePermissionSetOutput, error)
	UpdatePermissionSetRequest(*ssoadmin.UpdatePermissionSetInput) (*request.Request, *ssoadmin.UpdatePermissionSetOutput)
}

var _ SSOAdminAPI = (*ssoadmin.SSOAdmin)(nil)
