---
title: "Announcing v0.13.0: New binary, support for SQL Views, MS-SQL Driver beta program and more"
authors: rotemtam
tags: [announcement, views, mssql]
---

It's been just over two months since our last version announcement and today I'm super excited to share with you our
latest release, [v0.13](https://github.com/ariga/atlas/releases/tag/v0.13.0), which includes some 
long-anticipated additions to Atlas:

* **Atlas and Atlas Community Editions** - we are making a change in the way Atlas is distributed. Starting today, we are
  making many of the features previously available only in the commercial version of Atlas available to everyone for free.
  More on this below.

* **Support for SQL Views** - SQL Views are virtual tables in a database created by a query and stored in the database.
  Starting today, you can manage views in your database using the same Atlas workflows you use for tables, 
  indexes, foreign keys, etc.

* **Microsoft SQL Server Driver Beta** - Over the last few months, we have been working on a driver for MS-SQL with some of our 
  enterprise design partners and are happy to make it available to you as a beta. 

* **Built-in schema visualization** - Over the past year we released some tools to help developers visualize their database
  schemas using Entity Relationship Diagrams (ERDs). Starting today, you can use the `atlas schema inspect --visualize` command
  to create database ERDs directly from the command line.

* **GitHub Action for Deployments** - We recently received a request from the community to add a GitHub Action to streamline 
  applying migrations directly from GitHub workflows. We thought this was a great idea and are happy to introduce
  [`ariga/atlas-deploy-action`](https://github.com/ariga/atlas-deploy-action) which you can use to deploy your migrations
  today.

* **Type checking for schema files** - As part of our continuous effort to make the experience of working with Atlas as
  smooth as possible, we are excited to ship a new engine for running type checks on your schema files. 

This release is extra-packed with new features and improvements, so let's dive in!  

### Atlas and Atlas Community Editions

In recent months, based on strategic discussions with our advisors, we have come to realize that in order to keep
fueling Atlas's rapid growth and adoption, we should give free access to some features previously
available only in the commercial version.  For this reason, we are making a change in the way Atlas is
distributed. Here is a summary of how this is going to work:

The Atlas codebase will continue to be actively developed in our open-source repository
([`ariga/atlas`](https://github.com/ariga/atlas)) under the Apache 2 License. This version of Atlas will continue to be actively
maintained and supported by us in community channels (GitHub, Discord, etc). We will continue to build and ship versions
of this purely open-source version under the name "Atlas Community". For more information about obtaining
Atlas Community binaries, see the [docs](/community-edition).

In addition, we are starting to distribute for free (under the [Atlas EULA](https://ariga.io/legal/atlas/eula/)) the binaries for our
commercial product which will include features previously unavailable to the public. We plan to release many of these
features to the open-source repositories over time to keep supporting more open-source innovation in the database space.
To keep things short and sweet, this distribution of the project will simply be called "Atlas".

Starting today, our existing distribution channels (the `atlasgo.sh` installation script, Docker image, brew tap, etc.)
will point to this edition, and we are adding parallel installation options for users that prefer to use the community
edition.

### Trying out the new features

Before we dive into the new features, let's make sure you have the latest version of Atlas installed. To do so, run the
following command:

```shell
curl -sSf https://atlasgo.sh | sh
```
For more installation options, see the [docs](https://atlasgo.io/getting-started#installation).

In addition, two of the following features (MS-SQL driver, `schema inspect --visualize`) 
require you to log in your CLI to Atlas Cloud. To do so, run the following command:

```shell
atlas login
```

The CLI will ask your permission to open a browser window to complete the login process.

After completing the login process, you should see a message similar to the following:

```text
You are now connected to "acme-corp" on Atlas Cloud.
```


### Support for Views

"Views" are virtual tables created by a query and stored in the database. Many teams use them to simplify
complex queries, encapsulate logic, and present a consistent interface to users, abstracting the underlying data
structures. Starting today, you can start managing views in your database using the same Atlas workflows you use for
tables, indexes, foreign keys, etc. Views are currently supported for MySQL, MariaDB, PostgreSQL, MS-SQL, and SQLite.

To demonstrate how this works, let's start by creating a new database. For this example, let's
run a local MySQL database using Docker:

```shell
docker run --rm -d --name atlas-demo -p 3306:3306 -e MYSQL_ROOT_PASSWORD=pass -e MYSQL_DATABASE=default mysql:8
```

Next, create a new file named `schema.hcl` with the following content:

```hcl
schema "default" {}

table "users" {
  schema = schema.default
  column "id" {
    type = int
  }
  column "nickname" {
    type = varchar(32)
  }
  column "phone_number" {
    type = varchar(32)
  }
}

view "users_clean" {
  schema = schema.default
  column "id" {
    type = int
  }
  column "nickname" {
    type = varchar(32)
  }
  as = <<-SQL
   SELECT id, nickname
    FROM ${table.users.name}
  SQL
  depends_on = [table.users]
}
```

In this example, we first defined a table named `users` that contains some PII (the user's phone number). Next, we
defined a view named `users_clean` that exposes only the user's id and nickname. This view can be used by other
applications to access the user's data without exposing any personally identifiable information.

Next, run the following command to apply the schema to the database:

```shell
atlas schema apply -u mysql://root:pass@localhost:3306/default -f schema.hcl
```

Atlas will connect to the database, inspect its current schema (which is empty) and produce the
following output:

```shell
-- Planned Changes:
-- Create "users" table
CREATE TABLE `default`.`users` (`id` int NOT NULL, `nickname` varchar(32) NOT NULL, `phone_number` varchar(32) NOT NULL);
-- Create "users_clean" view
CREATE VIEW `default`.`users_clean` (`id`, `nickname`) AS SELECT id, nickname
 FROM users;
Use the arrow keys to navigate: ↓ ↑ → ←
? Are you sure?:
  ▸ Apply
    Abort
```
After reviewing the changes, press enter to apply them to the database. Atlas will connect to the database and apply the
changes. 

Next, run the following command to inspect the database schema:

```shell
atlas schema inspect -u mysql://root:pass@/default --format "{{ sql . \" \" }}"
```

Notice that we used the `--format` flag to instruct Atlas to output the schema as SQL statements. 

Atlas will connect to the database and produce the following output:

```sql
-- Create "users" table
CREATE TABLE `users` (
 `id` int NOT NULL,
 `nickname` varchar(32) NOT NULL,
 `phone_number` varchar(32) NOT NULL
) CHARSET utf8mb4 COLLATE utf8mb4_0900_ai_ci;
-- Create "users_clean" view
CREATE VIEW `users_clean` (
 `id`,
 `nickname`
) AS select `users`.`id` AS `id`,`users`.`nickname` AS `nickname` from `users`;
```

As you can see, Atlas created the `users` table and the `users_clean` view in the database!

### Microsoft SQL Server Driver

Microsoft SQL Server, one of the longest-standing database engines in our business, was
first released by Microsoft in 1989. MS-SQL is the go-to database for Windows environments in many industries. Over the
last few months, we have been working on a driver for MS-SQL with some of our enterprise design partners and are happy
to make it available to you as a beta feature.

To get started with MS-SQL, you must first opt-in to its beta testing program. To do so:

1. Login to your Atlas Cloud account using the [instructions above](#trying-out-the-new-features). 
2. Head over to your [Atlas Cloud account](https://auth.atlasgo.cloud).
3. Click on your profile picture in the bottom left corner to open the user menu and select the "Personal Settings" option.
4. Select the "Microsoft SQL Server" checkbox from the driver list and click on the "Save" button to save your changes.

![](https://atlasgo.io/uploads/v0.13.0/personal-settings.png)

Next, run the following command to start a local MS-SQL server using Docker:

```shell
docker run --rm -e 'ACCEPT_EULA=Y' -e 'MSSQL_SA_PASSWORD=P@ssw0rd0995' -p 1433:1433 -d mcr.microsoft.com/mssql/server:latest
```

Notice that by providing the `ACCEPT_EULA` environment variable you confirm your acceptance of the Microsoft's
[End-User Licensing Agreement](https://go.microsoft.com/fwlink/?linkid=857698).

Create a new file named `schema.hcl` with the following content:

```hcl
schema "dbo" {
}
table "users" {
  schema = schema.dbo
  column "id" {
    type = int
  }
  column "nickname" {
    type = varchar(32)
  }
}
```

With this file ready, run the following command to apply the schema to the database:

```shell
atlas schema apply \
  --url "sqlserver://sa:P@ssw0rd0995@localhost:1433?database=master" \
  --to "file://schema.hcl"
```

Atlas will connect to the database, inspect its current schema (which is empty) and produce the
following output:

```text
-- Planned Changes:
-- Create "users" table
CREATE TABLE [dbo].[users] ([id] int NOT NULL, [nickname] varchar(32) NOT NULL);
Use the arrow keys to navigate: ↓ ↑ → ←
? Are you sure?:
  ▸ Apply
    Abort
```

After reviewing the changes, press enter to apply them to the database. Atlas will connect to the database and apply the
changes.

Next, run the following command to inspect the database:

```shell
atlas schema inspect \
  --url "sqlserver://sa:P@ssw0rd0995@localhost:1433?database=master"
```

Atlas will connect to the database and produce the following output:

```text
table "users" {
  schema = schema.dbo
  column "id" {
    null = false
    type = int
  }
  column "nickname" {
    null = false
    type = varchar(32)
  }
}
schema "dbo" {
}
```

Great! Atlas created the `users` table in the database!

Do you use MS-SQL? We would love to hear feedback about your experience using this driver. Feel free
to give it a try and reach out on our [Discord channel](https://discord.gg/5rCXNYMz2r) to let us know what you think.

### Built-in Schema Visualization

Over the past year we have released some tools to help developers visualize their database
schemas using Entity Relationship Diagrams (ERDs). The success of these experiments (especially for
[Ent](https://entgo.io/blog/2023/01/26/visualizing-with-entviz) and [Django](https://atlasgo.io/blog/2023/05/17/djangoviz))
convinced us that we should provide this functionality natively in Atlas. So starting today, you can use
the `atlas schema inspect --visualize` and `atlas schema diff --visualize` to create database ERDs directly from the command line.

To get started, create a new schema file named `schema.hcl`:

```hcl
schema "default" {}

table "t1" {
  schema = schema.default
  column "id" {
      type = int
  }
  primary_key {
      columns = [column.id]
  }
}

table "t2" {
  schema = schema.default
  column "id" {
    type = int
  }
  column "t1_id" {
    type = int
  }
  foreign_key "t1_id" {
    columns = [column.t1_id]
    ref_columns = [table.t1.column.id]
  }
}
```

Next, run the following command to generate the ERD:

```shell
atlas schema inspect --dev-url docker://mysql/8/d --url file://schema.hcl --visualize
```

Atlas will prompt you to check where you would like to share the ERD:

```text
Use the arrow keys to navigate: ↓ ↑ → ←
? Where would you like to share your schema visualization?:
  ▸ Publicly (gh.atlasgo.cloud)
    Privately (acme-corp.atlasgo.cloud)
```

After selecting the desired option, Atlas will generate the ERD and print out the URL where you can access it:

```text
https://gh.atlasgo.cloud/explore/cdd7bee5
```

![](https://atlasgo.io/uploads/v0.13.0/share-publicly.png)

### `ariga/atlas-deploy` GitHub Action

GitHub Actions is a powerful tool that allows developers to automate workflows around GitHub repositories. We have previously 
published GitHub Actions for running [CI for schema changes](https://github.com/ariga/atlas-action) and
for [syncing your migration directory](https://github.com/ariga/atlas-sync-action) with Atlas Cloud.

Today, we are happy to announce the release of the `ariga/atlas-deploy-action` to the 
[GitHub Actions Marketplace](https://github.com/marketplace/actions/atlas-deploy-action). This action allows you to
run migrations directly from your GitHub Actions workflow. To get started, add the following step to your workflow:

```yaml
name: Deploy Database Migrations
on:
  push:
    branches:
      - master
jobs:
  deploy:
    runs-on: ubuntu-latest
    steps:
      - uses: actions/checkout@v3
      - name: Deploy Atlas Migrations
        uses: ariga/atlas-deploy-action@v0
        with:
          url: ${{ secrets.DATABASE_URL }}
          dir: path/to/migrations
```

### Type checking for schema files

I firmly believe that great developer experiences aren't created by any one single design decision
but are rather a result of a relentless commitment to improving things little by little over long
periods of time. As we work with Atlas as users every day, we constantly look for points of friction and
frustration and try to find ways to make them better.

Sometimes, these changes are small and simple, like improving the help text of a command or updating
a documentation page. Other times, they are more complex, and require building more fundamental
infrastructure. 

I give all of this as an intro to a feature that I am very excited about: type checking for the HCL schema.
Starting with this release, we are shipping a type checker engine that will give you more
precise and actionable feedback when you make mistakes in your schema files.

We have come as an industry to appreciate that a fast feedback loop is one of the most prominent factors
in developer productivity, and it all starts in the local development environment. 

Type checking validates the contents of your schema files and provides you with actionable feedback
in case you make a mistake. For example, suppose you define a table like this (try spotting the errors
yourself before reading on):

```hcl title="schema.hcl"
table "users" {
  column "id" {
    type = int
  }
  column "name" {
    type = varchar(255)
  }
  column "manager_id" {
    type = int
  }
  primray_key {
    columns = [
      column.id
    ]
  }
  index "idx_name" {
    coulmns = [
      column.name
    ]
    unique = true
  }
  foreign_key {
    columns = [column.manager_id]
    ref_columns = [column.id]
  }
}
```
Trying to apply this schema will produce the following error:

```text
Error: failed parsing mysql schema files: schema.hcl
schema.hcl:1,1-6: missing required attribute schema in block table
schema.hcl:11,3-14: unknown block type primray_key in block of type table (Did you mean primary_key?)
schema.hcl:17,5-19,6: unknown attribute coulmns in block of type index (Did you mean columns?)
schema.hcl:22,3-14: foreign_key block must have exactly 1 label
```
This type checking engine is available on the Atlas CLI and will be integrated into our editor
plugins for VSCode and (the upcoming) JetBrains IDEs.

### Wrapping up

This is it! I know this was a long post, but we are very excited about all of these new features
and we hope you will find them useful. As always, we would love to hear your feedback and suggestions
on our [Discord server](https://discord.gg/zZ6sWVg6NT).
