---
title: FAQ
---

#### Does Acorn support CustomResourceDefinitions (CRDs)?

CRD support is a commonly requested feature and we are thinking hard about how and whether we can support this. We recognize CRDs' value and prominence in the Kubernetes ecosystem, but because every CRD has its own unique impact and lifecycle, Acorn cannot reliably and predictably manage CustomResources generically. We are investigating different approaches and solutions.

If you have a specific CRD use-case, please share it [here](https://github.com/acorn-io/runtime/issues/329).

#### What is an Acorn image? Are you bundling and duplicating the container images I reference in my Acornfile?

Acorn images leverage existing container image standards and functionality. A normal [OCI container image](https://github.com/opencontainers/image-spec/blob/main/spec.md) is a collection of layers stored in a OCI registry and linked together with an image manifest. An Acorn image is just that as well.  It is an OCI index that has references to the Acorn metadata manifest and existing container image manifests. Its manifest references existing image manifests in the registry by digest.

There is no duplication of content in the registry as all the existing image digests do not change (by design). The only time content is duplicated is if a referenced image is in a different OCI registry than the one you are pushing the Acorn to.  This is by design and viewed as a feature.  This keeps all content specific to your app in one registry so that you don't have to deal with multiple registry auth and proxy issue at deployment.  Also this model ensures your app will stay fully intact even if an image is deleted or a tag is changed.

#### I deployed an Acorn app and the endpoint says "pending". What's broken?

If the endpoint is HTTP/HTTPS, you either don't have an ingress controller or it isn't set up properly. If you are sure your ingress controller is functioning properly, it may not be set as the default for your cluster and you need to tell Acorn to use it as part of the install command:
```shell
acorn install --ingress-class-name nginx
```
"nginx" is just an example in this case. Your actual ingress class name may vary.

If the endpoint is non-HTTP, like TCP, your cluster needs the ability to support [services of type LoadBalancer](https://kubernetes.io/docs/concepts/services-networking/service/#loadbalancer).