subroutine attach_greg_values(dir,tab_greg,error)
  use gtv_buffers
  use gtv_interfaces, except_this=>attach_greg_values
  use gtv_types
  !---------------------------------------------------------------------
  ! @ private
  !  Update the input Greg values and save them in the input directory
  ! descriptor.
  !---------------------------------------------------------------------
  type(gt_directory), intent(inout) :: dir       ! Directory
  type(greg_values),  intent(inout) :: tab_greg  ! Greg values
  logical,            intent(inout) :: error     ! Logical error flag
  !
  tab_greg%lx1 = 0.0
  tab_greg%lx2 = dir%phys_size(1)
  tab_greg%ly1 = 0.0
  tab_greg%ly2 = dir%phys_size(2)
  !
  dir%val_greg = tab_greg
  !
end subroutine attach_greg_values
!
subroutine get_greg_values(tab_greg)
  use gtv_dependencies_interfaces
  use gtv_interfaces
  use gildas_def
  use gtv_graphic
  !---------------------------------------------------------------------
  ! @ no-interface
  !---------------------------------------------------------------------
  integer(kind=4) :: tab_greg(*)  ! Whole block of Greg values
  ! Global
  include 'gbl_memory.inc'
  ! Local
  integer(kind=address_length) :: greg_routine
  !
  ! Get values from GreG values in TAB_GREG
  greg_routine = bytpnt(greg_user,membyt)
  call sub_greg_val(1,tab_greg,membyt(greg_routine))
  !
end subroutine get_greg_values
!
subroutine send_greg_values(tab_greg)
  use gtv_dependencies_interfaces
  use gtv_interfaces
  use gildas_def
  use gtv_graphic
  !---------------------------------------------------------------------
  ! @ no-interface
  !---------------------------------------------------------------------
  integer(kind=4) :: tab_greg(*)  ! Whole block of Greg values
  ! Global
  include 'gbl_memory.inc'
  ! Local
  integer(kind=address_length) :: greg_routine
  !
  ! Transmit values in TAB_GREG to GreG
  greg_routine = bytpnt(greg_user,membyt)
  call sub_greg_val(-1,tab_greg,membyt(greg_routine))
  !
end subroutine send_greg_values
!
subroutine reset_greg_val(tab_greg)
  use gtv_dependencies_interfaces
  use gtv_interfaces
  use gildas_def
  use gtv_graphic
  !---------------------------------------------------------------------
  ! @ no-interface
  !---------------------------------------------------------------------
  integer(kind=4) :: tab_greg(*)  ! Whole block of Greg values
  ! Global
  include 'gbl_memory.inc'
  ! Local
  integer(kind=address_length) :: greg_routine
  !
  ! Reset current position & pen in GreG
  greg_routine = bytpnt(greg_user,membyt)
  call sub_greg_val(0,tab_greg,membyt(greg_routine))
  !
end subroutine reset_greg_val
!
subroutine sub_greg_val(flag,tab_greg,greg_routine)
  use gtv_interfaces
  !---------------------------------------------------------------------
  ! @ no-interface
  !---------------------------------------------------------------------
  integer, intent(in) :: flag          !
  integer(kind=4)     :: tab_greg(*)   ! Whole block of Greg values
  external            :: greg_routine  !
  !
  call greg_routine(flag,tab_greg)
  !
end subroutine sub_greg_val
