subroutine catalog_comm(line,error)
  use gkernel_types
  use gkernel_interfaces
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  ! IMAGER
  !
  !   List or define Spectral Line Data Base(s)
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line
  logical :: error
  !
  character(len=*), parameter :: rname='CATALOG'
  character(len=1), parameter :: question_mark='?'
  !
  character(len=filename_length) :: line_comm = ' '
  character(len=filename_length) :: chain, file
  logical :: found
  character*16 :: check
  integer :: lt,i,j,narg,nc
  ! This duplicates the list in LINEDB Python code, but
  ! is unavoidable to check proper Data Base existence
  integer, parameter :: monline=4
  character*12 :: onlines(monline)
  data onlines /'voparis', 'cdms', 'jpl', 'splatalogue'/ !! camvamdc, cdmsvamdc
  !
  error = .false.
  !
  ! Normal code
  narg = sic_narg(0)
  if (narg.le.1) then
    chain = '?'
    call sic_ch(line,0,1,chain,nc,.false.,error)
    if (error) return
    if (chain(1:1).eq.question_mark) then
      call exec_program('@ catalog ?')
      return
    endif
  endif
  !
  ! Note the LowerCase for the "in" argument
  line_comm = 'LINEDB\USE in '
  lt = 15
  !
  do i=1,narg
    call sic_ch(line,0,1,chain,nc,.false.,error)
    !
    check = chain
    call sic_lower(check)
    found = .false.
    do j=1,monline
      if (check.eq.onlines(j)) then
        found = .true.
        exit
      endif
    enddo
    !
    if (found) then
      line_comm(lt:) = check
      lt = lt+len_trim(check)
    else
      ! If it is not one of the on-line databases, it can be a local
      ! file. Locate it
      found = sic_findfile(chain,file,' ','.linedb')
      !
      if (found) then
        chain  = '"'//trim(file)//'"'   ! Python LINEDB\USE does not parse anything else
        line_comm(lt:) = chain
        lt = lt+len_trim(chain)
      else
        call message_colour(3)
        call map_message(seve%w,rname,'No such line catalog '//chain)
        call message_colour(-1)
      endif
    endif
  enddo
  !
  ! Execute the LINEDB\USE IN command if needed
  if (lt.gt.15) call exec_program(line_comm(1:lt))
  !
end subroutine catalog_comm    
!
subroutine catalog_init
  use gkernel_interfaces
  !
  character(len=filename_length) :: line_comm = ' '
  character(len=filename_length) :: chain, file
  logical :: found
  ! Initialization patch until  "USE in" command is debugged 
  ! (currently not working in Procedures)
  chain = "~/imager"
  found = sic_findfile(chain,file,' ','.linedb')
  if (.not.found) then
    chain = "imager"
    found = sic_findfile(chain,file,'gag_data:','.linedb')
  endif  
  if (found) then
    line_comm = 'LINEDB\USE in "'//trim(file)//'"'
    call exec_program(line_comm)
  endif
end subroutine catalog_init
