!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetopology_spaelli_types
  use cubetools_parameters
  use cubetopology_messaging
  use cubetopology_spadiam_types
  use cubetopology_spapos_types
  !
  public :: spaelli_comm_t,spaelli_user_t,spaelli_prog_t
  private
  !
  type spaelli_comm_t
     type(spadiam_comm_t) :: diameter
     type(spapos_comm_t)  :: center
   contains
     procedure :: register => cubetopology_spaelli_comm_register
     procedure :: parse    => cubetopology_spaelli_comm_parse
  end type spaelli_comm_t
  !
  type spaelli_user_t
     type(spadiam_user_t) :: diameter
     type(spapos_user_t)  :: center
   contains
     procedure :: toprog => cubetopology_spaelli_user_toprog
     procedure :: list   => cubetopology_spaelli_user_list
  end type spaelli_user_t
  !
  type spaelli_prog_t
     type(spadiam_prog_t) :: diameter
     type(spapos_prog_t)  :: center
   contains
     procedure :: list   => cubetopology_spaelli_prog_list
  end type spaelli_prog_t
  !
contains
  !
  subroutine cubetopology_spaelli_comm_register(comm,&
       diamname,diamabstract,centname,centabstract,error)
    !----------------------------------------------------------------------
    ! Register an ellipse key
    !----------------------------------------------------------------------
    class(spaelli_comm_t), intent(out)   :: comm
    character(len=*),      intent(in)    :: diamname
    character(len=*),      intent(in)    :: diamabstract
    character(len=*),      intent(in)    :: centname
    character(len=*),      intent(in)    :: centabstract
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPAELLI>COMM>REGISTER'
    !
    call cubetopology_message(toposeve%trace,rname,'Welcome')
    !
    call comm%diameter%register(diamname,diamabstract,error)
    if (error) return
    call comm%center%register(centname,centabstract,error)
  end subroutine cubetopology_spaelli_comm_register
  !
  subroutine cubetopology_spaelli_comm_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spaelli_comm_t), intent(in)    :: comm
    character(len=*),      intent(in)    :: line
    type(spaelli_user_t),  intent(out)   :: user
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPAELLI>COMM>PARSE'
    !
    call cubetopology_message(toposeve%trace,rname,'Welcome')
    !
    call comm%diameter%parse(line,user%diameter,error)
    if (error) return
    call comm%center%parse(line,user%center,error)
    if (error) return
  end subroutine cubetopology_spaelli_comm_parse
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetopology_spaelli_user_toprog(user,cube,prog,error)
    use cube_types
    !------------------------------------------------------------------------
    !
    !------------------------------------------------------------------------
    class(spaelli_user_t), intent(in)    :: user
    type(cube_t),          intent(in)    :: cube
    type(spaelli_prog_t),  intent(out)   :: prog
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPAELLI>USER>TOPROG'
    !
    call cubetopology_message(toposeve%trace,rname,'Welcome')
    !
    call user%diameter%toprog(cube,prog%diameter,error)
    if (error) return
    call user%center%toprog(cube,prog%center,error)
    if (error) return
  end subroutine cubetopology_spaelli_user_toprog
  !
  subroutine cubetopology_spaelli_user_list(user,error)
    !------------------------------------------------------------------------
    ! Mostly for debugging
    !------------------------------------------------------------------------
    class(spaelli_user_t), intent(in)    :: user
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPAELLI>USER>LIST'
    !
    call cubetopology_message(toposeve%trace,rname,'Welcome')
    !
    call user%diameter%list(error)
    if (error) return
    call user%center%list(error)
    if (error) return
  end subroutine cubetopology_spaelli_user_list
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetopology_spaelli_prog_list(prog,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(spaelli_prog_t), intent(in)    :: prog
    logical,               intent(inout) :: error
    !
    character(len=*), parameter :: rname='SPAELLI>PROG>LIST'
    !
    call cubetopology_message(toposeve%trace,rname,'Welcome')
    !
    call prog%diameter%list(error)
    if (error) return
    call prog%center%list(error)
    if (error) return
  end subroutine cubetopology_spaelli_prog_list
end module cubetopology_spaelli_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
