subroutine eqplanet(name, s_3, error)
  use ast_astro
  use ast_constant
  !---------------------------------------------------------------------
  ! @ private
  !	ASTRO
  !	Get Apparent RA and DEC of planet NAME
  !---------------------------------------------------------------------
  character(len=*):: name           !
  real(kind=8) :: s_3(2)            !
  logical :: error                  !
  ! Local
  logical :: found
  integer(kind=4) :: m_body
  parameter (m_body = 9)
  character(len=12) :: body (m_body)
  integer(kind=4) :: vector(m_body), i_planet, i
  real(kind=8) :: x_0(3), x_2(3), v_0(3), v_2(3), result(6), trfm_32(9)
  real(kind=8) :: x_3(3), distance
  equivalence (result(1), x_0(1)), (result(4),v_0(1))
  data body/'MOON', 'SUN', 'MERCURY', 'VENUS', 'MARS', 'JUPITER', 'SATURN',  &
            'URANUS', 'NEPTUNE'/
  data vector /1, 2, 3, 3, 3, 3, 3, 3, 3/
  !------------------------------------------------------------------------
  ! Code :
  found = .false.
  !
  ! Loop on possible objects
  do i_planet = 1, m_body
    if (name .eq. body(i_planet)) then
      found = .true.
      call ephsta(vector(i_planet), i_planet, error)
      if (error) return
      !
      ! Get ecliptic J2000 coordinates
      call ephvec(jnow_tdt, 1, result, error)
      !
      ! Get Apparent Horizontal coordinates
      call matvec(x_0, trfm_20, x_2)
      call matvec(v_0, trfm_20, v_2)
      !
      ! Light-time correction
      distance = dsqrt(x_2(1)**2 + x_2(2)**2 + x_2(3)**2)
      do i = 1, 3
        x_2(i) = x_2(i) - distance / light * v_2(i)
      enddo
      !
      ! Apparent equatorial coordinates (without parallax)
      call transp(trfm_23, trfm_32)
      call matvec(x_2, trfm_32, x_3)
      call spher(x_3, s_3)
      return
    endif
  enddo
  999   error = .true.
  return
end subroutine eqplanet
