!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module mapping_default_types
  use clean_def
  !
  real :: d_min,d_max ! min max of dirty image
  !
  type (uvmap_par), save :: default_map,old_map,save_map
  !
  ! OPEN-MP control parameters
  logical, save :: omp_compiled = .false.
  logical, save :: omp_uvmap = .false.
  integer, save :: omp_grid = 0
  logical, save :: omp_restore_fast = .true.
  logical, save :: omp_uvmap_lock = .false.
  integer, save :: omp_single_beam = 0
  logical, save :: omp_debug = .false.
  !
  ! Parameter to select the imaging tool version. Non zero means old
  ! non-optimized code.
  integer, save :: map_version = 0
  !
  ! Parameters for determining image size
  integer, save :: map_power = 2         ! Max exponent of powers of 3 and 5
  real,    save :: map_rounding = 0.05   ! Tolerance for rounding to floor
  !
  ! Cleaning convergence criterium
  integer, save :: clean_converge = 10
  !
  public :: omp_define,uvmap_define
  !
  public :: d_min,d_max
  public :: default_map,old_map,save_map
  public :: map_power,map_rounding
  public :: clean_converge
  public :: map_version
  public :: omp_grid,omp_uvmap_lock,omp_single_beam,omp_debug
  !
  private
  !
contains
  !
  subroutine uvmap_define(error)
    use gkernel_interfaces
    !----------------------------------------------------------------------
    ! UV_MAP variables
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    integer :: iout
    integer(kind=index_length) :: dim(4) = 0
    !
    ! Requested precision
    default_map%precis = 0.1
    call sic_def_real('MAP_PRECIS',default_map%precis,0,dim,.false.,error)
    if(error) return
    ! Number of channels per beam
    default_map%beam = -1
    call sic_def_inte('MAP_BEAM_STEP',default_map%beam,0,dim,.false.,error)
    if(error) return
    !
    dim = [2,0,0,0]
    ! Map field in arcsecond
    default_map%field = 0
    call sic_def_real('MAP_FIELD',default_map%field,1,dim,.false.,error)
    if(error) return
    ! Map size in Pixels
    default_map%size = 0
    call sic_def_inte('MAP_SIZE',default_map%size,1,dim,.false.,error)
    if(error) return
    ! Map cell size in arcsecond
    default_map%xycell = 0
    call sic_def_real('MAP_CELL',default_map%xycell,1,dim,.false.,error)
    if(error) return
    dim = [3,0,0,0]
    ! UV Taper in m and Degree
    default_map%taper = 0
    call sic_def_real('MAP_UVTAPER',default_map%taper,1,dim,.false.,error)
    if(error) return
    ! Taper exponent
    default_map%taper(4) = 2
    call sic_def_real('MAP_TAPEREXPO',default_map%taper(4),0,dim,.false.,error)
    if(error) return
    ! UV cell size
    default_map%uniform(1) = 0.0
    call sic_def_real('MAP_UVCELL',default_map%uniform(1),0,dim,.false.,error)
    if(error) return
    ! Robustness coefficient
    default_map%uniform(2) = 1.0
    call sic_def_real('MAP_ROBUST',default_map%uniform(2),0,dim,.false.,error)
    if(error) return
    ! Weighting mode
    default_map%mode = 'NATURAL'
    call sic_def_char('MAP_WEIGHT',default_map%mode,.false.,error)
    if(error) return
    ! Truncation level(Mosaic or Primary)
    default_map%truncate = 20.0
    call sic_def_real('MAP_TRUNCATE',default_map%truncate,0,dim,.false.,error)
    if(error) return
    ! Convolution code
    default_map%ctype = 5
    call sic_def_inte('MAP_CONVOLUTION',default_map%ctype,0,dim,.false.,error)
    if(error) return
    !
    default_map%shift = .false.
    call sic_def_logi('MAP_SHIFT',default_map%shift,.false.,error)
    if(error) return
    default_map%ra_c = ' '
    call sic_def_char('MAP_RA',default_map%ra_c,.false.,error)
    if(error) return
    default_map%dec_c = ' '
    call sic_def_char('MAP_DEC',default_map%dec_c,.false.,error)
    if(error) return
    default_map%angle = 0.0
    call sic_def_real('MAP_ANGLE',default_map%angle,0,dim,.false.,error)
    if(error) return
    !
    ! Initialize status
    old_map = default_map
    save_map = old_map
    !
    ! Old names for compatibility
    !   define logical uv_shift /global
    !   define integer convolution /global
    !   define double uv_cell[2] uv_taper[3] taper_expo /global
    call sic_def_inte ('CONVOLUTION',old_map%ctype,0,dim,.false.,error)
    call sic_def_logi ('UV_SHIFT',old_map%shift,.false.,error)
    call sic_def_char ('WEIGHT_MODE',old_map%mode,.false.,error)
    dim = [2,0,0,0]
    call sic_def_real ('UV_CELL',old_map%uniform(1),1,dim,.false.,error)
    dim = [3,0,0,0]
    call sic_def_real ('UV_TAPER',old_map%taper,1,dim,.false.,error)
    call sic_def_real ('TAPER_EXPO',old_map%taper(4),0,dim,.false.,error)
    !
    call sic_def_real('MAP_ROUNDING',map_rounding,0,0,.false.,error)
    call sic_def_inte('MAP_POWER   ',map_power,0,0,.false.,error)
    !
    !***JP: Position to be checked
    call gi4_round_forfft(64,iout,error,map_rounding,map_power)
  end subroutine uvmap_define
  !
  subroutine omp_define(error)
    use gkernel_interfaces
    !----------------------------------------------------------------------
    ! OMP variables
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    call sic_defstructure('OMP_MAP',.true.,error)
    if (error) return
    omp_compiled = .false.
    !$ omp_compiled = .true.
    call sic_def_logi('OMP_MAP%COMPILED',omp_compiled,.false.,error)
    if (error) return
    call sic_def_logi('OMP_MAP%DEBUG',omp_debug,.false.,error)
    if (error) return
    call sic_def_logi('OMP_MAP%UV_MAP',omp_uvmap,.false.,error)
    if (error) return
    call sic_def_inte('OMP_MAP%GRID',omp_grid,0,0,.false.,error)
    if (error) return
    call sic_def_logi('OMP_MAP%RESTORE_FAST',omp_restore_fast,.false.,error)
    if (error) return
    call sic_def_logi('OMP_MAP%UV_MAP_LOCK',omp_uvmap_lock,.false.,error)
    if (error) return
    call sic_def_inte('OMP_MAP%SINGLE_BEAM_CODE',omp_single_beam,0,0,.false.,error)
    if (error) return
    call sic_def_inte('CLEAN_CONVERGE',clean_converge,0,0,.false.,error)
    if (error) return
  end subroutine omp_define
end module mapping_default_types
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
