!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubetemplate_visi2image_template
  use cubetemplate_messaging
  use cubetemplate_one2one_template
  !
  public :: visi2image_comm_t,visi2image_user_t,visi2image_prog_t
  private
  !
  type, extends(one2one_comm_t) :: visi2image_comm_t
  end type visi2image_comm_t
  !
  type, extends(one2one_user_t) :: visi2image_user_t
  end type visi2image_user_t
  !
  type, extends(one2one_prog_t) :: visi2image_prog_t
   contains
     procedure, public  :: header => cubetemplate_visi2image_prog_header
     procedure, private :: loop   => cubetemplate_visi2image_prog_loop
     procedure, private :: act    => cubetemplate_visi2image_prog_act
  end type visi2image_prog_t
  !
contains
  !
  !----------------------------------------------------------------------
  !
  subroutine cubetemplate_visi2image_prog_header(prog,comm,error)
    use cubetools_header_methods
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(visi2image_prog_t), intent(inout) :: prog
    class(one2one_comm_t),    intent(in)    :: comm
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='VISI2IMAGE>PROG>HEADER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call prog%one2one_prog_t%header(comm,error)
    if (error) return
    call cubetools_header_make_array_real(prog%oucube%head,error)
    if (error) return
  end subroutine cubetemplate_visi2image_prog_header
  !
  subroutine cubetemplate_visi2image_prog_loop(prog,iter,error)
    use cubetools_parameters
    use cubeadm_taskloop
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(visi2image_prog_t), intent(inout) :: prog
    type(cubeadm_iterator_t), intent(inout) :: iter
    logical,                  intent(inout) :: error
    !
    type(visi_t) :: visi
    type(image_t) :: image
    character(len=*), parameter :: rname='VISI2IMAGE>PROG>HEADER'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
    !
    call visi%associate('visi',prog%incube,iter,error)
    if (error) return
    call image%allocate('image',prog%oucube,iter,error)
    if (error) return
    !
    do while (iter%iterate_entry(error))
      call prog%act(iter%ie,visi,image,error)
      if (error) return
    enddo
  end subroutine cubetemplate_visi2image_prog_loop
  !
  subroutine cubetemplate_visi2image_prog_act(prog,ie,visi,image,error)
    use cubetools_parameters
    use cubeadm_image_types
    use cubeadm_visi_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(visi2image_prog_t), intent(inout) :: prog
    integer(kind=entr_k),     intent(in)    :: ie
    type(visi_t),             intent(inout) :: visi
    type(image_t),            intent(inout) :: image
    logical,                  intent(inout) :: error
    !
    character(len=*), parameter :: rname='VISI2IMAGE>PROG>ACT'
    !
    call cubetemplate_message(templateseve%trace,rname,'Welcome')
  end subroutine cubetemplate_visi2image_prog_act
end module cubetemplate_visi2image_template
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
