!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubecompute_difference
  use cubecompute_two2one_real_template
  use cubecompute_messaging
  !
  public :: cubecompute_difference_register
  private
  !
  type(two2one_real_comm_t) :: difference
  !
contains
  !
  subroutine cubecompute_difference_register(error)
    use cubedag_allflags
    !----------------------------------------------------------------------
    ! 
    !----------------------------------------------------------------------
    logical, intent(inout) :: error
    !
    character(len=*), parameter :: rname='DIFFERENCE>REGISTER'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call difference%register_syntax(&
         'DIFFERENCE','subtrahend','minuend',&
         [flag_difference],cubecompute_difference_command,error)
    if (error) return
    call difference%register_act(cubecompute_difference_prog_act,error)
    if (error) return
  end subroutine cubecompute_difference_register
  !
  subroutine cubecompute_difference_command(line,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    character(len=*), intent(in)    :: line
    logical,          intent(inout) :: error
    !
    type(two2one_real_user_t) :: user
    character(len=*), parameter :: rname='DIFFERENCE>COMMAND'
    !
    call cubecompute_message(computeseve%trace,rname,'Welcome')
    !
    call difference%parse(line,user,error)
    if (error) return
    call difference%main(user,error)
    if (error) continue
  end subroutine cubecompute_difference_command
  !
  !----------------------------------------------------------------------
  !
  subroutine cubecompute_difference_prog_act(prog,ie,subtrahend,minuend,difference,error)
    use cubetools_parameters
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(two2one_real_prog_t), intent(inout) :: prog
    integer(kind=entr_k),       intent(in)    :: ie
    type(image_t),              intent(inout) :: subtrahend
    type(image_t),              intent(inout) :: minuend
    type(image_t),              intent(inout) :: difference
    logical,                    intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    integer(kind=pixe_k) :: jx,jy
    character(len=*), parameter :: rname='DIFFERENCE>PROG>ACT'
    !
    call subtrahend%get(ie,error)
    if (error) return
    call minuend%get(ie,error)
    if (error) return
    do iy=prog%region%iy%first,prog%region%iy%last
       jy = iy-prog%region%iy%first+1
       do ix=prog%region%ix%first,prog%region%ix%last
          jx = ix-prog%region%ix%first+1
          difference%val(jx,jy) = subtrahend%val(ix,iy)-minuend%val(ix,iy)
       enddo ! ix
    enddo ! iy
    call difference%put(ie-prog%region%iz%first+1,error)
    if (error) return
  end subroutine cubecompute_difference_prog_act
end module cubecompute_difference
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
