  !
  ! Id: parametersReceiver.inc,v 1.2.5    2016-02-15 Hans Ungerechts
  !                                       GISMO no longer available
  ! Id: parametersReceiver.inc,v 1.2.4    2015-06-19 Hans Ungerechts
  ! Id: parametersReceiver.inc,v 1.2.3.3  2014-09-03 Hans Ungerechts
  ! Id: parametersReceiver.inc,v 1.2.3.2  2014-04-24 Hans Ungerechts
  ! Id: parametersReceiver.inc,v 1.2.3    2014-01-22, 23 Hans Ungerechts
  !
  ! Id: parametersReceiver.inc,v 1.1.15 2013-08-26 Hans Ungerechts
  !
  !                              1.1.15 2013-08-26 E150 upgrade
  !
  ! Id: parametersReceiver.inc,v 1.2.2  2012-08-21 Hans Ungerechts
  !     parametersReceiver.inc,v 1.2.1  2012-07-17 Hans Ungerechts
  !     based on:
  ! Id: parametersReceiver.inc,v 1.1.12 2012-02-17 Hans Ungerechts
  !
  !                              1.1.12 GISMO NIKA  
  !                              1.1.11 EMIR upgrade
  !
  Call pako_message(seve%t,programName,                                          &
       &    " module Receiver  --> parametersReceiver.inc, 1.2.5   2016-02-15 ") ! this allows to trace execution
  !
  catalogOpen = .False.
  !
  error  = .False.
  errorL = .False.
  errorC = .False.
  errorR = .False.
  !
  !
  ! *** RECEIVER NAME
  !
  iOption   = 0
  iArgument = 1
  ! iRec      = 0   10.Aug 2020
  iRec      = 1
  !
  If (SIC_PRESENT(iOption,iArgument)) Then
     Call SIC_CH(LINE,iOption,iArgument,                                         &
          &        cInputLong,lengthInput,.True.,errorC)                         !
  Else
     errorL = .True.
     messageText = "no receiver name specified"
     Call PakoMessage(priorityI,severityI,command,messageText)
  End If
  !
  If (errorC) Then
     messageText = "receiver name "//cInputLong(1:lengthInput)//" invalid"
     Call PakoMessage(priorityE,severityE,command,messageText)
  End If
  !
  ERROR = ERROR .Or. errorC
  !
  If (.Not.errorL .And. .Not.errorC .And. GV%doDebugMessages) Then
     Write (6,*) "  for receiver name: "
     Write (6,*) "      cInputLong(1:lengthInput):  -->",                          &
          &             cInputLong(1:lengthInput),"<--"                            !
     Call SIC_UPPER(cInputLong)
     Write (6,*) "      cInputLong(1:lengthInput):  -->",                          &
          &             cInputLong(1:lengthInput),"<--"                            !
  End If
  !
  ! *** Check against valid receiver names
  !
  If (SIC_PRESENT(iOption,iArgument) .And. .Not. error) Then
     !
     If (    GV%privilege.Eq.setPrivilege%staff                                    &
          & .And. (cInputLong(1:lengthInput).Eq.RxHolography(1:lengthInput))) Then !            
        !                                                                            !! TBD: check against list of special RX names
        errorC = .False.
        receiverSelected            = RxHolography
        l                           = lenc(receiverSelected)
        iMatch                      = iRxTest
        iRec                        = iMatch
        vars(iIn,iRec)%isConnected  = .True.
        vars(iIn,iRec)%wasConnected = .True.
        vars(iIn,iRec)%name         = receiverSelected
        If (GV%doDebugMessages) Then
           Write (6,*) "   "
           Write (6,*) "   --> special receiver "
           Write (6,*) "       receiverSelected: -->",                             &
                &              receiverSelected(1:lenc(receiverSelected)),"<--"    !
           Write (6,*) "       iMatch:                       ", iMatch
           Write (6,*) "       iRec:                         ", iRec
           Write (6,*) "       vars(iIn,iRec)%isConnected:   ",                    &
                &              vars(iIn,iRec)%isConnected                          !
           Write (6,*) "       vars(iIn,iRec)%wasConnected:  ",                    &
                &              vars(iIn,iRec)%wasConnected                         !
           Write (6,*) "       vars(iIn,iRec)%name:   ",                           &
                &              vars(iIn,iRec)%name(1:len_trim(vars(iIn,iRec)%name))!
           Write (6,*) "       *************************** "
        End If
        !
     End If
     !
     If (.Not. vars(iIn,iRec)%isConnected) Then
        If (GV%doDebugMessages) Then
           Write (6,*) "   "
           Write (6,*) "   Call pakoUmatchKey"
        End If
        Call pakoUmatchKey (                                                       &
             &              keys=receiverChoices,                                  &
             &              key=cInputLong,                                        &
             &              command='RECEIVER',                                    &
             &              howto='Start Upper',                                   &
             &              iMatch=iMatch,                                         &
             &              nMatch=nMatch,                                         &
             &              error=errorC,                                          &
             &              errorCode=errorCode                                    &
             &             )                                                       !
        !
        ERROR = ERROR .Or. errorC
        !
        If (iMatch.Ge.iA100 .And. iMatch.Le.iD270) Then
           !   
           Write (messageText, *)     receiverChoices(iMatch),                     &
                &                   " is no longer available "                     !
           !
           If (   .Not.                                                            &
                & (     GV%privilege.Eq.setPrivilege%ncsTeam                       &
                & )    ) Then                                                      !
              ERROR = .True.
              Call pakoMessage(priorityE,severityE,command,                        &
                   &           messageText)                                        !
           Else
              Call pakoMessage(priorityW,severityW,command,                        &
                   &           messageText)                                        !
           End If
           !
        End If
        !
        If (.Not. ERROR) Then
           iRec                        = iMatch
           receiverSelected            = receiverChoices(iMatch)
           vars(iIn,iRec)%isConnected  = .True.
           vars(iIn,iRec)%wasConnected = .True.
           vars(iIn,iRec)%name         = receiverChoices(iMatch)
        Else
           iRec                        = GPnoneI
        End If
        !
        l = lenc(receiverSelected)
        !
     End If   !!   If (.Not. vars(iIn,iRec)%isConnected)
     !
  End If   !!   If (SIC_PRESENT(iOption,iArgument) .And. .Not. error)
  !
  If (GV%doDebugMessages) Then
     Write (6,*) "   "
     Write (6,*) "       receiverSelected: -->",                             &
          &              receiverSelected(1:lenc(receiverSelected)),"<--"    !
     Write (6,*) "       iMatch:                       ", iMatch
     Write (6,*) "       iRec:                         ", iRec
     Write (6,*) "       vars(iIn,iRec)%isConnected:   ",                    &
          &              vars(iIn,iRec)%isConnected                          !
     Write (6,*) "       vars(iIn,iRec)%wasConnected:  ",                    &
          &              vars(iIn,iRec)%wasConnected                         !
     Write (6,*) "       vars(iIn,iRec)%name:   ",                           &
          &              vars(iIn,iRec)%name(1:len_trim(vars(iIn,iRec)%name))!
     Write (6,*) "       *************************** "
  End If
  !
  If (iRec .Eq. iHERA) Then
     messageText = rec%HERA//" not yet properly supported"
     Call PakoMessage(priorityW,severityW,command,messageText)
     messageText = "use: "//rec%HERA1//" "//rec%HERA2
     Call PakoMessage(priorityI,severityI,command,messageText)
  End If
  !
  ! *** Read parameters for BOLOmeter
  !
  If (iRec .Eq. iBOLO) Then
     !
!!$   NIKApixel%isSet         =  .False.
!!$   NIKApixel%systemName    =  offs%nas
!!$   NIKApixel%point%x       =  0.0
!!$   NIKApixel%point%y       =  0.0
!!$   NIKApixel%channel       =  1
!!$   NIKApixel%elevation     =  0
!!$   vars(iIn,iRec)%channel  =  1
     !
     If (SIC_NARG(0).Ge.2) Then
        !
        ! * parameters should be in command line
        messageText = " reading from command line "
        Call PakoMessage(priorityI,severityI,command,messageText)
        !
        nPar = 1
        lPar = 1
        !D       Write (6,*) " "
        !D       Write (6,*) "    line              ->",line(1:lenc(line)),"<-"
        !D       Write (6,*) "    cInputLong        ->",cInputLong(1:lengthInput),"<-"
        !D       Write (6,*) "    lengthInput:        ",lengthInput
        !D       Write (6,*) "    nPar:               ",nPar
        !D       Write (6,*) "    lPar:               ",lPar
        !D       Write (6,*) "    cPar              ->",cPar(1:lenc(cPar)),"<-"
        !
        !!   Index(line,"\")+1
        ii = Index(line,char(92))+1
        If (ii.Le.1) ii = 1
        jj = Index(line,'/')-1
        If (jj.Lt.1) jj = len_trim(line)
        cInputLong  = line(ii:jj)                            ! skip language and options
        lengthInput = len_trim(cInputLong)
        !
        Call SIC_BLANC(cInputLong,lengthInput)
        Call SIC_UPPER(cInputLong)
        !
        nPar = 1
        !
        Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! skip RECEIVER
        !
        Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! SKIP BOLOMETER
        !
        Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get  bolometer name
        !
        !D Write (6,*) "   "
        !D Write (6,*) "   --> bolometer "
        !D Write (6,*) "       cpar for bolometer name: -->", cpar(1:len_trim(cpar)), "<--"
        !D Write (6,*) "   "
        !
        errorNotFound = .False.
        !
     End If
     !
     error = error .Or. errorNotfound
     !
     If (.Not. error .And. SIC_NARG(0).Ge.2.) Then
        !
        Call pakoUmatchKey (                                                       &
             &              keys=bolometerChoices,                                 &
             &              key=cPar,                                              &
             &              command='RECEIVER',                                    &
             &              howto='Start Upper',                                   &
             &              iMatch=iMatch,                                         &
             &              nMatch=nMatch,                                         &
             &              error=errorC,                                          &
             &              errorCode=errorCode                                    &
             &             )                                                       !
        !
        !D Write (6,*) "      bolometerChoices:         ", bolometerChoices
        !D Write (6,*) "      iMatch: ", iMatch
        !D Write (6,*) "      cPar:   ", cPar
        !D Write (6,*) "      bolometerChoices(iMatch): ", bolometerChoices(iMatch)
        !D Write (6,*) "      errorC: ", errorC
        !D Write (6,*) "      errorCode: ", errorCode
        !
        ERROR = ERROR .Or. errorC
        !
        If (.Not. ERROR) Then
           !
           vars(iIn,iRec)%bolometerName = bolometerChoices(iMatch)
           If (vars(iIn,iRec)%bolometerName .Eq. bolo%mambo1) Then
              errorC = .True.
              Write (messageText, *) ' Bolometer ', bolo%mambo1,                   &
                   &  ' is no longer available '                                   !
              Call PakoMessage(priorityE,severityE,command,messageText)
!!$              vars(iIn,iRec)%nChannels     =  37
           Else If (vars(iIn,iRec)%bolometerName .Eq. bolo%mambo2) Then
              errorC = .True.
              Write (messageText, *) ' Bolometer ', bolo%mambo2,                   &
                   &  ' is no longer available '                                   !
              Call PakoMessage(priorityE,severityE,command,messageText)
!!$              vars(iIn,iRec)%nChannels     = 117
           Else If (vars(iIn,iRec)%bolometerName .Eq. bolo%gismo) Then
              errorC = .True.
              Write (messageText, *) ' Bolometer ', bolo%gismo,                    &
                   &  ' is no longer available '                                   !
              Call PakoMessage(priorityE,severityE,command,messageText)
           End If
           !
        End If
        !
     End If
     !
     If ( GV%doDebugMessages ) Then
        Write (6,*) "   "
        len = len_trim(vars(iIn,iRec)%bolometerName)
        Write (6,*) "       vars(iIn,iRec)%bolometerName: -->",                       &
             &              vars(iIn,iRec)%bolometerName(1:len) , "<--"               !
        !D    Write (6,*) "       bolo%nika :                   -->", bolo%nika, "<--"
        Write (6,*) "   "
     End If
     !
     error = error .Or. errorC
     !
     !
     If (            .Not.error                                                    &
          &    .And. vars(iIn,iRec)%bolometerName.Eq.bolo%nika                     &
          &    .And. SIC_NARG(0).Ge.3                                              &
          &   ) Then                                                               !
        !
        ! ***  bolometer channel / pixel
        !
        errorI = .False.
        !
        !
        Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get channel
        !
        !D       Write (6,*) "       cpar for bolometer channel/pixel: -->", cpar(1:len_trim(cpar)), "<--"
        !D       Write (6,*) "   "
        !
        !D       Write (6,*) " cPar, cPar(1:1), asterisk, asterisk(1:1): ",                 &
        !D            &        cPar, cPar(1:1), asterisk, asterisk(1:1)                     !
        !
        If (cPar(1:1).Ne.asterisk(1:1)) Then
           If (lPar.Gt.0) Then
              Read(cPar(1:lPar),'(I10)',iostat=ioerr) iInput
           End If
           !
           If (iInput.LT.1 .Or. iInput.GT.vars(iIn,iRec)%nChannels) Then
              errorI = .True.
              Write (messageText, *) ' channel / pixel', iInput, ' not valid. ', &
                   &  ' must be between 1 and ', vars(iIn,iRec)%nChannels        !
              Call PakoMessage(priorityE,severityE,command,messageText)
           End If
           !
           !
           !   ***   for NIKA: check configuration files for pixel Nasmyth offsets
           !
           foundPixel                    =  .False.
           !
!!$         NIKApixel%isSet               =  .False.
!!$         GV%sourceOffsets(iNas)%isSet  =  .False.
!!$         GV%arrayNasmythOffsetsAreSet  =  .False.
           !
           pixel = iInput
           !
           Write (messageText,*)                                                 &
                &         " looking for Nasmyth offsets for NIKA pixel ", pixel  !
           !! Write (6,*) "      messageText: -->", messageText, "<--"
           Call PakoMessage(priorityI,severityI,command,messageText)
           !
           iUnitR  =  ioUnit%Read
           !
           ii = 1
           !
           Do While ( .Not.foundPixel .And. ii.Le.4 )
              !
              Open(unit=iUnitR, action='read', file=NIKApixelFiles(ii),          &
                   &              status='old',                                  &
                   &              iostat=ier)                                    ! 
              !
              Write (messageText,*)                                              &
                   &   " try file ",                                             &
                   &   NIKApixelFiles(ii)(1:len_trim(NIKApixelFiles(ii)))        !
              Call PakoMessage(priorityI,severityI,command,messageText)
              !
              If (ier.Eq.0) then
                 !
                 Write (messageText,*)  " opened file ",                         &
                      &  NIKApixelFiles(ii)(1:len_trim(NIKApixelFiles(ii)))      !
                 Call PakoMessage(priorityI,severityI,command,messageText)
                 !
                 ioStatus = 0
                 !
                 Do While ( .Not.foundPixel .And. ioStatus.Eq.0 )
                    !
                    Read (iUnitR,'(a)',iostat=ioStatus) lineIn
                    !
                    If (ioStatus.Eq.0) Then
                       !
                       If ( lineIn(1:1).Ne."!"  .And. lineIn(1:1).Ne."#" ) Then
                          !                   
                          lineInTrim = lineIn
                          !
                          indexTrim  = min(Index(lineIn,"!"),Index(lineIn,"#"))-1
                          If ( indexTrim.Ge.1 ) Then
                             lineInTrim = lineIn(1:indexTrim)
                          End If
                          !
                          Read (lineInTrim,*,iostat=ioStatus)  jj, xx, yy
                          !
                          !D                       Write (6,*) "   jj, xx, yy ", jj, xx, yy
                          !
                          If (ioStatus.Eq.0) Then
                             !
                             If ( jj.Eq.pixel) then
                                foundPixel      =  .True.
                                !
                                NIKApixel%isSet         =  .True.
                                NIKApixel%systemName    =  offs%nas
                                NIKApixel%point%x       =  xx
                                NIKApixel%point%y       =  yy
                                NIKApixel%channel       =  pixel
                                NIKApixel%elevation     =  0
                                vars(iIn,iRec)%channel  =  pixel
                             End If
                             !
                          Else
                             !
                             Write (messageText,*)  " line ",                    &
                                  &                   lineIn(1:len_trim(lineIn)),&
                                  &                 " not valid"                 !
                             Call PakoMessage(priorityW,severityW,               &
                                  &           command,messageText)               !
                             !
                          End If
                          !
                       End If
                       !
                    End If
                    !
                 End Do
                 !
                 Close(unit=iUnitR)
                 !
              Else
                 !
                 Write (messageText,*)  " could not open file ",                 &
                      &     NIKApixelFiles(ii)(1:len_trim(NIKApixelFiles(ii)))   !
                 Call PakoMessage(priorityI,severityI,command,messageText)
                 !
              End If
              !
              ii = ii+1
              !
           End Do
           !
           If ( foundPixel ) Then
              !
              Write (messageText,'(A,I5,A,2F12.3)')                              &
                   &     " found offsets for NIKA pixel ", NIKApixel%channel,    &
                   &                                " : ", NIKApixel%point%x,    &
                   &                                       NIKApixel%point%y     !
              Call PakoMessage(priorityI,severityI,command,messageText)
              !
              GV%sourceOffsets(iNas)        =  NIKApixel
              GV%arrayNasmythOffsetsAreSet  =  .True.
              !
           Else
              !
              errorI  =  .True.
              Write (messageText,'(A,I5)')                                       &
                   &     " could not find offsets for NIKA pixel ", pixel        !
              Call PakoMessage(priorityE,severityE,command,messageText)
              !
!!$            GV%sourceOffsets(iNas)%isSet  =  .False.
!!$            GV%arrayNasmythOffsetsAreSet  =  .False.
              !
           End If
           !
           If (lPar.Gt.0 .And. ioerr.Eq.0 .And. .Not. errorI) Then  
              vars(iIn,iRec)%channel = iInput
           Else
              errorI = .True.
           End If
        End If
        !
        !D       Write (6,*) "  <-- in parametersReceiver.inc -- If NIKA "
        !
     End If   !!   .Not.error                                                    !
     !        !!    .And. vars(iIn,iRec)%bolometerName.Eq.bolo%nika              !
     !        !!    .And. SIC_NARG(0).Ge.3                                       !
     !
     error = error .Or. errorI
     !
     !D      Write (6,*) "                iRec:            ", iRec
     !D    Write (6,*) "       vars(iIn,iRec)%channel:   ", vars(iIn,iRec)%channel
     !
     !D      Write (6,*) "                vars(iIn,iRec):  "
     !D      Write (6,*) vars(iIn,iRec)
     !
     ! *** Read parameters for heterodyne receivers (not BOLOmeter)
     !
  Else If ( .Not.hasDefaults .And. .Not.hasClear .And.SIC_NARG(0).Ge.2) Then
     !
     !     --> NB: the following part revised 2014-01-22, 23                     ! !! --> 2014-01-22, 23
     !             to check against line name > 12 characters                      
     !             and to clean up error propragation
     !             Note analogy to handling of source name in SOURCE
     !
     NIKApixel%isSet         =  .False.
     NIKApixel%systemName    =  offs%nas
     NIKApixel%point%x       =  0.0
     NIKApixel%point%y       =  0.0
     NIKApixel%channel       =  1
     NIKApixel%elevation     =  0
     vars(iIn,iRec)%channel  =  1
     !
     ! *** line name
     !
     If (GV%doDebugMessages) Then
        Write (6,*) "   -> Read parameters for heterodyne receivers: "
        Write (6,*) "      hasDefaults: ", hasDefaults
        Write (6,*) "      hasClear:    ", hasClear
        !
        Write (6,*) "      ERROR:   ", ERROR
        !
     End If
     !
     If (.Not. error) Then
        !
        !D       Write (6,*) "   -> read line name into cInputLong "
        !
        iOption   = 0
        iArgument = 2
        If (SIC_PRESENT(iOption,iArgument)) Then
           Call SIC_CH(LINE,iOption,iArgument,                                   &
                &         cInputLong,lengthInput,.True.,errorC)                  !
        Else
           errorL = .True.
           messageText = "no line name specified"       
           Call PakoMessage(priorityI,severityI,command,messageText)
        End If
        !
        ERROR = ERROR .Or. errorC .Or. errorL
        !
        If (GV%doDebugMessages) Then
           Write (6,*) "      errorC:  ", errorC
           Write (6,*) "      errorL:  ", errorL
           Write (6,*) "      ERROR:   ", ERROR
        End If
        !
        !D       Write (6,*) "   -> check length "
        !
        errorC = lengthInput.Lt.1 .Or. lengthInput.Gt.12
        If (errorC) then
           messageText = "line name must have between 1 and 12 charcters"
           Call PakoMessage(priorityI,severityI,command,messageText)
        End If
        !
        ERROR = ERROR .Or. errorC
        !
        !D       Write (6,*) "   -> check special char "
        !
        Call pakoSpecialChar(cInputLong,"<>&",command=command,hasSpecial=errorC)
        !
        ERROR = ERROR .Or. errorC
        !
        If (ERROR) Then
           messageText = "line name invalid"
           Call PakoMessage(priorityE,severityE,command,messageText)
        End If
        !
        If (.Not.ERROR) Then
           cInput      = cInputLong(1:12)
           cInputUpper = cInput
           Call SIC_UPPER(cInputUpper)
        End If
        !
        !D       Write (6,*) "      cInput:      ", cInput
        !D       Write (6,*) "      cInputUpper: ", cInputUpper
        !
        If (SIC_PRESENT(iOption,iArgument)                                       &
             &       .And. .Not. ERROR) Then                                     !
           vars(iIn,iRec)%lineName = cInputUpper(1:lengthInput)
           messageText =                                                         &
                &        receiverSelected(1:lenc(receiverSelected))//            &
                &        " "//                                                   &
                &        vars(iIn,iRec)%lineName(1:lengthInput)                  !
           Call PakoMessage(priorityI,severityI,command,messageText)
        End If
        !
     End If   !!!   If (.Not. error) Then    !!!   read line name
     !
     error = error .Or. errorC     !!!     TBD: obsolete ?                       ! !! 2014-01-22, 23 <--
     !
     If (.Not. error) Then
        !
        If (SIC_NARG(0).Eq.2.) Then
           ! *** parameters should be in line catalog
           !
           !!OLD         messageText = " try line catalog: "//catalogList%line(1)(1:20)
           !!OLD         Call PakoMessage(priorityI,severityI,command,messageText)
           !!OLD         !
           messageText = " try line catalog: "//GVlineCatalog(1)
           Call PakoMessage(priorityI,severityI,command,messageText)
           !
           cFile = 'none'
           cFile = GVlineCatalog(1)
           !
           If (LENC(cFile).Eq.0) Then
              errorNotFound = .True.
              messageText = "no line catalog specified"
              Call PakoMessage(priorityE,severityE,command,messageText)
           Else
              Close(UNIT=10)
              Open(unit=10, action='read', file=cFile(1:lenc(cFile)),            &
                   &                 status='old', iostat=ier)                   !
              If (ier .Gt. 0) Then
                 errorNotFound = .True.
                 messageText =  "could not open line catalog: "                  &
                      &         //cFile(1:lenc(cFile))                           !
                 Call PakoMessage(priorityE,severityE,command,messageText)
              Else
                 catalogOpen = .True.
                 found = .False.
                 ioerr = 0
                 !
                 Do While (.Not. found .And. ioerr.Eq.0)
                    Read(10,'(A)',iostat=ioerr) cInputLong
                    lengthInput = len_trim(cInputLong)
                    !
                    !D  Write (6,*) "    lengthInput: ", lengthInput 
                    !D  Write (6,*) "    cInputLong:  -->",cInputLong(1:lengthInput),"<--"
                    !        ignore empty lines & comments 
                    If (lengthInput.Gt.0 .And. cInputLong(1:1).Ne.'!') Then
                       Call SIC_BLANC(cInputLong,lengthInput)
                       Call SIC_UPPER(cInputLong)
                       nPar = 1
                       lPar = 12
                       Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)          ! get line name
                       If (lPar.Ne.0) Then
                          lname = lenc(vars(iIn,iRec)%lineName)
                          name  = vars(iIn,iRec)%lineName(1:lname)
                          Call CHECKLINE(name,lname,cPar,lPar,found)
                       End If
                    Endif
                 Enddo
                 Close(UNIT=10)
                 !
                 If (found) Then
                    errorNotFound = .False.
                 Else
                    errorNotFound = .True.
                    messageText = "line not found in catalog: "                  &
                         &        //cFile(1:lenc(cFile))                         !
                    Call PakoMessage(priorityE,severityE,command,messageText)
                 End If
                 !
              End If
           End If
           !
        Else If (SIC_NARG(0).Gt.2.) Then
           ! *** parameters should be in command line
           !
           !D          Write (6,*) " use command line: ",line(1:lenc(line))
           messageText =                                                         &
                &      " use command line "                                      !
           Call PakoMessage(priorityI,severityI,command,messageText)
           !
           ii = Index(line,'RECEIVER')                                           ! skip language, command
           ii = ii + len_trim('RECEIVER')
           cInputLong  = line(ii:)
           lengthInput = LENC(cInputLong)
           !D                      Write (6,*) "    ii:                 ", ii
           !D                      Write (6,*) "    lengthInput         ", lengthInput
           !D                      Write (6,*) "    cInputLong        ->",cInputLong(1:lengthInput),"<-"
           !
           ii = Index(line,'/')
           If (ii.Eq.0) ii = LENC(line)+1
           cInputLong  = cInputLong(:ii-1)                                       ! ignore options
           lengthInput = LENC(cInputLong)
           Call SIC_BLANC(cInputLong,lengthInput)
           Call SIC_UPPER(cInputLong)
           !
           nPar = 1
           lPar = 12
           Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)                      ! skip receiver name
           Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)                      ! get  line name
           errorNotFound = .False.
           !
        End If
        !
        error = error .Or. errorNotfound
        !
        If (.Not. error .And. SIC_NARG(0).Ge.2. .And. GV%doDebugMessages) Then
           Write (6,*) "    lengthInput:        ",lengthInput
           Write (6,*) "    cInputLong        ->",cInputLong(1:lengthInput),"<-"
           Write (6,*) "    nPar:               ",nPar
           Write (6,*) "    lPar:               ",lPar
           Write (6,*) "    cPar              ->",cPar(1:lenc(cPar)),"<-"
           Write (6,*) "    cInputLong(nPar:) ->",cInputLong(nPar:lengthInput),"<-"!
        End If
        !
     End If
     !
     If (.Not. error .And. SIC_NARG(0).Ge.2.) Then
        !
        ! ***  get frequency
        !
        If (GV%doDebugMessages) Then
           Write (6,*) "   "
           Write (6,*) "    *** get frequency "
           Write (6,*) "    ================= " 
           Write (6,*) "   "
        End If
        !
        errorR = .False.
        !
        Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)                         !  !!  get frequency
        !
        iOption   = 0                                                            !  !!  added 2015-06-18           
        iArgument = 3                                                            !  !!  for frequency from variable
        !
        If (.Not. SIC_PRESENT(iOption,iArgument)) Then                           !  !!  added 2015-06-18
           !
           If (lPar.Gt.0) Then
              Read(cPar(1:lPar),'(F20.0)',iostat=ioerr) dInput
!!$              Read(cInput(1:lengthInput),*,iostat=ioerr) dInput
           End If
           !
           If (ioerr.Ne.0) Then
              !D               Write (6,*) " can not decode <-- instance 1"
              Write (messageText, *)   " can not decode ",                       &
                   &                     cPar(1:lPar)                            !
              Call pakoMessage(priorityE,severityE,command,                      &
                   &           messageText)                                      !
              ERROR = ERROR .Or. ioErr.ne.0
           End If
           !
           If (GV%doDebugMessages) Then
              Write (6,*) "    from catalog: "
              Write (6,*) "    LINE                  ->",                        &
                   &           LINE(1:len_trim(LINE)),"<-"                       !  
              Write (6,*) "    ioerr:                  ", ioerr
              Write (6,*) "    cPar                ->",                          &
                   &           cPar(1:len_trim(cPar)),"<-"                       !  
              Write (6,*) "    dInput:                 ",                        &
                   &           dInput                                            !
           End If
           !
        Else If (SIC_PRESENT(iOption,iArgument)) Then                            !  !!  added 2015-06-18           
           !                                                                     !  !!  for frequency from variable
           If (GV%doDebugMessages) Then
              Write (6,*) "    --> frequency from variable : "
              Write (6,*) "    LINE:                ->", LINE, "<-"
              Write (6,*) "    cInputLongFrequency: ->",                         &
                   &               cInputLongFrequency, "<-"                     !
              Write (6,*) "    iOption:               ", iOption
              Write (6,*) "    iArgument:             ", iArgument
              Write (6,*) "    lengthInput:           ", lengthInput
              Write (6,*) "    errorC:                ", errorC
           End If
           !
           Call SIC_CH(LINE,iOption,iArgument,                                   &
                 &         cInputLongFrequency,lengthInput,.True.,errorC)        !  !! modified 2016-01-15
           !                                                                     !  !! to allow long frequency strings
!!$           Call SIC_CH(LINE,iOption,iArgument,                                   &
!!$                 &         cInput,lengthInput,.True.,errorC)                     !
           !
           If ( .Not.errorC .And. lengthInput.Ge.1 ) Then
              Read(cInputLongFrequency(1:lengthInput),*,iostat=ioerr) dInput
!!$              Read(cInput(1:lengthInput),*,iostat=ioerr) dInput
!!$              Read(cInput(1:lengthInput),'(F20.0)',iostat=ioerr) dInput
              !D               Write (6,*) "    ioerr:       ", ioerr
              !D               Write (6,*) "    dInput:      ", dInput
           End If
           !
           If (ioerr.Ne.0) Then
              !D              Write (6,*) " can not decode <-- instance 2"
              Write (messageText, *)   " can not decode ",                       &
                   &                     cInput(1:lengthInput)                   !
              Call pakoMessage(priorityE,severityE,command,                      &
                   &           messageText)                                      !
              ERROR = ERROR .Or. ioErr.ne.0
           End If
           !
           If (GV%doDebugMessages) Then
              Write (6,*) "    from command line: "
              Write (6,*) "    LINE                  ->",                        &
                   &           LINE(1:len_trim(LINE)),"<-"                       !  
              Write (6,*) "    ioerr:                  ", ioerr
              Write (6,*) "    cInput                ->",                        &
                   &           cInput(1:len_trim(cInput)),"<-"                   !  
              Write (6,*) "    dInput:                 ",                        &
                   &           dInput                                            !
           End If
           !
        End If                                                                   !  !!  <-- 2015-06-18
        !
        If (          (                                                          &
             &        GV%iLimitCheck.Eq.iLoose                                   &
             &  .Or.  GV%iEMIRcheck .Eq.iLoose                                   &
             &        )                                                          &
             &  .And. lPar.Gt.0 .And. ioerr.Eq.0) Then                           !
           If (0.Le.dInput) Then                                                 !  !!  loose limits
              vars(iIn,iRec)%frequency%value = dInput
              errorR = .False.
           Else
              errorR = .True.
              Write (messageText, *)     dInput,                                 &
                   &                   " is outside loose limits "               !
              Call pakoMessage(priorityE,severityE,command,                      &
                   &           messageText)                                      !
           End If
        Else If (     (                                                          &
             &        GV%iLimitCheck.Eq.iRelaxed                                 &
             &  .Or.  GV%iEMIRcheck .Eq.iRelaxed                                 &
             &        )                                                          &
             &  .And. lPar.Gt.0 .And. ioerr.Eq.0) Then                           !
           If (1.0D0.Le.dInput .And. dInput.Le.1000.0D0) Then                        !  relaxed limits
              vars(iIn,iRec)%frequency%value = dInput
              errorR = .False.
           Else
              errorR = .True.
              Write (messageText, *)     dInput,                                 &
                   &                   " is outside relaxed limits "             !
              Call pakoMessage(priorityE,severityE,command,                      &
                   &           messageText)                                      !
           End If
        Else If (lPar.Gt.0 .And. ioerr.Eq.0) Then  
           Call checkR8(command,dInput,                                          &   !  regular limits
                &               vars(:,iRec)%frequency%value,                    &
                &               errorR)                                          !
        Else
           errorR = .True.
        End If
        !
        ! NOTE:
        ! if the frequency is below 80 GHz for the 3mm RXs (pre-EMIR),
        ! the logical flag %useSpecialLO is set to indicate
        ! that special LO hardware and caclulations are used
        ! TBD:
        ! should handle %frequency%unit, for now assumed to be GHz
        !
        If (.Not. errorR) Then
           If ( iRec.Eq.iA100 .Or. iRec.Eq.iB100 ) Then
              If ( vars(iIn,iRec)%frequency%value.LT.80.0D0 ) Then
                 vars(iIn,iRec)%useSpecialLO = .True.
              Else
                 vars(iIn,iRec)%useSpecialLO = .False.
              End If
           End If
        End If
        !
     End If
     !
     error = error .Or. errorR
     !
     If (.Not. ERROR .And. .Not. hasSband .And. SIC_NARG(0).Ge.2.) Then
        ! ***  subband / sideband
        !
        errorC = .False.
        Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get subband/sideband
        !
        !  ** EMIR
        !D       Write (6,*) "      iRec:   ", iRec
        If (        iRec.Eq.iE090                                                &
             & .Or. iRec.Eq.iE150                                                &
             & .Or. iRec.Eq.iE230                                                &
             & .Or. iRec.Eq.iE300                                                &
             & ) Then                                                            !
           !
           !D          Write (6,*) "      matching EMIR subband ..."
           !D          Write (6,*) "      cPar :           ", cPar
           !D          Write (6,*) "      subbandChoices : ", subbandChoices
           !
           Call pakoUmatchKey (                                                  &
                &              keys=subbandChoices,                              &
                &              key=cPar,                                         &
                &              command='RECEIVER',                               &
                &              howto='Start Upper',                              &
                &              iMatch=iMatch,                                    &
                &              nMatch=nMatch,                                    &
                &              error=errorC,                                     &
                &              errorCode=errorCode                               &
                &             )                                                  !
           !
           ERROR = ERROR .Or. errorC
           !
           If    (         GV%iUserLevel .Lt. iExperienced                       &
                &  .And. (iMatch.Eq.iLSB .Or. iMatch.Eq.iUSB) ) Then             !
              errorL = .True.
              messageText = subbandChoices(iMatch)//                             &
                   &        "requires higher user level"                         !
              Call PakoMessage(priorityE,severityE,                              &
                   & command,                                                    &
                   & messageText)                                                !
           End If
           ERROR = ERROR .Or. errorL
           !
           If (.Not. ERROR) Then
              vars(iIn,iRec)%sideBand = subbandChoices(iMatch)
              If      (      vars(iIn,iRec)%sideBand .Eq. esb%li                 &
                   &    .Or. vars(iIn,iRec)%sideBand .Eq. esb%ui  ) Then         !
                 vars(iIn,iRec)%centerIF       =  IF%EMIRinner
                 vars(iIn,iRec)%IF2            =  IF2%EMIRinner
              Else If (      vars(iIn,iRec)%sideBand .Eq. esb%lo                 &
                   &    .Or. vars(iIn,iRec)%sideBand .Eq. esb%uo  ) Then         !
                 vars(iIn,iRec)%centerIF       =  IF%EMIRouter
                 vars(iIn,iRec)%IF2            = IF2%EMIRouter
              Else If (      vars(iIn,iRec)%sideBand .Eq. esb%lsb                &
                   &    .Or. vars(iIn,iRec)%sideBand .Eq. esb%usb ) Then         !
                 If (iRec.Eq.iE090) Then
                    vars(iIn,iRec)%centerIF       =  IF%EMIRio
                    vars(iIn,iRec)%IF2            = IF2%EMIRio
                 Else
                    vars(iIn,iRec)%centerIF       =  IF%EMIRinner
                    vars(iIn,iRec)%IF2            =  IF2%EMIRinner
                 End If
              End If
           End If
           !
           !D Write (6,*) "      vars(iIn,iRec)%sideBand:      ", vars(iIn,iRec)%sideBand
           !D Write (6,*) "      vars(iIn,iRec)%centerIF:      ", vars(iIn,iRec)%centerIF
           !D Write (6,*) "      vars(iIn,iRec)%IF2:           ", vars(iIn,iRec)%IF2
           !
        Else
           !
           Call pakoUmatchKey (                                                  &
                &              keys=sidebandChoices,                             &
                &              key=cPar,                                         &
                &              command='RECEIVER',                               &
                &              howto='Start Upper',                              &
                &              iMatch=iMatch,                                    &
                &              nMatch=nMatch,                                    &
                &              error=errorC,                                     &
                &              errorCode=errorCode                               &
                &             )                                                  !
           !
           ERROR = ERROR .Or. errorC
           !
           If (.Not. ERROR) Then
              vars(iIn,iRec)%sideBand = sidebandChoices(iMatch)
           End If
           !
        End If
        !
     End If
     !
     !D    Write (6,*) " vars(iIn,iRec)%frequency%value: ", vars(iIn,iRec)%frequency%value
     !D    Write (6,*) " vars(iIn,iRec)%sideBand:        ", vars(iIn,iRec)%sideBand
     !
  End If  !  *** end if not bolometer
  !
  Call pako_message(seve%t,programName,                                          &
       &    " module Receiver  <-- parametersReceiver.inc ")                     ! 
  !
  ! =============================================================================
  !



  !!OLD   errorC = .True.
  !!OLD   Write (messageText, *) " Pako "//pakoVersion//" does not know any Bolometers "
  !!OLD   Call PakoMessage(priorityE,severityE,command,messageText)
  !!OLD   !
  !!OLD   Write (messageText, *) " MAMBO is decomissioned "
  !!OLD   Call PakoMessage(priorityI,severityI,command,messageText)
  !!OLD   !
  !!OLD   error = error .Or. errorC
  !!OLD      ! * parameters should be in command line
  !!OLD      messageText =                                              &
  !!OLD           &      " reading from command line "
  !!OLD      Call PakoMessage(priorityI,severityI,command,messageText)
  !!OLD      !
  !!OLD      ii = Index(line,'/')
  !!OLD      If (ii.Eq.0) ii = LENC(line)+1
  !!OLD      cInputLong  = line(14:ii-1)                   ! skip language, command, and options
  !!OLD      lengthInput = LENC(cInputLong)
  !!OLD      Call SIC_BLANC(cInputLong,lengthInput)
  !!OLD      Call SIC_UPPER(cInputLong)
  !!OLD      !
  !!OLD      nPar = 1
  !!OLD      lPar = 12
  !!OLD      Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! skip receiver name
  !!OLD      Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get  bolometer name
  !!OLD      errorNotFound = .False.
  !!OLD      !
  !!OLD   End If

!!$   If (.Not. error .And. SIC_NARG(0).Eq.2) Then
!!$      ! 
!!$      If (vars(iIn,iRec)%bolometerName .Eq. bolo%mambo1) Then
!!$         vars(iIn,iRec)%channel =   MAMBO1%iPixelBest    
!!$      End If
!!$      !
!!$   End If
!!$   !
!!$   If (.Not. error .And. SIC_NARG(0).Ge.3) Then
!!$      ! ***  bolometer gain
!!$      !
!!$      errorR = .False.
!!$      !
!!$      Call SIC_NEXT (cInputLong(nPar:),cPar,lPar,nPar)     ! get gain
!!$      !
!!$      If (cPar(1:1).Ne.'*') Then
!!$         If (lPar.Gt.0) Then
!!$            Read(cPar(1:lPar),'(F20.0)',iostat=ioerr) rInput
!!$         End If
!!$         !
!!$         If (lPar.Gt.0 .And. ioerr.Eq.0) Then  
!!$            !
!!$            Call pakoUmatchReal(gainBolometerChoices,rInput,0.1,                 &
!!$                 &    command//" gainBolo ","DELTA",                             &
!!$                 &    iMatch,nMatch,errorR,errorCode)                            !
!!$            If (.Not. errorR) Then
!!$               vars(iIn,iRec)%gainBolometer = rInput
!!$            End If
!!$         Else
!!$            errorR = .True.
!!$         End If
!!$      End If
!!$      !
!!$   End If
!!$   !
!!$   error = error .Or. errorR
!!$   !
!!$   If (.Not. error .And. SIC_NARG(0).Ge.4.) Then
!!$      ! ***  bolometer channel
!!$      !

              !!OLD       If ( (iRec.Eq.iE150.Or.iRec.Eq.iE230.Or.iRec.Eq.iE300)               & !!  EMIR upgrade:
!!$                                                                                   !!  obsolete with upgrade E150 2013-09
!!$            If ( (iRec.Eq.iE150)                                                 & !!  v 1.1.11
!!$                 &    .And. (iMatch.Eq.iLo .Or. iMatch.Eq.iUo)                   &
!!$                 &  ) Then                                                       !
!!$               !                     
!!$               ERROR = .True.
!!$               l  = Len_trim (vars(iIn,iRec)%name)
!!$               l2 = Len_trim (subbandChoices(iMatch))
!!$               messageText = "subband: "                                         &
!!$                    &       //subbandChoices(iMatch)(1:l2)//                     &
!!$                    &        " does not exist for this band "                    !
!!$               Call PakoMessage(priorityE,severityE,                             &
!!$                    & command//" "//vars(iIn,iRec)%name(1:l),                    &
!!$                    & messageText)                                               !
!!$               !
!!$            End If
