subroutine explore_comm(line,comm,error)
  use gkernel_interfaces
  !---------------------------------------------------------------------
  !
  ! EXPLORE [DataCube] [/ADD Ux Uy [Ibox]] [/NOWAIT]
  !
  !    Call the "explore" scripts that allow to display from a data cube
  ! - a 2-D image (channel or integrated area)
  ! - spectra at selected positions around it
  !
  ! The display is organized in a Keypad layout
  !     7 8 9
  !     4 5 6
  !     1 2 3
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: line
  character(len=*), intent(in) :: comm
  logical, intent(out) :: error
  !
  integer, parameter :: o_add=1
  integer, parameter :: o_nowait=2
  !
  logical :: wait,add,doit
  character(len=24) :: cx,cy,cb
  character(len=256), save :: what
  integer :: nx,ny,nb
  integer, save :: nw
  !
  cb = ' '
  call sic_ch(line,0,1,cb,nb,.false.,error)
  if (cb.eq.'?') then
    call exec_program('@ i_explore')
    return
  endif
  !
  add = sic_present(o_add,0)
  if (add) then
    wait = .false.
  else
    wait = .not.sic_present(o_nowait,0)
  endif
  !
  if (add) then
    call sic_ch(line,o_add,1,cx,nx,.true.,error)
    if (error) return
    call sic_ch(line,o_add,2,cy,ny,.true.,error)
    if (error) return
    call sic_ch(line,o_add,3,cb,nb,.false.,error)
    if (error) return
    nb = nb+1
    call exec_program('@ add_spectrum '//cx(1:nx)//' '//cy(1:ny)//' '//cb(1:nb))
  else
    doit = nw.eq.0
    call sic_ch(line,0,1,what,nw,doit,error)
    if (error) return
    !
    if (wait) then
      call exec_program('@ p_explore '//what(1:nw))
    else
      call exec_program('@ p_explore '//what(1:nw)//' nowait')
    endif
  endif
    
end subroutine explore_comm
