!
!   Id: inc/startXML/source.inc, v 1.2.3 2014-10-16 Hans Ungerechts
!
  If (GV%doDebugMessages) Then
     Write (6,*)  "      --> inc/startXML/source.inc, v 1.2.3 2014-10-16 "
  End If
  !
      Call pakoXMLwriteStartElement("RESOURCE","source",               &
     &                         comment="generated by paKo",            &
     &                         space ="before",                          &
     &                         error=errorXML)
!
! ** BODY
      If (vars(iValue)%isBody) Then
         !
         valueC = "BODY "//vars(iValue)%sourceName
         Write (valueComment,*) "solar system body"
         Call pakoXMLwriteElement("PARAM","sourceName",valueC,                  &
              &                         dataType="char",                        &
              &                         comment=valueComment,                   &
              &                         error=errorXML)
         !
         Write (valueC,'(F20.6)') vars(iValue)%perihelionEpoch-2400000.5D0
         Write (valueComment,'(A,F20.6,A)')                                     &
              &    "MJD (!). JD is: ", vars(iValue)%perihelionEpoch," d "
         Call pakoXMLwriteElement("PARAM","perihelionEpoch",valueC,             &
              &                         unit="d",                               &
              &                         dataType="double",                      &
              &                         comment=valueComment,                   &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') vars(iValue)%ascendingNode*deg
         Write (valueComment,*) vars(iValue)%ascendingNode, au%degree
         Call pakoXMLwriteElement("PARAM","ascendingNode",valueC,               &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         comment=valueComment,                   &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') vars(iValue)%argumentOfPerihelion*deg
         Write (valueComment,*) vars(iValue)%argumentOfPerihelion, au%degree
         Call pakoXMLwriteElement("PARAM","argumentOfPerihelion",valueC,        &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         comment=valueComment,                   &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') vars(iValue)%inclination*deg
         Write (valueComment,*) vars(iValue)%inclination, au%degree
         Call pakoXMLwriteElement("PARAM","inclination",valueC,                 &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         comment=valueComment,                   &
              &                         error=errorXML)
         !
         Write (valueC,'(F20.6)') vars(iValue)%perihelionDistance
         Call pakoXMLwriteElement("PARAM","perihelionDistance",valueC,         &
              &                         unit="AU",                              &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,'(F20.6)') vars(iValue)%eccentricity
         Call pakoXMLwriteElement("PARAM","eccentricity",valueC,                &
              &                         unit="--",                              &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
      End If
!
! **
      If (.Not. vars(iValue)%isBody) Then
         l = len_trim(vars(iValue)%sourceName)
         !D          Write (6,*) "   vars(iValue)%sourceName -->", vars(iValue)%sourceName, "<--"
         !D          Write (6,*) "   l:                         ", l
         If ( index(SpecialSources%TipCurAzi,vars(iValue)%sourceName(1:l))       &
              &   .Eq.1 ) Then                                                   !
            valueC = SpecialSources%TipCurAzi
            !D             Write (6,*) "   write XML source name: ", valueC
         Else
            Write (valueC,*) vars(iValue)%sourceName
         End If
         Call pakoXMLcase(valueC,error=errorXML)
         Call pakoXMLwriteElement("PARAM","sourceName",valueC,                   &
              &                         dataType="char",                         &
              &                         error=errorXML)                          !
      End If
      !
      If (.Not. (     vars(iValue)%isBody                                        &
           &     .Or. vars(iValue)%isPlanet                                      &
           &     .Or. vars(iValue)%isSatellite) ) Then                           !
         !
         If (GV%doDebugMessages) Then
            Write (6,*) "   vars(iDefault)%systemName:           -->",           &
                 &          vars(iDefault  )%systemName, "<--"                   !
            Write (6,*) "   vars(iIn     )%systemName:           -->",           &
                 &          vars(iIn   )%systemName, "<--"                       !
            Write (6,*) "   vars(iValue  )%systemName:           -->",           &
                 &          vars(iValue)%systemName, "<--"                       !
            Write (6,*) "   vars(iDefault)%equinoxSystemName:    -->",           &
                 &          vars(iDefault  )%equinoxSystemName, "<--"            !
            Write (6,*) "   vars(iIn     )%equinoxSystemName:    -->",           &
                 &          vars(iIn   )%equinoxSystemName, "<--"                !
            Write (6,*) "   vars(iValue  )%equinoxSystemName:    -->",           &
                 &          vars(iValue)%equinoxSystemName, "<--"                !
            Write (6,*) "   vars(iDefault)%epoch:                -->",           &
                 &          vars(iDefault  )%epoch, "<--"                        !
            Write (6,*) "   vars(iIn     )%epoch:                -->",           &
                 &          vars(iIn   )%epoch, "<--"                            !
            Write (6,*) "   vars(iValue  )%epoch:                -->",           &
                 &          vars(iValue)%epoch, "<--"                            !
         End If
         !
         valueC = vars(iValue)%systemName
         Call pakoXMLcase(valueC,error=errorXML)
         Call pakoXMLwriteElement("PARAM","basisSystem",valueC,                  &
              &                         dataType="char",                         &
              &                         error=errorXML)                          !
         !
         ! TBD: equinoxSystem from SOURCE command ??
         !
         !                                                                       !  !! 2012-11-19: patches for
         !                                                                       !  !! DIY-tip with NIKA
         valueC = vars(iValue)%equinoxSystemName
         If (vars(iValue  )%systemName .Eq. sys%horizontal) Then                 !  !! 2012-11-19: for horizontal:
            valueC = equ%J                                                       !  !! enforce equinoxSystem "J"
         End If
         Call pakoXMLwriteElement("PARAM","equinoxSystem",valueC,                &
              &                         dataType="char",                         &
              &                         error=errorXML)                          !
         !
         Write (valueC,*) vars(iValue)%epoch
         If (vars(iValue  )%systemName .Eq. sys%horizontal) Then                 !  !! 2012-11-19: for horizontal:
            valueC = "2000.000"                                                  !  !! enforce equinoxYear "2000.0"
         End If
         Call pakoXMLwriteElement("PARAM","equinoxYear",valueC,                  &
              &                         unit="yr",                               &
              &                         dataType="double",                       &
              &                         error=errorXML)                          !
         !
         Write (valueC,'(ES20.12)') vars(iValue)%longitude%rad
         Call pakoXMLwriteElement("PARAM","lambda",valueC,                       &
              &                         unit="rad",                              &
              &                         dataType="double",                       &
              &                         error=errorXML)                          !
         !
         Write (valueC,'(ES20.12)') vars(iValue)%latitude%rad
         Call pakoXMLwriteElement("PARAM","beta",valueC,                  &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,*) "NONE"
         Call pakoXMLcase(valueC,error=errorXML)
         Call pakoXMLwriteElement("PARAM","desriptiveSystem",valueC,      &
              &                         dataType="char",                        &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","alphaD",valueC,                &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","betaD",valueC,                 &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","gammaD",valueC,                &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,*) "RADIO"
         Call pakoXMLcase(valueC,error=errorXML)
         Call pakoXMLwriteElement("PARAM","projection",valueC,            &
              &                         dataType="char",                        &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","lambdaProjection",valueC,      &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","betaProjection",valueC,        &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
         Write (valueC,'(ES20.12)') 0.0
         Call pakoXMLwriteElement("PARAM","kappaProjection",valueC,       &
              &                         unit="rad",                             &
              &                         dataType="double",                      &
              &                         error=errorXML)
         !
      End If
! **
!
      Call writeXMLradialVelocity(programName,LINE,commandToSave,        &
     &        iUnit, ERROR)
!
      Call writeXMLoffsets(programName,LINE,commandToSave,               &
     &        iUnit, ERROR)
!
      Call writeXMLtopology(programName,LINE,commandToSave,              &
     &        iUnit, ERROR)
!
      Call writeXMLpointingCorrections(programName,LINE,commandToSave,   &
     &        iUnit, ERROR)
!
      Call writeXMLfocusCorrections(programName,LINE,commandToSave,      &
     &        iUnit, ERROR)
!
      Call pakoXMLwriteEndElement  ("RESOURCE","source",                 &
     &                         space="after",                            &
     &                         error=errorXML)
!



