!
!  Id: checkEMIR.inc,v        1.2.5  2016-06-09 Hans Ungerechts
!                             1.2.5  2016-03-31 Hans Ungerechts
!  Id: checkEMIR.inc,v        1.1.15 2013-08-26, 27 Hans Ungerechts 
!                             1.1.15 2013-08-26 E150 upgrade
!
!  Id: checkEMIR.inc,v        1.1.14 2012-11-06 Hans Ungerechts
!  Id: checkEMIR.inc,v        1.1.13 2012-09-17 Hans Ungerechts
!  Id: checkEMIR.inc,v        1.1.12 2012-06-04 Hans Ungerechts
!
!                             1.1.11 2011-11-14 EMIR upgrade
!
Call pako_message(seve%t,programName,                                            &
     &    " checkEMIR.inc, 1.2.5 2016-06-09 ")                                   ! this allows to trace execution
!
If (        vars(iIn,iBolo)%isConnected                                          &   !!!   TBD for HEMT
     & .Or. vars(iIn,iHERA)%isConnected                                          &
     & .Or. vars(iIn,iHERA1)%isConnected                                         &
     & .Or. vars(iIn,iHERA2)%isConnected                                         &
     & ) Then                                                                    !
   !
   errorInconsistent = .True.
   Write (messageText, *) "receiver combination not possible " 
   Call PakoMessage(priorityE,severityE,command//" (EMIR)",messageText)
   !
End If
!
!!  ** EMIR: count number of bands
!
countRX  = 0
EMIRlist = ""
!
If (vars(iIn,iE090)%isConnected) Then 
   countRX  = countRX+1
   l        = Len_trim(EMIRlist)
   EMIRlist = EMIRlist(1:l)//"+"//rec%E090(1:4)
End If
If (vars(iIn,iE150)%isConnected) Then 
   countRX  = countRX+1
   l        = Len_trim(EMIRlist)
   EMIRlist = EMIRlist(1:l)//"+"//rec%E150(1:4)
End If
If (vars(iIn,iE230)%isConnected) Then 
   countRX  = countRX+1
   l        = Len_trim(EMIRlist)
   EMIRlist = EMIRlist(1:l)//"+"//rec%E230(1:4)
End If
If (vars(iIn,iE300)%isConnected) Then 
   countRX  = countRX+1
   l        = Len_trim(EMIRlist)
   EMIRlist = EMIRlist(1:l)//"+"//rec%E300(1:4)
End If
!
l        = Len_trim(EMIRlist)
EMIRlist = EMIRlist(2:l)         ! get rid of 1st "+"
l        = Len_trim(EMIRlist)
!
!!  ** EMIR: check maximum number of bands
!
If (countRX .Gt.2) Then
   !   
   errorInconsistent = .True.
   Write (messageText, *) "maximum 2 bands " 
   Call PakoMessage(priorityE,severityE,command//" (EMIR)",messageText)
   !
End If
!
!!  ** EMIR: check possible band combinations
!
If (countRX .Eq.2) Then
   !   
   If (.Not. (     vars(iIn,iE090)%isConnected.And.vars(iIn,iE150)%isConnected   &
        &     .Or. vars(iIn,iE090)%isConnected.And.vars(iIn,iE230)%isConnected   &
        &     .Or. vars(iIn,iE150)%isConnected.And.vars(iIn,iE300)%isConnected   &
        &    ) ) Then                                                            !
      !   
      errorInconsistent = .True.
      Write (messageText, *) "band combination "//EMIRlist(1:l)                  &
           &               //" not possible with dichroics"                      !
      Call PakoMessage(priorityE,severityE,command//" (EMIR)",messageText)
      !
      !!  ** EMIR: usage note
      !
      Write (messageText, *) "possible band selections: ",                       &
           &                  rec%E090, rec%E150, rec%E230, rec%E300,            &
           &                  rec%E090(1:4)//"+"//rec%E150(1:4)," ",             &
           &                  rec%E090(1:4)//"+"//rec%E230(1:4)," ",             &
           &                  rec%E150(1:4)//"+"//rec%E300(1:4)                  !
      Call PakoMessage(priorityI,severityI,command//" (EMIR)",messageText)
      !
   End If
   !
End If
!
!!  ** EMIR: check to dis-allow  /horizontal none  /vertical none 
!!           i.e., disallow CT's "trick"
!!           see email HU 2009-07-10
!
Do ii = iE090, iE300, 1
   If (vars(iIn,ii)%isConnected) Then
      !
      !D       Write (6,*)
      !D       !
      !D       Write (6,*) "   ii : ", ii
      !D       Write (6,*) "   ", vars(iIn,ii)%name
      !D       Write (6,*) "   horizontal: ", vars(iIn,ii)%horizontalSubbands
      !D       Write (6,*) "   vertical:   ", vars(iIn,ii)%verticalSubbands
      !
      If (   vars(iIn,ii)%horizontalSubbands .Eq. GPnone   .And.                 &
           & vars(iIn,ii)%verticalSubbands   .Eq. GPnone )        Then           !
         !
         errorInconsistent = .True.
         Write (messageText, *) vars(iIn,ii)%name,                               &
              &   "/Horizontal NONE /Vertical NONE   IS NOT SUPPORTED"           !
         Call PakoMessage(priorityE,severityE,command,messageText)
         Write (messageText, *) vars(iIn,ii)%name,                               &
              &   "must select valid sub band for /Horizontal or /Vertical "     !
         Call PakoMessage(priorityW,severityW,command,messageText)
         Write (messageText, *) vars(iIn,ii)%name,                               &
              &   "If you want no subband of it: don't select this EMIR band"    !
         Call PakoMessage(priorityI,severityI,command,messageText)
         !
      End If
      !
   End If
End Do
!
!!  **  EMIR: new limit checking scheme based in EMIR user wiki  2016-04 to -06
!
If (         GV%EMIRcheck.Eq.setLimitCheck%anal                                  &  !!  only if set emir "test" or "a..."
     &  .Or. GV%EMIRcheck.Eq.setLimitCheck%test ) Then                           !
   !
   If (.Not.errorInconsistent .And. (      GV%EMIRcheck.Eq.setLimitCheck%test    &
        &                             .Or. (        GV%iLimitCheck.Le.iStrict    &
        &                                     .And. GV%iEMIRcheck .Le.iStrict )  &
        &                           )                                            &
        &   ) Then                                                               !
      !
      Do ii = iE090, iE300, 1                                                    ! !! loop over EMIR bands
         !
         If (vars(iIn,ii)%isConnected) Then
            !
            If (GV%doDebugMessages) Then
               Write (6,*) "             "
               Write (6,*) "  EMIR rules "
               Write (6,*) "  ========== "
            End If
            !
            Do jj = 1, nDimEMIRrules, 1                                          ! !! loop over EMIR rules
               !
               If (GV%doDebugMessages) Then
                  Write (6,*) "  jj = ", jj
                  Write (6,*) "  EMIRrules(jj) : "
                  Write (6,*)    EMIRrules(jj)
                  Write (6,*) "  "
               End If
               !
               If (          receiverChoices(ii)   .Eq. EMIRrules(jj)%band       & !! match band and subband of rules
                    & .And.  vars(iIn,ii)%sideband .Eq. EMIRrules(jj)%subBand    &
                    &  ) Then
                  !
                  messageText = GPnone
                  !
                  If     ( EMIRrules(jj)%test .Eq. EMIRtest%under                &  !! test frequency under hi 
                       &  .And.                                                  &
                       &  .Not. (                                                &
                       &    vars(iIn,ii)%frequency%value.Le.EMIRrules(jj)%hi+eps &  !! test <= hi+eps(ilon)
                       &        )                                                &
                       & ) Then                                                  !
                     !
                     errorInconsistent = errorInconsistent                       &
                          &         .Or. EMIRrules(jj)%severity.Ge.severityE     !
                     Write (messageText, '( A," ",                               &
                          &                 A," ",                               &
                          &                 F12.6, " ",                          &
                          &                 A," ",                               &
                          &                 " Broken Rule: ", A,                 &
                          &                 F12.3) ')                            &
                          &                 EMIRrules(jj)%band,                  &
                          &                 vars(iIn,ii)%lineName,               &
                          &                 vars(iIn,ii)%frequency%value,        &
                          &                 EMIRrules(jj)%subBand,               &
                          &                 EMIRrules(jj)%message,               &
                          &                 EMIRrules(jj)%hi                     !
                     !
                  End If   !!   test frequency under hi
                  !
                  If     ( EMIRrules(jj)%test .Eq. EMIRtest%inRange              &  !! test frequency in range lo to hi 
                       &  .And.                                                  &
                       &  .Not. (                                                &
                       &    vars(iIn,ii)%frequency%value.Ge.EMIRrules(jj)%lo-eps &  !! test >= lo-eps(ilon)
                       &  .And.                                                  &
                       &    vars(iIn,ii)%frequency%value.Le.EMIRrules(jj)%hi+eps &  !! test <= hi+eps(ilon)
                       &        )                                                &
                       & ) Then                                                  !
                     !
                     errorInconsistent = errorInconsistent                       &
                          &         .Or. EMIRrules(jj)%severity.Ge.severityE     !
                     Write (messageText, '( A," ",                               &
                          &                 A," ",                               &
                          &                 F12.6, " ",                          &
                          &                 A," ",                               &
                          &                 " Broken Rule: ", A,                 &
                          &                 F12.3,                               &
                          &                 F12.3) ')                            &
                          &                 EMIRrules(jj)%band,                  &
                          &                 vars(iIn,ii)%lineName,               &
                          &                 vars(iIn,ii)%frequency%value,        &
                          &                 EMIRrules(jj)%subBand,               &
                          &                 EMIRrules(jj)%message,               &
                          &                 EMIRrules(jj)%lo,                    &
                          &                 EMIRrules(jj)%hi                     !
                     !
                  End If   !!   test frequency in range lo to hi
                  !
                  !
                  If     ( EMIRrules(jj)%test .Eq. EMIRtest%over                 &  !! test frequency over > lo
                       &  .And.                                                  &
                       &  .Not. (                                                &
                       &    vars(iIn,ii)%frequency%value.Ge.EMIRrules(jj)%lo-eps &  !! test >= lo-eps(ilon)
                       &        )                                                &
                       & ) Then                                                  !
                     !
                     errorInconsistent = errorInconsistent                       &
                          &         .Or. EMIRrules(jj)%severity.Ge.severityE     !
                     Write (messageText, '( A," ",                               &
                          &                 A," ",                               &
                          &                 F12.6, " ",                          &
                          &                 A," ",                               &
                          &                 " Broken Rule: ", A,                 &
                          &                 F12.3) ')                            &
                          &                 EMIRrules(jj)%band,                  &
                          &                 vars(iIn,ii)%lineName,               &
                          &                 vars(iIn,ii)%frequency%value,        &
                          &                 EMIRrules(jj)%subBand,               &
                          &                 EMIRrules(jj)%message,               &
                          &                 EMIRrules(jj)%lo                     !
                     !
                  End If   !!   test frequency over > lo
                  !
                  If (messageText.Ne.GPnone) Then
                     Call PakoMessage(EMIRrules(jj)%priority,                    &
                          &           EMIRrules(jj)%severity,                    &
                          &           command,messageText)                       !
                     If (EMIRrules(jj)%comment.Ne.GPnone) Then
                        Call PakoMessage(EMIRrules(jj)%priority,                 &
                             &           EMIRrules(jj)%severity,                 &
                             &           command,EMIRrules(jj)%comment)          !
                     End If
                  End If
                  !
               End If   !!   receiverChoices(ii)   .Eq. EMIRrules(jj)%band
               !
            End Do   !!   jj = 1, nDimEMIRrules, 1
            !
         End If   !!   vars(iIn,ii)%isConnected
         !
      End Do   !!   ii = iE090, iE300, 1
      !
   End If   !!   GV%EMIRcheck.Eq.setLimitCheck%test  ... (more)
   !
End If  !!        GV%EMIRcheck.Eq.setLimitCheck%anal
!       !!   .Or. GV%EMIRcheck.Eq.setLimitCheck%test
!
!!  ** EMIR: check frequency and LO ranges
!
!!$If (GV%iEMIRcheck.Ne.iAnal) Then                                              ! !! NOTE: 2016-03-31
!                                                                                ! !! NOTE: temporary to test new "rules"
If (.Not.  (  GV%EMIRcheck.Eq.setLimitCheck%anal                                 & 
     &   .Or. GV%EMIRcheck.Eq.setLimitCheck%test )  ) Then                       ! 
!
If (.Not.errorInconsistent .And. (      GV%iLimitCheck.Le.iStrict                &
     &                            .And. GV%iEMIRcheck .Le.iStrict  )   ) Then    !
   !
   Do ii = iE090, iE300, 1
      If (vars(iIn,ii)%isConnected) Then
         !
         !
         !!       * EMIR: check LO ranges
         !
         fLO = vars(iIn,ii)%frequency%value+vars(iIn,ii)%fOffset%value
         !
         Select Case (vars(iIn,ii)%sideBand)
         Case (esb%lo) 
            fLO   =     fLO + IF%EMIRouter
         Case (esb%lsb)
            fLO   =     fLO + IF%EMIRio
         Case (esb%li)
            fLO   =     fLO + IF%EMIRinner
         Case (esb%ui)
            fLO   =     fLO - IF%EMIRinner
         Case (esb%usb)
            fLO   =     fLO - IF%EMIRio
         Case (esb%uo) 
            fLO   =     fLO - IF%EMIRouter
         End Select
         !
         If (GV%doDebugMessages) Then
            Write (6,*) " vars(iIn,ii): "
            Write (6,*)   vars(iIn,ii)
            Write (6,*) " vars(iIn,ii)%frequency%value: ",                       &
                 &        vars(iIn,ii)%frequency%value                           !
            Write (6,*) " fLO : ", fLo
            Write (6,*) " EMIRloRange(ii)%fLOmin:    ", EMIRloRange(ii)%fLOmin
            Write (6,*) " EMIRloRange(ii)%fLOmax:    ", EMIRloRange(ii)%fLOmax
            Write (6,*) " EMIRloRange(ii)%fLOgapMin: ", EMIRloRange(ii)%fLOgapMin
            Write (6,*) " EMIRloRange(ii)%fLOgapMax: ", EMIRloRange(ii)%fLOgapMax
         End If
         !
         errorRange = .False.
         !
         Select Case (vars(iIn,ii)%name)
         Case ( rec%E300 )                                                         !!  LO gap for E330
            If      (        fLO.Gt.EMIRloRange(ii)%fLOgapMin                    &
                 &    .And.  fLO.Lt.EMIRloRange(ii)%fLOgapMax                    &
                 &  ) Then                                                       !
               Write (messageText, '(A,F12.6,X,A,A)')                            &
                    &     vars(iIn,ii)%name,                                     &
                    &     vars(iIn,ii)%frequency%value,                          &
                    &     vars(iIn,ii)%sideband,                                 &
                    &     ": requested loc.osc. may be in gap. "                 &
                    &   //" Try other subband or sideband?"                      !
               Call PakoMessage(priorityW+2,severityW,command,messageText)
               Write (messageText, '(A, F12.3,A,F12.1,A,F12.1)')                 &
                    &     " requested loc.osc. is : ",                           &
                    &     fLO,                                                   &
                    &     ". gap for "//rec%E300//" is ~ ",                      &
                    &     EMIRloRange(ii)%fLOgapMin,                             &
                    &     " to ",                                                &
                    &     EMIRloRange(ii)%fLOgapMax                              !
               Call PakoMessage(priorityI,severityI,command,messageText)
            End If
         End Select
         !
         messageText = GPnone
         !
         Select Case (vars(iIn,ii)%sideBand)
         Case ( esb%lo, esb%lsb, esb%li ) 
            !
!!$         If      ( fLO.Gt.EMIRloRange(ii)%fLOmax+0.5) Then                               
            If      ( fLO.Gt.EMIRloRange(ii)%fLOmax    ) Then                               
               errorRange = .True.
               Write (messageText, '(A,F12.6,X,A,A)')                            &
                    &     vars(iIn,ii)%name,                                     &
                    &     vars(iIn,ii)%frequency%value,                          &
                    &     vars(iIn,ii)%sideband,                                 &
                    &     "beyond limit.  Maybe other subband or sideband?"      !
!!$                 &     vars(iIn,ii)%sideband,                                 &
!!$                 &     "beyond limit of Local Oscillator.  Maybe other sideband?"   !
            Else If ( fLO.Gt.EMIRloRange(ii)%fLOmax-0.5) Then                          
               Write (messageText, '(A,F12.6,X,A,A)')                            &
                    &     vars(iIn,ii)%name,                                     &
                    &     vars(iIn,ii)%frequency%value,                          &
                    &     vars(iIn,ii)%sideband,                                 &
                    &     "near limit.  Maybe other subband or sideband?"        !
!!$                 &     vars(iIn,ii)%sideband,                                       &
!!$                 &     "near limit of Local Oscillator.  Maybe other sideband?"     !
            End If
            !
!!$         If      ( fLO.Lt.EMIRloRange(ii)%fLOmin-0.5) Then                               
            If      ( fLO.Lt.EMIRloRange(ii)%fLOmin    ) Then                               
               errorRange = .True.
               Write (messageText, '(A,F12.6,X,A,A)')                            &
                    &     vars(iIn,ii)%name,                                     &
                    &     vars(iIn,ii)%frequency%value,                          &
                    &     vars(iIn,ii)%sideband,                                 &
                    &     "beyond limit.  Maybe other subband or sideband?"      !
            Else If ( fLO.Lt.EMIRloRange(ii)%fLOmin+0.5) Then                    
               Write (messageText, '(A,F12.6,X,A,A)')                            &
                    &     vars(iIn,ii)%name,                                     &
                    &     vars(iIn,ii)%frequency%value,                          &
                    &     vars(iIn,ii)%sideband,                                 &
                    &     "near limit.  Maybe other subband or sideband?"        !
            End If
            !
         Case ( esb%ui, esb%usb, esb%uo ) 
            !
!!$         If      ( fLO.Gt.EMIRloRange(ii)%fLOmax+0.5) Then                               
            If      ( fLO.Gt.EMIRloRange(ii)%fLOmax    ) Then                               
               errorRange = .True.
               Write (messageText, '(A,F12.6,X,A,A)')                            &
                    &     vars(iIn,ii)%name,                                     &
                    &     vars(iIn,ii)%frequency%value,                          &
                    &     vars(iIn,ii)%sideband,                                 &
                    &     "beyond limit.  Maybe other subband or sideband?"      !
            Else If ( fLO.Gt.EMIRloRange(ii)%fLOmax-0.5) Then                    
               Write (messageText, '(A,F12.6,X,A,A)')                            &
                    &     vars(iIn,ii)%name,                                     &
                    &     vars(iIn,ii)%frequency%value,                          &
                    &     vars(iIn,ii)%sideband,                                 &
                    &     "near limit.  Maybe other subband or sideband?"        !
            End If
            !
!!$         If      ( fLO.Lt.EMIRloRange(ii)%fLOmin-0.5) Then                         
            If      ( fLO.Lt.EMIRloRange(ii)%fLOmin    ) Then                         
               errorRange = .True.
               Write (messageText, '(A,F12.6,X,A,A)')                            &
                    &     vars(iIn,ii)%name,                                     &
                    &     vars(iIn,ii)%frequency%value,                          &
                    &     vars(iIn,ii)%sideband,                                 &
                    &     "beyond limit.  Maybe other subband or sideband?"      !
            Else If ( fLO.Lt.EMIRloRange(ii)%fLOmin+0.5) Then                    
               Write (messageText, '(A,F12.6,X,A,A)')                            &
                    &     vars(iIn,ii)%name,                                     &
                    &     vars(iIn,ii)%frequency%value,                          &
                    &     vars(iIn,ii)%sideband,                                 &
                    &     "near limit.  Maybe other subband or sideband?"        !
            End If
            !
         End Select
         !
         If (errorRange) Then
            errorInconsistent = .True.
            Call PakoMessage(priorityE,severityE,command,messageText)
         Else If (messageText .NE. GPnone) Then
            Call PakoMessage(priorityW,severityW,command,messageText)
         End If
         !
!
!!       * EMIR: check mixer ranges (SN email 2010-07-27)
!
         If (.Not. errorRange ) Then
            !
            fLSB = fLO-8.0                                                         !!  E150 upgrade 2013-09
            fUSB = fLO+8.0
            !
!!$            Select Case (vars(iIn,ii)%name)                                         !!  before E150 upgrade 2013-09
!!$            Case ( rec%E090, rec%E230, rec%E300 ) 
!!$               fLSB = fLO-8.0
!!$               fUSB = fLO+8.0
!!$            Case ( rec%E150 )
!!$               fLSB = fLO-6.0
!!$               fUSB = fLO+6.0
!!$            End Select
            !
            If (GV%doDebugMessages) Then
               Write (6,*) " vars(iIn,ii): "
               Write (6,*)   vars(iIn,ii)
               Write (6,*) " vars(iIn,ii)vars(iIn,ii)%frequency%value: ",        &
                    &        vars(iIn,ii)%frequency%value                        !
               Write (6,*) " fLO :   ", fLo
               Write (6,*) " fLSB:   ", fLSB
               Write (6,*) " fUSB:   ", fUSB
               Write (6,*) " EMIRmixRange(ii)%fDSBmin: ",                        &  !!  E150 upgrade 2013-09
                    &        EMIRmixRange(ii)%fDSBmin                            !
               Write (6,*) " EMIRmixRange(ii)%fDSBmax: ",                        &
                    &        EMIRmixRange(ii)%fDSBmax                            !
               !
!!$               Case ( rec%E090, rec%E230, rec%E300 )                               !!  before E150 upgrade 2013-09
!!$                  Write (6,*) " EMIRmixRange(ii)%fDSBmin: ",                     &
!!$                       &        EMIRmixRange(ii)%fDSBmin                         !
!!$                  Write (6,*) " EMIRmixRange(ii)%fDSBmax: ",                     &
!!$                       &        EMIRmixRange(ii)%fDSBmax                         !
!!$               Case ( rec%E150 )
!!$                  Write (6,*) " EMIRmixRange(ii)%fLSBmin: ",                     &
!!$                       &        EMIRmixRange(ii)%fLSBmin                         !
!!$                  Write (6,*) " EMIRmixRange(ii)%fLSBmax: ",                     &
!!$                       &        EMIRmixRange(ii)%fLSBmax                         !
!!$                  Write (6,*) " EMIRmixRange(ii)%fUSBmin: ",                     &
!!$                       &        EMIRmixRange(ii)%fUSBmin                         !
!!$                  Write (6,*) " EMIRmixRange(ii)%fUSBmax: ",                     &
!!$                       &        EMIRmixRange(ii)%fUSBmax                         !
!!$               End Select
            End If
            !            
            If (        fLSB.Lt.EMIRmixRange(ii)%fDSBmin                         &  !! E150 upgrade 2013-09   
                 & .Or. fUSB.Gt.EMIRmixRange(ii)%fDSBmax )  Then                 !
               errorRange = .True.
            End If
               !
!!$            Case ( rec%E090, rec%E230, rec%E300 )                                  !!  before E150 upgrade 2013-09
!!$               !
!!$               If (        fLSB.Lt.EMIRmixRange(ii)%fDSBmin                      &
!!$                    & .Or. fUSB.Gt.EMIRmixRange(ii)%fDSBmax )  Then              !
!!$                  errorRange = .True.
!!$               End If
!!$               !
!!$            Case ( rec%E150 )
!!$               !
!!$               Select Case (vars(iIn,ii)%sideBand)
!!$               Case ( esb%lo, esb%lsb, esb%li )
!!$                  If (        fLSB.Lt.EMIRmixRange(iE150)%fLSBmin                &
!!$                       & .Or. fLSB.Gt.EMIRmixRange(iE150)%fLSBmax )  Then        !
!!$                     errorRange = .True.
!!$                  End If
!!$               Case ( esb%ui, esb%usb, esb%uo )
!!$                  If (        fUSB.Lt.EMIRmixRange(iE150)%fUSBmin                &
!!$                       & .Or. fUSB.Gt.EMIRmixRange(iE150)%fUSBmax )  Then        !
!!$                     errorRange = .True.
!!$                  End If
!!$               End Select
!!$               !
!!$            End Select
            !
            If (errorRange) Then
               !
               errorInconsistent = .True.
               !
               Write (messageText, '(A,F12.6,X,A,A)')                         &      !!  E150 upgrade 2013-09 
                    &     vars(iIn,ii)%name,                                  &
                    &     vars(iIn,ii)%frequency%value,                       &
                    &     vars(iIn,ii)%sideband,                              &
                    &     " outside mixer limits"                             !
               Call PakoMessage(priorityE,severityE,                          &
                    &     command, messageText)                               !
               !
            End If
!
!!$               Select Case (vars(iIn,ii)%name)                                     !! before E150 upgrade 2013-09
!!$               Case ( rec%E090, rec%E230, rec%E300 )                               
!!$                  Write (messageText, '(A,F12.6,X,A,A)')                         &
!!$                       &     vars(iIn,ii)%name,                                  &
!!$                       &     vars(iIn,ii)%frequency%value,                       &
!!$                       &     vars(iIn,ii)%sideband,                              &
!!$                       &     " outside mixer limits"                             !
!!$                  Call PakoMessage(priorityE,severityE,                          &
!!$                       &     command, messageText)                               !
!!$               Case ( rec%E150 )
!!$                  Write (messageText, '(A,F12.6,X,A,A)')                         &
!!$                       &     vars(iIn,ii)%name,                                  &
!!$                       &     vars(iIn,ii)%frequency%value,                       &
!!$                       &     vars(iIn,ii)%sideband,                              &
!!$                       &     " outside mixer limits. Maybe other sideband?"      !
!!$                  Call PakoMessage(priorityE,severityE,                          &
!!$                       &     command, messageText)                               !
!!$               End Select
               !
         End If  !!  If (.Not. errorRange ) Then
         !
      End If  !!  If (vars(iIn,ii)%isConnected) Then
      !
   End Do  !!   Do ii = iE090, iE300, 1
   !
End If  !!   If (.Not.errorInconsistent .And. ( GV%iLimitCheck.Le.iStrict  
!
!!  ** EMIR: warning for E090 low frequencies
!
Do ii = iE090, iE090, 1
   If (vars(iIn,ii)%isConnected) Then
      !
      !!         errorInconsistent = .True.
      !
         If (        Index(vars(iIn,ii)%horizontalSubbands,esb%lo(1:2)).Ge.1     &
              & .Or. Index(vars(iIn,ii)%verticalSubbands,esb%lo(1:2)).Ge.1) Then !
            !
            fSubBandLO  =   vars(iIn,ii)%frequency%value                         &
                 &        + vars(iIn,ii)%fOffset%value                           &
                 &        - IF%EMIRouter                                         !
            !
            If (Index(vars(iIn,ii)%sideBand,esb%lo(1:2)).Ge.1 ) Then
               fSubBandLO = fSubBandLO + IF%EMIRouter
            End If
            If (Index(vars(iIn,ii)%sideBand,esb%li(1:2)).Ge.1 ) Then
               fSubBandLO = fSubBandLO + IF%EMIRinner
            End If
            If (Index(vars(iIn,ii)%sideBand,esb%ui(1:2)).Ge.1 ) Then
               fSubBandLO = fSubBandLO - IF%EMIRinner
            End If
            If (Index(vars(iIn,ii)%sideBand,esb%uo(1:2)).Ge.1 ) Then
               fSubBandLO = fSubBandLO - IF%EMIRouter
            End If
            !
            If (fSubBandLO.LT.83.0D0) Then
               !
               Write (messageText, '(A,A,A)')                                    &
                    &        vars(iIn,ii)%name,                                  &
                    &        esb%LO,                                             &
                    &        "  may have high gainImage ratio and high noise "   !
               Call PakoMessage(priorityW,severityW,                             &
                    &           command,                                         &
                    &           messageText)                                     !
               !
            End If
            !
         End If
         If (        Index(vars(iIn,ii)%horizontalSubbands,esb%li(1:2)).Ge.1     &
              & .Or. Index(vars(iIn,ii)%verticalSubbands,esb%li(1:2)).Ge.1) Then !
            !
            fSubBandLI  =   vars(iIn,ii)%frequency%value                         &
                 &        + vars(iIn,ii)%fOffset%value                           &
                 &        - IF%EMIRinner                                         !
            !
            If (Index(vars(iIn,ii)%sideBand,esb%lo(1:2)).Ge.1 ) Then
               fSubBandLI = fSubBandLI + IF%EMIRouter
            End If
            If (Index(vars(iIn,ii)%sideBand,esb%li(1:2)).Ge.1 ) Then
               fSubBandLI = fSubBandLI + IF%EMIRinner
            End If
            If (Index(vars(iIn,ii)%sideBand,esb%ui(1:2)).Ge.1 ) Then
               fSubBandLI = fSubBandLI - IF%EMIRinner
            End If
            If (Index(vars(iIn,ii)%sideBand,esb%uo(1:2)).Ge.1 ) Then
               fSubBandLI = fSubBandLI - IF%EMIRouter
            End If
            !
            If (fSubBandLI.LT.83.0D0) Then
               !
               Write (messageText, '(A,A,A)')                                    &
                    &        vars(iIn,ii)%name,                                  &
                    &        esb%LI,                                             &
                    &        "  may have high gainImage ratio and high noise "   !
               Call PakoMessage(priorityW,severityW,                             &
                    &           command,                                         &
                    &           messageText)                                     !
               !
            End If
            !
         End If
         !
   End If
End Do
!
End If  !!   Not.  (  GV%EMIRcheck.Eq.setLimitCheck%anal ... (more)              ! !! NOTE: temporary to test new "rules"
!
! TBD   ** EMIR: check possible sub band combinations in IF switch box (SN)         !!  EMIR upgrade:
! TBD                                                                               !!  v 1.1.11
!

If (GV%doDebugMessages) Then
   Write (6,*) " "
   Write (6,*) " checking pairs of requested subbands esbWish for consistency"
   Write (6,*) " "
   Write (6,100)
End If
!
Do ii = 1, nEMIRsbWish, 1
   Do jj = 1, nEMIRsbWish, 1
      If (ii.Ne.jj) Then
         !
         If (esbWish(ii)%isRequested .And. esbWish(jj)%isRequested) Then
            !
            If (GV%doDebugMessages) Then
               Write (6,*)   "   ii, jj: ", ii, jj
               Write (6,110) esbWish(ii)
               Write (6,110) esbWish(jj)
            End If
            !
            !                                                                      !!  EMIR upgrade 2011-11:        
            !                                                                      !!  rule imposed by 2nd row      
            !                                                                      !!  of 4 switches in SN's box    
            !                                                                      !!  %i8 is the number (1 to 16)  
            !                                                                      !!  of the EMIR output           
            !                                                                      !!  left to right in SN's        
            !                                                                      !!  figure "Scheme 2"            
            !                                                                      !!                               
            If (       (      (esbWish(ii)%i8.EQ.1 .Or.esbWish(ii)%i8.EQ.5)      &  
                 &      .And. (esbWish(jj)%i8.EQ.10.Or.esbWish(jj)%i8.EQ.14) )   &  
                 & .Or.(      (esbWish(ii)%i8.EQ.2 .Or.esbWish(ii)%i8.EQ.6)      &  
                 &      .And. (esbWish(jj)%i8.EQ.9 .Or.esbWish(jj)%i8.EQ.13) )   &  
                 & .Or.(      (esbWish(ii)%i8.EQ.3 .Or.esbWish(ii)%i8.EQ.7)      &  
                 &      .And. (esbWish(jj)%i8.EQ.12.Or.esbWish(jj)%i8.EQ.16) )   &  
                 & .Or.(      (esbWish(ii)%i8.EQ.4 .Or.esbWish(ii)%i8.EQ.8)      &  
                 &      .And. (esbWish(jj)%i8.EQ.11.Or.esbWish(jj)%i8.EQ.15) )   &  
                 & ) Then
               !
               errorInconsistent = .True.
               !
               Write (messageText, *) " rule 2nd row; "                          &
                    &               //" "//esbWish(ii)%bandName                  &
                    &               //" "//esbWish(ii)%polarization(1:3)         &
                    &               //" "//esbWish(ii)%sideband                  &
                    &               //" + "                                      &
                    &               //" "//esbWish(jj)%bandName                  &
                    &               //" "//esbWish(jj)%polarization(1:3)         &
                    &               //" "//esbWish(jj)%sideband                  &
                    &               //" not possible on Coax 1 to 4 "            !
               Call PakoMessage(priorityE,severityE,command,messageText)
               !
            End If   !!  esbWish(ii)%i8.EQ.1 .Or.esbWish(ii)%i8.EQ.5
            !
            !                                                                       !!  EMIR upgrade 2011-11:    
            !                                                                       !!  rule imposed by 3rd row  
            !                                                                       !!  of 4 switches in SN's box
            If  (         (esbWish(ii)%bandName    .EQ.esbWish(jj)%bandName)     &  
                 &   .And.(esbWish(ii)%polarization.EQ.esbWish(jj)%polarization) &  
                 &   .And.(esbWish(ii)%sideband    .EQ.esbWish(jj)%sideband)     &  
                 &   .And.(esbWish(ii)%subband     .NE.esbWish(jj)%subband)      &  
                 &   )  Then                                                     !
               !
               errorInconsistent = .True.
               !
               If (ii.Lt.jj) Then
                  Write (messageText, *) " "//esbWish(ii)%bandName               &
                       &               //" "//esbWish(ii)%polarization(1:3)      &
                       &               //" "//esbWish(ii)%subband                &
                       &               //" + "                                   &
                       &               //" "//esbWish(jj)%subband                &
                       &               //" not possible on Coax 1 to 4 "         !
                  Call PakoMessage(priorityE,severityE,command,messageText)
                  Write (messageText, *) " "//esbWish(ii)%bandName               &
                       &               //" "//esbWish(ii)%polarization(1:3)      &
                       &               //" "//esbWish(ii)%subband                &
                       &               //" + "                                   &
                       &               //" "//esbWish(jj)%subband                &
                       &               //" both need Coax "                      &
                       &               //" ",esbWish(jj)%i4                      !  !!  %i4 is the number of Coax 1 to 4
                  Call PakoMessage(priorityI,severityI,command,messageText)
               End If
               !
            End If  !!  esbWish(ii)%bandName    .EQ.esbWish(jj)%bandName ...
            !
         End If  !!  esbWish(ii)%isRequested .And. esbWish(jj)%isRequested) ...
         !
      End If  !!  ii.Ne.jj
      !
   End Do  !!  jj = 1, nEMIRsbWish, 1
   !
End Do  !!  ii = 1, nEMIRsbWish, 1
!
If (GV%doDebugMessages) Then
   Write (6,*) "   <-- checkEMIR.inc,v 1.1.15 2013-08-26 Hans Ungerechts"
   Write (6,*) " "
End If
!
!!!  ***************************************************************************



   !D    Write (6,*) " "
   !D    Write (6,*) "   --> checkEMIR.inc,v 1.2.5 2016-03-21  Hans Ungerechts "
   !D    Write (6,*) "       -> PROTOTYPE NEW EMIR LIMIT CHECKING              "
   !D    Write (6,*) "          GV%privilege: ", GV%privilege
            !!         If (GV%doDebugMessages) Then
            !D             Write (6,*) " ii, vars(iIn,ii): "
            !D             Write (6,*) "   "
            !D             Write (6,*)   ii
            !D             Write (6,*)   vars(iIn,ii)
            !D             Write (6,*) " ii: ", ii
            !D             Write (6,*) " receiverChoices(ii):  ", receiverChoices(ii) 
            !D             Write (6,*) " vars(iIn,ii)%sideband: ",                              &
            !D                  &        vars(iIn,ii)%sideband                                  !
            !D             Write (6,*) " vars(iIn,ii)%frequency%value: ",                       &
            !D                  &        vars(iIn,ii)%frequency%value                           !
            !
            !D             Write (6,*) "   "
            !D             Write (6,*) "     EMIRtest%under:     -->", EMIRtest%under, "<--"
            !D             Write (6,*) "     EMIRtest%inRange:   -->", EMIRtest%inRange, "<--"
            !D             Write (6,*) "     EMIRtest%over:      -->", EMIRtest%over, "<--"
            !D             Write (6,*) "   "
               !D                Write (6,*) " "
               !D                Write (6,*) " jj: ", jj
               !D                Write (6,*) " EMIRrules(jj):" 
               !D                Write (6,*) EMIRrules(jj)
               !
                  !D                      Write (6,*) "     EMIRrules(jj)%severity: ", EMIRrules(jj)%severity
                  !D                      Write (6,*) "     severityE:              ", severityE
                  !D                      Write (6,*) "     errorInconsistent:      ", errorInconsistent
                  !
                  !D                   Write (6,*) "  "
                  !D                   Write (6,*) "   EMIRrules(jj)%test: ", EMIRrules(jj)%test
                  !D                   Write (6,*) "   EMIRtest%inRange:   ", EMIRtest%inRange
                  !D                   Write (6,*) "   vars(iIn,ii)%frequency%value:  ", vars(iIn,ii)%frequency%value
                  !D                   Write (6,*) "   EMIRrules(jj)%lo:              ", EMIRrules(jj)%lo
                  !D                   Write (6,*) "   EMIRrules(jj)%hi:              ", EMIRrules(jj)%hi
                  !D                   Write (6,*) "   eps:                           ", eps
                  !D                   Write (6,*) "  "
                  !
   !
   !
