!
! Id: variablesReceiver.inc,v 1.2.5   2016-03-31
! Id: variablesReceiver.inc,v 1.2.3.3 2014-09-01
!                                     2014-04-16 Hans Ungerechts
!                                     holography /test receiver
! Id: variablesReceiver.inc,v 1.1.15  2013-08-27 Hans Ungerechts
!                                     upgrade E150 2013-09
!
!                             1.1.14  2012-10-22 Hans Ungerechts
!
! *** variables for command Receiver
!
Include 'inc/variables/headerForVariables.inc'
!
Type :: receiverFrequency
   Character(len=lenCh)     :: name           =  GPnone
   Character(len=lenCh)     :: kind           =  GPnone
   Character(len=lenCh)     :: unit           =  GPnone
   Character(len=lenCh)     :: doppler        =  GPnone         
   Real(kind=kindDouble)    :: value          =  GPnoneD
End Type receiverFrequency
!
Type :: gainRatio
   Character(len=lenCh)     :: name           =  GPnone
   Character(len=lenCh)     :: kind           =  GPnone
   Character(len=lenCh)     :: unit           =  GPnone
   Real(kind=kindSingle)    :: value          =  GPnoneR
   Real(kind=kindSingle)    :: db             =  -3.3e-33
End Type gainRatio
!
Type :: varReceiver
   !
   Character(len=lenCh)     :: name           =  GPnone
   Logical                  :: isConnected    =  GPnoneL
   Logical                  :: wasConnected   =  GPnoneL
   Logical                  :: gunnOn         =  GPnoneL
   !
   ! ** bolometer parameters
   !    TBD: eliminate duplication of information for bolometer
   !        %nChannels %channel
   Integer                  :: nChannels      =  GPnoneI  !  number of bolometer channels
   Character(len=lenCh)     :: bolometerName  =  GPnone   !  name of bolometer
   Real(kind=kindSingle)    :: gainBolometer  =  GPnoneR  !  bolometer gain
   Integer                  :: channel        =  GPnoneI  !  bolometer channel selected
   !
   Character(len=lenCh)     :: lineName       =  GPnone         
   Type(receiverFrequency)  :: frequency
   Type(receiverFrequency)  :: fOffset
   Character(len=lenCh)     :: sideBand       =  GPnone         
   !
   Character(len=lenCh)     :: width          =  GPnone   !  NARROW / WIDE
   !
   Type(gainRatio)          :: gainImage
   !
   Real(kind=kindSingle)    :: tempCold       =  GPnoneR
   Real(kind=kindSingle)    :: tempAmbient    =  GPnoneR
   !
   Character(len=lenCh)     :: tempColdCode   =  GPnone
   Character(len=lenCh)     :: tempAmbientCode =  GPnone
   !
   Real(kind=kindSingle)    :: effForward     =  GPnoneR
   Real(kind=kindSingle)    :: effBeam        =  GPnoneR
   Character(len=lenCh)     :: scale          =  GPnone
   !
   Character(len=lenCh)     :: derotatorSystem  =  GPnone
   Real(kind=kindSingle)    :: derotatorAngle   =  GPnoneR
   !
   Integer                  :: iPixel         =  GPnoneI  !  MB pixel selected
   !
   !  ** EMIR:
   Character(len=lenCh)     :: horizontalSubbands  =  GPnone
   Character(len=lenCh)     :: verticalSubbands    =  GPnone
   !
   ! ** additional variables, fixed or not directly set by Observer
   !
   Integer                  :: nPixels        =  GPnoneI  !  number of MB pixels
   !
   Real(kind=kindDouble)    :: centerIF       =  GPnoneD  ! 
   Real(kind=kindDouble)    :: bandWidth      =  GPnoneD  !  [GHz]
   !
   Integer                  :: disBoxInput    =  GPnoneI  !  distribution box input
   Real(kind=kindDouble)    :: IF2            =  GPnoneD  !  2nd IF
   Logical                  :: isFlippingIF2  =  GPnoneL  !  is flipping 2nd down converter
   !
   Character(len=lenCh)     :: polarization   =  GPnone   !  H/V in Nasmyth system
   !
   Logical                  :: useSpecialLO   =  GPnoneL  !  special LO mode (below 80 GHz)
   !
End Type varReceiver
!
! *** 
!
!  ** EMIR
!
Logical                     :: isEMIR         =  GPnoneL  !  is EMIR connected?
!
Integer, Parameter :: nDimReceivers = 17
!
Type (varReceiver), Dimension(nDimValues,nDimReceivers)  :: vars
Type (varReceiver),            Dimension(nDimReceivers)  :: listRX
Type (varReceiver)                                       :: rxReset
!
!!$Namelist / nmlReceiver / vars


!
! * for limits on tempCold Lookup:
Type :: varFrequencyLimits
   Type(receiverFrequency)  :: frequency
End Type varFrequencyLimits
!
Type(varFrequencyLimits), Dimension(2,nDimReceivers)     :: coldLimits
!
Character(len=lenLineDouble),  Dimension(nDimReceivers)  :: receiverCommand = GPnone
!
! * for limits on derotator in "frame":
Real(kind=kindSingle), Dimension(2)  ::  derotatorLimitFrame = GPnoneR
!
! *
Integer, Parameter :: nCombos =  7
!
Integer, Dimension(nDimReceivers,nCombos)                :: iCombos, iCombosN
!
!
! *****************************************************************************
!
! *** EMIR: frequency and local oscillator ranges
!
Type  ::  EMIRloRangeType
   !
   Real(kind=kindDouble)    ::   fEdgeMin  =   GPnoneD
   Real(kind=kindDouble)    ::   fLOMin    =   GPnoneD
   Real(kind=kindDouble)    ::   fLOMax    =   GPnoneD
   Real(kind=kindDouble)    ::   fEdgeMax  =   GPnoneD
   !
   Real(kind=kindDouble)    ::   fLOgapMin =   GPnoneD
   Real(kind=kindDouble)    ::   fLOgapMax =   GPnoneD
   !
End Type EMIRloRangeType
!
Type(EMIRloRangeType), Dimension(iE090:iE300)  ::  EMIRloRange                   
!
Type(EMIRloRangeType), Parameter               ::  EMIRloNone =                  &
     &      EMIRloRangeType (GPnoneD,GPnoneD,GPnoneD,GPnoneD,GPnoneD,GPnoneD)    !
!
! *****************************************************************************
!
! *** EMIR: frequency and mixer ranges
!
Type  ::  EMIRmixRangeType
   !
   Real(kind=kindDouble)    ::   fDSBmin   =   GPnoneD
   Real(kind=kindDouble)    ::   fLSBmin   =   GPnoneD
   Real(kind=kindDouble)    ::   fLSBmax   =   GPnoneD
   Real(kind=kindDouble)    ::   fUSBmin   =   GPnoneD
   Real(kind=kindDouble)    ::   fUSBmax   =   GPnoneD
   Real(kind=kindDouble)    ::   fDSBmax   =   GPnoneD
   !
End Type EMIRmixRangeType
!
Type(EMIRmixRangeType), Dimension(iE090:iE300)  ::  EMIRmixRange                 
!
Type(EMIRmixRangeType), Parameter               ::  EMIRmixNone =                &
     &      EMIRmixRangeType (GPnoneD,GPnoneD,GPnoneD,GPnoneD,GPnoneD,GPnoneD)   !
!
! *****************************************************************************
! *****************************************************************************
!
! *** EMIR: rules 2016
!
Real(kind=kindDouble), Parameter   ::  deltaUI = 6.25D0                           !  !! UI - local oscillator
Real(kind=kindDouble), Parameter   ::  deltaUO = 9.43D0                           !  !! UO - local oscillator
Real(kind=kindDouble), Parameter   ::  eps     = 0.0000001D0                      !  !! epsilon for tests
!
Type :: EMIRrulesType                                                             !  !! spec. of rules
   !
   Character(len=lenCh)     :: band           =  GPnone                           !  
   Character(len=lenCh)     :: subBand        =  GPnone                           !
   !
   Character(len=lenCh)     :: test           =  GPnone                           !  !! type of test
   Real(kind=kindDouble)    :: lo             =  GPnoneD                          !  !! low  limit
   Real(kind=kindDouble)    :: hi             =  GPnoneD                          !  !! high limit
   !
   Integer                  :: priority       =  GPnoneI                          !  !! priority of message
   Integer                  :: severity       =  GPnoneI                          !  !! severity
   Character(len=lenCh)     :: message        =  GPnone                           !  !! text for message
   Character(len=lenVar)    :: comment        =  GPnone                           !  !! text for comment / additional message
   !
End type EMIRrulesType
!
Integer , Parameter :: nDimEMIRrules = 60                                         !  !! number of rules
!
Type (EMIRrulesType) , Dimension(nDimEMIRrules)  ::  EMIRrules 
!
!
! *****************************************************************************
! *****************************************************************************
!
! *** EMIR: IF switch box (SN)
!
Type ::  EMIRsbType
   !
   Integer                  ::  i             =  GPnoneI
   Integer                  ::  i8            =  GPnoneI
   Integer                  ::  i4            =  GPnoneI
   !
   Integer                  ::  iBand         =  GPnoneI
   !
   Character(len=lenCh)     ::  bandName      =  GPnone
   Character(len=lenCh)     ::  polarization  =  GPnone
   Character(len=lenCh)     ::  sideband      =  GPnone
   Character(len=lenCh)     ::  subband       =  GPnone
   !
   Logical                  ::  isRequested   =  GPnoneL
   !
End Type EMIRsbType
!
Type(EMIRsbType), Parameter ::  esbNone =                                               &
     &  EMIRsbType(GPnoneI,GPnoneI,GPnoneI,GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL)
!
Integer, Parameter          ::  nEMIRsb   = 16
!
Type (EMIRsbType), Dimension(nEMIRsb), Parameter  ::                                    &  !!  subbands at inputs of
     &  esbInParameter =                                                                &  !!  SN's old switch box 2009 
     &  (/                                                                              &
     &  EMIRsbType(  1, 1, 1, iE090, rec%E090, pol%hor, sb%usb, eio%inner, GPnoneL ),   &
     &  EMIRsbType(  2, 2, 2, iE150, rec%E150, pol%hor, GPnone, GPnone   , GPnoneL ),   &
     &  EMIRsbType(  3, 3, 3, iE230, rec%E230, pol%hor, GPnone, GPnone   , GPnoneL ),   &
     &  EMIRsbType(  4, 4, 4, iE300, rec%E300, pol%hor, sb%usb, GPnone   , GPnoneL ),   &
     !                                                                                  !
     &  EMIRsbType(  5, 5, 1, iE090, rec%E090, pol%hor, sb%lsb, eio%inner, GPnoneL ),   &
     &  EMIRsbType(  6, 6, 2, iE090, rec%E090, pol%hor, sb%usb, eio%outer, GPnoneL ),   &
     &  EMIRsbType(  7, 7, 3, iE090, rec%E090, pol%hor, sb%lsb, eio%outer, GPnoneL ),   &
     &  EMIRsbType(  8, 8, 4, iE300, rec%E300, pol%hor, sb%lsb, GPnone   , GPnoneL ),   &
     !                                                                                  !
     &  EMIRsbType(  9, 1, 1, iE090, rec%E090, pol%ver, sb%usb, eio%inner, GPnoneL ),   &
     &  EMIRsbType( 10, 2, 2, iE150, rec%E150, pol%ver, GPnone, GPnone   , GPnoneL ),   &
     &  EMIRsbType( 11, 3, 3, iE230, rec%E230, pol%ver, GPnone, GPnone   , GPnoneL ),   &
     &  EMIRsbType( 12, 4, 4, iE300, rec%E300, pol%ver, sb%usb, GPnone   , GPnoneL ),   &
     !                                                                                  !
     &  EMIRsbType( 13, 5, 1, iE090, rec%E090, pol%ver, sb%lsb, eio%inner, GPnoneL ),   &
     &  EMIRsbType( 14, 6, 2, iE090, rec%E090, pol%ver, sb%usb, eio%outer, GPnoneL ),   &
     &  EMIRsbType( 15, 7, 3, iE090, rec%E090, pol%ver, sb%lsb, eio%outer, GPnoneL ),   &
     &  EMIRsbType( 16, 8, 4, iE300, rec%E300, pol%ver, sb%lsb, GPnone   , GPnoneL )    &
     &  /)                                                                              !
!
Type (EMIRsbType), Dimension(nEMIRsb)  ::  esbIn  =  esbInParameter                                                 
!
!
Logical, Dimension(iE090:iE300,nDimPolarizationChoices)  ::  requestLSB                    !!  E150 sw. box upgrade 2012-09 
Logical, Dimension(iE090:iE300,nDimPolarizationChoices)  ::  requestUSB                    !!  E150 sw. box upgrade 2012-09 
!
Integer, Parameter   ::  nEMIRsbAll = 32                                                   !!  EMIR upgrade 2011:
!                                                                                          !!  E150 upgrade 2012-09
!
!! NOTE: the following modification for upgrade of E150 in 2013-09                            !!  upgrade E150 in 2013-09 
!!$Type (EMIRsbType), Dimension(nEMIRsbAll), Parameter  ::                                 &  !!  list of ALL sub bands
!!$     &  esbAllParameter =                                                               &  !!  
!!$     &  (/                                                                              &  !!  IMPORTANT:
!!$     !                                                                                     !!  2nd index %i8 
!!$     !                                                                                     !!      codes number if Input to Sw. Box
!!$     !                                                                                     !!  1rd index %i4
!!$     !                                                                                     !!      codes to which Coax cable
!!$     !                                                                                     !!  this subband goes: 
!!$     !                                                                                     !!  1 2 3 4  for  E090 and E330
!!$     !                                                                                     !!  2 1 4 3  for  E150  !!  changed for E150 upgrade 2012-09
!!$     !                                                                                     !!  2 1 4 3  for  E330
!!$     !               i i8 i4  iBand  bandName  polariz  sideba  subban     isRequ          !!
!!$     !
!!$     &  EMIRsbType(  1, 1, 1, iE090, rec%E090, pol%ver, sb%lsb, esb%li   , GPnoneL ),   &  !!  inner 
!!$     &  EMIRsbType(  2, 2, 2, iE090, rec%E090, pol%ver, sb%usb, esb%ui   , GPnoneL ),   &  !!  in sequence of sw. box Inputs
!!$     &  EMIRsbType(  3, 3, 3, iE090, rec%E090, pol%hor, sb%lsb, esb%li   , GPnoneL ),   &
!!$     &  EMIRsbType(  4, 4, 4, iE090, rec%E090, pol%hor, sb%usb, esb%ui   , GPnoneL ),   &
!!$     !                        
!!$     &  EMIRsbType(  5, 5, 1, iE300, rec%E300, pol%ver, sb%lsb, esb%li   , GPnoneL ),   &
!!$     &  EMIRsbType(  6, 6, 2, iE300, rec%E300, pol%ver, sb%usb, esb%ui   , GPnoneL ),   &
!!$     &  EMIRsbType(  7, 7, 3, iE300, rec%E300, pol%hor, sb%lsb, esb%li   , GPnoneL ),   &
!!$     &  EMIRsbType(  8, 8, 4, iE300, rec%E300, pol%hor, sb%usb, esb%ui   , GPnoneL ),   &
!!$     !                                                                                     !!  exceptions for E150
!!$     &  EMIRsbType(  9, 9, 2, iE150, rec%E150, pol%ver, GPnone, GPnone   , GPnoneL ),   &  !!  LSB or USB
!!$     &  EMIRsbType( 10,10, 1, iE150, rec%E150, pol%ver, GPnone, GPnone   , GPnoneL ),   &  !!  changed for E150 upgrade 2012-09
!!$     &  EMIRsbType( 11,11, 4, iE150, rec%E150, pol%hor, GPnone, GPnone   , GPnoneL ),   &  !!  LSB or USB
!!$     &  EMIRsbType( 12,12, 3, iE150, rec%E150, pol%hor, GPnone, GPnone   , GPnoneL ),   &  !!  changed for E150 upgrade 2012-09
!!$     !                        
!!$     &  EMIRsbType( 13,13, 2, iE230, rec%E230, pol%ver, sb%lsb, esb%li   , GPnoneL ),   &
!!$     &  EMIRsbType( 14,14, 1, iE230, rec%E230, pol%ver, sb%usb, esb%ui   , GPnoneL ),   &
!!$     &  EMIRsbType( 15,15, 4, iE230, rec%E230, pol%hor, sb%lsb, esb%li   , GPnoneL ),   &
!!$     &  EMIRsbType( 16,16, 3, iE230, rec%E230, pol%hor, sb%usb, esb%ui   , GPnoneL ),   &
!!$     !                        
!!$     &  EMIRsbType( 17, 1, 1, iE090, rec%E090, pol%ver, sb%lsb, esb%lo   , GPnoneL ),   &  !!  outer
!!$     &  EMIRsbType( 18, 2, 2, iE090, rec%E090, pol%ver, sb%usb, esb%uo   , GPnoneL ),   &  !!  in sequence of sw. box Inputs
!!$     &  EMIRsbType( 19, 3, 3, iE090, rec%E090, pol%hor, sb%lsb, esb%lo   , GPnoneL ),   &
!!$     &  EMIRsbType( 20, 4, 4, iE090, rec%E090, pol%hor, sb%usb, esb%uo   , GPnoneL ),   &
!!$     !                        
!!$     &  EMIRsbType( 21, 5, 1, iE300, rec%E300, pol%ver, sb%lsb, esb%lo   , GPnoneL ),   &
!!$     &  EMIRsbType( 22, 6, 2, iE300, rec%E300, pol%ver, sb%usb, esb%uo   , GPnoneL ),   &
!!$     &  EMIRsbType( 23, 7, 3, iE300, rec%E300, pol%hor, sb%lsb, esb%lo   , GPnoneL ),   &
!!$     &  EMIRsbType( 24, 8, 4, iE300, rec%E300, pol%hor, sb%usb, esb%uo   , GPnoneL ),   &
!!$     !                                                                                     !!  exceptions for E150
!!$     &  EMIRsbType( 25, 9, 2, iE150, GPnone  , GPnone , GPnone, GPnone   , GPnoneL ),   &  !!  no outer
!!$     &  EMIRsbType( 26,10, 1, iE150, GPnone  , GPnone , GPnone, GPnone   , GPnoneL ),   &  !!  no outer
!!$     &  EMIRsbType( 27,11, 4, iE150, GPnone  , GPnone , GPnone, GPnone   , GPnoneL ),   &  !!  no outer
!!$     &  EMIRsbType( 28,12, 3, iE150, GPnone  , GPnone , GPnone, GPnone   , GPnoneL ),   &  !!  no outer
!!$     !                        
!!$     &  EMIRsbType( 29,13, 2, iE230, rec%E230, pol%ver, sb%lsb, esb%lo   , GPnoneL ),   &
!!$     &  EMIRsbType( 30,14, 1, iE230, rec%E230, pol%ver, sb%usb, esb%uo   , GPnoneL ),   &
!!$     &  EMIRsbType( 31,15, 4, iE230, rec%E230, pol%hor, sb%lsb, esb%lo   , GPnoneL ),   &
!!$     &  EMIRsbType( 32,16, 3, iE230, rec%E230, pol%hor, sb%usb, esb%uo   , GPnoneL )    &
!!$     !                        
!!$     &  /)                                                                              !
!!$!
!!
!!   NOTE: the following is the version after the E150 upgrade 2013-09                     !!  E150 upgrade 2012-09
!!
Type (EMIRsbType), Dimension(nEMIRsbAll), Parameter  ::                                 &  !!  list of ALL sub bands
     &  esbAllParameter =                                                               &  !!  
     &  (/                                                                              &  !!  IMPORTANT:
     !                                                                                     !!  2nd index %i8 
     !                                                                                     !!      codes number of Input to Sw. Box
     !                                                                                     !!  3rd index %i4
     !                                                                                     !!      codes to which Coax cable
     !                                                                                     !!  this subband goes: 
     !                                                                                     !!  1 2 3 4  for  E090 and E330
     !                                                                                     !!  2 1 4 3  for  E150 and E330
     !               i i8 i4  iBand  bandName  polariz  sideba  subban     isRequ          !!
     !
     &  EMIRsbType(  1, 1, 1, iE090, rec%E090, pol%ver, sb%lsb, esb%li   , GPnoneL ),   &  !!  inner 
     &  EMIRsbType(  2, 2, 2, iE090, rec%E090, pol%ver, sb%usb, esb%ui   , GPnoneL ),   &  !!  in sequence of sw. box Inputs
     &  EMIRsbType(  3, 3, 3, iE090, rec%E090, pol%hor, sb%lsb, esb%li   , GPnoneL ),   &
     &  EMIRsbType(  4, 4, 4, iE090, rec%E090, pol%hor, sb%usb, esb%ui   , GPnoneL ),   &
     !                        
     &  EMIRsbType(  5, 5, 1, iE300, rec%E300, pol%ver, sb%lsb, esb%li   , GPnoneL ),   &
     &  EMIRsbType(  6, 6, 2, iE300, rec%E300, pol%ver, sb%usb, esb%ui   , GPnoneL ),   &
     &  EMIRsbType(  7, 7, 3, iE300, rec%E300, pol%hor, sb%lsb, esb%li   , GPnoneL ),   &
     &  EMIRsbType(  8, 8, 4, iE300, rec%E300, pol%hor, sb%usb, esb%ui   , GPnoneL ),   &
     !                                                                                     
     &  EMIRsbType(  9, 9, 2, iE150, rec%E150, pol%ver, sb%lsb, esb%li   , GPnoneL ),   &  
     &  EMIRsbType( 10,10, 1, iE150, rec%E150, pol%ver, sb%usb, esb%ui   , GPnoneL ),   &  
     &  EMIRsbType( 11,11, 4, iE150, rec%E150, pol%hor, sb%lsb, esb%li   , GPnoneL ),   &  
     &  EMIRsbType( 12,12, 3, iE150, rec%E150, pol%hor, sb%usb, esb%ui   , GPnoneL ),   &  
     !                        
     &  EMIRsbType( 13,13, 2, iE230, rec%E230, pol%ver, sb%lsb, esb%li   , GPnoneL ),   &
     &  EMIRsbType( 14,14, 1, iE230, rec%E230, pol%ver, sb%usb, esb%ui   , GPnoneL ),   &
     &  EMIRsbType( 15,15, 4, iE230, rec%E230, pol%hor, sb%lsb, esb%li   , GPnoneL ),   &
     &  EMIRsbType( 16,16, 3, iE230, rec%E230, pol%hor, sb%usb, esb%ui   , GPnoneL ),   &
     !                        
     &  EMIRsbType( 17, 1, 1, iE090, rec%E090, pol%ver, sb%lsb, esb%lo   , GPnoneL ),   &  !!  outer
     &  EMIRsbType( 18, 2, 2, iE090, rec%E090, pol%ver, sb%usb, esb%uo   , GPnoneL ),   &  !!  in sequence of sw. box Inputs
     &  EMIRsbType( 19, 3, 3, iE090, rec%E090, pol%hor, sb%lsb, esb%lo   , GPnoneL ),   &
     &  EMIRsbType( 20, 4, 4, iE090, rec%E090, pol%hor, sb%usb, esb%uo   , GPnoneL ),   &
     !                        
     &  EMIRsbType( 21, 5, 1, iE300, rec%E300, pol%ver, sb%lsb, esb%lo   , GPnoneL ),   &
     &  EMIRsbType( 22, 6, 2, iE300, rec%E300, pol%ver, sb%usb, esb%uo   , GPnoneL ),   &
     &  EMIRsbType( 23, 7, 3, iE300, rec%E300, pol%hor, sb%lsb, esb%lo   , GPnoneL ),   &
     &  EMIRsbType( 24, 8, 4, iE300, rec%E300, pol%hor, sb%usb, esb%uo   , GPnoneL ),   &
     !                                                                                     
     &  EMIRsbType( 25, 9, 2, iE150, rec%E150, pol%ver, sb%lsb, esb%lo   , GPnoneL ),   &
     &  EMIRsbType( 26,10, 1, iE150, rec%E150, pol%ver, sb%usb, esb%uo   , GPnoneL ),   &
     &  EMIRsbType( 27,11, 4, iE150, rec%E150, pol%hor, sb%lsb, esb%lo   , GPnoneL ),   &
     &  EMIRsbType( 28,12, 3, iE150, rec%E150, pol%hor, sb%usb, esb%uo   , GPnoneL ),   &
     !                        
     &  EMIRsbType( 29,13, 2, iE230, rec%E230, pol%ver, sb%lsb, esb%lo   , GPnoneL ),   &
     &  EMIRsbType( 30,14, 1, iE230, rec%E230, pol%ver, sb%usb, esb%uo   , GPnoneL ),   &
     &  EMIRsbType( 31,15, 4, iE230, rec%E230, pol%hor, sb%lsb, esb%lo   , GPnoneL ),   &
     &  EMIRsbType( 32,16, 3, iE230, rec%E230, pol%hor, sb%usb, esb%uo   , GPnoneL )    &
     !                        
     &  /)                                                                              !
!
Type (EMIRsbType), Dimension(nEMIRsbAll)  ::  esbAll  =  esbAllParameter                   !!  list of ALL sub bands
!
!
Integer, Parameter   ::  nEMIRsbWish =  8                                                  !!  EMIR upgrade 2011:
!
Type (EMIRsbType), Dimension(nEMIRsbWish), Parameter  ::                                &  !!  sub bands "wished"      
     &  esbWishParameter =                                                              &  !!  4 are possible; 
     &  (/                                                                              &  !!  user may try up to 8;
     &  EMIRsbType(  1, 1, 1, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &  !!  we try, check and 
     &  EMIRsbType(  2, 2, 2, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &  !!  generate error(s)
     &  EMIRsbType(  3, 3, 3, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     &  EMIRsbType(  4, 4, 4, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     &  EMIRsbType(  5, 5, 5, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     &  EMIRsbType(  6, 6, 6, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     &  EMIRsbType(  7, 7, 7, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     &  EMIRsbType(  8, 8, 8, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL )             &
     &  /)                                                                              !
!
Type (EMIRsbType), Dimension(nEMIRsbWish)  ::  esbWish  =  esbWishParameter                !!  sub bands "wished"
!
Type (EMIRsbType), Dimension(nEMIRsbWish)  ::  EMIRsubBandsBis  = esbNone                  !!  requested EMIR sub bands
!                                                                                          !!  try up to 8, see esbWish
!                                                                                          !!  cp. EMIRsubBands below
!
!
Integer, Parameter   ::  nEMIRsbCoax =  8                                                  !!  EMIR upgrade 2011:
!
Type (EMIRsbType), Dimension(nEMIRsbCoax), Parameter  ::                                &  !!  sub bands on Coax 1 to 8
     &  esbCoaxParameter =                                                              &
     &  (/                                                                              &
     !                                                                        
     &  EMIRsbType(  1, 1, 1, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     &  EMIRsbType(  2, 2, 2, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     &  EMIRsbType(  3, 3, 3, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     &  EMIRsbType(  4, 4, 4, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     !                        
     &  EMIRsbType(  5, 5, 1, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     &  EMIRsbType(  6, 6, 2, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     &  EMIRsbType(  7, 7, 3, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL ),            &
     &  EMIRsbType(  8, 8, 4, GPnoneI,GPnone,GPnone,GPnone,GPnone,GPnoneL )             &
     !                        
     &  /)                                                                              !
!
Type (EMIRsbType), Dimension(nEMIRsbCoax)  ::  esbCoax  =  esbCoaxParameter                !!   sub bands on Coax 1 to 8
!
!
Integer, Parameter  ::  nEsbBoxes   =  6                                         !!  Boxes in SN's box
Integer, Parameter  ::  nEsbBoxIn   =  4                                         !!  Inputs for each box
Integer, Parameter  ::  nEsbBoxSw   =  4                                         !!  Switches in each box
Integer, Parameter  ::  nEsbBoxOut  =  2                                         !!  Outputs of each box
!
Integer, Parameter  ::  nEsbIF      =  4                                         !!  IF cables
!
Integer, Parameter  ::  nEsbSwNone  = -1                                         !!  code for "switch undefined"
!
Type (EMIRsbType), Dimension(nEsbIF)                ::  EMIRsubBands  = esbNone  !!  Requested EMIR sub bands
!
Type (EMIRsbType), Dimension(nEsbBoxes,nEsbBoxIn)   ::  esbBoxIn   = esbNone     !!  Inputs for each box
Integer,           Dimension(nEsbBoxes,nEsbBoxSw)   ::  esbBoxSwI  = nEsbSwNone  !!  Switches in each box (Integer)
Character(len=4),  Dimension(nEsbBoxes)             ::  esbBoxSwC  = GPnone      !!  Switches in each box (Character, undef:blank)
Character(len=4),  Dimension(nEsbBoxes)             ::  esbBoxSwC0 = GPnone      !!  Switches in each box (Character, undef:0)
Type (EMIRsbType), Dimension(nEsbBoxes,nEsbBoxOut)  ::  esbBoxOut  = esbNone     !!  Outputs of each box
Type (EMIRsbType), Dimension(nEsbIF)                ::  IFcable    = esbNone     !!  Outputs on IF cables
!
Integer(kind=8)                                     ::  esbSwitchesI             !!  Integer:  switches
Character(len=24)                                   ::  esbSwitchesC             !!  Char/bin: switches
Character(len=6)                                    ::  esbSwitchesChex          !!  Char/hex: switches
!
! *****************************************************************************
!
! *** Arrays
!
Character(len=lenCh)  , Parameter  ::    Info = "OK"
Character(len=lenCh)  , Parameter  ::  noInfo = "noInfo"
!
!  ** HERA
!
Logical                     :: isHERA      =  GPnoneL  !  is HERA connected?

Type ::  heraPixelTypeBis
   Integer                  :: number      =  GPnoneI
   Real(kind=kindSingle)    :: gain        =  GPnoneR
   Real(kind=kindSingle)    :: gainImage   =  GPnoneR
   Real(kind=kindSingle)    :: tempCold    =  GPnoneR
   Real(kind=kindSingle)    :: tempAmbient =  GPnoneR
   Real(kind=kindSingle)    :: effForward  =  GPnoneR
   Real(kind=kindSingle)    :: effBeam     =  GPnoneR
   Real(kind=kindSingle)    :: x           =  GPnoneR
   Real(kind=kindSingle)    :: y           =  GPnoneR
   Character(len=lenCh)     :: flag        =  GPnone
End Type heraPixelTypeBis
!
Integer, Parameter          ::  nDimHera =  18
!
Type ::  HeraArrayType
   Integer                                      ::  nPixels       =  nDimHera
   Integer                                      ::  nPixelsHera1  =    9
   Integer                                      ::  nPixelsHera2  =    9
   Integer                                      ::  iPixelCenter  =    5
   Integer                                      ::  iPixelBest    =    5
   Type(heraPixelTypeBis), Dimension(nDimHera)  ::  pixel
End Type HeraArrayType
!
Type (HeraArrayType), Parameter   ::  HeraCFig  =                                &
     &   HeraArrayType (                                                         &
     &   nDimHera ,                                                              &
     &     9 ,                                                                   &
     &     9 ,                                                                   &
     &     5 ,                                                                   &
     &     5 ,                                                                   &
     &   (/                                                                      &
     &   heraPixelTypeBis( 1, 1.0, 0.1, 77, 270, 0.91, 0.52, -24.0,-24.0, Info), &
     &   heraPixelTypeBis( 2, 1.0, 0.1, 77, 270, 0.91, 0.52, -24.0,  0.0, Info), &
     &   heraPixelTypeBis( 3, 1.0, 0.1, 77, 270, 0.91, 0.52, -24.0, 24.0, Info), &
!                                                                                !
     &   heraPixelTypeBis( 4, 1.0, 0.1, 77, 270, 0.91, 0.52,   0.0,-24.0, Info), &
     &   heraPixelTypeBis( 5, 1.0, 0.1, 77, 270, 0.91, 0.52,   0.0,  0.0, Info), &
     &   heraPixelTypeBis( 6, 1.0, 0.1, 77, 270, 0.91, 0.52,   0.0, 24.0, Info), &
!                                                                                !
     &   heraPixelTypeBis( 7, 1.0, 0.1, 77, 270, 0.91, 0.52,  24.0,-24.0, Info), &
     &   heraPixelTypeBis( 8, 1.0, 0.1, 77, 270, 0.91, 0.52,  24.0,  0.0, Info), &
     &   heraPixelTypeBis( 9, 1.0, 0.1, 77, 270, 0.91, 0.52,  24.0, 24.0, Info), &
!                                                                                !
     &   heraPixelTypeBis(10, 1.0, 0.1, 77, 270, 0.91, 0.52, -24.0,-24.0, Info), &
     &   heraPixelTypeBis(11, 1.0, 0.1, 77, 270, 0.91, 0.52, -24.0,  0.0, Info), &
     &   heraPixelTypeBis(12, 1.0, 0.1, 77, 270, 0.91, 0.52, -24.0, 24.0, Info), &
!                                                                                !
     &   heraPixelTypeBis(13, 1.0, 0.1, 77, 270, 0.91, 0.52,   0.0,-24.0, Info), &
     &   heraPixelTypeBis(14, 1.0, 0.1, 77, 270, 0.91, 0.52,   0.0,  0.0, Info), &
     &   heraPixelTypeBis(15, 1.0, 0.1, 77, 270, 0.91, 0.52,   0.0, 24.0, Info), &
!                                                                                !
     &   heraPixelTypeBis(16, 1.0, 0.1, 77, 270, 0.91, 0.52,  24.0,-24.0, Info), &
     &   heraPixelTypeBis(17, 1.0, 0.1, 77, 270, 0.91, 0.52,  24.0,  0.0, Info), &
     &   heraPixelTypeBis(18, 1.0, 0.1, 77, 270, 0.91, 0.52,  24.0, 24.0, Info)  &
     &   /)                                                                      &
     &                   )                                                       !
!
!   * Deprecated(?): (set in receiverSetDefaults; used in modulePakoPlots)
!  
Type  ::  heraPixelType
   Type(xyPointType)        :: offsets
   Type(gainRatio)          :: gainImage
End Type heraPixelType
!
Integer, Parameter :: nDimHeraPixel = 18
!
Type (heraPixelType), Dimension(nDimHeraPixel)  ::  heraPixel 
!
!  ** MAMBOs
!
Type ::  mamboPixelType
   Integer                  :: number   =  GPnoneI
   Real(kind=kindSingle)    :: gain     =  GPnoneR
   Real(kind=kindSingle)    :: gainBis  =  GPnoneR
   Real(kind=kindSingle)    :: x        =  GPnoneR
   Real(kind=kindSingle)    :: y        =  GPnoneR
   Character(len=lenCh)     :: flag     =  GPnone
End Type mamboPixelType
!
!   * MAMBO1
!
Integer, Parameter                 ::  nDimMAMBO1 =  40
!
Type ::  MAMBO1ArrayType
   Integer                                      ::  nPixels       =  nDimMAMBO1
   Integer                                      ::  nPixelsAC     =   37
   Integer                                      ::  nPixelsDC     =    3
   Integer                                      ::  iPixelCenter  =    1
   Integer                                      ::  iPixelBest    =    1
   Type(mamboPixelType), Dimension(nDimMAMBO1)  ::  pixel
End Type MAMBO1ArrayType
!
Type (MAMBO1ArrayType), Parameter   ::  MAMBO1  =                                &
     &   MAMBO1ArrayType (                                                       &
     &   nDimMAMBO1 ,                                                            &
     &    37 ,                                                                   &
     &     3 ,                                                                   &
     &     1 ,                                                                   &
     &     1 ,                                                                   &
     &   (/                                                                      &
     &   mamboPixelType(   1, 1.0252, 1.0252,     0.000,     0.000,   Info),     &
     &   mamboPixelType(   2, 0.8749, 0.8749,    53.423,    -9.871,   Info),     &
     &   mamboPixelType(   3, 1.0984, 1.0984,   -35.863,    19.519,   Info),     &
     &   mamboPixelType(   4, 0.9879, 0.9879,    17.822,   -10.247,   Info),     &
     &   mamboPixelType(   5, 0.9809, 0.9809,    -0.117,   -41.401,   Info),     &
     &   mamboPixelType(   6, 1.0924, 1.0924,    -0.099,    20.794,   Info),     &
     &   mamboPixelType(   7, 0.9891, 0.9891,    35.865,   -20.464,   Info),     &
     &   mamboPixelType(   8, 1.0214, 1.0214,    -0.443,    61.102,   Info),     &
     &   mamboPixelType(   9, 0.9618, 0.9618,    53.447,    10.883,   Info),     &
     &   mamboPixelType(  10, 1.0757, 1.0757,   -35.746,   -21.046,   Info),     &
     &   mamboPixelType(  11, 0.9877, 0.9877,   -17.525,    50.883,   Info),     &
     &   mamboPixelType(  12, 0.9975, 0.9975,   -53.75 ,   -10.806,   Info),     &
     &   mamboPixelType(  13, 1.1128, 1.1128,   -35.766,    -0.114,   Info),     &
     &   mamboPixelType(  14, 0.9317, 0.9317,   -35.773,   -41.298,   Info),     &
     &   mamboPixelType(  15, 0.9035, 0.9035,     0.046,   -61.655,   Info),     &
     &   mamboPixelType(  16, 0.9377, 0.9377,    17.752,   -51.475,   Info),     &
     &   mamboPixelType(  17, 0.9372, 0.9372,    18.039,   -31.081,   Info),     &
     &   mamboPixelType(  18, 1.0000, 1.0000,    35.450,   -41.440,   Info),     &
     &   mamboPixelType(  19, 1.0270, 1.0270,    35.196,    20.828,   Info),     &
     &   mamboPixelType(  20, 0.9509, 0.9509,   -53.336,   -31.165,   Info),     &
     &   mamboPixelType(  21, 0.8671, 0.8671,    -0.555,    40.649,   Info),     &
     &   mamboPixelType(  22, 1.1047, 1.1047,    18.005,    10.422,   Info),     &
     &   mamboPixelType(  23, 1.2818, 1.2818,    53.171,    31.229,   Info),     &
     &   mamboPixelType(  24, 0.9120, 0.9120,    -0.302,   -20.866,   Info),     &
     &   mamboPixelType(  25, 0.8369, 0.8369,   -36.132,    40.561,   Info),     &
     &   mamboPixelType(  26, 1.0701, 1.0701,   -18.191,     9.959,   Info),     &
     &   mamboPixelType(  27, 1.0532, 1.0532,   -53.82 ,     9.892,   Info),     &
     &   mamboPixelType(  28, 1.0861, 1.0861,   -18.032,   -10.771,   Info),     &
     &   mamboPixelType(  29, 0.9398, 0.9398,   -17.833,   -30.952,   Info),     &
     &   mamboPixelType(  30, 1.0052, 1.0052,   -17.67 ,    30.483,   Info),     &
     &   mamboPixelType(  31, 0.9768, 0.9768,   -17.79 ,   -51.535,   Info),     &
     &   mamboPixelType(  32, 1.0856, 1.0856,    53.5  ,   -30.592,   Info),     &
     &   mamboPixelType(  33, 1.0171, 1.0171,    35.474,    41.265,   Info),     &
     &   mamboPixelType(  34, 0.8356, 0.8356,    17.415,    50.895,   Info),     &
     &   mamboPixelType(  35, 1.0014, 1.0014,   -54.005,    29.737,   Info),     &
     &   mamboPixelType(  36, 1.0605, 1.0605,    17.941,    31.109,   Info),     &
     &   mamboPixelType(  37, 0.9723, 0.9723,    36.033,     0.348,   Info),     &
     &   mamboPixelType(  38, 1.0000, 1.0000,     0.000,     0.000,   Info),     &
     &   mamboPixelType(  39, 1.0000, 1.0000,     0.000,     0.000,   Info),     &
     &   mamboPixelType(  40, 1.1000, 1.2000,     0.000,     0.000,   Info)      &
     &   /)                                                                      &
     &                   )
!
!   * MAMBO2
!
Integer, Parameter                 ::  nDimMAMBO2 = 120
!
Type ::  MAMBO2ArrayType
   Integer                                      ::  nPixels       =  nDimMAMBO2
   Integer                                      ::  nPixelsAC     =  117
   Integer                                      ::  nPixelsDC     =    3
   Integer                                      ::  iPixelCenter  =   53
   Integer                                      ::  iPixelBest    =   20
   Type(mamboPixelType), Dimension(nDimMAMBO2)  ::  pixel
End Type MAMBO2ArrayType
!
Type (MAMBO2ArrayType), Parameter   ::  MAMBO2  =                                &
     &   MAMBO2ArrayType (                                                       &
     &   nDimMAMBO2 ,                                                            &
     &   117 ,                                                                   &
     &     3 ,                                                                   &
     &    53 ,                                                                   &
     &    20 ,                                                                   &
     &   (/                                                                      &
     &   mamboPixelType(   1, 1.0000, 1.0000,   -37.000,   -22.000, noInfo),     &
     &   mamboPixelType(   2, 1.1681, 1.1681,   -37.069,    -0.253,   Info),     &
     &   mamboPixelType(   3, 0.9616, 0.9616,    57.521,    75.093,   Info),     &
     &   mamboPixelType(   4, 1.0908, 1.0908,    76.216,    64.270,   Info),     &
     &   mamboPixelType(   5, 1.0522, 1.0522,    56.400,    31.685,   Info),     &
     &   mamboPixelType(   6, 0.8109, 0.8109,  -113.938,   -45.128,   Info),     &
     &   mamboPixelType(   7, 0.8006, 0.8006,    76.801,   -86.282,   Info),     &
     &   mamboPixelType(   8, 0.8724, 0.8724,   -94.327,   -56.390,   Info),     &
     &   mamboPixelType(   9, 0.7909, 0.7909,   -74.773,   -89.581,   Info),     &
     &   mamboPixelType(  10, 0.9690, 0.9690,   -93.660,    55.370,   Info),     &
     &   mamboPixelType(  11, 1.0000, 1.0000,    19.000,    75.000, noInfo),     &
     &   mamboPixelType(  12, 1.0857, 1.0857,   -74.737,   -21.923,   Info),     &
     &   mamboPixelType(  13, 1.2637, 1.2637,   -55.704,    11.168,   Info),     &
     &   mamboPixelType(  14, 1.2194, 1.2194,    18.978,   -11.165,   Info),     &
     &   mamboPixelType(  15, 0.9994, 0.9994,    19.627,   -75.879,   Info),     &
     &   mamboPixelType(  16, 0.9265, 0.9265,    94.020,   -11.316,   Info),     &
     &   mamboPixelType(  17, 0.9886, 0.9886,    56.116,   -10.964,   Info),     &
     &   mamboPixelType(  18, 0.8641, 0.8641,   113.661,    21.265,   Info),     &
     &   mamboPixelType(  19, 0.8728, 0.8728,     1.632,    86.571,   Info),     &
     &   mamboPixelType(  20, 0.8973, 0.8973,   -54.787,    76.776,   Info),     &
     &   mamboPixelType(  21, 0.9109, 0.9109,   -36.322,   -88.350,   Info),     &
     &   mamboPixelType(  22, 0.9777, 0.9777,    39.099,   -86.639,   Info),     &
     &   mamboPixelType(  23, 0.9485, 0.9485,   -55.617,   -77.393,   Info),     &
     &   mamboPixelType(  24, 1.0224, 1.0224,    37.729,    -0.334,   Info),     &
     &   mamboPixelType(  25, 1.1613, 1.1613,   -36.905,    21.438,   Info),     &
     &   mamboPixelType(  26, 1.0683, 1.0683,    38.748,    86.342,   Info),     &
     &   mamboPixelType(  27, 1.1632, 1.1632,    37.867,   -43.058,   Info),     &
     &   mamboPixelType(  28, 1.1052, 1.1052,    75.500,   -43.145,   Info),     &
     &   mamboPixelType(  29, 0.9765, 0.9765,    93.929,    10.332,   Info),     &
     &   mamboPixelType(  30, 1.0283, 1.0283,    94.478,   -54.147,   Info),     &
     &   mamboPixelType(  31, 1.0970, 1.0970,   -36.655,   -65.798,   Info),     &
     &   mamboPixelType(  32, 1.1212, 1.1212,   -74.520,     0.495,   Info),     &
     &   mamboPixelType(  33, 0.9622, 0.9622,    57.076,   -54.042,   Info),     &
     &   mamboPixelType(  34, 0.9865, 0.9865,   -74.884,   -44.125,   Info),     &
     &   mamboPixelType(  35, 1.0425, 1.0425,   -18.406,    32.418,   Info),     &
     &   mamboPixelType(  36, 1.1127, 1.1127,   -17.749,   -54.449,   Info),     &
     &   mamboPixelType(  37, 0.9681, 0.9681,    57.476,   -75.640,   Info),     &
     &   mamboPixelType(  38, 1.1471, 1.1471,     0.582,    42.897,   Info),     &
     &   mamboPixelType(  39, 1.1629, 1.1629,   -18.546,   -11.023,   Info),     &
     &   mamboPixelType(  40, 1.0873, 1.0873,    19.052,    31.965,   Info),     &
     &   mamboPixelType(  41, 0.9365, 0.9365,   -17.293,   -98.830,   Info),     &
     &   mamboPixelType(  42, 1.0000, 1.0000,    19.400,   -53.000, noInfo),     &
     &   mamboPixelType(  43, 0.9194, 0.9194,   -35.920,    87.539,   Info),     &
     &   mamboPixelType(  44, 1.0294, 1.0294,   -94.032,    11.229,   Info),     &
     &   mamboPixelType(  45, 0.8892, 0.8892,  -113.930,    22.467,   Info),     &
     &   mamboPixelType(  46, 1.0234, 1.0234,    37.558,    42.332,   Info),     &
     &   mamboPixelType(  47, 1.1306, 1.1306,   -36.583,    43.498,   Info),     &
     &   mamboPixelType(  48, 0.8442, 0.8442,    95.679,   -75.071,   Info),     &
     &   mamboPixelType(  49, 1.0528, 1.0528,    75.744,    42.345,   Info),     &
     &   mamboPixelType(  50, 1.0544, 1.0544,     0.747,   -65.151,   Info),     &
     &   mamboPixelType(  51, 0.9890, 0.9890,   -17.340,    76.000,   Info),     &
     &   mamboPixelType(  52, 0.9003, 0.9003,     2.019,  -109.669,   Info),     &
     &   mamboPixelType(  53, 1.1864, 1.1864,     0.000,     0.000,   Info),     &
     &   mamboPixelType(  54, 1.1765, 1.1765,   -55.855,    32.659,   Info),     &
     &   mamboPixelType(  55, 0.9931, 0.9931,   -74.093,    66.145,   Info),     &
     &   mamboPixelType(  56, 0.8000, 0.8000,    58.065,   -97.553,   Info),     &
     &   mamboPixelType(  57, 1.2272, 1.2272,     0.200,   -21.958,   Info),     &
     &   mamboPixelType(  58, 1.0991, 1.0991,   -55.908,   -10.951,   Info),     &
     &   mamboPixelType(  59, 0.7656, 0.7656,   -54.679,    99.459,   Info),     &
     &   mamboPixelType(  60, 0.9977, 0.9977,   -55.688,   -55.083,   Info),     &
     &   mamboPixelType(  61, 0.8477, 0.8477,    77.472,    86.421,   Info),     &
     &   mamboPixelType(  62, 0.9404, 0.9404,    96.080,    75.318,   Info),     &
     &   mamboPixelType(  63, 1.0926, 1.0926,   -36.993,   -43.622,   Info),     &
     &   mamboPixelType(  64, 1.0939, 1.0939,    75.192,   -21.709,   Info),     &
     &   mamboPixelType(  65, 0.8313, 0.8313,   113.296,   -22.019,   Info),     &
     &   mamboPixelType(  66, 1.2541, 1.2541,    75.089,    21.013,   Info),     &
     &   mamboPixelType(  67, 0.9045, 0.9045,   -75.018,   -66.760,   Info),     &
     &   mamboPixelType(  68, 0.9832, 0.9832,  -114.333,   -22.582,   Info),     &
     &   mamboPixelType(  69, 1.1176, 1.1176,   -74.762,    21.948,   Info),     &
     &   mamboPixelType(  70, 1.0512, 1.0512,   -55.671,   -33.065,   Info),     &
     &   mamboPixelType(  71, 1.0873, 1.0873,    95.087,    53.488,   Info),     &
     &   mamboPixelType(  72, 1.0206, 1.0206,    38.094,    64.035,   Info),     &
     &   mamboPixelType(  73, 0.8148, 0.8148,     2.451,   108.935,   Info),     &
     &   mamboPixelType(  74, 0.9885, 0.9885,   -36.575,    65.340,   Info),     &
     &   mamboPixelType(  75, 1.1686, 1.1686,   -18.577,    10.594,   Info),     &
     &   mamboPixelType(  76, 0.9949, 0.9949,    20.479,   -97.975,   Info),     &
     &   mamboPixelType(  77, 0.7434, 0.7434,    58.402,    97.594,   Info),     &
     &   mamboPixelType(  78, 1.0584, 1.0584,   -17.753,    54.090,   Info),     &
     &   mamboPixelType(  79, 0.8867, 0.8867,   -35.279,   110.033,   Info),     &
     &   mamboPixelType(  80, 1.1184, 1.1184,    37.484,    21.144,   Info),     &
     &   mamboPixelType(  81, 0.9554, 0.9554,    20.588,    97.559,   Info),     &
     &   mamboPixelType(  82, 1.1402, 1.1402,     0.376,    21.494,   Info),     &
     &   mamboPixelType(  83, 1.0000, 1.0000,   -93.800,   -10.800, noInfo),     &
     &   mamboPixelType(  84, 1.0482, 1.0482,   -94.408,   -33.428,   Info),     &
     &   mamboPixelType(  85, 1.0493, 1.0493,    56.630,    53.147,   Info),     &
     &   mamboPixelType(  86, 1.0305, 1.0305,    19.248,    53.593,   Info),     &
     &   mamboPixelType(  87, 0.9064, 0.9064,    40.131,   108.735,   Info),     &
     &   mamboPixelType(  88, 0.9813, 0.9813,     1.059,   -87.191,   Info),     &
     &   mamboPixelType(  89, 0.9120, 0.9120,   -16.817,    97.939,   Info),     &
     &   mamboPixelType(  90, 0.9688, 0.9688,     1.049,    64.693,   Info),     &
     &   mamboPixelType(  91, 1.0491, 1.0491,   -55.376,    54.606,   Info),     &
     &   mamboPixelType(  92, 0.8975, 0.8975,    39.413,  -109.468,   Info),     &
     &   mamboPixelType(  93, 0.9126, 0.9126,  -114.004,     0.172,   Info),     &
     &   mamboPixelType(  94, 0.8101, 0.8101,   113.781,   -43.133,   Info),     &
     &   mamboPixelType(  95, 1.0444, 1.0444,    94.051,   -32.692,   Info),     &
     &   mamboPixelType(  96, 1.0942, 1.0942,    75.688,   -64.952,   Info),     &
     &   mamboPixelType(  97, 0.9813, 0.9813,    56.496,   -32.454,   Info),     &
     &   mamboPixelType(  98, 1.0808, 1.0808,    74.803,    -0.603,   Info),     &
     &   mamboPixelType(  99, 1.0236, 1.0236,    94.173,    31.912,   Info),     &
     &   mamboPixelType( 100, 0.7831, 0.7831,  -113.946,    44.700,   Info),     &
     &   mamboPixelType( 101, 0.8240, 0.8240,   -73.760,    88.716,   Info),     &
     &   mamboPixelType( 102, 0.9896, 0.9896,   -74.395,    43.792,   Info),     &
     &   mamboPixelType( 103, 1.0000, 1.0000,   -94.000,   -79.000, noInfo),     &
     &   mamboPixelType( 104, 0.7776, 0.7776,   -36.061,  -111.239,   Info),     &
     &   mamboPixelType( 105, 0.9711, 0.9711,   -17.576,   -76.458,   Info),     &
     &   mamboPixelType( 106, 0.8540, 0.8540,   113.939,    42.496,   Info),     &
     &   mamboPixelType( 107, 1.2080, 1.2080,    56.211,    10.282,   Info),     &
     &   mamboPixelType( 108, 1.1429, 1.1429,    37.771,   -21.630,   Info),     &
     &   mamboPixelType( 109, 1.0906, 1.0906,   -18.184,   -32.787,   Info),     &
     &   mamboPixelType( 110, 1.2920, 1.2920,    18.914,   -32.446,   Info),     &
     &   mamboPixelType( 111, 1.0251, 1.0251,    38.412,   -64.686,   Info),     &
     &   mamboPixelType( 112, 0.9859, 0.9859,    18.708,    10.615,   Info),     &
     &   mamboPixelType( 113, 0.7754, 0.7754,   112.438,    -0.178, noInfo),     &
     &   mamboPixelType( 114, 0.8036, 0.8036,   -93.699,    78.119,   Info),     &
     &   mamboPixelType( 115, 0.7278, 0.7278,   -55.490,  -100.401,   Info),     &
     &   mamboPixelType( 116, 0.9897, 0.9897,     0.516,   -43.483,   Info),     &
     &   mamboPixelType( 117, 0.9524, 0.9524,   -93.900,    33.045,   Info),     &
     &   mamboPixelType( 118,  1    ,  1    ,      0   ,      0   ,   Info),     &
     &   mamboPixelType( 119 , 0.860 ,0.860  ,  -93.669 ,   78.955,   Info),     &
     &   mamboPixelType( 120,  1.030, 1.030 ,    95.097,    75.675,   Info)      & 
     &   /)                                                                      &
     &                   )
!
! *
Integer, Parameter                   :: nDimGainBoloChoices  = 7
Real, Dimension(nDimGainBoloChoices) :: gainBolometerChoices
!
! *
Logical                :: isInitialized  =  .False.
Logical                :: catalogOpen    =  .False.
!
! *** "helper" variables
!
Logical                :: hasDefaults, hasConnect,   hasDisconnect,  hasClear,   &
     &                    hasCenterIF, hasDerotator, hasDoppler, hasEfficiency,  &
     &                    hasFoffset,  hasGainImage, hasSband,   hasScale,       &
     &                    hasTempload, hasWidth                                               !
Logical                :: doConnectRX, doDisconnectRX, doClearRX
!
Character(len=lenVar)  :: cFile = GPnone  ! catalog file name
!
!   * more "helper" variables: (some are obsolete?)

Character(len=lenCh)   :: receiverSelected = GPnone
Character(len=lenCh)   :: name  = GPnone
Integer                :: lname = 1
!
Integer                :: larg  = 1
Integer                :: lenc  = 1
!
Logical                :: found =.False.
Integer                :: npar  = 1
Integer                :: npar1 = 1
Integer                :: ier   = 1
Integer                :: iRec  = 1 
!
Integer, Dimension(nDimReceivers) :: iIsConnected
Integer, Dimension(nDimReceivers) :: iComboCheck
!
!   * NIKA Nasmyth offsets
!
Type(varOffsets)       ::  NIKApixel       !!  %isSet
!                                          !!  %systemName
!                                          !!  %point%x
!                                          !!  %point%y
!                                          !!  %channel
!                                          !!  %elevation
