subroutine vector_header(line,error)
  use image_def
  use sic_dependencies_interfaces
  use sic_interfaces, except_this=>vector_header
  use gbl_message
  use sic_structures
  use sic_dictionaries
  use sic_types
  !---------------------------------------------------------------------
  ! @ private
  !  Support routine for command
  !  VECTOR\HEADER File|SicVariable
  ! 1 /EXTREMA         Add/update the extrema section
  ! 2 /TELESCOPE Name  Add/update the telescope section
  !---------------------------------------------------------------------
  character(len=*), intent(in)    :: line   ! Input command line
  logical,          intent(inout) :: error  ! Logical error flag
  ! Local
  character(len=*), parameter :: rname='HEADER'
  integer(kind=4), parameter :: optextr=1
  integer(kind=4), parameter :: opttele=2
  logical :: doextr,dotele
  type(gildas) :: mine
  integer(kind=4) :: i, n, ier
  real(kind=4), allocatable :: mydata(:,:)
  integer(kind=size_length) :: asize
  character(len=24) :: teles
  character(len=filename_length) :: chain
  real(kind=8) :: dummy(3)
  type(sic_descriptor_t) :: desc
  logical :: err, found
  !
  if (.not.sic_present(0,1)) then
    call sic_message(seve%e,rname,'Missing file name as argument')
    call sic_message(seve%e,rname,  &
      'Use [GREG3\]IMAGE (with no argument) to list the IMAGE header')
    error = .true.
    return
  endif
  !
  ! Command line parsing
  call gildas_null(mine)
  call sic_ch(line,0,1,chain,n,.true.,error)
  if (error) return
  doextr = sic_present(optextr,0)
  dotele = sic_present(opttele,0)
  if (dotele) then
    call sic_ke(line,opttele,1,teles,n,.true.,error)
    if (error)  return
  endif
  !
  ! Open the corresponding data file
  if (doextr .or. dotele) then
    mine%file = chain
    call gdf_read_header(mine,error) ! Just read header
    if (error) return
    !
    if (doextr) then
      if (address_length.eq.4) then
        call gdf_toobig(mine%gil%dim,mine%gil%ndim,mine%gil%form,error)
        if (error) then
          call sic_message(seve%e,rname,'/EXTREMA not supported for large files')
          return
        endif
      endif
      !
      call sic_message(seve%i,rname,'Compute extrema in file '//mine%file)
      if (mine%gil%type_gdf.eq.code_gdf_uvt) then
        allocate(mydata(mine%gil%dim(1),mine%gil%dim(2)),stat=ier)
        call gdf_read_data(mine,mydata,error)
        if (error)  return
        mine%loca%addr = locwrd(mydata)
        call gdf_get_baselines (mine,error)
        if (error)  return
      elseif (mine%gil%type_gdf.eq.code_gdf_tuv) then
        allocate(mydata(mine%gil%dim(1),2),stat=ier)
        mine%blc(2) = 1
        mine%trc(2) = 2
        call gdf_read_data(mine,mydata,error)
        if (error)  return
        mine%loca%addr = locwrd(mydata)
        call gdf_get_baselines (mine,error)
        if (error)  return
      else
        ! The Real*8 case is not well treated yet...
        asize = 1
        do i=1,mine%gil%ndim
          asize = asize*mine%gil%dim(i)
        enddo
        allocate(mydata(asize,1),stat=ier)
        if (failed_allocate(rname,'data',ier,error))  return
        call gdf_read_data(mine,mydata,error)
        if (error)  return
        mine%loca%addr = locwrd(mydata)
        call gdf_get_extrema (mine,error)
        if (error)  return
      endif
      deallocate(mydata)
    endif
    !
    if (dotele) then
      call gdf_addteles(mine,'TELE',teles,dummy,error)
      if (error) then
        call gdf_close_image(mine,err)   ! Do not forget
        return
      endif
    endif
    !
    call gdf_update_header(mine,error)
    if (error)  return
    call gdf_close_image(mine,error)   ! Do not forget
    if (error)  return
    !
  else if (sic_findfile(chain,mine%file,' ',' ')) then
    chain = mine%file
    ! It is a File, 
    ! Only print header
    if (index(chain,'fits').ne.0) then
      call gdf_fits_header(chain,error)
      if (.not.error) return
    endif
    mine%file = chain
    call gdf_read_header(mine,error) ! Just read header
    if (error) return
    call gdf_print_header(mine)  ! and display
    call gdf_close_image(mine,error)   ! Do not forget
    if (error)  return
    !
  else
    ! Try a Sic variable
    call sic_descriptor (chain,desc,found)
    if (.not.found) then
      call sic_message(seve%w,rname,'No such file or header variable '//chain)
      return
    endif
    if (.not.associated(desc%head)) then
      call sic_message(seve%w,rname,  &
        'Variable '//trim(chain)//' does not provide a header')
      return
    endif
    call gdf_print_header(desc%head)
  endif
  !
end subroutine vector_header
!
subroutine gdf_fits_header(file,error)
  use image_def
  use sic_dependencies_interfaces
  use gbl_message
  !---------------------------------------------------------------------
  ! @ private
  !  Support routine for command VECTOR\HEADER File
  !    for FITS file format
  !---------------------------------------------------------------------
  character(len=*), intent(in) :: file
  logical, intent(inout) :: error
  !
  integer :: flun,ier, i,j
  integer(kind=4) :: farray(20,36)
  character(len=8) :: fkeyw
  character(len=80) :: fline
  character(len=filename_length) :: fich
  !
  ier = sic_getlun(flun)
  call sic_parse_file(file,' ',' ',fich)
  open(unit=flun,file=trim(fich),recl=720*facunf,status='OLD',form='UNFORMATTED',  &
       access='DIRECT',action='READ',iostat=ier)
  if (ier.ne.0) then
    call putios('E-OPEN,  ',ier)
    call sic_frelun(flun)
    error = .true.
    return
  endif
  !
  read(flun,rec=1) farray
  call bytoch(farray(1:20,1),fkeyw,8)
  if (fkeyw.ne.'SIMPLE ') then
    error = .true.
    close(unit=flun)
    call sic_frelun(flun)
    return
  endif
  !
  j = 1
  do
    do i=1,36
      call bytoch(farray(1:20,i),fline,80)
      write(*,'(a)') trim(fline)
      if (fline(1:4).eq.'END ') exit
    enddo
    if (fline(1:4).eq.'END ') exit
    j = j+1
    read(flun,rec=j) farray
  enddo
  !
  close(unit=flun)
  call sic_frelun(flun)
  error = .false.
end subroutine gdf_fits_header
!
