/* ###
 * IP: GHIDRA
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package agent.dbgeng.model.iface2;

import agent.dbgeng.manager.DbgEventsListenerAdapter;
import agent.dbgeng.model.iface1.*;

public interface DbgModelTargetRoot extends //
		///DbgModelTargetObject,
		DbgModelTargetAccessConditioned, //
		DbgModelTargetAttacher, //
		DbgModelTargetActiveScope, //
		DbgModelTargetEventScope, //
		DbgModelTargetLauncher, //
		DbgModelTargetFocusScope, //
		DbgEventsListenerAdapter {

	void setDefaultConnector(DbgModelTargetConnector defaultConnector);

	// getActive & requestActivation implemented by DbgModelTargetObject & DbgModelTargetActiveScope 
	// getFocus & requestFocus implemented by DbgModelTargetObject & DbgModelTargetFocusScope 
}
