/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangLabelToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.util.AddEditDialog;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;

public class RenameLabelAction
extends AbstractDecompilerAction {
    public RenameLabelAction() {
        super("Rename Label");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRenameLabel"));
        this.setKeyBindingData(new KeyBindingData(76, 0));
        this.setPopupMenuData(new MenuData(new String[]{"Rename Label"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        return tokenAtCursor instanceof ClangLabelToken;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Symbol symbol = this.getSymbol(context);
        if (symbol != null) {
            AddEditDialog dialog = new AddEditDialog("", context.getTool());
            dialog.editLabel(symbol, context.getProgram());
        }
    }
}

