/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.WrappingVerticalLayoutTextField;
import docking.widgets.fieldpanel.support.FieldHighlightFactory;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.ClangFieldElement;
import java.util.List;

public class ClangTextField
extends WrappingVerticalLayoutTextField {
    private List<ClangToken> tokenList;
    private final int lineNumber;

    private static FieldElement createSingleLineElement(FieldElement[] textElements) {
        return new CompositeFieldElement(textElements);
    }

    public ClangTextField(List<ClangToken> tokenList, FieldElement[] fieldElements, int x, int lineNumber, int width, FieldHighlightFactory hlFactory) {
        super(ClangTextField.createSingleLineElement(fieldElements), x, width - x, 30, hlFactory, false);
        this.tokenList = tokenList;
        this.lineNumber = lineNumber;
    }

    public ClangToken getToken(FieldLocation loc) {
        if (loc == null) {
            return null;
        }
        FieldElement clickedObject = this.getClickedObject(loc);
        if (clickedObject instanceof ClangFieldElement) {
            ClangFieldElement element = (ClangFieldElement)clickedObject;
            return element.getToken();
        }
        int index = this.getTokenIndex(loc);
        return this.tokenList.get(index);
    }

    int getNextTokenIndexStartingAfter(FieldLocation location) {
        int n = 0;
        for (int i = 0; i < this.tokenList.size(); ++i) {
            if (location.col == n) {
                return i;
            }
            ClangToken token = this.tokenList.get(i);
            int length = n + token.getText().length();
            if (length >= location.col) {
                return i + 1;
            }
            n = length;
        }
        return this.tokenList.size();
    }

    int getTokenIndex(FieldLocation location) {
        int n = 0;
        for (int i = 0; i < this.tokenList.size(); ++i) {
            if (location.col == n) {
                return i;
            }
            ClangToken token = this.tokenList.get(i);
            int length = n + token.getText().length();
            if (length > location.col) {
                return i;
            }
            n = length;
        }
        return this.tokenList.size() - 1;
    }

    FieldElement getClickedObject(FieldLocation fieldLocation) {
        return this.getFieldElement(fieldLocation.row, fieldLocation.col);
    }

    List<ClangToken> getTokens() {
        return this.tokenList;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }
}

