/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import generic.jar.ResourceFile;
import ghidra.app.decompiler.DecompileCallback;
import ghidra.app.decompiler.DecompileDebug;
import ghidra.app.decompiler.DecompileException;
import ghidra.app.decompiler.DecompileOptions;
import ghidra.app.decompiler.DecompileProcess;
import ghidra.app.decompiler.DecompileProcessFactory;
import ghidra.app.decompiler.DecompileResults;
import ghidra.app.decompiler.DecompilerDisposer;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.UniqueLayout;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.lang.BasicCompilerSpec;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.SleighLanguageDescription;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.AddressXML;
import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.ByteIngest;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.Encoder;
import ghidra.program.model.pcode.PackedDecode;
import ghidra.program.model.pcode.PackedDecodeOverlay;
import ghidra.program.model.pcode.PackedEncode;
import ghidra.program.model.pcode.PackedEncodeOverlay;
import ghidra.program.model.pcode.PcodeDataTypeManager;
import ghidra.program.model.pcode.StringIngest;
import ghidra.program.model.pcode.XmlEncode;
import ghidra.program.model.symbol.IdentityNameTransformer;
import ghidra.program.model.symbol.NameTransformer;
import ghidra.util.Msg;
import ghidra.util.task.CancelledListener;
import ghidra.util.task.TaskMonitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class DecompInterface {
    protected Program program = null;
    private SleighLanguage pcodelanguage = null;
    private PcodeDataTypeManager dtmanage = null;
    protected String decompileMessage = "";
    protected CompilerSpec compilerSpec = null;
    protected DecompileProcess decompProcess;
    protected DecompileCallback decompCallback = null;
    protected EncodeDecodeSet baseEncodingSet = null;
    protected EncodeDecodeSet overlayEncodingSet = null;
    protected StringIngest stringResponse = new StringIngest();
    private DecompileDebug debug = null;
    protected CancelledListener monitorListener = new CancelledListener(){

        public void cancelled() {
            DecompInterface.this.stopProcess();
        }
    };
    private String actionname = "decompile";
    private DecompileOptions options = null;
    private boolean printSyntaxTree = true;
    private boolean printCCode = true;
    private boolean sendParamMeasures = false;
    private boolean jumpLoad = false;

    public synchronized void enableDebug(File debugfile) {
        this.debug = new DecompileDebug(debugfile);
    }

    public boolean debugEnabled() {
        return this.debug != null;
    }

    public String getSimplificationStyle() {
        return this.actionname;
    }

    public Program getProgram() {
        return this.program;
    }

    public Language getLanguage() {
        return this.pcodelanguage;
    }

    public PcodeDataTypeManager getDataTypeManager() {
        return this.dtmanage;
    }

    public String getLastMessage() {
        return this.decompileMessage;
    }

    private boolean isErrorMessage() {
        if (this.decompileMessage == null || this.decompileMessage.length() == 0) {
            return false;
        }
        return this.decompileMessage.toLowerCase().indexOf("warning") == -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String fileToString(ResourceFile file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));){
            StringBuffer buffer = new StringBuffer();
            String line = null;
            while ((line = reader.readLine()) != null) {
                buffer.append(line);
            }
            String string = buffer.toString();
            return string;
        }
    }

    protected void initializeProcess() throws IOException, DecompileException {
        if (this.decompCallback == null) {
            throw new IOException("Program not opened in decompiler");
        }
        if (this.decompProcess == null) {
            this.decompProcess = DecompileProcessFactory.get();
        } else if (!this.decompProcess.isReady()) {
            DecompileProcessFactory.release(this.decompProcess);
            this.decompProcess = DecompileProcessFactory.get();
        }
        long uniqueBase = UniqueLayout.SLEIGH_BASE.getOffset(this.pcodelanguage);
        XmlEncode xmlEncode = new XmlEncode();
        this.pcodelanguage.encodeTranslator((Encoder)xmlEncode, this.program.getAddressFactory(), uniqueBase);
        String tspec = xmlEncode.toString();
        xmlEncode.clear();
        this.dtmanage.encodeCoreTypes((Encoder)xmlEncode);
        String coretypes = xmlEncode.toString();
        SleighLanguageDescription sleighdescription = (SleighLanguageDescription)this.pcodelanguage.getLanguageDescription();
        ResourceFile pspecfile = sleighdescription.getSpecFile();
        String pspecxml = DecompInterface.fileToString(pspecfile);
        xmlEncode.clear();
        this.compilerSpec.encode((Encoder)xmlEncode);
        String cspecxml = xmlEncode.toString();
        this.baseEncodingSet = new EncodeDecodeSet(this.program);
        this.decompCallback.setNativeMessage(null);
        this.decompProcess.registerProgram(this.decompCallback, pspecxml, cspecxml, tspec, coretypes, this.program);
        String nativeMessage = this.decompCallback.getNativeMessage();
        if (nativeMessage != null && nativeMessage.length() != 0) {
            throw new IOException("Could not register program: " + nativeMessage);
        }
        if (this.options != null) {
            this.baseEncodingSet.mainQuery.clear();
            this.options.encode(this.baseEncodingSet.mainQuery, this);
            this.decompProcess.setMaxResultSize(this.options.getMaxPayloadMBytes());
            this.decompProcess.sendCommand1Param("setOptions", this.baseEncodingSet.mainQuery, (ByteIngest)this.stringResponse);
            if (!this.stringResponse.toString().equals("t")) {
                throw new IOException("Did not accept decompiler options");
            }
        }
        if (this.actionname == null) {
            throw new IOException("Decompile action not specified");
        }
        if (!this.actionname.equals("decompile")) {
            this.decompProcess.sendCommand2Params("setAction", this.actionname, "", (ByteIngest)this.stringResponse);
            if (!this.stringResponse.toString().equals("t")) {
                throw new IOException("Could not set decompile action");
            }
        }
        if (!this.printSyntaxTree) {
            this.decompProcess.sendCommand2Params("setAction", "", "notree", (ByteIngest)this.stringResponse);
            if (!this.stringResponse.toString().equals("t")) {
                throw new IOException("Could not turn off syntax tree");
            }
        }
        if (!this.printCCode) {
            this.decompProcess.sendCommand2Params("setAction", "", "noc", (ByteIngest)this.stringResponse);
            if (!this.stringResponse.toString().equals("t")) {
                throw new IOException("Could not turn off C printing");
            }
        }
        if (this.sendParamMeasures) {
            this.decompProcess.sendCommand2Params("setAction", "", "parammeasures", (ByteIngest)this.stringResponse);
            if (!this.stringResponse.toString().equals("t")) {
                throw new IOException("Could not turn on sending of parameter measures");
            }
        }
        if (this.jumpLoad) {
            this.decompProcess.sendCommand2Params("setAction", "", "jumpload", (ByteIngest)this.stringResponse);
            if (!this.stringResponse.toString().equals("t")) {
                throw new IOException("Could not turn on jumptable loads");
            }
        }
    }

    protected void verifyProcess() throws IOException, DecompileException {
        if (this.decompProcess == null || !this.decompProcess.isReady()) {
            this.initializeProcess();
        }
        if (!this.decompProcess.isReady()) {
            throw new IOException("Unable to restart decompiler process");
        }
    }

    public synchronized boolean openProgram(Program prog) {
        this.decompileMessage = "";
        this.program = prog;
        Language lang = prog.getLanguage();
        if (!lang.supportsPcode()) {
            this.decompileMessage = "Language does not support PCode.";
            return false;
        }
        this.pcodelanguage = (SleighLanguage)lang;
        CompilerSpec spec = prog.getCompilerSpec();
        if (!(spec instanceof BasicCompilerSpec)) {
            this.decompileMessage = "Language has unsupported compiler spec: " + spec.getClass().getName();
            return false;
        }
        this.compilerSpec = spec;
        IdentityNameTransformer transformer = this.options == null ? new IdentityNameTransformer() : this.options.getNameTransformer();
        this.dtmanage = new PcodeDataTypeManager(prog, (NameTransformer)transformer);
        try {
            this.decompCallback = new DecompileCallback(prog, (Language)this.pcodelanguage, this.program.getCompilerSpec(), this.dtmanage);
            this.initializeProcess();
            if (!this.decompProcess.isReady()) {
                throw new IOException("Unable to start decompiler process");
            }
            this.decompileMessage = this.decompCallback.getNativeMessage();
            if (!this.isErrorMessage()) {
                return true;
            }
        }
        catch (Exception ex) {
            this.decompileMessage = ex.getMessage();
            if (this.decompProcess == null) {
                return false;
            }
            this.stopProcess();
        }
        this.program = null;
        this.decompCallback = null;
        this.baseEncodingSet = null;
        return false;
    }

    public synchronized void closeProgram() {
        this.decompileMessage = "";
        if (this.program != null) {
            this.program = null;
            this.decompCallback = null;
            this.baseEncodingSet = null;
            this.overlayEncodingSet = null;
            try {
                if (this.decompProcess != null && this.decompProcess.isReady()) {
                    this.decompProcess.deregisterProgram();
                    DecompileProcessFactory.release(this.decompProcess);
                }
            }
            catch (IOException iOException) {
            }
            catch (DecompileException decompileException) {
                // empty catch block
            }
            this.stopProcess();
        }
    }

    public synchronized boolean setSimplificationStyle(String actionstring) {
        this.actionname = actionstring;
        if (this.decompProcess == null) {
            return true;
        }
        try {
            this.verifyProcess();
            this.decompProcess.sendCommand2Params("setAction", actionstring, "", (ByteIngest)this.stringResponse);
            return this.stringResponse.toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized boolean toggleSyntaxTree(boolean val) {
        this.printSyntaxTree = val;
        if (this.decompProcess == null) {
            return true;
        }
        String printstring = val ? "tree" : "notree";
        try {
            this.verifyProcess();
            this.decompProcess.sendCommand2Params("setAction", "", printstring, (ByteIngest)this.stringResponse);
            return this.stringResponse.toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized boolean toggleCCode(boolean val) {
        this.printCCode = val;
        if (this.decompProcess == null) {
            return true;
        }
        String printstring = val ? "c" : "noc";
        try {
            this.verifyProcess();
            this.decompProcess.sendCommand2Params("setAction", "", printstring, (ByteIngest)this.stringResponse);
            return this.stringResponse.toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized boolean toggleParamMeasures(boolean val) {
        this.sendParamMeasures = val;
        if (this.decompProcess == null) {
            return true;
        }
        String printstring = val ? "parammeasures" : "noparammeasures";
        try {
            this.verifyProcess();
            this.decompProcess.sendCommand2Params("setAction", "", printstring, (ByteIngest)this.stringResponse);
            return this.stringResponse.toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized boolean toggleJumpLoads(boolean val) {
        this.jumpLoad = val;
        if (this.decompProcess == null) {
            return true;
        }
        String jumpstring = val ? "jumpload" : "nojumpload";
        try {
            this.verifyProcess();
            this.decompProcess.sendCommand2Params("setAction", "", jumpstring, (ByteIngest)this.stringResponse);
            return this.stringResponse.toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized boolean setOptions(DecompileOptions options) {
        this.options = options;
        if (this.dtmanage != null) {
            this.dtmanage.setNameTransformer(options.getNameTransformer());
        }
        this.decompileMessage = "";
        if (this.decompProcess == null) {
            return true;
        }
        try {
            this.verifyProcess();
            this.baseEncodingSet.mainQuery.clear();
            options.encode(this.baseEncodingSet.mainQuery, this);
            this.decompProcess.setMaxResultSize(options.getMaxPayloadMBytes());
            this.decompProcess.sendCommand1Param("setOptions", this.baseEncodingSet.mainQuery, (ByteIngest)this.stringResponse);
            return this.stringResponse.toString().equals("t");
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return false;
    }

    public synchronized DecompileOptions getOptions() {
        return this.options;
    }

    public synchronized int flushCache() {
        int res = -1;
        try {
            if (this.decompProcess != null && this.decompProcess.isReady()) {
                this.decompProcess.sendCommand("flushNative", (ByteIngest)this.stringResponse);
                return Integer.parseInt(this.stringResponse.toString());
            }
        }
        catch (IOException iOException) {
        }
        catch (DecompileException decompileException) {
            // empty catch block
        }
        this.stopProcess();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BlockGraph structureGraph(BlockGraph ingraph, int timeoutSecs, TaskMonitor monitor) {
        this.decompileMessage = "";
        if (monitor != null && monitor.isCancelled()) {
            return null;
        }
        if (monitor != null) {
            monitor.addCancelledListener(this.monitorListener);
        }
        BlockGraph resgraph = null;
        try {
            this.setupEncodeDecode(Address.NO_ADDRESS);
            this.verifyProcess();
            this.baseEncodingSet.mainQuery.clear();
            ingraph.encode(this.baseEncodingSet.mainQuery);
            this.decompProcess.sendCommandTimeout("structureGraph", timeoutSecs, this.baseEncodingSet);
            this.decompileMessage = this.decompCallback.getNativeMessage();
            if (!this.baseEncodingSet.mainResponse.isEmpty()) {
                resgraph = new BlockGraph();
                resgraph.decode((Decoder)this.baseEncodingSet.mainResponse);
                resgraph.transferObjectRef(ingraph);
            }
        }
        catch (Exception ex) {
            this.decompileMessage = "Exception while graph structuring: " + ex.getMessage() + "\n";
        }
        finally {
            if (monitor != null) {
                monitor.removeCancelledListener(this.monitorListener);
            }
        }
        return resgraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized DecompileResults decompileFunction(Function func, int timeoutSecs, TaskMonitor monitor) {
        DecompileProcess.DisposeState processState;
        this.decompileMessage = "";
        if (monitor != null && monitor.isCancelled()) {
            return null;
        }
        if (monitor != null) {
            monitor.addCancelledListener(this.monitorListener);
        }
        if (this.program == null) {
            return new DecompileResults(func, (Language)this.pcodelanguage, null, this.dtmanage, this.decompileMessage, null, DecompileProcess.DisposeState.DISPOSED_ON_CANCEL);
        }
        PackedDecode decoder = null;
        try {
            Address funcEntry = func.getEntryPoint();
            if (this.debug != null) {
                this.debug.setFunction(func);
            }
            this.decompCallback.setFunction(func, funcEntry, this.debug);
            EncodeDecodeSet activeSet = this.setupEncodeDecode(funcEntry);
            decoder = activeSet.mainResponse;
            this.verifyProcess();
            activeSet.mainQuery.clear();
            AddressXML.encode((Encoder)activeSet.mainQuery, (Address)funcEntry);
            this.decompProcess.sendCommandTimeout("decompileAt", timeoutSecs, activeSet);
            this.decompileMessage = this.decompCallback.getNativeMessage();
        }
        catch (Exception ex) {
            decoder.clear();
            this.decompileMessage = "Exception while decompiling " + func.getEntryPoint() + ": " + ex.getMessage() + "\n";
        }
        finally {
            if (monitor != null) {
                monitor.removeCancelledListener(this.monitorListener);
            }
        }
        try {
            if (this.debug != null) {
                XmlEncode xmlEncode = new XmlEncode();
                this.options.encode((Encoder)xmlEncode, this);
                this.debug.shutdown((Language)this.pcodelanguage, xmlEncode.toString());
                this.debug = null;
            }
        }
        catch (IOException e) {
            Msg.error((Object)this.debug, (Object)"Could not dump debug info");
        }
        if (this.decompProcess != null) {
            processState = this.decompProcess.getDisposeState();
            if (this.decompProcess.getDisposeState() == DecompileProcess.DisposeState.NOT_DISPOSED) {
                this.flushCache();
            }
        } else {
            processState = DecompileProcess.DisposeState.DISPOSED_ON_CANCEL;
        }
        return new DecompileResults(func, (Language)this.pcodelanguage, this.compilerSpec, this.dtmanage, this.decompileMessage, (Decoder)decoder, processState);
    }

    public void stopProcess() {
        if (this.decompProcess != null) {
            this.decompProcess.dispose();
        }
    }

    public void resetDecompiler() {
        this.stopProcess();
        try {
            this.initializeProcess();
        }
        catch (DecompileException | IOException e) {
            this.decompileMessage = "Exception while resetting decompiler: " + e.getMessage() + "\n";
        }
    }

    public void dispose() {
        if (this.program == null) {
            if (this.decompProcess != null) {
                DecompileProcessFactory.release(this.decompProcess);
            }
            return;
        }
        DecompilerDisposer.dispose(this);
    }

    void disposeCallback() {
        this.closeProgram();
    }

    public CompilerSpec getCompilerSpec() {
        return this.compilerSpec;
    }

    protected EncodeDecodeSet setupEncodeDecode(Address addr) throws AddressFormatException {
        AddressSpace spc = addr.getAddressSpace();
        if (!spc.isOverlaySpace()) {
            return this.baseEncodingSet;
        }
        OverlayAddressSpace overlay = (OverlayAddressSpace)spc;
        if (this.overlayEncodingSet == null) {
            this.overlayEncodingSet = new EncodeDecodeSet(this.program, overlay);
        } else {
            this.overlayEncodingSet.setOverlay(overlay);
        }
        return this.overlayEncodingSet;
    }

    public static class EncodeDecodeSet {
        public OverlayAddressSpace overlay;
        public Encoder mainQuery;
        public PackedDecode mainResponse;
        public PackedDecode callbackQuery;
        public PackedEncode callbackResponse;

        public EncodeDecodeSet(Program program) {
            this.overlay = null;
            this.mainQuery = new PackedEncode();
            this.mainResponse = new PackedDecode(program.getAddressFactory());
            this.callbackQuery = new PackedDecode(program.getAddressFactory());
            this.callbackResponse = new PackedEncode();
        }

        public EncodeDecodeSet(Program program, OverlayAddressSpace spc) throws AddressFormatException {
            this.mainQuery = new PackedEncodeOverlay(spc);
            this.mainResponse = new PackedDecodeOverlay(program.getAddressFactory(), spc);
            this.callbackQuery = new PackedDecodeOverlay(program.getAddressFactory(), spc);
            this.callbackResponse = new PackedEncodeOverlay(spc);
        }

        public void setOverlay(OverlayAddressSpace spc) throws AddressFormatException {
            if (this.overlay == spc) {
                return;
            }
            this.overlay = spc;
            ((PackedEncodeOverlay)this.mainQuery).setOverlay(spc);
            ((PackedDecodeOverlay)this.mainResponse).setOverlay(spc);
            ((PackedDecodeOverlay)this.callbackQuery).setOverlay(spc);
            ((PackedEncodeOverlay)this.callbackResponse).setOverlay(spc);
        }
    }
}

