/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangFuncProto;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangStatement;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangVariableDecl;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.PcodeFactory;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;

public class ClangTokenGroup
implements ClangNode,
Iterable<ClangNode> {
    private ClangNode parent;
    Address minaddress;
    Address maxaddress;
    private ArrayList<ClangNode> tokgroup;

    public ClangTokenGroup(ClangNode par) {
        this.parent = par;
        this.tokgroup = new ArrayList();
        this.minaddress = null;
        this.maxaddress = null;
    }

    @Override
    public Address getMinAddress() {
        return this.minaddress;
    }

    @Override
    public Address getMaxAddress() {
        return this.maxaddress;
    }

    public void AddTokenGroup(ClangNode obj) {
        Address minaddr = obj.getMinAddress();
        Address maxaddr = obj.getMaxAddress();
        if (minaddr != null) {
            if (this.minaddress == null) {
                this.minaddress = minaddr;
            } else if (minaddr.compareTo((Object)this.minaddress) < 0) {
                this.minaddress = minaddr;
            }
        }
        if (maxaddr != null) {
            if (this.maxaddress == null) {
                this.maxaddress = maxaddr;
            } else if (this.maxaddress.compareTo((Object)maxaddr) < 0) {
                this.maxaddress = maxaddr;
            }
        }
        this.tokgroup.add(obj);
    }

    @Override
    public ClangNode Parent() {
        return this.parent;
    }

    @Override
    public int numChildren() {
        return this.tokgroup.size();
    }

    @Override
    public ClangNode Child(int i) {
        return this.tokgroup.get(i);
    }

    @Override
    public ClangFunction getClangFunction() {
        return this.parent.getClangFunction();
    }

    @Override
    public void setHighlight(Color val) {
        for (ClangNode element : this.tokgroup) {
            element.setHighlight(val);
        }
    }

    @Override
    public void flatten(List<ClangNode> list) {
        for (ClangNode element : this.tokgroup) {
            element.flatten(list);
        }
    }

    public void decode(Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        int elem;
        while ((elem = decoder.openElement()) != 0) {
            if (elem == ElementId.ELEM_RETURN_TYPE.id()) {
                child = new ClangReturnType(this);
                ((ClangReturnType)child).decode(decoder, pfactory);
                this.AddTokenGroup(child);
            } else if (elem == ElementId.ELEM_VARDECL.id()) {
                child = new ClangVariableDecl(this);
                ((ClangVariableDecl)child).decode(decoder, pfactory);
                this.AddTokenGroup(child);
            } else if (elem == ElementId.ELEM_STATEMENT.id()) {
                child = new ClangStatement(this);
                ((ClangStatement)child).decode(decoder, pfactory);
                this.AddTokenGroup(child);
            } else if (elem == ElementId.ELEM_FUNCPROTO.id()) {
                child = new ClangFuncProto(this);
                child.decode(decoder, pfactory);
                this.AddTokenGroup(child);
            } else if (elem == ElementId.ELEM_BLOCK.id()) {
                child = new ClangTokenGroup(this);
                child.decode(decoder, pfactory);
                this.AddTokenGroup(child);
            } else {
                ClangToken tok = ClangToken.buildToken(elem, this, decoder, pfactory);
                this.AddTokenGroup(tok);
            }
            decoder.closeElement(elem);
        }
    }

    private static boolean isLetterDigitOrUnderscore(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public String toString() {
        String lastTokenStr = null;
        StringBuffer buffer = new StringBuffer();
        for (ClangNode node : this.tokgroup) {
            String tokenStr = node.toString();
            if (tokenStr.length() == 0) continue;
            if (lastTokenStr != null && ClangTokenGroup.isLetterDigitOrUnderscore(tokenStr.charAt(0)) && ClangTokenGroup.isLetterDigitOrUnderscore(lastTokenStr.charAt(lastTokenStr.length() - 1))) {
                buffer.append(' ');
            }
            lastTokenStr = tokenStr;
            buffer.append(tokenStr);
        }
        return buffer.toString();
    }

    @Override
    public Iterator<ClangNode> iterator() {
        return this.tokgroup.iterator();
    }

    public Stream<ClangNode> stream() {
        return this.tokgroup.stream();
    }
}

