/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.app.decompiler.ClangBreak;
import ghidra.app.decompiler.ClangCommentToken;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangLabelToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangOpToken;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangTypeToken;
import ghidra.app.decompiler.ClangVariableToken;
import ghidra.program.model.address.Address;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;
import java.awt.Color;
import java.util.List;

public class ClangToken
implements ClangNode {
    public static final int KEYWORD_COLOR = 0;
    public static final int COMMENT_COLOR = 1;
    public static final int TYPE_COLOR = 2;
    public static final int FUNCTION_COLOR = 3;
    public static final int VARIABLE_COLOR = 4;
    public static final int CONST_COLOR = 5;
    public static final int PARAMETER_COLOR = 6;
    public static final int GLOBAL_COLOR = 7;
    public static final int DEFAULT_COLOR = 8;
    public static final int ERROR_COLOR = 9;
    public static final int SPECIAL_COLOR = 10;
    public static final int MAX_COLOR = 11;
    private ClangNode parent;
    private ClangLine lineparent;
    private String text;
    private int syntax_type;
    private Color highlight;
    private boolean matchingToken;

    public ClangToken(ClangNode par) {
        this.parent = par;
        this.text = null;
        this.highlight = null;
        this.syntax_type = 8;
        this.lineparent = null;
    }

    public ClangToken(ClangNode par, String txt) {
        this.parent = par;
        this.text = txt;
        this.highlight = null;
        this.syntax_type = 8;
    }

    public ClangToken(ClangNode par, String txt, int color) {
        this.parent = par;
        this.text = txt;
        this.highlight = null;
        this.syntax_type = color;
    }

    @Override
    public ClangNode Parent() {
        return this.parent;
    }

    public ClangLine getLineParent() {
        return this.lineparent;
    }

    public void setLineParent(ClangLine line) {
        this.lineparent = line;
    }

    @Override
    public Address getMinAddress() {
        return null;
    }

    @Override
    public Address getMaxAddress() {
        return null;
    }

    @Override
    public int numChildren() {
        return 0;
    }

    @Override
    public ClangNode Child(int i) {
        return null;
    }

    @Override
    public ClangFunction getClangFunction() {
        if (this.parent != null) {
            return this.parent.getClangFunction();
        }
        return null;
    }

    @Override
    public void setHighlight(Color val) {
        this.highlight = val;
    }

    public Color getHighlight() {
        return this.highlight;
    }

    public void setMatchingToken(boolean matchingToken) {
        this.matchingToken = matchingToken;
    }

    public boolean isMatchingToken() {
        return this.matchingToken;
    }

    public boolean isVariableRef() {
        return false;
    }

    public int getSyntaxType() {
        return this.syntax_type;
    }

    void setSyntaxType(int syntax_type) {
        this.syntax_type = syntax_type;
    }

    public String getText() {
        return this.text;
    }

    void setText(String text) {
        this.text = text;
    }

    public void decode(Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        int attribId;
        this.syntax_type = 8;
        while ((attribId = decoder.getNextAttributeId()) != 0) {
            if (attribId != AttributeId.ATTRIB_COLOR.id()) continue;
            this.syntax_type = (int)decoder.readUnsignedInteger();
            break;
        }
        this.text = decoder.readString(AttributeId.ATTRIB_CONTENT);
        if (this.syntax_type < 0 || this.syntax_type >= 11) {
            this.syntax_type = 8;
        }
    }

    @Override
    public void flatten(List<ClangNode> list) {
        list.add(this);
    }

    public static ClangToken buildToken(int node, ClangNode par, Decoder decoder, PcodeFactory pfactory) throws DecoderException {
        ClangToken token = null;
        if (node == ElementId.ELEM_VARIABLE.id()) {
            token = new ClangVariableToken(par);
        } else if (node == ElementId.ELEM_OP.id()) {
            token = new ClangOpToken(par);
        } else if (node == ElementId.ELEM_SYNTAX.id()) {
            token = new ClangSyntaxToken(par);
        } else if (node == ElementId.ELEM_BREAK.id()) {
            token = new ClangBreak(par);
        } else if (node == ElementId.ELEM_FUNCNAME.id()) {
            token = new ClangFuncNameToken(par, null);
        } else if (node == ElementId.ELEM_TYPE.id()) {
            token = new ClangTypeToken(par);
        } else if (node == ElementId.ELEM_COMMENT.id()) {
            token = new ClangCommentToken(par);
        } else if (node == ElementId.ELEM_LABEL.id()) {
            token = new ClangLabelToken(par);
        } else if (node == ElementId.ELEM_FIELD.id()) {
            token = new ClangFieldToken(par);
        } else {
            throw new DecoderException("Expecting token element");
        }
        ((ClangToken)token).decode(decoder, pfactory);
        return token;
    }

    public static ClangToken buildSpacer(ClangNode par, int indent, String indentStr) {
        Object spacing = new String();
        for (int i = 0; i < indent; ++i) {
            spacing = (String)spacing + indentStr;
        }
        return new ClangSyntaxToken(par, (String)spacing);
    }

    public String toString() {
        return this.text;
    }

    public HighVariable getHighVariable() {
        return null;
    }

    public HighSymbol getHighSymbol(HighFunction highFunction) {
        return null;
    }

    public Varnode getVarnode() {
        return null;
    }

    public PcodeOp getPcodeOp() {
        return null;
    }
}

