/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.importer.batch;

import docking.DialogComponentProvider;
import docking.widgets.ListSelectionTableDialog;
import docking.widgets.checkbox.GCheckBox;
import docking.widgets.combobox.GComboBox;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.label.GDLabel;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import generic.theme.GThemeDefaults;
import ghidra.app.services.ProgramManager;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.framework.main.AppInfo;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.plugintool.PluginTool;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugins.importer.batch.BatchGroup;
import ghidra.plugins.importer.batch.BatchGroupLoadSpec;
import ghidra.plugins.importer.batch.BatchImportTableModel;
import ghidra.plugins.importer.batch.BatchInfo;
import ghidra.plugins.importer.batch.BatchProjectDestinationPanel;
import ghidra.plugins.importer.batch.UserAddedSourceInfo;
import ghidra.plugins.importer.tasks.ImportBatchTask;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BatchImportDialog
extends DialogComponentProvider {
    private static final String LAST_IMPORT_DIR = "LastBatchImportDir";
    private BatchInfo batchInfo;
    private DomainFolder destinationFolder;
    private ProgramManager programManager;
    private boolean stripLeading = true;
    private boolean stripContainer = false;
    private boolean openAfterImporting = false;
    private BatchImportTableModel tableModel;
    private GTable table;
    private JButton removeSourceButton;
    private JButton rescanButton;
    private JSpinner maxDepthSpinner;
    private SourcesListModel sourceListModel;

    public static void showAndImport(PluginTool tool, BatchInfo batchInfo, List<FSRL> initialFiles, DomainFolder defaultFolder, ProgramManager programManager) {
        BatchImportDialog dialog = new BatchImportDialog(batchInfo, defaultFolder);
        dialog.setProgramManager(programManager);
        SystemUtilities.runSwingLater(() -> {
            dialog.build();
            if (initialFiles != null && !initialFiles.isEmpty()) {
                dialog.addSources(initialFiles);
            }
            if (!dialog.setupInitialDefaults()) {
                return;
            }
            tool.showDialog((DialogComponentProvider)dialog);
        });
    }

    private BatchImportDialog(BatchInfo batchInfo, DomainFolder defaultFolder) {
        super("Batch Import", true);
        this.batchInfo = batchInfo != null ? batchInfo : new BatchInfo();
        this.destinationFolder = defaultFolder != null ? defaultFolder : AppInfo.getActiveProject().getProjectData().getRootFolder();
        this.setHelpLocation(new HelpLocation("ImporterPlugin", "Batch_Import_Dialog"));
        this.setPreferredSize(900, 600);
    }

    private void build() {
        this.tableModel = new BatchImportTableModel(this.batchInfo){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                super.setValueAt(aValue, rowIndex, columnIndex);
                BatchImportDialog.this.refreshButtons();
            }
        };
        this.table = new GTable((TableModel)((Object)this.tableModel));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Point p = e.getPoint();
                int row = BatchImportDialog.this.table.rowAtPoint(p);
                int col = BatchImportDialog.this.table.columnAtPoint(p);
                TableColumnModel columnModel = BatchImportDialog.this.table.getColumnModel();
                TableColumn column = columnModel.getColumn(col);
                int modelIndex = column.getModelIndex();
                if (modelIndex == BatchImportTableModel.COLS.FILES.ordinal()) {
                    BatchImportDialog.this.showFiles(row);
                }
            }
        });
        this.table.setShowGrid(false);
        this.table.setIntercellSpacing(new Dimension(0, 0));
        TableColumn selectedColumn = this.table.getColumnModel().getColumn(BatchImportTableModel.COLS.SELECTED.ordinal());
        selectedColumn.setResizable(false);
        selectedColumn.setMaxWidth(50);
        TableColumn filesColumn = this.table.getColumnModel().getColumn(BatchImportTableModel.COLS.FILES.ordinal());
        filesColumn.setCellEditor(this.createFilesColumnCellEditor());
        filesColumn.setCellRenderer(this.createFilesColumnCellRenderer());
        TableColumn langColumn = this.table.getColumnModel().getColumn(BatchImportTableModel.COLS.LANG.ordinal());
        langColumn.setCellEditor(this.createLangColumnCellEditor());
        langColumn.setCellRenderer(this.createLangColumnCellRenderer());
        JScrollPane scrollPane = new JScrollPane((Component)this.table);
        JPanel filesPanel = new JPanel();
        filesPanel.setLayout(new BorderLayout());
        filesPanel.add((Component)scrollPane, "Center");
        filesPanel.setBorder(this.createTitledBorder("Files to Import", true));
        JPanel sourceListPanel = new JPanel();
        sourceListPanel.setLayout(new BorderLayout());
        sourceListPanel.setBorder(this.createTitledBorder("Import Sources", false));
        this.sourceListModel = new SourcesListModel();
        final JList<String> sourceList = new JList<String>(this.sourceListModel);
        sourceList.setName("batch.import.source.list");
        sourceList.addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                boolean hasSelection = sourceList.getSelectedIndices().length > 0;
                this.removeSourceButton.setEnabled(hasSelection);
            }
        });
        JScrollPane sourceListScrollPane = new JScrollPane(sourceList);
        sourceListPanel.add((Component)sourceListScrollPane, "Center");
        JPanel sourceOptionsPanel = new JPanel();
        sourceOptionsPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        sourceListPanel.add((Component)sourceOptionsPanel, "South");
        JPanel maxDepthPanel = new JPanel();
        GDLabel maxDepthLabel = new GDLabel("Depth limit:");
        String maxDepthTip = "Maximum container (ie. nested zip, tar, etc) depth in the source file to recursively descend into";
        maxDepthLabel.setToolTipText(maxDepthTip);
        maxDepthPanel.add((Component)maxDepthLabel);
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(this.batchInfo.getMaxDepth(), 0, 99, 1);
        this.maxDepthSpinner = new JSpinner(spinnerNumberModel);
        this.maxDepthSpinner.setToolTipText(maxDepthTip);
        this.rescanButton = new JButton("Rescan");
        this.rescanButton.setToolTipText("Clear Files to Import list and rescan Import Sources for applications to import");
        spinnerNumberModel.addChangeListener(e -> this.rescanButton.setEnabled(spinnerNumberModel.getNumber().intValue() != this.batchInfo.getMaxDepth()));
        this.rescanButton.addActionListener(e -> SystemUtilities.runSwingLater(() -> this.setMaxDepth(spinnerNumberModel.getNumber().intValue())));
        maxDepthPanel.add(this.maxDepthSpinner);
        maxDepthPanel.add(this.rescanButton);
        sourceOptionsPanel.add(maxDepthPanel);
        JPanel sourceListButtonsPanel = new JPanel();
        sourceListButtonsPanel.setLayout(new BorderLayout());
        JButton addSourceButton = new JButton("Add");
        this.removeSourceButton = new JButton("Remove");
        this.removeSourceButton.setEnabled(false);
        addSourceButton.addActionListener(e -> this.addSources());
        this.removeSourceButton.addActionListener(e -> {
            ArrayList<FSRL> sourcesToRemove = new ArrayList<FSRL>();
            for (int index : sourceList.getSelectedIndices()) {
                if (index < 0 || index >= this.batchInfo.getUserAddedSources().size()) continue;
                UserAddedSourceInfo uasi = this.batchInfo.getUserAddedSources().get(index);
                sourcesToRemove.add(uasi.getFSRL());
            }
            Object object = sourcesToRemove.iterator();
            while (object.hasNext()) {
                FSRL fsrl = (FSRL)object.next();
                this.batchInfo.remove(fsrl);
            }
            this.refreshData();
        });
        sourceListButtonsPanel.add((Component)addSourceButton, "North");
        sourceListButtonsPanel.add((Component)this.removeSourceButton, "South");
        JPanel buttonWrapperPanel = new JPanel();
        buttonWrapperPanel.add(sourceListButtonsPanel);
        sourceListPanel.add((Component)buttonWrapperPanel, "East");
        this.sourceListModel.addListDataListener(new ListDataListener(){

            @Override
            public void intervalRemoved(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                this.contentsChanged(e);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                boolean hasSelection = sourceList.getSelectedIndices().length > 0;
                BatchImportDialog.this.removeSourceButton.setEnabled(hasSelection);
            }
        });
        JPanel outputOptionsPanel = this.buildOutputOptionsPanel();
        Box box = Box.createVerticalBox();
        box.add(sourceListPanel);
        box.add(filesPanel);
        box.add(outputOptionsPanel);
        this.addOKButton();
        this.addCancelButton();
        this.addWorkPanel(box);
    }

    private Border createTitledBorder(String title, boolean drawLine) {
        return BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createTitledBorder(" " + title + " "));
    }

    private JPanel buildOutputOptionsPanel() {
        JPanel outputChoicesPanel = new JPanel();
        outputChoicesPanel.setLayout(new BoxLayout(outputChoicesPanel, 2));
        GCheckBox stripLeadingCb = new GCheckBox("Strip leading path", this.stripLeading);
        stripLeadingCb.addChangeListener(e -> this.setStripLeading(stripLeadingCb.isSelected()));
        stripLeadingCb.setToolTipText("The destination folder for imported files will not include the source file's leading path");
        GCheckBox stripContainerCb = new GCheckBox("Strip container paths", this.stripContainer);
        stripContainerCb.addChangeListener(e -> this.setStripContainer(stripContainerCb.isSelected()));
        stripContainerCb.setToolTipText("The destination folder for imported files will not include any source path names");
        GCheckBox openAfterImportCb = new GCheckBox("Open after import", this.openAfterImporting);
        openAfterImportCb.addChangeListener(e -> this.setOpenAfterImporting(openAfterImportCb.isSelected()));
        openAfterImportCb.setToolTipText("Open imported binaries in Code Browser");
        outputChoicesPanel.add((Component)stripLeadingCb);
        outputChoicesPanel.add((Component)stripContainerCb);
        if (this.programManager != null) {
            outputChoicesPanel.add((Component)openAfterImportCb);
        }
        outputChoicesPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        BatchProjectDestinationPanel destPanel = new BatchProjectDestinationPanel(this.getComponent(), this.destinationFolder){

            @Override
            public void onProjectDestinationChange(DomainFolder newFolder) {
                BatchImportDialog.this.destinationFolder = newFolder;
            }
        };
        JPanel outputOptionsPanel = new JPanel(new BorderLayout());
        outputOptionsPanel.setBorder(this.createTitledBorder("Import Options", true));
        outputOptionsPanel.add((Component)outputChoicesPanel, "North");
        outputOptionsPanel.add((Component)destPanel, "South");
        return outputOptionsPanel;
    }

    private void showFiles(int row) {
        BatchGroup group = (BatchGroup)this.tableModel.getRowObject(row);
        List<BatchGroup.BatchLoadConfig> batchLoadConfigs = group.getBatchLoadConfig();
        List names = batchLoadConfigs.stream().map(batchLoadConfig -> batchLoadConfig.getPreferredFileName()).sorted().collect(Collectors.toList());
        ListSelectionTableDialog dialog = new ListSelectionTableDialog("Application Files", names);
        dialog.hideOkButton();
        dialog.showSelectMultiple((Component)this.table);
    }

    private void setOpenAfterImporting(boolean b) {
        this.openAfterImporting = b;
    }

    private void refreshData() {
        this.sourceListModel.refresh();
        this.tableModel.refreshData();
        this.maxDepthSpinner.setValue(this.batchInfo.getMaxDepth());
        this.refreshButtons();
    }

    private void refreshButtons() {
        this.setOkEnabled(this.batchInfo.getEnabledCount() > 0);
        this.rescanButton.setEnabled(((Number)this.maxDepthSpinner.getValue()).intValue() != this.batchInfo.getMaxDepth());
    }

    public boolean setupInitialDefaults() {
        if (this.batchInfo.getUserAddedSources().isEmpty() && !this.addSources()) {
            return false;
        }
        if (this.batchInfo.getMaxDepth() < 2) {
            this.setMaxDepth(2);
        }
        return true;
    }

    private boolean addSources() {
        GhidraFileChooser chooser = new GhidraFileChooser((Component)this.getComponent());
        chooser.setMultiSelectionEnabled(true);
        chooser.setTitle("Choose File to Batch Import");
        chooser.setApproveButtonText("Select files");
        chooser.setFileSelectionMode(GhidraFileChooserMode.FILES_AND_DIRECTORIES);
        chooser.addFileFilter(ImporterUtilities.LOADABLE_FILES_FILTER);
        chooser.addFileFilter(ImporterUtilities.CONTAINER_FILES_FILTER);
        chooser.setSelectedFileFilter(GhidraFileFilter.ALL);
        chooser.setLastDirectoryPreference(LAST_IMPORT_DIR);
        List selectedFiles = chooser.getSelectedFiles();
        if (selectedFiles.isEmpty()) {
            return !chooser.wasCancelled();
        }
        ArrayList<FSRL> filesToAdd = new ArrayList<FSRL>();
        for (File selectedFile : selectedFiles) {
            filesToAdd.add(FileSystemService.getInstance().getLocalFSRL(selectedFile));
        }
        chooser.dispose();
        return this.addSources(filesToAdd);
    }

    private boolean addSources(List<FSRL> filesToAdd) {
        List<FSRL> updatedFiles = filesToAdd.stream().map(FSRL::convertRootToContainer).collect(Collectors.toList());
        List<FSRL> badFiles = this.batchInfo.addFiles(updatedFiles);
        if (!badFiles.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (FSRL fsrl : badFiles) {
                if (sb.length() > 0) {
                    sb.append(",\n");
                }
                sb.append(fsrl.getPath());
            }
            Msg.showWarn((Object)((Object)this), (Component)this.getComponent(), (String)("Skipping " + badFiles.size() + " file(s)"), (Object)("Program encountered while adding files to batch: " + sb.toString()));
        }
        this.refreshData();
        return true;
    }

    protected void okCallback() {
        new TaskLauncher((Task)new ImportBatchTask(this.batchInfo, this.destinationFolder, this.openAfterImporting ? this.programManager : null, this.stripLeading, this.stripContainer), (Component)this.getComponent());
        this.close();
    }

    private TableCellEditor createFilesColumnCellEditor() {
        GComboBox comboBox = new GComboBox();
        DefaultCellEditor cellEditor = new DefaultCellEditor((JComboBox)comboBox, (JComboBox)comboBox){
            final /* synthetic */ JComboBox val$comboBox;
            {
                this.val$comboBox = jComboBox;
                super(arg0);
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return true;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jtable, Object value, boolean isSelected, int row, int column) {
                this.val$comboBox.setSelectedItem("");
                this.val$comboBox.removeAllItems();
                BatchGroup rowVal = (BatchGroup)BatchImportDialog.this.tableModel.getRowObject(row);
                this.val$comboBox.addItem(rowVal.size() + " files...");
                for (BatchGroup.BatchLoadConfig batchLoadConfig : rowVal.getBatchLoadConfig()) {
                    this.val$comboBox.addItem(batchLoadConfig.getPreferredFileName());
                }
                return super.getTableCellEditorComponent((JTable)BatchImportDialog.this.table, value, isSelected, row, column);
            }
        };
        cellEditor.setClickCountToStart(2);
        return cellEditor;
    }

    private TableCellRenderer createFilesColumnCellRenderer() {
        GTableCellRenderer cellRenderer = new GTableCellRenderer(){

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
                renderer.setToolTipText("Click to view the files");
                return renderer;
            }

            protected String getText(Object value) {
                BatchGroup batchGroup = (BatchGroup)value;
                if (batchGroup != null) {
                    return batchGroup.size() + " files...";
                }
                return "";
            }
        };
        return cellRenderer;
    }

    private TableCellEditor createLangColumnCellEditor() {
        GComboBox comboBox = new GComboBox();
        DefaultCellEditor cellEditor = new DefaultCellEditor((JComboBox)comboBox, (JComboBox)comboBox){
            final /* synthetic */ JComboBox val$comboBox;
            {
                this.val$comboBox = jComboBox;
                super(arg0);
            }

            @Override
            public boolean shouldSelectCell(EventObject anEvent) {
                return false;
            }

            @Override
            public Component getTableCellEditorComponent(JTable jtable, Object value, boolean isSelected, int row, int column) {
                this.val$comboBox.removeAllItems();
                BatchGroup batchGroup = (BatchGroup)BatchImportDialog.this.tableModel.getRowObject(row);
                for (BatchGroupLoadSpec bo : batchGroup.getCriteria().getBatchGroupLoadSpecs()) {
                    this.val$comboBox.addItem(bo);
                }
                return super.getTableCellEditorComponent(jtable, value, isSelected, row, column);
            }
        };
        return cellEditor;
    }

    private TableCellRenderer createLangColumnCellRenderer() {
        GTableCellRenderer cellRenderer = new GTableCellRenderer(){
            {
                this.setHTMLRenderingEnabled(true);
            }

            public Component getTableCellRendererComponent(GTableCellRenderingData data) {
                JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
                renderer.setToolTipText("Click to set language");
                return renderer;
            }

            protected String getText(Object value) {
                BatchGroupLoadSpec bgls = (BatchGroupLoadSpec)value;
                return bgls != null ? bgls.toString() : "<html><font size=\"-2\" color=\"" + GThemeDefaults.Colors.Messages.HINT + "\">Click to set language</font>";
            }
        };
        return cellRenderer;
    }

    private void setStripLeading(boolean stripLeading) {
        this.stripLeading = stripLeading;
    }

    private void setStripContainer(boolean stripContainer) {
        this.stripContainer = stripContainer;
    }

    private void setMaxDepth(int newMaxDepth) {
        if (newMaxDepth == this.batchInfo.getMaxDepth()) {
            return;
        }
        this.batchInfo.setMaxDepth(newMaxDepth);
        this.refreshData();
    }

    private void setProgramManager(ProgramManager programManager) {
        this.programManager = programManager;
    }

    private class SourcesListModel
    extends AbstractListModel<String> {
        int prevSize;

        private SourcesListModel() {
            this.prevSize = BatchImportDialog.this.batchInfo.getUserAddedSources().size();
        }

        @Override
        public int getSize() {
            return this.prevSize;
        }

        @Override
        public String getElementAt(int index) {
            List<UserAddedSourceInfo> list = BatchImportDialog.this.batchInfo.getUserAddedSources();
            if (index >= list.size()) {
                return "Missing";
            }
            UserAddedSourceInfo uasi = list.get(index);
            String info = String.format("%s [%d files/%d apps/%d containers/%d%s levels]", uasi.getFSRL().getPath(), uasi.getRawFileCount(), uasi.getFileCount(), uasi.getContainerCount(), uasi.getMaxNestLevel() - uasi.getFSRL().getNestingDepth() + 1, uasi.wasRecurseTerminatedEarly() ? "+" : "");
            return info;
        }

        public void refresh() {
            if (this.prevSize > 0) {
                this.fireIntervalRemoved(this, 0, this.prevSize - 1);
            }
            this.prevSize = BatchImportDialog.this.batchInfo.getUserAddedSources().size();
            if (this.prevSize > 0) {
                this.fireIntervalAdded(this, 0, this.prevSize - 1);
            }
        }
    }
}

