/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.widgets.SelectFromListDialog;
import ghidra.app.services.ProgramManager;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class FSBUtils {
    public static ProgramManager getProgramManager(PluginTool tool, boolean allowUserPrompt) {
        List<PluginTool> runningPMTools;
        PluginTool pmTool = null;
        ProgramManager pm = (ProgramManager)tool.getService(ProgramManager.class);
        pmTool = pm != null ? tool : ((runningPMTools = FSBUtils.getRunningProgramManagerTools(tool)).size() == 1 ? runningPMTools.get(0) : (allowUserPrompt ? FSBUtils.selectPMTool(tool) : null));
        return pmTool != null ? (ProgramManager)pmTool.getService(ProgramManager.class) : null;
    }

    public static List<PluginTool> getRunningProgramManagerTools(PluginTool tool) {
        ArrayList<PluginTool> pluginTools = new ArrayList<PluginTool>();
        for (PluginTool runningTool : tool.getToolServices().getRunningTools()) {
            PluginTool pt = runningTool;
            ProgramManager pmService = (ProgramManager)pt.getService(ProgramManager.class);
            if (pmService == null) continue;
            pluginTools.add(pt);
        }
        return pluginTools;
    }

    private static PluginTool selectPMTool(PluginTool tool) {
        ProgramManager pm = (ProgramManager)tool.getService(ProgramManager.class);
        if (pm != null) {
            return tool;
        }
        List<PluginTool> pluginTools = FSBUtils.getRunningProgramManagerTools(tool);
        if (pluginTools.size() == 1) {
            return pluginTools.get(0);
        }
        if (pluginTools.isEmpty()) {
            Msg.showWarn((Object)tool, (Component)tool.getActiveWindow(), (String)"No open tools", (Object)"There are no open tools to use to open a program with");
            return null;
        }
        PluginTool pt = (PluginTool)SelectFromListDialog.selectFromList(pluginTools, (String)"Select tool", (String)"Select a tool to use to open programs", pluginTool -> pluginTool.getName());
        return pt;
    }
}

