/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DockingUtils;
import docking.widgets.HyperlinkComponent;
import docking.widgets.MultiLineLabel;
import docking.widgets.PopupWindow;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.label.GIconLabel;
import generic.theme.GColor;
import generic.theme.GThemeDefaults;
import generic.util.WindowUtilities;
import ghidra.framework.Application;
import ghidra.util.HTMLUtilities;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.View;
import resources.ResourceManager;
import utilities.util.FileUtilities;

class InfoPanel
extends JPanel {
    private static final int MARGIN = 10;
    private String version;
    private String marking;
    private String distributionInfo;
    private Color bgColor;
    private int imageWidth;
    private static final String SPLASH_FILENAME = "splash.txt";
    private static final String CLOUD_REV_FILENAME = "images/cloudbarReversed.jpg";
    private static final String GHIDRA_FILENAME = "images/GHIDRA_Splash.png";
    private static final String CLOUD_FILENAME = "images/cloudbar.jpg";

    InfoPanel() {
        this.getAboutInfo();
        this.bgColor = new GColor("color.bg.splash.infopanel");
        this.create();
    }

    private void create() {
        this.setLayout(new BorderLayout());
        this.add(this.createImagePanel(), "Center");
        this.add(this.createSouthPanel(), "South");
        this.setBackground(this.bgColor);
    }

    private Component buildTextPanel() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        panel.setBackground(this.bgColor);
        if (Application.isTestBuild()) {
            panel.add(this.buildTestBuildLabel());
        }
        panel.add(this.buildVersionPanel());
        if (this.marking != null) {
            panel.add(this.buildMarkingLabel());
        }
        if (this.distributionInfo != null) {
            panel.add(this.buildDistributionLabel());
        }
        return panel;
    }

    private Component buildDistributionLabel() {
        String content = this.distributionInfo;
        JLabel resizer = new JLabel(content);
        final int desiredTextViewWidth = this.imageWidth - 20;
        View view = (View)resizer.getClientProperty("html");
        if (view == null) {
            GDLabel label = new GDLabel(content){

                public Dimension getPreferredSize() {
                    Dimension preferredSize = super.getPreferredSize();
                    preferredSize.width = desiredTextViewWidth;
                    return preferredSize;
                }
            };
            return label;
        }
        view.setSize(desiredTextViewWidth, 0.0f);
        float w = view.getPreferredSpan(0);
        float h = view.getPreferredSpan(1);
        GHtmlLabel distLabel = new GHtmlLabel(content);
        distLabel.setPreferredSize(new Dimension((int)Math.ceil(w), (int)Math.ceil(h + 10.0f)));
        return distLabel;
    }

    private Component buildMarkingLabel() {
        MultiLineLabel markingLabel = new MultiLineLabel(this.marking, 0, 3, 1);
        markingLabel.setForeground((Color)GThemeDefaults.Colors.Palette.RED);
        return markingLabel;
    }

    private Component buildVersionPanel() {
        JPanel vPanel = new JPanel(new BorderLayout());
        vPanel.setBackground(this.bgColor);
        vPanel.add(this.buildVersionLabel(), "Center");
        vPanel.add((Component)this.buildJavaVersionComponent(), "South");
        return vPanel;
    }

    private Component buildTestBuildLabel() {
        MultiLineLabel testLabel = new MultiLineLabel("-- UNSUPPORTED TEST BUILD --", 0, 3, 1);
        testLabel.setForeground((Color)GThemeDefaults.Colors.Palette.RED);
        return testLabel;
    }

    private Component createSouthPanel() {
        ImageIcon cloudImage;
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
        ImageIcon cloudRevImage = ResourceManager.loadImage((String)CLOUD_REV_FILENAME);
        if (cloudRevImage != null) {
            GIconLabel cloudRevLabel = new GIconLabel((Icon)cloudRevImage);
            panel.add((Component)cloudRevLabel, "North");
        }
        if ((cloudImage = ResourceManager.loadImage((String)CLOUD_FILENAME)) != null) {
            GIconLabel cloudLabel = new GIconLabel((Icon)cloudImage);
            panel.add((Component)cloudLabel, "South");
        }
        panel.add(this.buildTextPanel(), "Center");
        panel.setBackground(this.bgColor);
        return panel;
    }

    private Component buildVersionLabel() {
        MultiLineLabel versionLabel = new MultiLineLabel(this.version, 0, 3, 1);
        Font font = versionLabel.getFont();
        font = font.deriveFont(14.0f).deriveFont(1);
        versionLabel.setFont(font);
        versionLabel.setForeground((Color)new GColor("color.fg.infopanel.version"));
        return versionLabel;
    }

    private Component createImagePanel() {
        JPanel imagePanel = new JPanel();
        imagePanel.setBackground(this.bgColor);
        imagePanel.setLayout(new BorderLayout());
        ImageIcon ghidraSplashImage = ResourceManager.loadImage((String)GHIDRA_FILENAME);
        GIconLabel l = new GIconLabel((Icon)ghidraSplashImage);
        imagePanel.add((Component)l, "Center");
        this.imageWidth = ghidraSplashImage.getIconWidth();
        return imagePanel;
    }

    private HyperlinkComponent buildJavaVersionComponent() {
        String anchorName = "java_version";
        HyperlinkComponent javaVersionComponent = new HyperlinkComponent("<HTML><CENTER>Java Version <A HREF=\"" + anchorName + "\">" + System.getProperty("java.version") + "</A></CENTER>");
        javaVersionComponent.addHyperlinkListener(anchorName, e -> {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            this.showJavaHomeInfo(javaVersionComponent);
        });
        DockingUtils.setTransparent((JComponent)javaVersionComponent);
        return javaVersionComponent;
    }

    private void showJavaHomeInfo(HyperlinkComponent javaVersionComponent) {
        JToolTip tooltip = new JToolTip();
        tooltip.setTipText(System.getProperty("java.home"));
        Point location = MouseInfo.getPointerInfo().getLocation();
        Window window = WindowUtilities.windowForComponent((Component)javaVersionComponent);
        tooltip.setLocation(location);
        PopupWindow popupWindow = new PopupWindow(window, (JComponent)tooltip);
        SwingUtilities.convertPointFromScreen(location, (Component)javaVersionComponent);
        MouseEvent dummyEvent = new MouseEvent((Component)javaVersionComponent, (int)System.currentTimeMillis(), System.currentTimeMillis(), 0, location.x, location.y, 1, false);
        popupWindow.setCloseWindowDelay(1);
        popupWindow.showPopup(dummyEvent);
    }

    private void getAboutInfo() {
        String releaseName = Application.getApplicationReleaseName();
        Object buildInfo = "";
        if (releaseName != null) {
            buildInfo = "\nBuild " + releaseName;
        }
        this.version = "Version " + Application.getApplicationVersion() + (SystemUtilities.isInDevelopmentMode() ? " - DEVELOPMENT" : "") + (String)buildInfo + "\n" + Application.getBuildDate();
        this.marking = Application.getApplicationProperty((String)"application.release.marking");
        this.distributionInfo = this.loadSplashScreenHTML();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadSplashScreenHTML() {
        try (InputStream in = ResourceManager.getResourceAsStream((String)SPLASH_FILENAME);){
            if (in == null) {
                Msg.debug((Object)this, (Object)"Unable to find splash screen text from: splash.txt");
                String string2 = "splash.txt file is missing!";
                return string2;
            }
            String text = FileUtilities.getText((InputStream)in);
            if (!HTMLUtilities.isHTML((String)text)) {
                text = HTMLUtilities.toHTML((String)text);
            }
            String string = text = text.replace('\n', ' ');
            return string;
        }
        catch (IOException e) {
            Msg.debug((Object)this, (Object)"Unable to read splash screen text from: splash.txt", (Throwable)e);
            return "splash.txt file is unreadable!";
        }
    }
}

