/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import ghidra.framework.options.CustomOption;
import ghidra.framework.options.SaveState;

public class NamespaceWrappedOption
implements CustomOption {
    private static final String SHOW_LOCAL_NAMESPACE = "showLocalNamespace";
    private static final String SHOW_NON_LOCAL_NAMESPACE = "showNonLocalNamespace";
    private static final String USE_LOCAL_PREFIX_OVERRIDE = "useLocalPrefixOverride";
    private static final String LOCAL_PREFIX = "localPrefix";
    private static final String SHOW_LIBRARY_IN_NAMESPACE = "showLibraryInNamespace";
    private static boolean DEFAULT_SHOW_LOCAL_NAMESPACE = false;
    private static boolean DEFAULT_SHOW_NONLOCAL_NAMESPACE = true;
    private static boolean DEFAULT_USE_LOCAL_PREFIX_OVERRIDE = false;
    private static String DEFAULT_LOCAL_PREFIX_TEXT = "local::";
    private static boolean DEFAULT_SHOW_LIBRARY_IN_NAMESPACE = true;
    private boolean showLocalNamespace = DEFAULT_SHOW_LOCAL_NAMESPACE;
    private boolean showNonLocalNamespace = DEFAULT_SHOW_NONLOCAL_NAMESPACE;
    private boolean useLocalPrefixOverride = DEFAULT_USE_LOCAL_PREFIX_OVERRIDE;
    private String localPrefixText = DEFAULT_LOCAL_PREFIX_TEXT;
    private boolean showLibraryInNamespace = DEFAULT_SHOW_LIBRARY_IN_NAMESPACE;

    public boolean isShowLocalNamespace() {
        return this.showLocalNamespace;
    }

    public boolean isShowNonLocalNamespace() {
        return this.showNonLocalNamespace;
    }

    public String getLocalPrefixText() {
        return this.localPrefixText;
    }

    public void setShowLocalNamespace(boolean showLocalNamespace) {
        this.showLocalNamespace = showLocalNamespace;
    }

    public void setShowNonLocalNamespace(boolean showNonLocalNamespace) {
        this.showNonLocalNamespace = showNonLocalNamespace;
    }

    public void setUseLocalPrefixOverride(boolean useLocalPrefixOverride) {
        this.useLocalPrefixOverride = useLocalPrefixOverride;
    }

    public boolean isUseLocalPrefixOverride() {
        return this.useLocalPrefixOverride;
    }

    public void setLocalPrefixText(String localPrefixText) {
        this.localPrefixText = localPrefixText;
    }

    public boolean isShowLibraryInNamespace() {
        return this.showLibraryInNamespace;
    }

    public void setShowLibraryInNamespace(boolean showLibraryInNamespace) {
        this.showLibraryInNamespace = showLibraryInNamespace;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NamespaceWrappedOption)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        NamespaceWrappedOption otherOption = (NamespaceWrappedOption)obj;
        return this.showLocalNamespace == otherOption.showLocalNamespace && this.showNonLocalNamespace == otherOption.showNonLocalNamespace && this.useLocalPrefixOverride == otherOption.useLocalPrefixOverride && this.localPrefixText.equals(otherOption.localPrefixText) && this.showLibraryInNamespace == otherOption.showLibraryInNamespace;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + (this.showLocalNamespace ? 1 : 0);
        result = prime * result + (this.showNonLocalNamespace ? 1 : 0);
        result = prime * result + (this.useLocalPrefixOverride ? 1 : 0);
        result = prime * result + (this.localPrefixText == null ? 0 : this.localPrefixText.hashCode());
        result = prime * result + (this.showLibraryInNamespace ? 1 : 0);
        return result;
    }

    public void readState(SaveState saveState) {
        this.showLocalNamespace = saveState.getBoolean(SHOW_LOCAL_NAMESPACE, this.showLocalNamespace);
        this.showNonLocalNamespace = saveState.getBoolean(SHOW_NON_LOCAL_NAMESPACE, this.showNonLocalNamespace);
        this.useLocalPrefixOverride = saveState.getBoolean(USE_LOCAL_PREFIX_OVERRIDE, this.useLocalPrefixOverride);
        this.localPrefixText = saveState.getString(LOCAL_PREFIX, this.localPrefixText);
        this.showLibraryInNamespace = saveState.getBoolean(SHOW_LIBRARY_IN_NAMESPACE, DEFAULT_SHOW_LIBRARY_IN_NAMESPACE);
    }

    public void writeState(SaveState saveState) {
        saveState.putBoolean(SHOW_LOCAL_NAMESPACE, this.showLocalNamespace);
        saveState.putBoolean(SHOW_NON_LOCAL_NAMESPACE, this.showNonLocalNamespace);
        saveState.putBoolean(USE_LOCAL_PREFIX_OVERRIDE, this.useLocalPrefixOverride);
        saveState.putString(LOCAL_PREFIX, this.localPrefixText);
        saveState.putBoolean(SHOW_LIBRARY_IN_NAMESPACE, this.showLibraryInNamespace);
    }
}

