/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.support.FieldLocation;
import generic.theme.Gui;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.template.TemplateSimplifier;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.Data;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.classfinder.ExtensionPoint;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.math.BigInteger;

public abstract class FieldFactory
implements ExtensionPoint {
    public static final String FONT_OPTION_NAME = "BASE FONT";
    public static final String BASE_LISTING_FONT_ID = "font.listing.base";
    protected FieldFormatModel model;
    protected String name;
    protected int startX;
    protected int width;
    private FontMetrics defaultMetrics;
    private FontMetrics[] fontMetrics = new FontMetrics[4];
    protected Font baseFont;
    protected int style = -1;
    protected boolean enabled = true;
    protected ListingHighlightProvider hlProvider;
    protected String colorOptionName;
    protected String styleOptionName;
    private TemplateSimplifier templateSimplifier;

    protected FieldFactory(String name, FieldFormatModel model, ListingHighlightProvider highlightProvider, Options displayOptions, Options fieldOptions) {
        this.name = name;
        this.model = model;
        this.hlProvider = highlightProvider;
        this.colorOptionName = name + " Color";
        this.styleOptionName = name + " Style";
        this.width = 100;
        this.templateSimplifier = model.getFormatManager().getTemplateSimplifier();
        this.initDisplayOptions(displayOptions);
        this.initFieldOptions(fieldOptions);
    }

    protected void initFieldOptions(Options fieldOptions) {
        fieldOptions.getOptions(this.name).setOptionsHelpLocation(new HelpLocation("CodeBrowserPlugin", this.name));
    }

    protected void initDisplayOptions(Options displayOptions) {
        this.baseFont = Gui.getFont((String)BASE_LISTING_FONT_ID);
        displayOptions.registerOption(this.styleOptionName, (Object)-1, null, "Sets the " + this.style);
        this.style = displayOptions.getInt(this.styleOptionName, -1);
        this.setMetrics(this.baseFont);
    }

    public FieldFactory(String name) {
        this.name = name;
    }

    public void servicesChanged() {
    }

    public abstract FieldFactory newInstance(FieldFormatModel var1, ListingHighlightProvider var2, ToolOptions var3, ToolOptions var4);

    public void displayOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals(FONT_OPTION_NAME)) {
            this.baseFont = SystemUtilities.adjustForFontSizeOverride((Font)((Font)newValue));
            this.setMetrics(this.baseFont);
        } else if (optionName.equals(this.styleOptionName)) {
            this.style = options.getInt(optionName, -1);
            this.setMetrics(this.baseFont);
        }
        this.model.update();
    }

    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
    }

    public String getFieldName() {
        return this.name;
    }

    public int getStartX() {
        return this.startX;
    }

    public void setStartX(int x) {
        this.startX = x;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int w) {
        this.width = w;
    }

    public FieldFormatModel getFieldModel() {
        return this.model;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean state) {
        this.enabled = state;
        this.model.modelChanged();
    }

    public boolean supportsLocation(ListingField listingField, ProgramLocation location) {
        BigInteger dummyIndex = BigInteger.ZERO;
        int dummyFieldNumber = 0;
        FieldLocation f = this.getFieldLocation(listingField, dummyIndex, dummyFieldNumber, location);
        return f != null;
    }

    public abstract ListingField getField(ProxyObj<?> var1, int var2);

    public abstract FieldLocation getFieldLocation(ListingField var1, BigInteger var2, int var3, ProgramLocation var4);

    public abstract ProgramLocation getProgramLocation(int var1, int var2, ListingField var3);

    public abstract boolean acceptsType(int var1, Class<?> var2);

    protected boolean hasSamePath(ListingField bf, ProgramLocation loc) {
        Object obj = bf.getProxy().getObject();
        if (obj instanceof Data) {
            Data data = (Data)obj;
            int[] path1 = data.getComponentPath();
            int[] path2 = loc.getComponentPath();
            if (path1 == null) {
                return path2 == null || path2.length == 0;
            }
            if (path2 == null) {
                return path1.length == 0;
            }
            if (path1.length != path2.length) {
                return false;
            }
            for (int i = 0; i < path2.length; ++i) {
                if (path1[i] == path2[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String getFieldText() {
        return this.name;
    }

    public FontMetrics getMetrics() {
        return this.getMetrics(this.style);
    }

    protected FontMetrics getMetrics(int fontStyle) {
        if (fontStyle == -1) {
            return this.defaultMetrics;
        }
        return this.fontMetrics[fontStyle];
    }

    private void setMetrics(Font newFont) {
        this.defaultMetrics = Toolkit.getDefaultToolkit().getFontMetrics(newFont);
        for (int i = 0; i < this.fontMetrics.length; ++i) {
            Font font = newFont.deriveFont(i);
            this.fontMetrics[i] = Toolkit.getDefaultToolkit().getFontMetrics(font);
        }
    }

    protected String simplifyTemplates(String input) {
        return this.templateSimplifier.simplify(input);
    }
}

