/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.RowColLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.ArrayElementFieldLocation;
import ghidra.app.util.viewer.field.ArrayElementPropertyEditor;
import ghidra.app.util.viewer.field.ArrayElementWrappedOption;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.docking.settings.Settings;
import ghidra.framework.options.CustomOption;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.exception.AssertException;
import java.awt.Color;
import java.beans.PropertyEditor;
import java.math.BigInteger;

public class ArrayValuesFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Array Values";
    private int valuesPerLine;
    private PropertyEditor arrayOptionsEditor = new ArrayElementPropertyEditor();

    public ArrayValuesFieldFactory() {
        super(FIELD_NAME);
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider highlightProvider, ToolOptions toolOptions, ToolOptions fieldOptions) {
        return new ArrayValuesFieldFactory(formatModel, highlightProvider, (Options)toolOptions, (Options)fieldOptions);
    }

    private ArrayValuesFieldFactory(FieldFormatModel model, ListingHighlightProvider hlProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hlProvider, displayOptions, fieldOptions);
        this.setupOptions(fieldOptions);
    }

    private void setupOptions(Options fieldOptions) {
        fieldOptions.registerOption("Array Options.Array Display Options", OptionType.CUSTOM_TYPE, (Object)new ArrayElementWrappedOption(), null, "Adjusts the Array Field display", this.arrayOptionsEditor);
        CustomOption wrappedOption = fieldOptions.getCustomOption("Array Options.Array Display Options", (CustomOption)new ArrayElementWrappedOption());
        HelpLocation hl = new HelpLocation("CodeBrowserPlugin", "Array_Options");
        fieldOptions.getOptions("Array Options").setOptionsHelpLocation(hl);
        fieldOptions.getOptions("Array Options.Array Display Options").setOptionsHelpLocation(hl);
        if (!(wrappedOption instanceof ArrayElementWrappedOption)) {
            throw new AssertException("Someone set an option for Array Options.Array Display Options that is not the expected ghidra.app.util.viewer.field.NamespaceWrappedOption type.");
        }
        ArrayElementWrappedOption arrayElementOption = (ArrayElementWrappedOption)wrappedOption;
        this.valuesPerLine = arrayElementOption.getArrayElementsPerLine();
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        int itemCount;
        int index;
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof Data)) {
            return null;
        }
        Data data = (Data)obj;
        Data parent = data.getParent();
        int numComponents = parent.getNumComponents();
        int remaining = numComponents - (index = data.getComponentIndex());
        boolean isLastLine = remaining <= (itemCount = Math.min(remaining, this.valuesPerLine));
        FieldElement[] aStrings = new FieldElement[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            Data child = parent.getComponent(index++);
            boolean isLastItem = isLastLine && i == itemCount - 1;
            String value = this.getDisplayValue(child, !isLastItem);
            AttributedString as = new AttributedString(value, (Color)ListingColors.ARRAY_VALUES, this.getMetrics());
            aStrings[i] = new TextFieldElement(as, i, 0);
        }
        return ListingTextField.createPackedTextField(this, proxy, aStrings, this.startX + varWidth, this.width, 1, this.hlProvider);
    }

    private String getDisplayValue(Data data, boolean addDelimeter) {
        DataType dt = data.getDataType();
        int minLength = data.getLength() * 3 + 1;
        StringBuffer buf = new StringBuffer(dt.getRepresentation((MemBuffer)data, (Settings)data, data.getLength()));
        if (buf.length() < minLength) {
            for (int i = buf.length(); i < minLength; ++i) {
                buf.insert(0, ' ');
            }
        }
        if (addDelimeter) {
            buf.append(',');
        }
        return buf.toString();
    }

    @Override
    public FieldLocation getFieldLocation(ListingField lf, BigInteger index, int fieldNum, ProgramLocation location) {
        if (!(location instanceof ArrayElementFieldLocation)) {
            return null;
        }
        ArrayElementFieldLocation loc = (ArrayElementFieldLocation)location;
        ListingTextField btf = (ListingTextField)lf;
        Data firstDataOnLine = (Data)btf.getProxy().getObject();
        int elementIndex = loc.getElementIndexOnLine(firstDataOnLine);
        RowColLocation rcl = btf.dataToScreenLocation(elementIndex, loc.getCharOffset());
        return new FieldLocation(index, fieldNum, rcl.row(), rcl.col());
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField listingField) {
        if (!(listingField instanceof ListingTextField)) {
            return null;
        }
        Data data = (Data)listingField.getProxy().getObject();
        ListingTextField btf = (ListingTextField)listingField;
        RowColLocation loc = btf.screenToDataLocation(row, col);
        int arrayIndex = data.getComponentIndex() + loc.row();
        Data arrayElement = data.getParent().getComponent(arrayIndex);
        Program program = data.getProgram();
        return new ArrayElementFieldLocation(program, arrayElement.getMinAddress(), arrayElement.getComponentPath(), this.getDisplayValue(arrayElement, false), loc.row(), loc.col());
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 6;
    }

    @Override
    public void fieldOptionsChanged(Options options, String optionName, Object oldValue, Object newValue) {
        if (optionName.equals("Array Options.Array Display Options")) {
            CustomOption customOption = options.getCustomOption("Array Options.Array Display Options", (CustomOption)new ArrayElementWrappedOption());
            if (!(customOption instanceof ArrayElementWrappedOption)) {
                throw new AssertException("Someone set an option for Array Options.Array Display Options that is not the expected ghidra.app.util.viewer.field.NamespaceWrappedOption type.");
            }
            ArrayElementWrappedOption arrayElementOption = (ArrayElementWrappedOption)customOption;
            this.valuesPerLine = arrayElementOption.getArrayElementsPerLine();
        }
    }
}

