/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfData;
import ghidra.app.util.bin.format.omf.OmfRecord;
import java.io.IOException;

public class OmfEnumeratedData
extends OmfData {
    private long streamOffset;
    private int streamLength;

    public OmfEnumeratedData(BinaryReader reader) throws IOException {
        this.readRecordHeader(reader);
        long start = reader.getPointerIndex();
        this.segmentIndex = OmfRecord.readIndex(reader);
        this.dataOffset = (long)OmfRecord.readInt2Or4(reader, this.hasBigFields()) & 0xFFFFFFFFL;
        this.streamOffset = reader.getPointerIndex();
        this.streamLength = this.getRecordLength() - 1 - (int)(this.streamOffset - start);
        reader.setPointerIndex(this.streamOffset + (long)this.streamLength);
        this.readCheckSumByte(reader);
    }

    @Override
    public int getLength() {
        return this.streamLength;
    }

    @Override
    public byte[] getByteArray(BinaryReader reader) throws IOException {
        reader.setPointerIndex(this.streamOffset);
        byte[] buffer = reader.readNextByteArray(this.streamLength);
        return buffer;
    }

    @Override
    public boolean isAllZeroes() {
        return false;
    }
}

