/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.dyld;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheHeader;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo1;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo2;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo3;
import ghidra.app.util.bin.format.macho.dyld.DyldCacheSlideInfo4;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer64DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public abstract class DyldCacheSlideInfoCommon
implements StructConverter {
    public static final int DATA_PAGE_MAP_ENTRY = 1;
    public static final int BYTES_PER_CHAIN_OFFSET = 4;
    public static final int CHAIN_OFFSET_MASK = 16383;
    protected int version;
    protected long slideInfoOffset;

    public static DyldCacheSlideInfoCommon parseSlideInfo(BinaryReader reader, long slideInfoOffset, MessageLog log, TaskMonitor monitor) {
        if (slideInfoOffset == 0L) {
            return null;
        }
        DyldCacheSlideInfoCommon returnedSlideInfo = null;
        monitor.setMessage("Parsing DYLD slide info...");
        monitor.initialize(1L);
        try {
            reader.setPointerIndex(slideInfoOffset);
            int version = reader.readNextInt();
            reader.setPointerIndex(slideInfoOffset);
            switch (version) {
                case 1: {
                    returnedSlideInfo = new DyldCacheSlideInfo1(reader);
                    break;
                }
                case 2: {
                    returnedSlideInfo = new DyldCacheSlideInfo2(reader);
                    break;
                }
                case 3: {
                    returnedSlideInfo = new DyldCacheSlideInfo3(reader);
                    break;
                }
                case 4: {
                    returnedSlideInfo = new DyldCacheSlideInfo4(reader);
                    break;
                }
                default: {
                    throw new IOException();
                }
            }
            monitor.incrementProgress(1L);
        }
        catch (IOException e) {
            log.appendMsg(DyldCacheHeader.class.getSimpleName(), "Failed to parse dyld_cache_slide_info.");
            return null;
        }
        returnedSlideInfo.slideInfoOffset = slideInfoOffset;
        return returnedSlideInfo;
    }

    public DyldCacheSlideInfoCommon(BinaryReader reader) throws IOException {
        this.version = reader.readNextInt();
    }

    public int getVersion() {
        return this.version;
    }

    public long getSlideInfoOffset() {
        return this.slideInfoOffset;
    }

    public abstract void fixPageChains(Program var1, DyldCacheHeader var2, boolean var3, MessageLog var4, TaskMonitor var5) throws MemoryAccessException, CancelledException;

    protected void addRelocationTableEntry(Program program, Address chainLoc, int type, long chainValue, int appliedByteLength, String name) {
        program.getRelocationTable().add(chainLoc, Relocation.Status.APPLIED, type, new long[]{chainValue}, appliedByteLength, name);
    }

    protected void createChainPointers(Program program, List<Address> unchainedLocList, TaskMonitor monitor) throws CancelledException {
        int numFixedLocations = unchainedLocList.size();
        monitor.setMessage("Fixed " + numFixedLocations + " chained pointers.  Creating Pointers");
        for (Address addr : unchainedLocList) {
            monitor.checkCancelled();
            try {
                program.getListing().createData(addr, (DataType)Pointer64DataType.dataType);
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {}
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType("dyld_cache_slide_info", 0);
        struct.add(DWORD, "version", "");
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }
}

