/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class PreboundDynamicLibraryCommand
extends LoadCommand {
    private LoadCommandString name;
    private int nmodules;
    private LoadCommandString linkedModules;

    PreboundDynamicLibraryCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.name = new LoadCommandString(reader, this);
        this.nmodules = reader.readNextInt();
        this.linkedModules = new LoadCommandString(reader, this);
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(this.name.toDataType(), "name", null);
        struct.add(DWORD, "nmodules", null);
        struct.add(this.linkedModules.toDataType(), "linked_modules", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    public String getLibraryName() {
        return this.name.getString();
    }

    public int getNumberOfModules() {
        return this.nmodules;
    }

    public String getLinkedModules() {
        return this.linkedModules.getString();
    }

    @Override
    public String getCommandName() {
        return "prebound_dylib_command";
    }

    @Override
    public void markup(MachHeader header, FlatProgramAPI api, Address baseAddress, boolean isBinary, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        this.updateMonitor(monitor);
        try {
            if (isBinary) {
                this.createFragment(api, baseAddress, parentModule);
                Address addr = baseAddress.getNewAddress(this.getStartIndex());
                api.createData(addr, this.toDataType());
                int nameLen = this.getCommandSize() - this.name.getOffset();
                Address nameAddr = addr.add((long)this.name.getOffset());
                api.createAsciiString(nameAddr, nameLen);
            }
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName() + " - " + e.getMessage());
        }
    }
}

