/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.structmapping;

import generic.jar.ResourceFile;
import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.dwarf4.next.DWARFDataTypeConflictHandler;
import ghidra.app.util.bin.format.golang.structmapping.StructureContext;
import ghidra.app.util.bin.format.golang.structmapping.StructureMappingInfo;
import ghidra.app.util.bin.format.golang.structmapping.StructureReader;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.DataConverter;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DataTypeMapper
implements AutoCloseable {
    protected Program program;
    protected DataTypeManager programDTM;
    protected DataTypeManager archiveDTM;
    protected List<CategoryPath> programSearchCPs = new ArrayList<CategoryPath>();
    protected List<CategoryPath> archiveSearchCPs = new ArrayList<CategoryPath>();
    protected Map<Class<?>, StructureMappingInfo<?>> mappingInfo = new HashMap();
    protected Set<Address> markedupStructs = new HashSet<Address>();
    protected TaskMonitor markupTaskMonitor = TaskMonitor.DUMMY;

    protected DataTypeMapper(Program program, ResourceFile archiveGDT) throws IOException {
        this.program = program;
        this.programDTM = program.getDataTypeManager();
        this.archiveDTM = archiveGDT != null ? FileDataTypeManager.openFileArchive((ResourceFile)archiveGDT, (boolean)false) : null;
    }

    @Override
    public void close() {
        if (this.archiveDTM != null) {
            this.archiveDTM.close();
            this.archiveDTM = null;
        }
    }

    public CategoryPath getDefaultVariableLengthStructCategoryPath() {
        return CategoryPath.ROOT;
    }

    public Program getProgram() {
        return this.program;
    }

    protected BinaryReader createProgramReader() {
        MemoryByteProvider bp = new MemoryByteProvider(this.program.getMemory(), this.program.getImageBase().getAddressSpace());
        return new BinaryReader(bp, !this.program.getMemory().isBigEndian());
    }

    public DataConverter getDataConverter() {
        return DataConverter.getInstance((boolean)this.program.getMemory().isBigEndian());
    }

    public DataTypeMapper addProgramSearchCategoryPath(CategoryPath ... paths) {
        this.programSearchCPs.addAll(Arrays.asList(paths));
        return this;
    }

    public DataTypeMapper addArchiveSearchCategoryPath(CategoryPath ... paths) {
        this.archiveSearchCPs.addAll(Arrays.asList(paths));
        return this;
    }

    public <T> void registerStructure(Class<T> clazz) throws IOException {
        Structure structDT = null;
        String structName = StructureMappingInfo.getStructureDataTypeNameForClass(clazz);
        if (structName != null && !structName.isBlank()) {
            structDT = this.getType(structName, Structure.class);
        }
        if (!StructureReader.class.isAssignableFrom(clazz) && structDT == null) {
            if (structName == null || structName.isBlank()) {
                structName = "<missing>";
            }
            throw new IOException("Missing struct definition %s - %s".formatted(clazz.getSimpleName(), structName));
        }
        StructureMappingInfo<T> structMappingInfo = StructureMappingInfo.fromClass(clazz, structDT);
        this.mappingInfo.put(clazz, structMappingInfo);
    }

    public void registerStructures(List<Class<?>> classes) throws IOException {
        for (Class<?> clazz : classes) {
            this.registerStructure(clazz);
        }
    }

    public <T> StructureMappingInfo<T> getStructureMappingInfo(Class<T> clazz) {
        StructureMappingInfo<?> smi = this.mappingInfo.get(clazz);
        return smi;
    }

    public <T> StructureMappingInfo<T> getStructureMappingInfo(T structureInstance) {
        return structureInstance != null ? this.mappingInfo.get(structureInstance.getClass()) : null;
    }

    public Structure getStructureDataType(Class<?> clazz) {
        StructureMappingInfo<?> mi = this.mappingInfo.get(clazz);
        return mi != null ? mi.getStructureDataType() : null;
    }

    public String getStructureDataTypeName(Class<?> clazz) {
        StructureMappingInfo<?> mi = this.mappingInfo.get(clazz);
        return mi != null ? mi.getStructureName() : null;
    }

    protected DataType findType(String name, List<CategoryPath> searchList, DataTypeManager dtm) {
        for (CategoryPath searchCP : searchList) {
            DataType dataType = dtm.getDataType(searchCP, name);
            if (dataType == null) continue;
            return dataType;
        }
        return null;
    }

    public <T extends DataType> T getType(String name, Class<T> clazz) {
        DataType dataType = this.findType(name, this.programSearchCPs, this.programDTM);
        if (dataType == null && this.archiveDTM != null && (dataType = this.findType(name, this.archiveSearchCPs, this.archiveDTM)) != null) {
            dataType = this.programDTM.resolve(dataType, (DataTypeConflictHandler)DWARFDataTypeConflictHandler.INSTANCE);
        }
        if (dataType == null) {
            dataType = BuiltInDataTypeManager.getDataTypeManager().getDataType(CategoryPath.ROOT, name);
        }
        return (T)(clazz.isInstance(dataType) ? (DataType)clazz.cast(dataType) : null);
    }

    public <T extends DataType> T getTypeOrDefault(String name, Class<T> clazz, T defaultValue) {
        T result = this.getType(name, clazz);
        return result != null ? result : defaultValue;
    }

    public DataTypeManager getDTM() {
        return this.programDTM;
    }

    private <T> StructureContext<T> getStructureContext(Class<T> structureClass, BinaryReader reader) {
        StructureMappingInfo<Class<T>> smi = this.getStructureMappingInfo((T)structureClass);
        if (smi == null) {
            throw new IllegalArgumentException("Unknown structure mapped class: " + structureClass.getSimpleName());
        }
        return new StructureContext<Class<T>>(this, smi, reader);
    }

    public <T> StructureContext<T> getExistingStructureContext(T structureInstance) throws IOException {
        StructureMappingInfo<T> smi = structureInstance != null ? this.getStructureMappingInfo(structureInstance) : null;
        return smi != null ? smi.recoverStructureContext(structureInstance) : null;
    }

    public <T> Address getExistingStructureAddress(T structureInstance) throws IOException {
        StructureMappingInfo<T> smi = structureInstance != null ? this.getStructureMappingInfo(structureInstance) : null;
        StructureContext<T> structureContext = smi != null ? smi.recoverStructureContext(structureInstance) : null;
        return structureContext != null ? structureContext.getStructureAddress() : null;
    }

    public void setMarkupTaskMonitor(TaskMonitor monitor) {
        this.markupTaskMonitor = Objects.requireNonNullElse(monitor, TaskMonitor.DUMMY);
    }

    public <T> void markup(T obj, boolean nested) throws IOException {
        if (this.markupTaskMonitor.isCancelled()) {
            throw new IOException("Markup canceled");
        }
        if (obj == null) {
            return;
        }
        if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            for (Object listElement : list) {
                this.markup(listElement, nested);
            }
        } else if (obj.getClass().isArray()) {
            int len = Array.getLength(obj);
            for (int i = 0; i < len; ++i) {
                this.markup(Array.get(obj, i), nested);
            }
        } else if (obj instanceof Iterator) {
            Iterator it = (Iterator)obj;
            while (it.hasNext()) {
                Object itElement = it.next();
                this.markup(itElement, nested);
            }
        } else {
            StructureContext<T> structureContext = this.getExistingStructureContext(obj);
            if (structureContext == null) {
                throw new IllegalArgumentException();
            }
            this.markupTaskMonitor.incrementProgress(1L);
            structureContext.markupStructure(nested);
        }
    }

    public <T> T readStructure(Class<T> structureClass, BinaryReader structReader) throws IOException {
        StructureContext<T> structureContext = this.getStructureContext(structureClass, structReader);
        T result = structureContext.readNewInstance();
        return result;
    }

    public <T> T readStructure(Class<T> structureClass, long position) throws IOException {
        return this.readStructure(structureClass, this.getReader(position));
    }

    public <T> T readStructure(Class<T> structureClass, Address address) throws IOException {
        return this.readStructure(structureClass, this.getReader(address.getOffset()));
    }

    public BinaryReader getReader(long position) {
        BinaryReader reader = this.createProgramReader();
        reader.setPointerIndex(position);
        return reader;
    }

    public Address getDataAddress(long offset) {
        return this.program.getImageBase().getNewAddress(offset);
    }

    public Address getCodeAddress(long offset) {
        return this.program.getImageBase().getNewAddress(offset);
    }

    public void labelAddress(Address addr, String symbolName) throws IOException {
        try {
            SymbolTable symbolTable = this.getProgram().getSymbolTable();
            Symbol[] symbols = symbolTable.getSymbols(addr);
            if (symbols.length == 0 || symbols[0].isDynamic()) {
                symbolName = SymbolUtilities.replaceInvalidChars((String)symbolName, (boolean)true);
                symbolTable.createLabel(addr, symbolName, SourceType.IMPORTED);
            }
        }
        catch (InvalidInputException e) {
            throw new IOException(e);
        }
    }

    public <T> void labelStructure(T obj, String symbolName) throws IOException {
        Address addr = this.getExistingStructureAddress(obj);
        this.labelAddress(addr, symbolName);
    }

    public void markupAddress(Address addr, DataType dt) throws IOException {
        this.markupAddress(addr, dt, -1);
    }

    public void markupAddress(Address addr, DataType dt, int length) throws IOException {
        try {
            DataUtilities.createData((Program)this.program, (Address)addr, (DataType)dt, (int)length, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_DEFAULT_CONFLICT_DATA);
        }
        catch (CodeUnitInsertionException e) {
            throw new IOException(e);
        }
    }

    public void markupAddressIfUndefined(Address addr, DataType dt) throws IOException {
        Data data = DataUtilities.getDataAtAddress((Program)this.program, (Address)addr);
        if (data == null || Undefined.isUndefined((DataType)data.getBaseDataType())) {
            this.markupAddress(addr, dt);
        }
    }

    public String toString() {
        return "DataTypeMapper { program: %s}".formatted(this.program.getName());
    }
}

